/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.internal.reports;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.WorkingDaysToDaysConverter;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.monitor.api.CombinedClassificationFilter;
import pro.taskana.monitor.api.SelectedItem;
import pro.taskana.monitor.api.TaskTimestamp;
import pro.taskana.monitor.api.reports.ClassificationReport;
import pro.taskana.monitor.api.reports.TimeIntervalReportBuilder;
import pro.taskana.monitor.api.reports.header.TimeIntervalColumnHeader;
import pro.taskana.monitor.api.reports.item.AgeQueryItem;
import pro.taskana.monitor.internal.MonitorMapper;
import pro.taskana.monitor.internal.preprocessor.WorkingDaysToDaysReportConverter;
import pro.taskana.task.api.TaskCustomField;
import pro.taskana.task.api.TaskState;

abstract class TimeIntervalReportBuilderImpl<B extends TimeIntervalReportBuilder<B, I, H>, I extends AgeQueryItem, H extends TimeIntervalColumnHeader>
implements TimeIntervalReportBuilder<B, I, H> {
    protected InternalTaskanaEngine taskanaEngine;
    protected MonitorMapper monitorMapper;
    protected List<H> columnHeaders;
    protected boolean inWorkingDays;
    protected List<String> workbasketIds;
    protected List<TaskState> states;
    protected List<String> classificationCategory;
    protected List<String> domains;
    protected List<String> classificationIds;
    protected List<String> excludedClassificationIds;
    protected WorkingDaysToDaysConverter converter;
    private String[] custom1In;
    private String[] custom1NotIn;
    private String[] custom1Like;
    private String[] custom2In;
    private String[] custom2NotIn;
    private String[] custom2Like;
    private String[] custom3In;
    private String[] custom3NotIn;
    private String[] custom3Like;
    private String[] custom4In;
    private String[] custom4NotIn;
    private String[] custom4Like;
    private String[] custom5In;
    private String[] custom5NotIn;
    private String[] custom5Like;
    private String[] custom6In;
    private String[] custom6NotIn;
    private String[] custom6Like;
    private String[] custom7In;
    private String[] custom7NotIn;
    private String[] custom7Like;
    private String[] custom8In;
    private String[] custom8NotIn;
    private String[] custom8Like;
    private String[] custom9In;
    private String[] custom9NotIn;
    private String[] custom9Like;
    private String[] custom10In;
    private String[] custom10NotIn;
    private String[] custom10Like;
    private String[] custom11In;
    private String[] custom11NotIn;
    private String[] custom11Like;
    private String[] custom12In;
    private String[] custom12NotIn;
    private String[] custom12Like;
    private String[] custom13In;
    private String[] custom13NotIn;
    private String[] custom13Like;
    private String[] custom14In;
    private String[] custom14NotIn;
    private String[] custom14Like;
    private String[] custom15In;
    private String[] custom15NotIn;
    private String[] custom15Like;
    private String[] custom16In;
    private String[] custom16NotIn;
    private String[] custom16Like;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;

    TimeIntervalReportBuilderImpl(InternalTaskanaEngine taskanaEngine, MonitorMapper monitorMapper) {
        this.taskanaEngine = taskanaEngine;
        this.monitorMapper = monitorMapper;
        this.columnHeaders = Collections.emptyList();
        this.converter = taskanaEngine.getEngine().getWorkingDaysToDaysConverter();
    }

    @Override
    public B withColumnHeaders(List<H> columnHeaders) {
        B b;
        B b2;
        List<H> list = columnHeaders;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.columnHeaders = columnHeaders;
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B inWorkingDays() {
        B b;
        B b2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.inWorkingDays = true;
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B workbasketIdIn(List<String> workbasketIds) {
        B b;
        B b2;
        List<String> list = workbasketIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.workbasketIds = new ArrayList<String>(workbasketIds);
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B stateIn(List<TaskState> states) {
        B b;
        B b2;
        List<TaskState> list = states;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.states = new ArrayList<TaskState>(states);
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B classificationCategoryIn(List<String> classificationCategory) {
        B b;
        B b2;
        List<String> list = classificationCategory;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.classificationCategory = new ArrayList<String>(classificationCategory);
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B classificationIdIn(List<String> classificationIds) {
        B b;
        B b2;
        List<String> list = classificationIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.classificationIds = new ArrayList<String>(classificationIds);
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B excludedClassificationIdIn(List<String> excludedClassificationIds) {
        B b;
        B b2;
        List<String> list = excludedClassificationIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.excludedClassificationIds = new ArrayList<String>(excludedClassificationIds);
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B domainIn(List<String> domains) {
        B b;
        B b2;
        List<String> list = domains;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.domains = new ArrayList<String>(domains);
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B customAttributeIn(TaskCustomField customField, String ... strings) throws InvalidArgumentException {
        B b;
        B b2;
        TaskCustomField taskCustomField = customField;
        String[] stringArray = strings;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)((Object)taskCustomField), (Object)stringArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (strings.length == 0) {
            throw new InvalidArgumentException("At least one string has to be provided as a search parameter");
        }
        switch (customField) {
            case CUSTOM_1: {
                this.custom1In = strings;
                break;
            }
            case CUSTOM_2: {
                this.custom2In = strings;
                break;
            }
            case CUSTOM_3: {
                this.custom3In = strings;
                break;
            }
            case CUSTOM_4: {
                this.custom4In = strings;
                break;
            }
            case CUSTOM_5: {
                this.custom5In = strings;
                break;
            }
            case CUSTOM_6: {
                this.custom6In = strings;
                break;
            }
            case CUSTOM_7: {
                this.custom7In = strings;
                break;
            }
            case CUSTOM_8: {
                this.custom8In = strings;
                break;
            }
            case CUSTOM_9: {
                this.custom9In = strings;
                break;
            }
            case CUSTOM_10: {
                this.custom10In = strings;
                break;
            }
            case CUSTOM_11: {
                this.custom11In = strings;
                break;
            }
            case CUSTOM_12: {
                this.custom12In = strings;
                break;
            }
            case CUSTOM_13: {
                this.custom13In = strings;
                break;
            }
            case CUSTOM_14: {
                this.custom14In = strings;
                break;
            }
            case CUSTOM_15: {
                this.custom15In = strings;
                break;
            }
            case CUSTOM_16: {
                this.custom16In = strings;
                break;
            }
            default: {
                throw new SystemException("Unknown custom attribute '" + (Object)((Object)customField) + "'");
            }
        }
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B customAttributeNotIn(TaskCustomField customField, String ... strings) throws InvalidArgumentException {
        B b;
        B b2;
        TaskCustomField taskCustomField = customField;
        String[] stringArray = strings;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)((Object)taskCustomField), (Object)stringArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (strings.length == 0) {
            throw new InvalidArgumentException("At least one string has to be provided as a search parameter");
        }
        switch (customField) {
            case CUSTOM_1: {
                this.custom1NotIn = strings;
                break;
            }
            case CUSTOM_2: {
                this.custom2NotIn = strings;
                break;
            }
            case CUSTOM_3: {
                this.custom3NotIn = strings;
                break;
            }
            case CUSTOM_4: {
                this.custom4NotIn = strings;
                break;
            }
            case CUSTOM_5: {
                this.custom5NotIn = strings;
                break;
            }
            case CUSTOM_6: {
                this.custom6NotIn = strings;
                break;
            }
            case CUSTOM_7: {
                this.custom7NotIn = strings;
                break;
            }
            case CUSTOM_8: {
                this.custom8NotIn = strings;
                break;
            }
            case CUSTOM_9: {
                this.custom9NotIn = strings;
                break;
            }
            case CUSTOM_10: {
                this.custom10NotIn = strings;
                break;
            }
            case CUSTOM_11: {
                this.custom11NotIn = strings;
                break;
            }
            case CUSTOM_12: {
                this.custom12NotIn = strings;
                break;
            }
            case CUSTOM_13: {
                this.custom13NotIn = strings;
                break;
            }
            case CUSTOM_14: {
                this.custom14NotIn = strings;
                break;
            }
            case CUSTOM_15: {
                this.custom15NotIn = strings;
                break;
            }
            case CUSTOM_16: {
                this.custom16NotIn = strings;
                break;
            }
            default: {
                throw new SystemException("Unknown custom attribute '" + (Object)((Object)customField) + "'");
            }
        }
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B customAttributeLike(TaskCustomField customField, String ... strings) throws InvalidArgumentException {
        B b;
        B b2;
        TaskCustomField taskCustomField = customField;
        String[] stringArray = strings;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)((Object)taskCustomField), (Object)stringArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (strings.length == 0) {
            throw new InvalidArgumentException("At least one string has to be provided as a search parameter");
        }
        switch (customField) {
            case CUSTOM_1: {
                this.custom1Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_2: {
                this.custom2Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_3: {
                this.custom3Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_4: {
                this.custom4Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_5: {
                this.custom5Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_6: {
                this.custom6Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_7: {
                this.custom7Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_8: {
                this.custom8Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_9: {
                this.custom9Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_10: {
                this.custom10Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_11: {
                this.custom11Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_12: {
                this.custom12Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_13: {
                this.custom13Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_14: {
                this.custom14Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_15: {
                this.custom15Like = this.toUpperCopy(strings);
                break;
            }
            case CUSTOM_16: {
                this.custom16Like = this.toUpperCopy(strings);
                break;
            }
            default: {
                throw new SystemException("Unknown custom field '" + (Object)((Object)customField) + "'");
            }
        }
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public List<String> listTaskIdsForSelectedItems(List<SelectedItem> selectedItems, TaskTimestamp timestamp) throws NotAuthorizedException, InvalidArgumentException {
        List<String> list;
        List<String> list2;
        List<SelectedItem> list3 = selectedItems;
        TaskTimestamp taskTimestamp = timestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, list3, (Object)((Object)taskTimestamp));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.MONITOR);
        try {
            this.taskanaEngine.openConnection();
            if (this.columnHeaders == null) {
                throw new InvalidArgumentException("ColumnHeader must not be null.");
            }
            if (selectedItems == null || selectedItems.isEmpty()) {
                throw new InvalidArgumentException("SelectedItems must not be null or empty.");
            }
            boolean joinWithAttachments = this.subKeyIsSet(selectedItems);
            if (!(this instanceof ClassificationReport.Builder) && joinWithAttachments) {
                throw new InvalidArgumentException("SubKeys are supported for ClassificationReport only.");
            }
            List<CombinedClassificationFilter> combinedClassificationFilter = this.getCombinedClassificationFilter();
            joinWithAttachments |= combinedClassificationFilter != null;
            if (this.inWorkingDays) {
                selectedItems = this.convertWorkingDaysToDays(selectedItems, this.columnHeaders);
            }
            List<String> list4 = this.monitorMapper.getTaskIdsForSelectedItems(Instant.now(), this, combinedClassificationFilter, this.determineGroupedBy(), timestamp, selectedItems, joinWithAttachments);
            list2 = list4;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        List<String> list5 = list = list2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list);
        return list2;
    }

    @Override
    public List<String> listCustomAttributeValuesForCustomAttributeName(TaskCustomField taskCustomField) throws NotAuthorizedException {
        List<String> list;
        List<String> list2;
        TaskCustomField taskCustomField2 = taskCustomField;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)((Object)taskCustomField2));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.MONITOR);
        try {
            this.taskanaEngine.openConnection();
            List<String> list3 = this.monitorMapper.getCustomAttributeValuesForReport(this, this.getCombinedClassificationFilter(), taskCustomField);
            list2 = list3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        List<String> list4 = list = list2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list);
        return list2;
    }

    protected abstract B _this();

    protected abstract String determineGroupedBy();

    protected List<CombinedClassificationFilter> getCombinedClassificationFilter() {
        List<CombinedClassificationFilter> list;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<CombinedClassificationFilter> list2 = null;
        List<CombinedClassificationFilter> list3 = list = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list);
        return list2;
    }

    private List<SelectedItem> convertWorkingDaysToDays(List<SelectedItem> selectedItems, List<H> columnHeaders) throws InvalidArgumentException {
        List<SelectedItem> list;
        List<SelectedItem> list2;
        List<SelectedItem> list3 = selectedItems;
        List<H> list4 = columnHeaders;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, list3, list4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkingDaysToDaysReportConverter instance = WorkingDaysToDaysReportConverter.initialize(columnHeaders, this.converter);
        List<SelectedItem> list5 = list2 = (list = selectedItems.stream().map(s -> new SelectedItem(s.getKey(), s.getSubKey(), Collections.min(instance.convertWorkingDaysToDays(s.getLowerAgeLimit())), Collections.max(instance.convertWorkingDaysToDays(s.getUpperAgeLimit())))).collect(Collectors.toList()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    private boolean subKeyIsSet(List<SelectedItem> selectedItems) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        JoinPoint joinPoint;
        block1: {
            List<SelectedItem> list = selectedItems;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, list);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            for (SelectedItem selectedItem : selectedItems) {
                if (selectedItem.getSubKey() == null || selectedItem.getSubKey().isEmpty()) continue;
                bl2 = bl3 = true;
                break block1;
            }
            bl2 = bl3 = false;
        }
        boolean bl4 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl3;
    }

    private String[] toUpperCopy(String ... source) {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        String[] stringArray4 = source;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)stringArray4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (source == null || source.length == 0) {
            stringArray2 = stringArray3 = null;
        } else {
            String[] target = new String[source.length];
            int i = 0;
            while (i < source.length) {
                target[i] = source[i].toUpperCase();
                ++i;
            }
            stringArray2 = stringArray3 = target;
        }
        String[] stringArray5 = stringArray = stringArray2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, stringArray);
        return stringArray3;
    }

    static {
        TimeIntervalReportBuilderImpl.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TimeIntervalReportBuilderImpl.java", TimeIntervalReportBuilderImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withColumnHeaders", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "columnHeaders", "", "pro.taskana.monitor.api.reports.TimeIntervalReportBuilder"), 108);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "inWorkingDays", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "", "", "", "pro.taskana.monitor.api.reports.TimeIntervalReportBuilder"), 114);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "customAttributeLike", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "pro.taskana.task.api.TaskCustomField:[Ljava.lang.String;", "customField:strings", "pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.monitor.api.reports.TimeIntervalReportBuilder"), 282);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listTaskIdsForSelectedItems", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List:pro.taskana.monitor.api.TaskTimestamp", "selectedItems:timestamp", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "java.util.List"), 346);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listCustomAttributeValuesForCustomAttributeName", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "pro.taskana.task.api.TaskCustomField", "taskCustomField", "pro.taskana.common.api.exceptions.NotAuthorizedException", "java.util.List"), 383);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getCombinedClassificationFilter", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "", "", "", "java.util.List"), 400);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "convertWorkingDaysToDays", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List:java.util.List", "selectedItems:columnHeaders", "pro.taskana.common.api.exceptions.InvalidArgumentException", "java.util.List"), 407);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "subKeyIsSet", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "selectedItems", "", "boolean"), 422);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("82", "toUpperCopy", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "[Ljava.lang.String;", "source", "", "[Ljava.lang.String;"), 431);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "workbasketIdIn", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "workbasketIds", "", "pro.taskana.monitor.api.reports.TimeIntervalReportBuilder"), 120);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stateIn", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "states", "", "pro.taskana.monitor.api.reports.TimeIntervalReportBuilder"), 126);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "classificationCategoryIn", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "classificationCategory", "", "pro.taskana.monitor.api.reports.TimeIntervalReportBuilder"), 132);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "classificationIdIn", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "classificationIds", "", "pro.taskana.monitor.api.reports.TimeIntervalReportBuilder"), 138);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "excludedClassificationIdIn", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "excludedClassificationIds", "", "pro.taskana.monitor.api.reports.TimeIntervalReportBuilder"), 144);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "domainIn", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "domains", "", "pro.taskana.monitor.api.reports.TimeIntervalReportBuilder"), 150);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "customAttributeIn", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "pro.taskana.task.api.TaskCustomField:[Ljava.lang.String;", "customField:strings", "pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.monitor.api.reports.TimeIntervalReportBuilder"), 156);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "customAttributeNotIn", "pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl", "pro.taskana.task.api.TaskCustomField:[Ljava.lang.String;", "customField:strings", "pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.monitor.api.reports.TimeIntervalReportBuilder"), 219);
    }
}

