/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.spi.priority.internal;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.LogSanitizer;
import pro.taskana.spi.priority.api.PriorityServiceProvider;
import pro.taskana.task.api.models.TaskSummary;

public class PriorityServiceManager {
    private static final Logger LOGGER;
    private static PriorityServiceManager singleton;
    private final ServiceLoader<PriorityServiceProvider> serviceLoader = ServiceLoader.load(PriorityServiceProvider.class);
    private boolean enabled = false;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        PriorityServiceManager.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(PriorityServiceManager.class);
    }

    private PriorityServiceManager() {
        for (PriorityServiceProvider priorityProvider : this.serviceLoader) {
            LOGGER.info("Registered PriorityServiceProvider: {}", (Object)priorityProvider.getClass().getName());
            this.enabled = true;
        }
        if (!this.enabled) {
            LOGGER.info("No PriorityServiceProvider found. Running without PriorityServiceProvider.");
        }
    }

    public static synchronized PriorityServiceManager getInstance() {
        PriorityServiceManager priorityServiceManager;
        PriorityServiceManager priorityServiceManager2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (singleton == null) {
            singleton = new PriorityServiceManager();
        }
        PriorityServiceManager priorityServiceManager3 = priorityServiceManager2 = (priorityServiceManager = singleton);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)priorityServiceManager2);
        return priorityServiceManager;
    }

    public static boolean isPriorityServiceEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = Objects.nonNull(singleton) && PriorityServiceManager.singleton.enabled ? (bl = true) : (bl = false);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public long countRegisteredServices() {
        long l;
        long l2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        long l3 = l2 = (l = StreamSupport.stream(this.serviceLoader.spliterator(), false).count());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.longObject((long)l2));
        return l;
    }

    public Optional<Integer> calculatePriorityOfTask(TaskSummary task) {
        Optional<Object> optional;
        Optional<Object> optional2;
        Optional<Integer> optional3;
        List priorities;
        TaskSummary taskSummary = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)taskSummary);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sending task to PriorityServiceProviders: {}", (Object)task);
        }
        if ((priorities = StreamSupport.stream(this.serviceLoader.spliterator(), false).map(provider -> this.getPriorityByProvider(task, (PriorityServiceProvider)provider)).filter(Optional::isPresent).map(Optional::get).distinct().collect(Collectors.toList())).size() <= 1) {
            optional3 = priorities.stream().findFirst();
            optional2 = optional3;
        } else {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("The PriorityServiceProviders determined more than one priority for Task {}.", (Object)LogSanitizer.stripLineBreakingChars((Object)task));
            }
            optional3 = Optional.empty();
            optional2 = optional3;
        }
        Optional<Object> optional4 = optional = optional2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, optional);
        return optional3;
    }

    private Optional<Integer> getPriorityByProvider(TaskSummary task, PriorityServiceProvider provider) {
        Optional<Integer> optional;
        Optional<Integer> optional2;
        TaskSummary taskSummary = task;
        PriorityServiceProvider priorityServiceProvider = provider;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)taskSummary, (Object)priorityServiceProvider);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            optional2 = provider.calculatePriority(task);
        }
        catch (Exception e) {
            throw new SystemException(String.format("Caught exception while calculating priority of Task in provider %s.", provider.getClass().getName()), (Throwable)e);
        }
        Optional<Integer> optional3 = optional = optional2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, optional);
        return optional2;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PriorityServiceManager.java", PriorityServiceManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("29", "getInstance", "pro.taskana.spi.priority.internal.PriorityServiceManager", "", "", "", "pro.taskana.spi.priority.internal.PriorityServiceManager"), 35);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "isPriorityServiceEnabled", "pro.taskana.spi.priority.internal.PriorityServiceManager", "", "", "", "boolean"), 42);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "countRegisteredServices", "pro.taskana.spi.priority.internal.PriorityServiceManager", "", "", "", "long"), 46);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "calculatePriorityOfTask", "pro.taskana.spi.priority.internal.PriorityServiceManager", "pro.taskana.task.api.models.TaskSummary", "task", "", "java.util.Optional"), 50);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getPriorityByProvider", "pro.taskana.spi.priority.internal.PriorityServiceManager", "pro.taskana.task.api.models.TaskSummary:pro.taskana.spi.priority.api.PriorityServiceProvider", "task:provider", "", "java.util.Optional"), 76);
    }
}

