/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal.jobs.helper;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.CheckedConsumer;
import pro.taskana.spi.priority.internal.PriorityServiceManager;
import pro.taskana.task.api.TaskQueryColumnName;
import pro.taskana.task.api.TaskState;
import pro.taskana.task.api.models.TaskSummary;
import pro.taskana.task.internal.jobs.helper.SqlConnectionRunner;
import pro.taskana.task.internal.jobs.helper.TaskUpdatePriorityBatchStatement;

public class TaskUpdatePriorityWorker {
    private final SqlConnectionRunner sqlConnectionRunner;
    private final TaskanaEngine taskanaEngine;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public TaskUpdatePriorityWorker(TaskanaEngine taskanaEngine) {
        this.taskanaEngine = taskanaEngine;
        this.sqlConnectionRunner = new SqlConnectionRunner(taskanaEngine);
    }

    public List<String> executeBatch(List<String> taskIds) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        List<String> list = taskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ArrayList<String> updatedTaskIds = new ArrayList<String>();
        this.sqlConnectionRunner.runWithConnection((CheckedConsumer<Connection, SQLException>)((CheckedConsumer)connection -> {
            TaskUpdatePriorityBatchStatement taskUpdateBatch = new TaskUpdatePriorityBatchStatement((Connection)connection);
            List<TaskSummary> list3 = this.getTaskSummariesByIds(taskIds);
            for (TaskSummary taskSummary : list3) {
                Optional<Integer> calculatedPriority = this.getCalculatedPriority(taskSummary);
                if (!calculatedPriority.isPresent()) continue;
                String taskId = taskSummary.getId();
                updatedTaskIds.add(taskId);
                taskUpdateBatch.addPriorityUpdate(taskId, calculatedPriority.get());
            }
            taskUpdateBatch.executeBatch();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }));
        ArrayList<String> arrayList3 = arrayList2 = (arrayList = updatedTaskIds);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList2);
        return arrayList;
    }

    public List<String> getAllRelevantTaskIds() {
        List list;
        List list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List list3 = list2 = (list = this.taskanaEngine.getTaskService().createTaskQuery().stateNotIn(TaskState.END_STATES).listValues(TaskQueryColumnName.ID, BaseQuery.SortDirection.ASCENDING));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    public List<TaskSummary> getTaskSummariesByIds(List<String> taskIds) {
        List list;
        List list2;
        List<String> list3 = taskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, list3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List list4 = list2 = (list = this.taskanaEngine.getTaskService().createTaskQuery().idIn(taskIds.toArray(new String[0])).list());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    public Optional<Integer> getCalculatedPriority(TaskSummary taskSummary) {
        Optional<Integer> optional;
        Optional<Integer> optional2;
        TaskSummary taskSummary2 = taskSummary;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)taskSummary2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Optional<Integer> optional3 = optional2 = (optional = PriorityServiceManager.getInstance().calculatePriorityOfTask(taskSummary).filter(TaskUpdatePriorityWorker.hasDifferentPriority(taskSummary)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, optional2);
        return optional;
    }

    public static Predicate<Integer> hasDifferentPriority(TaskSummary taskSummary) {
        Predicate<Integer> predicate;
        Predicate<Integer> predicate2;
        TaskSummary taskSummary2 = taskSummary;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)taskSummary2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Predicate<Integer> predicate3 = predicate2 = (predicate = prio -> taskSummary != null && prio.intValue() != taskSummary.getPriority());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, predicate2);
        return predicate;
    }

    static {
        TaskUpdatePriorityWorker.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskUpdatePriorityWorker.java", TaskUpdatePriorityWorker.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeBatch", "pro.taskana.task.internal.jobs.helper.TaskUpdatePriorityWorker", "java.util.List", "taskIds", "", "java.util.List"), 25);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAllRelevantTaskIds", "pro.taskana.task.internal.jobs.helper.TaskUpdatePriorityWorker", "", "", "", "java.util.List"), 58);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskSummariesByIds", "pro.taskana.task.internal.jobs.helper.TaskUpdatePriorityWorker", "java.util.List", "taskIds", "", "java.util.List"), 66);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCalculatedPriority", "pro.taskana.task.internal.jobs.helper.TaskUpdatePriorityWorker", "pro.taskana.task.api.models.TaskSummary", "taskSummary", "", "java.util.Optional"), 74);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "hasDifferentPriority", "pro.taskana.task.internal.jobs.helper.TaskUpdatePriorityWorker", "pro.taskana.task.api.models.TaskSummary", "taskSummary", "", "java.util.function.Predicate"), 80);
    }
}

