/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.CustomHoliday;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.api.exceptions.WrongCustomHolidayFormatException;
import pro.taskana.common.internal.TaskanaEngineImpl;
import pro.taskana.common.internal.configuration.DB;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.CheckedFunction;
import pro.taskana.common.internal.util.FileLoaderUtil;
import pro.taskana.common.internal.util.Pair;

public class TaskanaEngineConfiguration {
    private static final Logger LOGGER;
    private static final String TASKANA_PROPERTIES = "/taskana.properties";
    private static final String TASKANA_PROPERTY_SEPARATOR = "|";
    private static final String TASKANA_JOB_BATCH_SIZE = "taskana.jobs.batchSize";
    private static final String TASKANA_JOB_RETRIES = "taskana.jobs.maxRetries";
    private static final String TASKANA_JOB_CLEANUP_RUN_EVERY = "taskana.jobs.cleanup.runEvery";
    private static final String TASKANA_JOB_CLEANUP_FIRST_RUN = "taskana.jobs.cleanup.firstRunAt";
    private static final String TASKANA_JOB_CLEANUP_MINIMUM_AGE = "taskana.jobs.cleanup.minimumAge";
    private static final String TASKANA_JOB_TASK_CLEANUP_ALL_COMPLETED_SAME_PARENT_BUSINESS = "taskana.jobs.cleanup.allCompletedSameParentBusiness";
    private static final String TASKANA_JOB_PRIORITY_BATCHSIZE = "taskana.jobs.priority.batchSize";
    private static final String TASKANA_JOB_PRIORITY_RUN_EVERY = "taskana.jobs.priority.runEvery";
    private static final String TASKANA_JOB_PRIORITY_FIRST_RUN = "taskana.jobs.priority.firstRunAt";
    private static final String TASKANA_JOB_PRIORITY_ACTIVE = "taskana.jobs.priority.active";
    private static final String TASKANA_DOMAINS_PROPERTY = "taskana.domains";
    private static final String TASKANA_CLASSIFICATION_TYPES_PROPERTY = "taskana.classification.types";
    private static final String TASKANA_CLASSIFICATION_CATEGORIES_PROPERTY = "taskana.classification.categories";
    private static final String TASKANA_GERMAN_HOLIDAYS_ENABLED = "taskana.german.holidays.enabled";
    private static final String TASKANA_GERMAN_HOLIDAYS_CORPUS_CHRISTI_ENABLED = "taskana.german.holidays.corpus-christi.enabled";
    private static final String TASKANA_CUSTOM_HOLIDAY = "taskana.custom.holidays";
    private static final String TASKANA_CUSTOM_HOLIDAY_DAY_MONTH_SEPARATOR = ".";
    private static final String TASKANA_HISTORY_DELETION_ON_TASK_DELETION_ENABLED = "taskana.history.deletion.on.task.deletion.enabled";
    private static final String TASKANA_VALIDATION_ALLOW_TIMESTAMP_SERVICE_LEVEL_MISMATCH = "taskana.validation.allowTimestampServiceLevelMismatch";
    private static final String DEFAULT_SCHEMA_NAME = "TASKANA";
    private final List<CustomHoliday> customHolidays = new ArrayList<CustomHoliday>();
    protected String propertiesFileName = "/taskana.properties";
    protected DataSource dataSource;
    protected String schemaName;
    protected String propertiesSeparator = "|";
    protected Map<TaskanaRole, Set<String>> roleMap;
    protected boolean securityEnabled;
    protected boolean useManagedTransactions;
    protected List<String> domains = new ArrayList<String>();
    protected List<String> classificationTypes = new ArrayList<String>();
    protected Map<String, List<String>> classificationCategoriesByTypeMap = new HashMap<String, List<String>>();
    private boolean deleteHistoryOnTaskDeletionEnabled;
    private boolean germanPublicHolidaysEnabled;
    private boolean corpusChristiEnabled;
    private int jobBatchSize = 100;
    private int maxNumberOfJobRetries = 3;
    private Instant cleanupJobFirstRun = Instant.parse("2018-01-01T00:00:00Z");
    private Duration cleanupJobRunEvery = Duration.parse("P1D");
    private Duration cleanupJobMinimumAge = Duration.parse("P14D");
    private boolean taskCleanupJobAllCompletedSameParentBusiness = true;
    private boolean validationAllowTimestampServiceLevelMismatch = false;
    private int priorityJobBatchSize = 100;
    private Instant priorityJobFirstRun = Instant.parse("2018-01-01T00:00:00Z");
    private Duration priorityJobRunEvery = Duration.parse("P1D");
    private boolean priorityJobActive = false;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_53;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_54;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_55;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_56;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_57;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_58;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_59;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_60;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_61;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_62;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_63;

    static {
        TaskanaEngineConfiguration.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TaskanaEngineConfiguration.class);
    }

    public TaskanaEngineConfiguration(DataSource dataSource, boolean useManagedTransactions, String schemaName) {
        this(dataSource, useManagedTransactions, true, schemaName);
    }

    public TaskanaEngineConfiguration(DataSource dataSource, boolean useManagedTransactions, boolean securityEnabled, String schemaName) {
        this(dataSource, useManagedTransactions, securityEnabled, null, null, schemaName);
    }

    public TaskanaEngineConfiguration(DataSource dataSource, boolean useManagedTransactions, boolean securityEnabled, String propertiesFileName, String propertySeparator, String schemaName) {
        this.useManagedTransactions = useManagedTransactions;
        this.securityEnabled = securityEnabled;
        if (propertiesFileName != null) {
            this.propertiesFileName = propertiesFileName;
        }
        if (propertySeparator != null) {
            this.propertiesSeparator = propertySeparator;
        }
        this.dataSource = dataSource != null ? dataSource : TaskanaEngineConfiguration.createDefaultDataSource();
        this.initSchemaName(schemaName);
        this.initTaskanaProperties(this.propertiesFileName, this.propertiesSeparator);
    }

    public void initTaskanaProperties(String propertiesFile, String separator) {
        String string = propertiesFile;
        String string2 = separator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)string2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Reading taskana configuration from {} with separator {}", (Object)propertiesFile, (Object)separator);
        }
        Properties props = this.readPropertiesFromFile(propertiesFile);
        this.initTaskanaRoles(props, separator);
        this.initJobParameters(props);
        this.initDomains(props);
        this.initClassificationTypes(props);
        this.initClassificationCategories(props);
        this.initBooleanProperty(props, TASKANA_GERMAN_HOLIDAYS_ENABLED, this::setGermanPublicHolidaysEnabled);
        this.initBooleanProperty(props, TASKANA_GERMAN_HOLIDAYS_CORPUS_CHRISTI_ENABLED, this::setCorpusChristiEnabled);
        this.initBooleanProperty(props, TASKANA_HISTORY_DELETION_ON_TASK_DELETION_ENABLED, this::setDeleteHistoryOnTaskDeletionEnabled);
        this.initBooleanProperty(props, TASKANA_VALIDATION_ALLOW_TIMESTAMP_SERVICE_LEVEL_MISMATCH, this::setValidationAllowTimestampServiceLevelMismatch);
        this.initCustomHolidays(props, separator);
        Object var7_7 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_7);
    }

    public static DataSource createDefaultDataSource() {
        DataSource dataSource;
        DataSource dataSource2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String driverClass = "org.h2.Driver";
        String jdbcUrl = "jdbc:h2:mem:taskana;IGNORECASE=TRUE;LOCK_MODE=0;INIT=CREATE SCHEMA IF NOT EXISTS TASKANA\\;SET COLLATION DEFAULT_de_DE";
        String username = "sa";
        String password = "sa";
        LOGGER.info("No datasource is provided. An in-memory db is used: '{}', '{}', '{}', '{}'", new Object[]{driverClass, jdbcUrl, username, password});
        DataSource dataSource3 = dataSource2 = (dataSource = TaskanaEngineConfiguration.createDatasource(driverClass, jdbcUrl, username, password));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dataSource2);
        return dataSource;
    }

    public TaskanaEngine buildTaskanaEngine() throws SQLException {
        TaskanaEngine taskanaEngine;
        TaskanaEngine taskanaEngine2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskanaEngine taskanaEngine3 = taskanaEngine2 = (taskanaEngine = TaskanaEngineImpl.createTaskanaEngine(this));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskanaEngine2);
        return taskanaEngine;
    }

    public static DataSource createDatasource(String driver, String jdbcUrl, String username, String password) {
        PooledDataSource pooledDataSource;
        PooledDataSource pooledDataSource2;
        String string = driver;
        String string2 = jdbcUrl;
        String string3 = username;
        String string4 = password;
        Object[] objectArray = new Object[]{string, string2, string3, string4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        PooledDataSource pooledDataSource3 = pooledDataSource2 = (pooledDataSource = new PooledDataSource(driver, jdbcUrl, username, password));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)pooledDataSource2);
        return pooledDataSource;
    }

    public boolean isSecurityEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.securityEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public DataSource getDatasource() {
        DataSource dataSource;
        DataSource dataSource2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DataSource dataSource3 = dataSource2 = (dataSource = this.dataSource);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dataSource2);
        return dataSource;
    }

    public boolean getUseManagedTransactions() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.useManagedTransactions);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public int getMaxNumberOfUpdatesPerTransaction() {
        int n;
        int n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = this.jobBatchSize);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public void setMaxNumberOfUpdatesPerTransaction(int jobBatchSize) {
        int n = jobBatchSize;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.jobBatchSize = jobBatchSize;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public int getMaxNumberOfJobRetries() {
        int n;
        int n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = this.maxNumberOfJobRetries);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public void setMaxNumberOfJobRetries(int maxNumberOfJobRetries) {
        int n = maxNumberOfJobRetries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.maxNumberOfJobRetries = maxNumberOfJobRetries;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public boolean isCorpusChristiEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.corpusChristiEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public void setCorpusChristiEnabled(boolean corpusChristiEnabled) {
        boolean bl = corpusChristiEnabled;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.corpusChristiEnabled = corpusChristiEnabled;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public boolean isGermanPublicHolidaysEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.germanPublicHolidaysEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public void setGermanPublicHolidaysEnabled(boolean germanPublicHolidaysEnabled) {
        boolean bl = germanPublicHolidaysEnabled;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.germanPublicHolidaysEnabled = germanPublicHolidaysEnabled;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public boolean isValidationAllowTimestampServiceLevelMismatch() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.validationAllowTimestampServiceLevelMismatch);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public void setValidationAllowTimestampServiceLevelMismatch(boolean validationAllowTimestampServiceLevelMismatch) {
        boolean bl = validationAllowTimestampServiceLevelMismatch;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.validationAllowTimestampServiceLevelMismatch = validationAllowTimestampServiceLevelMismatch;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public boolean isDeleteHistoryOnTaskDeletionEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.deleteHistoryOnTaskDeletionEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public void setDeleteHistoryOnTaskDeletionEnabled(boolean deleteHistoryOnTaskDeletionEnabled) {
        boolean bl = deleteHistoryOnTaskDeletionEnabled;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.deleteHistoryOnTaskDeletionEnabled = deleteHistoryOnTaskDeletionEnabled;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public List<CustomHoliday> getCustomHolidays() {
        List<CustomHoliday> list;
        List<CustomHoliday> list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<CustomHoliday> list3 = list2 = (list = this.customHolidays);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public void addCustomHolidays(List<CustomHoliday> customHolidays) {
        List<CustomHoliday> list = customHolidays;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.customHolidays.addAll(customHolidays);
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public Map<TaskanaRole, Set<String>> getRoleMap() {
        Map<TaskanaRole, Set<String>> map;
        Map<TaskanaRole, Set<String>> map2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<TaskanaRole, Set<String>> map3 = map2 = (map = this.roleMap);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    public void setRoleMap(Map<TaskanaRole, Set<String>> roleMap) {
        Map<TaskanaRole, Set<String>> map = roleMap;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.roleMap = roleMap;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public List<String> getDomains() {
        List<String> list;
        List<String> list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> list3 = list2 = (list = this.domains);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public void setDomains(List<String> domains) {
        List<String> list = domains;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.domains = domains;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public List<String> getClassificationTypes() {
        List<String> list;
        List<String> list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> list3 = list2 = (list = this.classificationTypes);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public void setClassificationTypes(List<String> classificationTypes) {
        List<String> list = classificationTypes;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.classificationTypes = classificationTypes;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public List<String> getAllClassificationCategories() {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ArrayList<String> classificationCategories = new ArrayList<String>();
        for (Map.Entry<String, List<String>> type : this.classificationCategoriesByTypeMap.entrySet()) {
            classificationCategories.addAll((Collection)type.getValue());
        }
        ArrayList<String> arrayList3 = arrayList2 = (arrayList = classificationCategories);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList2);
        return arrayList;
    }

    public Map<String, List<String>> getClassificationCategoriesByTypeMap() {
        Map<String, List<String>> map;
        Map<String, List<String>> map2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<String, List<String>> map3 = map2 = (map = this.classificationCategoriesByTypeMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ArrayList((Collection)e.getValue()))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    public List<String> getClassificationCategoriesByType(String type) {
        List<String> list;
        List<String> list2;
        String string = type;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> list3 = list2 = (list = this.classificationCategoriesByTypeMap.getOrDefault(type, Collections.emptyList()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public void setClassificationCategoriesByType(Map<String, List<String>> classificationCategoriesByType) {
        Map<String, List<String>> map = classificationCategoriesByType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.classificationCategoriesByTypeMap = classificationCategoriesByType;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public Instant getCleanupJobFirstRun() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.cleanupJobFirstRun);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public void setCleanupJobFirstRun(Instant cleanupJobFirstRun) {
        Instant instant = cleanupJobFirstRun;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object)instant);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.cleanupJobFirstRun = cleanupJobFirstRun;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public Duration getCleanupJobRunEvery() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.cleanupJobRunEvery);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public void setCleanupJobRunEvery(Duration cleanupJobRunEvery) {
        Duration duration = cleanupJobRunEvery;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object)duration);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.cleanupJobRunEvery = cleanupJobRunEvery;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public Duration getCleanupJobMinimumAge() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.cleanupJobMinimumAge);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public void setCleanupJobMinimumAge(Duration cleanupJobMinimumAge) {
        Duration duration = cleanupJobMinimumAge;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)duration);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.cleanupJobMinimumAge = cleanupJobMinimumAge;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public boolean isTaskCleanupJobAllCompletedSameParentBusiness() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.taskCleanupJobAllCompletedSameParentBusiness);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public void setTaskCleanupJobAllCompletedSameParentBusiness(boolean taskCleanupJobAllCompletedSameParentBusiness) {
        boolean bl = taskCleanupJobAllCompletedSameParentBusiness;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskCleanupJobAllCompletedSameParentBusiness = taskCleanupJobAllCompletedSameParentBusiness;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public int getPriorityJobBatchSize() {
        int n;
        int n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = this.priorityJobBatchSize);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public void setPriorityJobBatchSize(int priorityJobBatchSize) {
        int n = priorityJobBatchSize;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.priorityJobBatchSize = priorityJobBatchSize;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public Instant getPriorityJobFirstRun() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.priorityJobFirstRun);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public void setPriorityJobFirstRun(Instant priorityJobFirstRun) {
        Instant instant = priorityJobFirstRun;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, (Object)instant);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.priorityJobFirstRun = priorityJobFirstRun;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public Duration getPriorityJobRunEvery() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.priorityJobRunEvery);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public void setPriorityJobRunEvery(Duration priorityJobRunEvery) {
        Duration duration = priorityJobRunEvery;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this, (Object)duration);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.priorityJobRunEvery = priorityJobRunEvery;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public boolean isPriorityJobActive() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.priorityJobActive);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public void setPriorityJobActive(boolean priorityJobActive) {
        boolean bl = priorityJobActive;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.priorityJobActive = priorityJobActive;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public String getSchemaName() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.schemaName);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public void setSchemaName(String schemaName) {
        String string = schemaName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.schemaName = schemaName;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public static boolean shouldUseLowerCaseForAccessIds() {
        boolean bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl2 = true;
        boolean bl3 = bl = true;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl2;
    }

    public Properties readPropertiesFromFile() {
        Properties properties;
        Properties properties2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Properties properties3 = properties2 = (properties = this.readPropertiesFromFile(this.propertiesFileName));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)properties2);
        return properties;
    }

    private <T> Optional<T> parseProperty(Properties props, String key, CheckedFunction<String, T, Exception> function) {
        Optional optional;
        Optional<Object> optional2;
        Optional<Object> optional3;
        JoinPoint joinPoint;
        block3: {
            block2: {
                Properties properties = props;
                String string = key;
                CheckedFunction<String, T, Exception> checkedFunction = function;
                Object[] objectArray = new Object[]{properties, string, checkedFunction};
                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this, (Object[])objectArray);
                LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
                String property = props.getProperty(key, "");
                if (property.isEmpty()) break block2;
                try {
                    optional2 = optional3 = Optional.ofNullable(function.apply((Object)property));
                }
                catch (Exception t) {
                    LOGGER.warn("Could not parse property {} ({}). Using default. Exception: {}", new Object[]{key, property, t.getMessage()});
                }
                break block3;
            }
            optional2 = optional3 = Optional.empty();
        }
        Optional optional4 = optional = optional2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, optional);
        return optional3;
    }

    private void initJobParameters(Properties props) {
        Properties properties = props;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, (Object)this, (Object)this, (Object)properties);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.parseProperty(props, TASKANA_JOB_BATCH_SIZE, Integer::parseInt).ifPresent(this::setMaxNumberOfUpdatesPerTransaction);
        this.parseProperty(props, TASKANA_JOB_RETRIES, Integer::parseInt).ifPresent(this::setMaxNumberOfJobRetries);
        this.parseProperty(props, TASKANA_JOB_CLEANUP_FIRST_RUN, Instant::parse).ifPresent(this::setCleanupJobFirstRun);
        this.parseProperty(props, TASKANA_JOB_CLEANUP_RUN_EVERY, Duration::parse).ifPresent(this::setCleanupJobRunEvery);
        this.parseProperty(props, TASKANA_JOB_CLEANUP_MINIMUM_AGE, Duration::parse).ifPresent(this::setCleanupJobMinimumAge);
        this.parseProperty(props, TASKANA_JOB_PRIORITY_BATCHSIZE, Integer::parseInt).ifPresent(this::setPriorityJobBatchSize);
        this.parseProperty(props, TASKANA_JOB_PRIORITY_RUN_EVERY, Duration::parse).ifPresent(this::setPriorityJobRunEvery);
        this.parseProperty(props, TASKANA_JOB_PRIORITY_FIRST_RUN, Instant::parse).ifPresent(this::setPriorityJobFirstRun);
        this.parseProperty(props, TASKANA_JOB_PRIORITY_ACTIVE, Boolean::parseBoolean).ifPresent(this::setPriorityJobActive);
        this.parseProperty(props, TASKANA_JOB_TASK_CLEANUP_ALL_COMPLETED_SAME_PARENT_BUSINESS, Boolean::parseBoolean).ifPresent(this::setTaskCleanupJobAllCompletedSameParentBusiness);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Configured number of task and workbasket updates per transaction: {}", (Object)this.jobBatchSize);
            LOGGER.debug("Number of retries of failed task updates: {}", (Object)this.maxNumberOfJobRetries);
            LOGGER.debug("CleanupJob configuration: first run at {}", (Object)this.cleanupJobFirstRun);
            LOGGER.debug("CleanupJob configuration: runs every {}", (Object)this.cleanupJobRunEvery);
            LOGGER.debug("CleanupJob configuration: minimum age of tasks to be cleanup up is {}", (Object)this.cleanupJobMinimumAge);
            LOGGER.debug("TaskCleanupJob configuration: all completed task with the same parent business property id {}", (Object)this.taskCleanupJobAllCompletedSameParentBusiness);
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private void initDomains(Properties props) {
        Properties properties = props;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_53, (Object)this, (Object)this, (Object)properties);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        CheckedFunction parseFunction = p -> this.splitStringAndTrimElements((String)p, ",", String::toUpperCase);
        this.parseProperty(props, TASKANA_DOMAINS_PROPERTY, parseFunction).ifPresent(this::setDomains);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Configured domains: {}", this.domains);
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    private void initClassificationTypes(Properties props) {
        Properties properties = props;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_54, (Object)this, (Object)this, (Object)properties);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        CheckedFunction parseFunction = p -> this.splitStringAndTrimElements((String)p, ",", String::toUpperCase);
        this.parseProperty(props, TASKANA_CLASSIFICATION_TYPES_PROPERTY, parseFunction).ifPresent(this::setClassificationTypes);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Configured classificationTypes: {}", this.classificationTypes);
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    private void initClassificationCategories(Properties props) {
        Properties properties = props;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_55, (Object)this, (Object)this, (Object)properties);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Function<String, List> getClassificationCategoriesForType = type -> {
            CheckedFunction parseFunction = s -> this.splitStringAndTrimElements((String)s, ",", String::toUpperCase);
            return this.parseProperty(props, "taskana.classification.categories." + type.toLowerCase(), parseFunction).orElseGet(ArrayList::new);
        };
        this.classificationCategoriesByTypeMap = this.classificationTypes.stream().map(type -> Pair.of((Object)type, (Object)((List)getClassificationCategoriesForType.apply((String)type)))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Configured classification categories : {}", this.classificationCategoriesByTypeMap);
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    private void initBooleanProperty(Properties props, String propertyName, Consumer<Boolean> consumer) {
        Properties properties = props;
        String string = propertyName;
        Consumer<Boolean> consumer2 = consumer;
        Object[] objectArray = new Object[]{properties, string, consumer2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_56, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.parseProperty(props, propertyName, Boolean::parseBoolean).ifPresent(consumer);
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    private void initSchemaName(String schemaName) {
        String string = schemaName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_57, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (schemaName != null && !schemaName.isEmpty()) {
            this.setSchemaName(schemaName);
        } else {
            this.setSchemaName(DEFAULT_SCHEMA_NAME);
        }
        try {
            Throwable throwable = null;
            Object var3_7 = null;
            try (Connection connection = this.dataSource.getConnection();){
                String databaseProductId = DB.getDatabaseProductId((String)connection.getMetaData().getDatabaseProductName());
                this.schemaName = DB.isPostgres((String)databaseProductId) ? this.schemaName.toLowerCase() : this.schemaName.toUpperCase();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException ex) {
            LOGGER.error("Caught exception when attempting to initialize the schema name", (Throwable)ex);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Using schema name {}", (Object)this.getSchemaName());
        }
        Object var8_11 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_11);
    }

    private void initTaskanaRoles(Properties props, String rolesSeparator) {
        Properties properties = props;
        String string = rolesSeparator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_58, (Object)this, (Object)this, (Object)properties, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Function<TaskanaRole, Set> getAccessIdsForRole = role -> {
            List<String> accessIds = this.splitStringAndTrimElements(props.getProperty(role.getPropertyName().toLowerCase(), ""), rolesSeparator, TaskanaEngineConfiguration.shouldUseLowerCaseForAccessIds() ? String::toLowerCase : UnaryOperator.identity());
            return new HashSet<String>(accessIds);
        };
        this.roleMap = Arrays.stream(TaskanaRole.values()).map(role -> Pair.of((Object)role, (Object)((Set)getAccessIdsForRole.apply((TaskanaRole)role)))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        if (LOGGER.isDebugEnabled()) {
            this.roleMap.forEach((k, v) -> LOGGER.debug("Found Taskana RoleConfig {} : {} ", k, v));
        }
        Object var7_7 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_7);
    }

    private void initCustomHolidays(Properties props, String separator) {
        Properties properties = props;
        String string = separator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_59, (Object)this, (Object)this, (Object)properties, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        CheckedFunction parseFunction = s -> this.splitStringAndTrimElements((String)s, separator).stream().map(str -> {
            try {
                return this.createCustomHolidayFromPropsEntry((String)str);
            }
            catch (WrongCustomHolidayFormatException e) {
                LOGGER.warn(e.getMessage());
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        this.parseProperty(props, TASKANA_CUSTOM_HOLIDAY, parseFunction).ifPresent(this::addCustomHolidays);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Configured custom Holidays : {}", this.customHolidays);
        }
        Object var7_7 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_7);
    }

    private CustomHoliday createCustomHolidayFromPropsEntry(String customHolidayEntry) throws WrongCustomHolidayFormatException {
        CustomHoliday customHoliday;
        String string = customHolidayEntry;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_60, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> parts = this.splitStringAndTrimElements(customHolidayEntry, TASKANA_CUSTOM_HOLIDAY_DAY_MONTH_SEPARATOR);
        if (parts.size() != 2) {
            throw new WrongCustomHolidayFormatException(customHolidayEntry);
        }
        CustomHoliday customHoliday2 = CustomHoliday.of((Integer)Integer.valueOf(parts.get(0)), (Integer)Integer.valueOf(parts.get(1)));
        CustomHoliday customHoliday3 = customHoliday = customHoliday2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)customHoliday);
        return customHoliday2;
    }

    private List<String> splitStringAndTrimElements(String str, String separator) {
        List<String> list;
        List<String> list2;
        String string = str;
        String string2 = separator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_61, (Object)this, (Object)this, (Object)string, (Object)string2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> list3 = list2 = (list = this.splitStringAndTrimElements(str, separator, UnaryOperator.identity()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    private List<String> splitStringAndTrimElements(String str, String separator, UnaryOperator<String> modifier) {
        List<String> list;
        List<String> list2;
        String string = str;
        String string2 = separator;
        UnaryOperator<String> unaryOperator = modifier;
        Object[] objectArray = new Object[]{string, string2, unaryOperator};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_62, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> list3 = list2 = (list = Arrays.stream(str.split(Pattern.quote(separator))).filter(s -> !s.isEmpty()).map(String::trim).map(modifier).collect(Collectors.toList()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    private Properties readPropertiesFromFile(String propertiesFile) {
        Properties properties;
        Properties properties2;
        String string = propertiesFile;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_63, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Properties props = new Properties();
        try {
            Throwable throwable = null;
            Object var4_8 = null;
            try (InputStream stream = FileLoaderUtil.openFileFromClasspathOrSystem((String)propertiesFile, this.getClass());){
                props.load(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("caught IOException when processing properties file {}.", (Object)propertiesFile);
            throw new SystemException("internal System error when processing properties file " + propertiesFile, e.getCause());
        }
        Properties properties3 = properties2 = (properties = props);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)properties2);
        return properties;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskanaEngineConfiguration.java", TaskanaEngineConfiguration.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initTaskanaProperties", "pro.taskana.TaskanaEngineConfiguration", "java.lang.String:java.lang.String", "propertiesFile:separator", "", "void"), 161);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "createDefaultDataSource", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "javax.sql.DataSource"), 187);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMaxNumberOfJobRetries", "pro.taskana.TaskanaEngineConfiguration", "int", "maxNumberOfJobRetries", "", "void"), 252);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isCorpusChristiEnabled", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "boolean"), 256);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCorpusChristiEnabled", "pro.taskana.TaskanaEngineConfiguration", "boolean", "corpusChristiEnabled", "", "void"), 260);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isGermanPublicHolidaysEnabled", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "boolean"), 264);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setGermanPublicHolidaysEnabled", "pro.taskana.TaskanaEngineConfiguration", "boolean", "germanPublicHolidaysEnabled", "", "void"), 268);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isValidationAllowTimestampServiceLevelMismatch", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "boolean"), 272);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setValidationAllowTimestampServiceLevelMismatch", "pro.taskana.TaskanaEngineConfiguration", "boolean", "validationAllowTimestampServiceLevelMismatch", "", "void"), 276);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isDeleteHistoryOnTaskDeletionEnabled", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "boolean"), 282);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDeleteHistoryOnTaskDeletionEnabled", "pro.taskana.TaskanaEngineConfiguration", "boolean", "deleteHistoryOnTaskDeletionEnabled", "", "void"), 286);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustomHolidays", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.util.List"), 290);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildTaskanaEngine", "pro.taskana.TaskanaEngineConfiguration", "", "", "java.sql.SQLException", "pro.taskana.common.api.TaskanaEngine"), 210);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addCustomHolidays", "pro.taskana.TaskanaEngineConfiguration", "java.util.List", "customHolidays", "", "void"), 294);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRoleMap", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.util.Map"), 298);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRoleMap", "pro.taskana.TaskanaEngineConfiguration", "java.util.Map", "roleMap", "", "void"), 302);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDomains", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.util.List"), 306);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDomains", "pro.taskana.TaskanaEngineConfiguration", "java.util.List", "domains", "", "void"), 310);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationTypes", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.util.List"), 314);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setClassificationTypes", "pro.taskana.TaskanaEngineConfiguration", "java.util.List", "classificationTypes", "", "void"), 318);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAllClassificationCategories", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.util.List"), 322);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationCategoriesByTypeMap", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.util.Map"), 330);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationCategoriesByType", "pro.taskana.TaskanaEngineConfiguration", "java.lang.String", "type", "", "java.util.List"), 335);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "createDatasource", "pro.taskana.TaskanaEngineConfiguration", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "driver:jdbcUrl:username:password", "", "javax.sql.DataSource"), 223);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setClassificationCategoriesByType", "pro.taskana.TaskanaEngineConfiguration", "java.util.Map", "classificationCategoriesByType", "", "void"), 339);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCleanupJobFirstRun", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.time.Instant"), 344);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCleanupJobFirstRun", "pro.taskana.TaskanaEngineConfiguration", "java.time.Instant", "cleanupJobFirstRun", "", "void"), 348);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCleanupJobRunEvery", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.time.Duration"), 352);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCleanupJobRunEvery", "pro.taskana.TaskanaEngineConfiguration", "java.time.Duration", "cleanupJobRunEvery", "", "void"), 356);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCleanupJobMinimumAge", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.time.Duration"), 360);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCleanupJobMinimumAge", "pro.taskana.TaskanaEngineConfiguration", "java.time.Duration", "cleanupJobMinimumAge", "", "void"), 364);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isTaskCleanupJobAllCompletedSameParentBusiness", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "boolean"), 368);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTaskCleanupJobAllCompletedSameParentBusiness", "pro.taskana.TaskanaEngineConfiguration", "boolean", "taskCleanupJobAllCompletedSameParentBusiness", "", "void"), 372);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriorityJobBatchSize", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "int"), 378);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSecurityEnabled", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "boolean"), 228);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPriorityJobBatchSize", "pro.taskana.TaskanaEngineConfiguration", "int", "priorityJobBatchSize", "", "void"), 382);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriorityJobFirstRun", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.time.Instant"), 386);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPriorityJobFirstRun", "pro.taskana.TaskanaEngineConfiguration", "java.time.Instant", "priorityJobFirstRun", "", "void"), 390);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriorityJobRunEvery", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.time.Duration"), 394);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPriorityJobRunEvery", "pro.taskana.TaskanaEngineConfiguration", "java.time.Duration", "priorityJobRunEvery", "", "void"), 398);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isPriorityJobActive", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "boolean"), 402);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPriorityJobActive", "pro.taskana.TaskanaEngineConfiguration", "boolean", "priorityJobActive", "", "void"), 406);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSchemaName", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.lang.String"), 410);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSchemaName", "pro.taskana.TaskanaEngineConfiguration", "java.lang.String", "schemaName", "", "void"), 414);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "shouldUseLowerCaseForAccessIds", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "boolean"), 424);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDatasource", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "javax.sql.DataSource"), 232);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "readPropertiesFromFile", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.util.Properties"), 428);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "parseProperty", "pro.taskana.TaskanaEngineConfiguration", "java.util.Properties:java.lang.String:pro.taskana.common.internal.util.CheckedFunction", "props:key:function", "", "java.util.Optional"), 432);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initJobParameters", "pro.taskana.TaskanaEngineConfiguration", "java.util.Properties", "props", "", "void"), 449);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initDomains", "pro.taskana.TaskanaEngineConfiguration", "java.util.Properties", "props", "", "void"), 500);
        ajc$tjp_54 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initClassificationTypes", "pro.taskana.TaskanaEngineConfiguration", "java.util.Properties", "props", "", "void"), 510);
        ajc$tjp_55 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initClassificationCategories", "pro.taskana.TaskanaEngineConfiguration", "java.util.Properties", "props", "", "void"), 521);
        ajc$tjp_56 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initBooleanProperty", "pro.taskana.TaskanaEngineConfiguration", "java.util.Properties:java.lang.String:java.util.function.Consumer", "props:propertyName:consumer", "", "void"), 543);
        ajc$tjp_57 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initSchemaName", "pro.taskana.TaskanaEngineConfiguration", "java.lang.String", "schemaName", "", "void"), 548);
        ajc$tjp_58 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initTaskanaRoles", "pro.taskana.TaskanaEngineConfiguration", "java.util.Properties:java.lang.String", "props:rolesSeparator", "", "void"), 572);
        ajc$tjp_59 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initCustomHolidays", "pro.taskana.TaskanaEngineConfiguration", "java.util.Properties:java.lang.String", "props:separator", "", "void"), 595);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUseManagedTransactions", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "boolean"), 236);
        ajc$tjp_60 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createCustomHolidayFromPropsEntry", "pro.taskana.TaskanaEngineConfiguration", "java.lang.String", "customHolidayEntry", "pro.taskana.common.api.exceptions.WrongCustomHolidayFormatException", "pro.taskana.common.api.CustomHoliday"), 617);
        ajc$tjp_61 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "splitStringAndTrimElements", "pro.taskana.TaskanaEngineConfiguration", "java.lang.String:java.lang.String", "str:separator", "", "java.util.List"), 627);
        ajc$tjp_62 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "splitStringAndTrimElements", "pro.taskana.TaskanaEngineConfiguration", "java.lang.String:java.lang.String:java.util.function.UnaryOperator", "str:separator:modifier", "", "java.util.List"), 631);
        ajc$tjp_63 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "readPropertiesFromFile", "pro.taskana.TaskanaEngineConfiguration", "java.lang.String", "propertiesFile", "", "java.util.Properties"), 640);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxNumberOfUpdatesPerTransaction", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "int"), 240);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMaxNumberOfUpdatesPerTransaction", "pro.taskana.TaskanaEngineConfiguration", "int", "jobBatchSize", "", "void"), 244);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxNumberOfJobRetries", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "int"), 248);
    }
}

