/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.api;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Supplier;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.TaskanaEngineConfiguration;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.common.api.ConfigurationService;
import pro.taskana.common.api.JobService;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.WorkingDaysToDaysConverter;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.security.CurrentUserContext;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.monitor.api.MonitorService;
import pro.taskana.task.api.TaskService;
import pro.taskana.user.api.UserService;
import pro.taskana.workbasket.api.WorkbasketService;

public interface TaskanaEngine {
    public static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public TaskService getTaskService();

    public MonitorService getMonitorService();

    public WorkbasketService getWorkbasketService();

    public ClassificationService getClassificationService();

    public JobService getJobService();

    public UserService getUserService();

    public ConfigurationService getConfigurationService();

    public TaskanaEngineConfiguration getConfiguration();

    public WorkingDaysToDaysConverter getWorkingDaysToDaysConverter();

    public boolean isHistoryEnabled();

    public ConnectionManagementMode getConnectionManagementMode();

    public void setConnectionManagementMode(ConnectionManagementMode var1);

    public void setConnection(Connection var1) throws SQLException;

    public void closeConnection();

    public boolean isUserInRole(TaskanaRole ... var1);

    public void checkRoleMembership(TaskanaRole ... var1) throws NotAuthorizedException;

    public <T> T runAsAdmin(Supplier<T> var1);

    default public void runAsAdmin(Runnable runnable) {
        Runnable runnable2 = runnable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)runnable2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.runAsAdmin(() -> {
            runnable.run();
            return null;
        });
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public CurrentUserContext getCurrentUserContext();

    static {
        Factory factory = new Factory("TaskanaEngine.java", TaskanaEngine.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "runAsAdmin", "pro.taskana.common.api.TaskanaEngine", "java.lang.Runnable", "runnable", "", "void"), 148);
    }

    public static final class ConnectionManagementMode
    extends Enum<ConnectionManagementMode> {
        public static final /* enum */ ConnectionManagementMode PARTICIPATE;
        public static final /* enum */ ConnectionManagementMode AUTOCOMMIT;
        public static final /* enum */ ConnectionManagementMode EXPLICIT;
        private static final /* synthetic */ ConnectionManagementMode[] ENUM$VALUES;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        static {
            ConnectionManagementMode.ajc$preClinit();
            PARTICIPATE = new ConnectionManagementMode();
            AUTOCOMMIT = new ConnectionManagementMode();
            EXPLICIT = new ConnectionManagementMode();
            ENUM$VALUES = new ConnectionManagementMode[]{PARTICIPATE, AUTOCOMMIT, EXPLICIT};
        }

        public static ConnectionManagementMode[] values() {
            ConnectionManagementMode[] connectionManagementModeArray;
            ConnectionManagementMode[] connectionManagementModeArray2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            ConnectionManagementMode[] connectionManagementModeArray3 = ENUM$VALUES;
            int n = connectionManagementModeArray3.length;
            ConnectionManagementMode[] connectionManagementModeArray4 = new ConnectionManagementMode[n];
            System.arraycopy(ENUM$VALUES, 0, connectionManagementModeArray4, 0, n);
            ConnectionManagementMode[] connectionManagementModeArray5 = connectionManagementModeArray2 = (connectionManagementModeArray = connectionManagementModeArray4);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)connectionManagementModeArray2);
            return connectionManagementModeArray;
        }

        public static ConnectionManagementMode valueOf(String arg0) {
            ConnectionManagementMode connectionManagementMode;
            ConnectionManagementMode connectionManagementMode2;
            String string = arg0;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            ConnectionManagementMode connectionManagementMode3 = connectionManagementMode2 = (connectionManagementMode = Enum.valueOf(ConnectionManagementMode.class, arg0));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)connectionManagementMode2);
            return connectionManagementMode;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskanaEngine.java", ConnectionManagementMode.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "values", "pro.taskana.common.api.TaskanaEngine$ConnectionManagementMode", "", "", "", "[Lpro.taskana.common.api.TaskanaEngine$ConnectionManagementMode;"), 1);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "valueOf", "pro.taskana.common.api.TaskanaEngine$ConnectionManagementMode", "java.lang.String", "arg0", "", "pro.taskana.common.api.TaskanaEngine$ConnectionManagementMode"), 1);
        }
    }
}

