/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.workbasket.internal;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.Pair;

public class WorkbasketAccessSqlProvider {
    private static final List<Pair<String, String>> COLUMNS;
    private static final List<Pair<String, String>> PERMISSIONS;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    static {
        WorkbasketAccessSqlProvider.ajc$preClinit();
        COLUMNS = Arrays.asList(Pair.of((Object)"WORKBASKET_ID", (Object)"#{workbasketAccessItem.workbasketId}"), Pair.of((Object)"ACCESS_ID", (Object)"#{workbasketAccessItem.accessId}"), Pair.of((Object)"ACCESS_NAME", (Object)"#{workbasketAccessItem.accessName}"));
        PERMISSIONS = Arrays.asList(Pair.of((Object)"PERM_READ", (Object)"#{workbasketAccessItem.permRead}"), Pair.of((Object)"PERM_OPEN", (Object)"#{workbasketAccessItem.permOpen}"), Pair.of((Object)"PERM_APPEND", (Object)"#{workbasketAccessItem.permAppend}"), Pair.of((Object)"PERM_TRANSFER", (Object)"#{workbasketAccessItem.permTransfer}"), Pair.of((Object)"PERM_DISTRIBUTE", (Object)"#{workbasketAccessItem.permDistribute}"), Pair.of((Object)"PERM_CUSTOM_1", (Object)"#{workbasketAccessItem.permCustom1}"), Pair.of((Object)"PERM_CUSTOM_2", (Object)"#{workbasketAccessItem.permCustom2}"), Pair.of((Object)"PERM_CUSTOM_3", (Object)"#{workbasketAccessItem.permCustom3}"), Pair.of((Object)"PERM_CUSTOM_4", (Object)"#{workbasketAccessItem.permCustom4}"), Pair.of((Object)"PERM_CUSTOM_5", (Object)"#{workbasketAccessItem.permCustom5}"), Pair.of((Object)"PERM_CUSTOM_6", (Object)"#{workbasketAccessItem.permCustom6}"), Pair.of((Object)"PERM_CUSTOM_7", (Object)"#{workbasketAccessItem.permCustom7}"), Pair.of((Object)"PERM_CUSTOM_8", (Object)"#{workbasketAccessItem.permCustom8}"), Pair.of((Object)"PERM_CUSTOM_9", (Object)"#{workbasketAccessItem.permCustom9}"), Pair.of((Object)"PERM_CUSTOM_10", (Object)"#{workbasketAccessItem.permCustom10}"), Pair.of((Object)"PERM_CUSTOM_11", (Object)"#{workbasketAccessItem.permCustom11}"), Pair.of((Object)"PERM_CUSTOM_12", (Object)"#{workbasketAccessItem.permCustom1}"));
    }

    private WorkbasketAccessSqlProvider() {
    }

    public static String findById() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = "<script>SELECT ID, " + WorkbasketAccessSqlProvider.commonSelectStatements() + "FROM WORKBASKET_ACCESS_LIST WHERE ID = #{id} " + "<if test=\"_databaseId == 'db2'\">with UR </if>" + "</script>");
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public static String findByWorkbasketId() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = "<script>SELECT WBA.ID, WB.KEY, " + WorkbasketAccessSqlProvider.commonSelectStatements() + "FROM WORKBASKET_ACCESS_LIST AS WBA " + "LEFT JOIN WORKBASKET AS WB ON WORKBASKET_ID = WB.ID " + "WHERE WORKBASKET_ID = #{id} " + "<if test=\"_databaseId == 'db2'\">with UR </if>" + "</script>");
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public static String findByAccessId() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = "<script>SELECT WBA.ID, WB.KEY, " + WorkbasketAccessSqlProvider.commonSelectStatements() + "FROM WORKBASKET_ACCESS_LIST AS WBA " + "LEFT JOIN WORKBASKET AS WB ON WORKBASKET_ID = WB.ID " + "WHERE ACCESS_ID = #{id} " + "<if test=\"_databaseId == 'db2'\">with UR </if>" + "</script>");
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public static String insert() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = "INSERT INTO WORKBASKET_ACCESS_LIST (ID, " + WorkbasketAccessSqlProvider.commonSelectStatements() + ") VALUES (#{workbasketAccessItem.id}, " + WorkbasketAccessSqlProvider.insertValues() + ")");
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public static String update() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = "UPDATE WORKBASKET_ACCESS_LIST SET " + WorkbasketAccessSqlProvider.commonUpdateStatement() + "WHERE id = #{workbasketAccessItem.id}");
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public static String delete() {
        String string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string2 = "DELETE FROM WORKBASKET_ACCESS_LIST WHERE ID = #{id}";
        String string3 = string = "DELETE FROM WORKBASKET_ACCESS_LIST WHERE ID = #{id}";
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
        return string2;
    }

    public static String deleteAllAccessItemsForWorkbasketId() {
        String string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string2 = "DELETE FROM WORKBASKET_ACCESS_LIST WHERE WORKBASKET_ID = #{workbasketId}";
        String string3 = string = "DELETE FROM WORKBASKET_ACCESS_LIST WHERE WORKBASKET_ID = #{workbasketId}";
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
        return string2;
    }

    public static String deleteAccessItemsForAccessId() {
        String string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string2 = "DELETE FROM WORKBASKET_ACCESS_LIST where ACCESS_ID = #{accessId}";
        String string3 = string = "DELETE FROM WORKBASKET_ACCESS_LIST where ACCESS_ID = #{accessId}";
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
        return string2;
    }

    public static String findByWorkbasketAndAccessId() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = "<script><choose><when test=\"_databaseId == 'db2'\">SELECT " + WorkbasketAccessSqlProvider.getMaximumPermissionStatement(false) + "</when>" + "<otherwise>" + "SELECT " + WorkbasketAccessSqlProvider.getMaximumPermissionStatement(true) + "</otherwise>" + "</choose>" + "FROM WORKBASKET_ACCESS_LIST " + "WHERE WORKBASKET_ID = #{workbasketId} AND ACCESS_ID IN" + "(<foreach item='item' collection='accessIds' separator=',' >#{item}</foreach>) " + "<if test=\"_databaseId == 'db2'\">with UR </if>" + "</script>");
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public static String findByWorkbasketKeyDomainAndAccessId() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = "<script><choose><when test=\"_databaseId == 'db2'\">SELECT " + WorkbasketAccessSqlProvider.getMaximumPermissionStatement(false) + "</when>" + "<otherwise>" + "SELECT " + WorkbasketAccessSqlProvider.getMaximumPermissionStatement(true) + "</otherwise>" + "</choose>" + "FROM WORKBASKET_ACCESS_LIST " + "WHERE WORKBASKET_ID in (" + "SELECT ID FROM WORKBASKET " + "WHERE UPPER(KEY) = UPPER(#{workbasketKey}) " + "AND UPPER(DOMAIN) = UPPER(#{domain}) " + ")" + "AND ACCESS_ID IN" + "(<foreach item='item' collection='accessIds' separator=',' >#{item}</foreach>)" + "<if test=\"_databaseId == 'db2'\">with UR</if>" + "</script>");
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private static String commonUpdateStatement() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = Stream.concat(COLUMNS.stream(), PERMISSIONS.stream()).map(col -> String.valueOf((String)col.getLeft()) + " = " + (String)col.getRight()).collect(Collectors.joining(", ", "", " ")));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private static String insertValues() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = Stream.concat(COLUMNS.stream(), PERMISSIONS.stream()).map(Pair::getRight).collect(Collectors.joining(", ", "", " ")));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private static String getMaximumPermissionStatement(boolean isNotDb2) {
        String string;
        String string2;
        boolean bl = isNotDb2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, null, null, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = PERMISSIONS.stream().map(perm -> {
            String temp = "MAX(" + (String)perm.getLeft();
            if (isNotDb2) {
                temp = String.valueOf(temp) + "::int";
            }
            temp = String.valueOf(temp) + ") AS " + (String)perm.getLeft();
            return temp;
        }).collect(Collectors.joining(", ", "", " ")));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private static String commonSelectStatements() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = Stream.concat(COLUMNS.stream(), PERMISSIONS.stream()).map(Pair::getLeft).collect(Collectors.joining(", ", "", " ")));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WorkbasketAccessSqlProvider.java", WorkbasketAccessSqlProvider.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "findById", "pro.taskana.workbasket.internal.WorkbasketAccessSqlProvider", "", "", "", "java.lang.String"), 44);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "findByWorkbasketId", "pro.taskana.workbasket.internal.WorkbasketAccessSqlProvider", "", "", "", "java.lang.String"), 54);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "commonUpdateStatement", "pro.taskana.workbasket.internal.WorkbasketAccessSqlProvider", "", "", "", "java.lang.String"), 147);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "insertValues", "pro.taskana.workbasket.internal.WorkbasketAccessSqlProvider", "", "", "", "java.lang.String"), 153);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "getMaximumPermissionStatement", "pro.taskana.workbasket.internal.WorkbasketAccessSqlProvider", "boolean", "isNotDb2", "", "java.lang.String"), 159);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "commonSelectStatements", "pro.taskana.workbasket.internal.WorkbasketAccessSqlProvider", "", "", "", "java.lang.String"), 173);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "findByAccessId", "pro.taskana.workbasket.internal.WorkbasketAccessSqlProvider", "", "", "", "java.lang.String"), 66);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "insert", "pro.taskana.workbasket.internal.WorkbasketAccessSqlProvider", "", "", "", "java.lang.String"), 78);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "update", "pro.taskana.workbasket.internal.WorkbasketAccessSqlProvider", "", "", "", "java.lang.String"), 86);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "delete", "pro.taskana.workbasket.internal.WorkbasketAccessSqlProvider", "", "", "", "java.lang.String"), 92);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "deleteAllAccessItemsForWorkbasketId", "pro.taskana.workbasket.internal.WorkbasketAccessSqlProvider", "", "", "", "java.lang.String"), 96);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "deleteAccessItemsForAccessId", "pro.taskana.workbasket.internal.WorkbasketAccessSqlProvider", "", "", "", "java.lang.String"), 100);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "findByWorkbasketAndAccessId", "pro.taskana.workbasket.internal.WorkbasketAccessSqlProvider", "", "", "", "java.lang.String"), 104);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "findByWorkbasketKeyDomainAndAccessId", "pro.taskana.workbasket.internal.WorkbasketAccessSqlProvider", "", "", "", "java.lang.String"), 123);
    }
}

