/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ibatis.exceptions.PersistenceException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.classification.api.exceptions.ClassificationNotFoundException;
import pro.taskana.classification.api.models.ClassificationSummary;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.IdGenerator;
import pro.taskana.task.api.exceptions.AttachmentPersistenceException;
import pro.taskana.task.api.models.Attachment;
import pro.taskana.task.api.models.AttachmentSummary;
import pro.taskana.task.api.models.Task;
import pro.taskana.task.internal.AttachmentMapper;
import pro.taskana.task.internal.models.AttachmentImpl;
import pro.taskana.task.internal.models.ObjectReferenceImpl;
import pro.taskana.task.internal.models.TaskImpl;

public class AttachmentHandler {
    private static final Logger LOGGER;
    private final AttachmentMapper attachmentMapper;
    private final ClassificationService classificationService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    static {
        AttachmentHandler.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(AttachmentHandler.class);
    }

    AttachmentHandler(AttachmentMapper attachmentMapper, ClassificationService classificationService) {
        this.attachmentMapper = attachmentMapper;
        this.classificationService = classificationService;
    }

    void insertAndDeleteAttachmentsOnTaskUpdate(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) throws AttachmentPersistenceException, InvalidArgumentException, ClassificationNotFoundException {
        TaskImpl taskImpl = newTaskImpl;
        TaskImpl taskImpl2 = oldTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<Attachment> newAttachments = newTaskImpl.getAttachments().stream().filter(Objects::nonNull).collect(Collectors.toList());
        newTaskImpl.setAttachments(newAttachments);
        for (Attachment attachment : newAttachments) {
            this.verifyAttachment((AttachmentImpl)attachment, newTaskImpl.getDomain());
            this.initAttachment((AttachmentImpl)attachment, newTaskImpl);
        }
        this.deleteRemovedAttachmentsOnTaskUpdate(newTaskImpl, oldTaskImpl);
        this.insertNewAttachmentsOnTaskUpdate(newTaskImpl, oldTaskImpl);
        this.updateModifiedAttachmentsOnTaskUpdate(newTaskImpl, oldTaskImpl);
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    void insertNewAttachmentsOnTaskCreation(TaskImpl task) throws InvalidArgumentException, AttachmentPersistenceException, ClassificationNotFoundException {
        TaskImpl taskImpl = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)taskImpl);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<Attachment> attachments = task.getAttachments();
        if (attachments != null) {
            for (Attachment attachment : attachments) {
                AttachmentImpl attachmentImpl = (AttachmentImpl)attachment;
                this.verifyAttachment(attachmentImpl, task.getDomain());
                this.initAttachment(attachmentImpl, task);
                try {
                    this.attachmentMapper.insert(attachmentImpl);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("TaskService.createTask() for TaskId={} INSERTED an Attachment={}.", (Object)task.getId(), (Object)attachmentImpl);
                }
                catch (PersistenceException e) {
                    throw new AttachmentPersistenceException(attachmentImpl.getId(), task.getId(), e);
                }
            }
        }
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    private void insertNewAttachmentsOnTaskUpdate(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) throws AttachmentPersistenceException {
        TaskImpl taskImpl = newTaskImpl;
        TaskImpl taskImpl2 = oldTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Set oldAttachmentIds = oldTaskImpl.getAttachments().stream().map(AttachmentSummary::getId).collect(Collectors.toSet());
        List newAttachments = newTaskImpl.getAttachments().stream().filter(Predicate.not(a -> oldAttachmentIds.contains(a.getId()))).collect(Collectors.toList());
        for (Attachment attachment : newAttachments) {
            this.insertNewAttachmentOnTaskUpdate(newTaskImpl, attachment);
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    private void updateModifiedAttachmentsOnTaskUpdate(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) {
        TaskImpl taskImpl = newTaskImpl;
        TaskImpl taskImpl2 = oldTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<Attachment> newAttachments = newTaskImpl.getAttachments();
        List<Attachment> oldAttachments = oldTaskImpl.getAttachments();
        if (newAttachments != null && !newAttachments.isEmpty() && oldAttachments != null && !oldAttachments.isEmpty()) {
            Map oldAttachmentMap = oldAttachments.stream().collect(Collectors.toMap(AttachmentSummary::getId, Function.identity()));
            newAttachments.forEach(a -> {
                if (oldAttachmentMap.containsKey(a.getId()) && !a.equals(oldAttachmentMap.get(a.getId()))) {
                    this.attachmentMapper.update((AttachmentImpl)a);
                }
            });
        }
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    private void deleteRemovedAttachmentsOnTaskUpdate(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) {
        List<Attachment> oldAttachments;
        TaskImpl taskImpl = newTaskImpl;
        TaskImpl taskImpl2 = oldTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<Attachment> newAttachments = newTaskImpl.getAttachments();
        List<Object> newAttachmentIds = new ArrayList();
        if (newAttachments != null && !newAttachments.isEmpty()) {
            newAttachmentIds = newAttachments.stream().map(AttachmentSummary::getId).collect(Collectors.toList());
        }
        if ((oldAttachments = oldTaskImpl.getAttachments()) != null && !oldAttachments.isEmpty()) {
            ArrayList newAttIds = newAttachmentIds;
            oldAttachments.forEach(a -> {
                if (!newAttIds.contains(a.getId())) {
                    this.attachmentMapper.delete(a.getId());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("TaskService.updateTask() for TaskId={} DELETED an Attachment={}.", (Object)newTaskImpl.getId(), a);
                    }
                }
            });
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    private void insertNewAttachmentOnTaskUpdate(TaskImpl newTaskImpl, Attachment attachment) throws AttachmentPersistenceException {
        TaskImpl taskImpl = newTaskImpl;
        Attachment attachment2 = attachment;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)taskImpl, (Object)attachment2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        AttachmentImpl attachmentImpl = (AttachmentImpl)attachment;
        try {
            this.attachmentMapper.insert(attachmentImpl);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("TaskService.updateTask() for TaskId={} INSERTED an Attachment={}.", (Object)newTaskImpl.getId(), (Object)attachmentImpl);
            }
        }
        catch (PersistenceException e) {
            throw new AttachmentPersistenceException(attachmentImpl.getId(), newTaskImpl.getId(), e);
        }
        Object var8_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_8);
    }

    private void initAttachment(AttachmentImpl attachment, Task newTask) {
        AttachmentImpl attachmentImpl = attachment;
        Task task = newTask;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)attachmentImpl, (Object)task);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (attachment.getId() == null) {
            attachment.setId(IdGenerator.generateWithPrefix((String)"TAI"));
        }
        if (attachment.getTaskId() == null) {
            attachment.setTaskId(newTask.getId());
        }
        if (attachment.getCreated() == null) {
            attachment.setCreated(newTask.getModified());
        }
        if (attachment.getModified() == null) {
            attachment.setModified(attachment.getCreated());
        }
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private void verifyAttachment(AttachmentImpl attachment, String domain) throws InvalidArgumentException, ClassificationNotFoundException {
        AttachmentImpl attachmentImpl = attachment;
        String string = domain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)attachmentImpl, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ClassificationSummary classification = attachment.getClassificationSummary();
        if (classification == null) {
            throw new InvalidArgumentException("Classification of Attachment must not be null.");
        }
        if (classification.getKey() == null || classification.getKey().length() == 0) {
            throw new InvalidArgumentException("ClassificationKey of Attachment must not be empty.");
        }
        ObjectReferenceImpl.validate(attachment.getObjectReference(), "ObjectReference", "Attachment");
        classification = this.classificationService.getClassification(attachment.getClassificationSummary().getKey(), domain).asSummary();
        attachment.setClassificationSummary(classification);
        Object var7_7 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_7);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AttachmentHandler.java", AttachmentHandler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "insertAndDeleteAttachmentsOnTaskUpdate", "pro.taskana.task.internal.AttachmentHandler", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.task.internal.models.TaskImpl", "newTaskImpl:oldTaskImpl", "pro.taskana.task.api.exceptions.AttachmentPersistenceException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.classification.api.exceptions.ClassificationNotFoundException", "void"), 40);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "insertNewAttachmentsOnTaskCreation", "pro.taskana.task.internal.AttachmentHandler", "pro.taskana.task.internal.models.TaskImpl", "task", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.task.api.exceptions.AttachmentPersistenceException:pro.taskana.classification.api.exceptions.ClassificationNotFoundException", "void"), 57);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "insertNewAttachmentsOnTaskUpdate", "pro.taskana.task.internal.AttachmentHandler", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.task.internal.models.TaskImpl", "newTaskImpl:oldTaskImpl", "pro.taskana.task.api.exceptions.AttachmentPersistenceException", "void"), 83);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateModifiedAttachmentsOnTaskUpdate", "pro.taskana.task.internal.AttachmentHandler", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.task.internal.models.TaskImpl", "newTaskImpl:oldTaskImpl", "", "void"), 100);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteRemovedAttachmentsOnTaskUpdate", "pro.taskana.task.internal.AttachmentHandler", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.task.internal.models.TaskImpl", "newTaskImpl:oldTaskImpl", "", "void"), 120);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "insertNewAttachmentOnTaskUpdate", "pro.taskana.task.internal.AttachmentHandler", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.task.api.models.Attachment", "newTaskImpl:attachment", "pro.taskana.task.api.exceptions.AttachmentPersistenceException", "void"), 146);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initAttachment", "pro.taskana.task.internal.AttachmentHandler", "pro.taskana.task.internal.models.AttachmentImpl:pro.taskana.task.api.models.Task", "attachment:newTask", "", "void"), 163);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "verifyAttachment", "pro.taskana.task.internal.AttachmentHandler", "pro.taskana.task.internal.models.AttachmentImpl:java.lang.String", "attachment:domain", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.classification.api.exceptions.ClassificationNotFoundException", "void"), 178);
    }
}

