/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal.jobs.helper;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.CheckedConsumer;

public class SqlConnectionRunner {
    private final TaskanaEngine taskanaEngine;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public SqlConnectionRunner(TaskanaEngine taskanaEngine) {
        this.taskanaEngine = Objects.requireNonNull(taskanaEngine, "TaskanaEngine may not be null");
    }

    public void runWithConnection(CheckedConsumer<Connection, SQLException> consumer) {
        CheckedConsumer<Connection, SQLException> checkedConsumer = consumer;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, checkedConsumer);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            Throwable throwable = null;
            Object var3_7 = null;
            try (Connection connection = this.getConnection();){
                String originalSchema = connection.getSchema();
                try {
                    connection.setSchema(this.taskanaEngine.getConfiguration().getSchemaName());
                    consumer.accept((Object)connection);
                }
                finally {
                    connection.setSchema(originalSchema);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new SystemException("SQL error while running low level SQL", (Throwable)e);
        }
        Object var9_12 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_12);
    }

    public Connection getConnection() throws SQLException {
        Connection connection;
        Connection connection2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Connection connection3 = connection2 = (connection = this.taskanaEngine.getConfiguration().getDatasource().getConnection());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)connection2);
        return connection;
    }

    static {
        SqlConnectionRunner.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SqlConnectionRunner.java", SqlConnectionRunner.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "runWithConnection", "pro.taskana.task.internal.jobs.helper.SqlConnectionRunner", "pro.taskana.common.internal.util.CheckedConsumer", "consumer", "", "void"), 26);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConnection", "pro.taskana.task.internal.jobs.helper.SqlConnectionRunner", "", "", "java.sql.SQLException", "java.sql.Connection"), 42);
    }
}

