/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.user.internal;

import org.apache.ibatis.exceptions.PersistenceException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.user.api.UserService;
import pro.taskana.user.api.exceptions.UserAlreadyExistException;
import pro.taskana.user.api.exceptions.UserNotFoundException;
import pro.taskana.user.api.models.User;
import pro.taskana.user.internal.UserMapper;
import pro.taskana.user.internal.models.UserImpl;

public class UserServiceImpl
implements UserService {
    private static final Logger LOGGER;
    private final InternalTaskanaEngine taskanaEngine;
    private final UserMapper userMapper;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    static {
        UserServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(UserServiceImpl.class);
    }

    public UserServiceImpl(InternalTaskanaEngine taskanaEngine, UserMapper userMapper) {
        this.taskanaEngine = taskanaEngine;
        this.userMapper = userMapper;
    }

    @Override
    public User newUser() {
        UserImpl userImpl;
        UserImpl userImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        UserImpl userImpl3 = userImpl2 = (userImpl = new UserImpl());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)userImpl2);
        return userImpl;
    }

    @Override
    public User getUser(String id) throws UserNotFoundException {
        User user;
        User user2;
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        User user3 = this.taskanaEngine.executeInDatabaseConnection(() -> this.userMapper.findById(id));
        if (user3 == null) {
            throw new UserNotFoundException(id);
        }
        User user4 = user2 = (user = user3);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)user2);
        return user;
    }

    @Override
    public User createUser(User userToCreate) throws InvalidArgumentException, NotAuthorizedException, UserAlreadyExistException {
        User user;
        User user2;
        User user3 = userToCreate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)user3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        this.validateAndPopulateFields(userToCreate);
        this.insertIntoDatabase(userToCreate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Method createUser() created User '{}'.", (Object)userToCreate);
        }
        User user4 = user2 = (user = userToCreate);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)user2);
        return user;
    }

    @Override
    public User updateUser(User userToUpdate) throws UserNotFoundException, NotAuthorizedException {
        User user;
        User user2;
        User user3 = userToUpdate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)user3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        this.getUser(userToUpdate.getId());
        this.taskanaEngine.executeInDatabaseConnection(() -> this.userMapper.update((UserImpl)userToUpdate));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Method updateUser() updated User '{}'.", (Object)userToUpdate);
        }
        User user4 = user2 = (user = userToUpdate);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)user2);
        return user;
    }

    @Override
    public void deleteUser(String id) throws UserNotFoundException, NotAuthorizedException {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        this.getUser(id);
        this.taskanaEngine.executeInDatabaseConnection(() -> this.userMapper.delete(id));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Method deleteUser() deleted User with id '{}'.", (Object)id);
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private void insertIntoDatabase(User userToCreate) throws UserAlreadyExistException {
        User user = userToCreate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)user);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            try {
                this.taskanaEngine.openConnection();
                this.userMapper.insert((UserImpl)userToCreate);
            }
            catch (PersistenceException persistenceException) {
                throw new UserAlreadyExistException(userToCreate.getId());
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    private void validateAndPopulateFields(User userToCreate) throws InvalidArgumentException {
        User user = userToCreate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)user);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (userToCreate.getId() == null || userToCreate.getId().isEmpty()) {
            throw new InvalidArgumentException("UserId must not be empty when creating User.");
        }
        if (userToCreate.getFirstName() == null || userToCreate.getLastName() == null) {
            throw new InvalidArgumentException("First and last name of User must be set or empty.");
        }
        if (userToCreate.getFullName() == null || userToCreate.getFullName().isEmpty()) {
            userToCreate.setFullName(String.valueOf(userToCreate.getLastName()) + ", " + userToCreate.getFirstName());
        }
        if (userToCreate.getLongName() == null || userToCreate.getLongName().isEmpty()) {
            userToCreate.setLongName(String.valueOf(userToCreate.getFullName()) + " - (" + userToCreate.getId() + ")");
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("UserServiceImpl.java", UserServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newUser", "pro.taskana.user.internal.UserServiceImpl", "", "", "", "pro.taskana.user.api.models.User"), 29);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUser", "pro.taskana.user.internal.UserServiceImpl", "java.lang.String", "id", "pro.taskana.user.api.exceptions.UserNotFoundException", "pro.taskana.user.api.models.User"), 34);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createUser", "pro.taskana.user.internal.UserServiceImpl", "pro.taskana.user.api.models.User", "userToCreate", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.user.api.exceptions.UserAlreadyExistException", "pro.taskana.user.api.models.User"), 44);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateUser", "pro.taskana.user.internal.UserServiceImpl", "pro.taskana.user.api.models.User", "userToUpdate", "pro.taskana.user.api.exceptions.UserNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.user.api.models.User"), 58);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteUser", "pro.taskana.user.internal.UserServiceImpl", "java.lang.String", "id", "pro.taskana.user.api.exceptions.UserNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException", "void"), 71);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "insertIntoDatabase", "pro.taskana.user.internal.UserServiceImpl", "pro.taskana.user.api.models.User", "userToCreate", "pro.taskana.user.api.exceptions.UserAlreadyExistException", "void"), 81);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateAndPopulateFields", "pro.taskana.user.internal.UserServiceImpl", "pro.taskana.user.api.models.User", "userToCreate", "pro.taskana.common.api.exceptions.InvalidArgumentException", "void"), 92);
    }
}

