/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.workbasket.api.exceptions;

import java.util.Arrays;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.exceptions.ErrorCode;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.MapCreator;
import pro.taskana.workbasket.api.WorkbasketPermission;

public class MismatchedWorkbasketPermissionException
extends NotAuthorizedException {
    public static final String ERROR_KEY_KEY_DOMAIN = "WORKBASKET_WITH_KEY_MISMATCHED_PERMISSION";
    public static final String ERROR_KEY_ID = "WORKBASKET_WITH_ID_MISMATCHED_PERMISSION";
    private final String currentUserId;
    private final WorkbasketPermission[] requiredPermissions;
    private final String workbasketId;
    private final String workbasketKey;
    private final String domain;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public MismatchedWorkbasketPermissionException(String currentUserId, String workbasketId, WorkbasketPermission ... requiredPermissions) {
        super(String.format("Not authorized. The current user '%s' has no '%s' permission(s) for Workbasket '%s'.", currentUserId, Arrays.toString((Object[])requiredPermissions), workbasketId), ErrorCode.of((String)ERROR_KEY_ID, (Map)MapCreator.of((Object)"currentUserId", (Object)currentUserId, (Object)"workbasketId", (Object)workbasketId, (Object)"requiredPermissions", (Object)requiredPermissions)));
        this.currentUserId = currentUserId;
        this.requiredPermissions = requiredPermissions;
        this.workbasketId = workbasketId;
        this.workbasketKey = null;
        this.domain = null;
    }

    public MismatchedWorkbasketPermissionException(String currentUserId, String workbasketKey, String domain, WorkbasketPermission ... requiredPermissions) {
        super(String.format("Not authorized. The current user '%s' has no '%s' permission for Workbasket with key '%s' in domain '%s'.", currentUserId, Arrays.toString((Object[])requiredPermissions), workbasketKey, domain), ErrorCode.of((String)ERROR_KEY_KEY_DOMAIN, (Map)MapCreator.of((Object)"currentUserId", (Object)currentUserId, (Object)"workbasketKey", (Object)workbasketKey, (Object)"domain", (Object)domain, (Object)"requiredPermissions", (Object)requiredPermissions)));
        this.currentUserId = currentUserId;
        this.requiredPermissions = requiredPermissions;
        this.workbasketKey = workbasketKey;
        this.domain = domain;
        this.workbasketId = null;
    }

    public String getWorkbasketKey() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.workbasketKey);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getDomain() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.domain);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getWorkbasketId() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.workbasketId);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public WorkbasketPermission[] getRequiredPermissions() {
        WorkbasketPermission[] workbasketPermissionArray;
        WorkbasketPermission[] workbasketPermissionArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketPermission[] workbasketPermissionArray3 = workbasketPermissionArray2 = (workbasketPermissionArray = this.requiredPermissions);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketPermissionArray2);
        return workbasketPermissionArray;
    }

    public String getCurrentUserId() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.currentUserId);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    static {
        MismatchedWorkbasketPermissionException.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MismatchedWorkbasketPermissionException.java", MismatchedWorkbasketPermissionException.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasketKey", "pro.taskana.workbasket.api.exceptions.MismatchedWorkbasketPermissionException", "", "", "", "java.lang.String"), 77);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDomain", "pro.taskana.workbasket.api.exceptions.MismatchedWorkbasketPermissionException", "", "", "", "java.lang.String"), 81);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasketId", "pro.taskana.workbasket.api.exceptions.MismatchedWorkbasketPermissionException", "", "", "", "java.lang.String"), 85);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRequiredPermissions", "pro.taskana.workbasket.api.exceptions.MismatchedWorkbasketPermissionException", "", "", "", "[Lpro.taskana.workbasket.api.WorkbasketPermission;"), 89);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCurrentUserId", "pro.taskana.workbasket.api.exceptions.MismatchedWorkbasketPermissionException", "", "", "", "java.lang.String"), 93);
    }
}

