/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.JobService;
import pro.taskana.common.api.ScheduledJob;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.JobMapper;
import pro.taskana.common.internal.logging.LoggingAspect;

public class JobServiceImpl
implements JobService {
    public static final int JOB_DEFAULT_PRIORITY = 50;
    private static final Duration JOB_DEFAULT_LOCK_EXPIRATION_PERIOD;
    private static final Logger LOGGER;
    private final JobMapper jobMapper;
    private final InternalTaskanaEngine taskanaEngineImpl;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        JobServiceImpl.ajc$preClinit();
        JOB_DEFAULT_LOCK_EXPIRATION_PERIOD = Duration.ofSeconds(60L);
        LOGGER = LoggerFactory.getLogger(JobServiceImpl.class);
    }

    public JobServiceImpl(InternalTaskanaEngine taskanaEngine, JobMapper jobMapper) {
        this.taskanaEngineImpl = taskanaEngine;
        this.jobMapper = jobMapper;
    }

    @Override
    public ScheduledJob createJob(ScheduledJob job) {
        ScheduledJob scheduledJob;
        ScheduledJob scheduledJob2;
        ScheduledJob scheduledJob3 = job;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)scheduledJob3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.initializeDefaultJobProperties(job);
        Integer id = this.taskanaEngineImpl.executeInDatabaseConnection(() -> this.jobMapper.insertJob(job));
        job.setJobId(id);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Created job {}", (Object)job);
        }
        ScheduledJob scheduledJob4 = scheduledJob2 = (scheduledJob = job);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)scheduledJob2);
        return scheduledJob;
    }

    public void deleteJobs(String jobType) {
        String string = jobType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngineImpl.executeInDatabaseConnection(() -> this.jobMapper.deleteMultiple(jobType));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deleted jobs of type: {}", (Object)jobType);
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public ScheduledJob lockJob(ScheduledJob job, String owner) {
        ScheduledJob scheduledJob;
        ScheduledJob scheduledJob2;
        ScheduledJob scheduledJob3 = job;
        String string = owner;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)scheduledJob3, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        job.setLockedBy(owner);
        job.setLockExpires(Instant.now().plus(JOB_DEFAULT_LOCK_EXPIRATION_PERIOD));
        job.setRetryCount(job.getRetryCount() - 1);
        this.taskanaEngineImpl.executeInDatabaseConnection(() -> this.jobMapper.update(job));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Job {} locked. Remaining retries: {}", (Object)job.getJobId(), (Object)job.getRetryCount());
        }
        ScheduledJob scheduledJob4 = scheduledJob2 = (scheduledJob = job);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)scheduledJob2);
        return scheduledJob;
    }

    public List<ScheduledJob> findJobsToRun() {
        List list;
        List list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List availableJobs = this.taskanaEngineImpl.executeInDatabaseConnection(() -> this.jobMapper.findJobsToRun(Instant.now()));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found available jobs: {}", (Object)availableJobs);
        }
        List list3 = list2 = (list = availableJobs);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    public void deleteJob(ScheduledJob job) {
        ScheduledJob scheduledJob = job;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)scheduledJob);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngineImpl.executeInDatabaseConnection(() -> this.jobMapper.delete(job));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deleted job: {}", (Object)job);
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private void initializeDefaultJobProperties(ScheduledJob job) {
        ScheduledJob scheduledJob = job;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)scheduledJob);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant now = Instant.now();
        job.setCreated(now);
        job.setState(ScheduledJob.State.READY);
        job.setPriority(50);
        if (job.getDue() == null) {
            job.setDue(now);
        }
        job.setRetryCount(this.taskanaEngineImpl.getEngine().getConfiguration().getMaxNumberOfJobRetries());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Job after initialization: {}", (Object)job);
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JobServiceImpl.java", JobServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createJob", "pro.taskana.common.internal.JobServiceImpl", "pro.taskana.common.api.ScheduledJob", "job", "", "pro.taskana.common.api.ScheduledJob"), 28);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteJobs", "pro.taskana.common.internal.JobServiceImpl", "java.lang.String", "jobType", "", "void"), 38);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "lockJob", "pro.taskana.common.internal.JobServiceImpl", "pro.taskana.common.api.ScheduledJob:java.lang.String", "job:owner", "", "pro.taskana.common.api.ScheduledJob"), 45);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findJobsToRun", "pro.taskana.common.internal.JobServiceImpl", "", "", "", "java.util.List"), 56);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteJob", "pro.taskana.common.internal.JobServiceImpl", "pro.taskana.common.api.ScheduledJob", "job", "", "void"), 65);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initializeDefaultJobProperties", "pro.taskana.common.internal.JobServiceImpl", "pro.taskana.common.api.ScheduledJob", "job", "", "void"), 72);
    }
}

