/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.workbasket.internal.jobs;

import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.BulkOperationResults;
import pro.taskana.common.api.ScheduledJob;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.internal.JobServiceImpl;
import pro.taskana.common.internal.jobs.AbstractTaskanaJob;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.transaction.TaskanaTransactionProvider;
import pro.taskana.common.internal.util.CollectionUtil;
import pro.taskana.workbasket.api.WorkbasketQueryColumnName;

public class WorkbasketCleanupJob
extends AbstractTaskanaJob {
    private static final Logger LOGGER;
    private final int batchSize;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        WorkbasketCleanupJob.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(WorkbasketCleanupJob.class);
    }

    public WorkbasketCleanupJob(TaskanaEngine taskanaEngine, TaskanaTransactionProvider txProvider, ScheduledJob job) {
        super(taskanaEngine, txProvider, job, true);
        this.batchSize = taskanaEngine.getConfiguration().getMaxNumberOfUpdatesPerTransaction();
    }

    @Override
    public void execute() throws TaskanaException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        LOGGER.info("Running job to delete all workbaskets marked for deletion");
        try {
            List<String> workbasketsMarkedForDeletion = this.getWorkbasketsMarkedForDeletion();
            int totalNumberOfWorkbasketDeleted = CollectionUtil.partitionBasedOnSize(workbasketsMarkedForDeletion, (int)this.batchSize).stream().mapToInt(this::deleteWorkbasketsTransactionally).sum();
            LOGGER.info("Job ended successfully. {} workbaskets deleted.", (Object)totalNumberOfWorkbasketDeleted);
        }
        catch (Exception e) {
            throw new SystemException("Error while processing WorkbasketCleanupJob.", (Throwable)e);
        }
        Object var4_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_5);
    }

    public static void initializeSchedule(TaskanaEngine taskanaEngine) {
        TaskanaEngine taskanaEngine2 = taskanaEngine;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)taskanaEngine2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        JobServiceImpl jobService = (JobServiceImpl)taskanaEngine.getJobService();
        WorkbasketCleanupJob job = new WorkbasketCleanupJob(taskanaEngine, null, null);
        jobService.deleteJobs(job.getType());
        job.scheduleNextJob();
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    @Override
    protected String getType() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = WorkbasketCleanupJob.class.getName());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private List<String> getWorkbasketsMarkedForDeletion() {
        List list;
        List list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List list3 = list2 = (list = this.taskanaEngineImpl.getWorkbasketService().createWorkbasketQuery().markedForDeletion(true).listValues(WorkbasketQueryColumnName.ID, BaseQuery.SortDirection.ASCENDING));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    private int deleteWorkbasketsTransactionally(List<String> workbasketsToBeDeleted) {
        int n;
        int n2;
        List<String> list = workbasketsToBeDeleted;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = ((Integer)TaskanaTransactionProvider.executeInTransactionIfPossible((TaskanaTransactionProvider)this.txProvider, () -> {
            try {
                return this.deleteWorkbaskets(workbasketsToBeDeleted);
            }
            catch (Exception e) {
                LOGGER.warn("Could not delete workbaskets.", (Throwable)e);
                return 0;
            }
        })).intValue());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    private int deleteWorkbaskets(List<String> workbasketsToBeDeleted) throws InvalidArgumentException, NotAuthorizedException {
        int n;
        int n2;
        List<String> list = workbasketsToBeDeleted;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults<String, TaskanaException> results = this.taskanaEngineImpl.getWorkbasketService().deleteWorkbaskets(workbasketsToBeDeleted);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} workbasket deleted.", (Object)(workbasketsToBeDeleted.size() - results.getFailedIds().size()));
        }
        for (String failedId : results.getFailedIds()) {
            LOGGER.warn("Workbasket with id {} could not be deleted. Reason:", (Object)failedId, (Object)results.getErrorForId((Object)failedId));
        }
        int n3 = n2 = (n = workbasketsToBeDeleted.size() - results.getFailedIds().size());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WorkbasketCleanupJob.java", WorkbasketCleanupJob.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "pro.taskana.workbasket.internal.jobs.WorkbasketCleanupJob", "", "", "pro.taskana.common.api.exceptions.TaskanaException", "void"), 38);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "initializeSchedule", "pro.taskana.workbasket.internal.jobs.WorkbasketCleanupJob", "pro.taskana.common.api.TaskanaEngine", "taskanaEngine", "", "void"), 59);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getType", "pro.taskana.workbasket.internal.jobs.WorkbasketCleanupJob", "", "", "", "java.lang.String"), 67);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getWorkbasketsMarkedForDeletion", "pro.taskana.workbasket.internal.jobs.WorkbasketCleanupJob", "", "", "", "java.util.List"), 71);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteWorkbasketsTransactionally", "pro.taskana.workbasket.internal.jobs.WorkbasketCleanupJob", "java.util.List", "workbasketsToBeDeleted", "", "int"), 80);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteWorkbaskets", "pro.taskana.workbasket.internal.jobs.WorkbasketCleanupJob", "java.util.List", "workbasketsToBeDeleted", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "int"), 93);
    }
}

