/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.CustomHoliday;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.TaskanaEngineImpl;
import pro.taskana.common.internal.configuration.DB;
import pro.taskana.common.internal.configuration.TaskanaConfigurationInitializer;
import pro.taskana.common.internal.configuration.TaskanaProperty;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.FileLoaderUtil;
import pro.taskana.workbasket.api.WorkbasketPermission;

public class TaskanaEngineConfiguration {
    private static final Logger LOGGER;
    private static final String TASKANA_PROPERTIES = "/taskana.properties";
    private static final String TASKANA_PROPERTY_SEPARATOR = "|";
    private static final String DEFAULT_SCHEMA_NAME = "TASKANA";
    protected String propertiesFileName = "/taskana.properties";
    protected DataSource dataSource;
    protected String schemaName;
    protected String propertiesSeparator = "|";
    protected Map<TaskanaRole, Set<String>> roleMap;
    protected boolean securityEnabled;
    protected boolean useManagedTransactions;
    @TaskanaProperty(value="taskana.domains")
    protected List<String> domains = new ArrayList<String>();
    @TaskanaProperty(value="taskana.classification.types")
    protected List<String> classificationTypes = new ArrayList<String>();
    protected Map<String, List<String>> classificationCategoriesByTypeMap = new HashMap<String, List<String>>();
    @TaskanaProperty(value="taskana.custom.holidays")
    private List<CustomHoliday> customHolidays = new ArrayList<CustomHoliday>();
    @TaskanaProperty(value="taskana.history.deletion.on.task.deletion.enabled")
    private boolean deleteHistoryOnTaskDeletionEnabled;
    @TaskanaProperty(value="taskana.german.holidays.enabled")
    private boolean germanPublicHolidaysEnabled;
    @TaskanaProperty(value="taskana.german.holidays.corpus-christi.enabled")
    private boolean corpusChristiEnabled;
    @TaskanaProperty(value="taskana.jobs.batchSize")
    private int jobBatchSize = 100;
    @TaskanaProperty(value="taskana.jobs.maxRetries")
    private int maxNumberOfJobRetries = 3;
    @TaskanaProperty(value="taskana.jobs.cleanup.firstRunAt")
    private Instant cleanupJobFirstRun = Instant.parse("2018-01-01T00:00:00Z");
    @TaskanaProperty(value="taskana.jobs.cleanup.runEvery")
    private Duration cleanupJobRunEvery = Duration.parse("P1D");
    @TaskanaProperty(value="taskana.jobs.cleanup.minimumAge")
    private Duration cleanupJobMinimumAge = Duration.parse("P14D");
    @TaskanaProperty(value="taskana.jobs.cleanup.allCompletedSameParentBusiness")
    private boolean taskCleanupJobAllCompletedSameParentBusiness = true;
    @TaskanaProperty(value="taskana.validation.allowTimestampServiceLevelMismatch")
    private boolean validationAllowTimestampServiceLevelMismatch = false;
    @TaskanaProperty(value="taskana.addAdditionalUserInfo")
    private boolean addAdditionalUserInfo = false;
    @TaskanaProperty(value="taskana.jobs.priority.batchSize")
    private int priorityJobBatchSize = 100;
    @TaskanaProperty(value="taskana.jobs.priority.firstRunAt")
    private Instant priorityJobFirstRun = Instant.parse("2018-01-01T00:00:00Z");
    @TaskanaProperty(value="taskana.jobs.priority.runEvery")
    private Duration priorityJobRunEvery = Duration.parse("P1D");
    @TaskanaProperty(value="taskana.jobs.priority.active")
    private boolean priorityJobActive = false;
    @TaskanaProperty(value="taskana.jobs.user.refresh.runEvery")
    private Duration userRefreshJobRunEvery = Duration.parse("P1D");
    @TaskanaProperty(value="taskana.jobs.user.refresh.firstRunAt")
    private Instant userRefreshJobFirstRun = Instant.parse("2018-01-01T23:00:00Z");
    @TaskanaProperty(value="taskana.user.minimalPermissionsToAssignDomains")
    private List<WorkbasketPermission> minimalPermissionsToAssignDomains;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_53;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_54;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_55;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_56;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_57;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_58;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_59;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_60;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_61;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_62;

    static {
        TaskanaEngineConfiguration.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TaskanaEngineConfiguration.class);
    }

    public TaskanaEngineConfiguration(DataSource dataSource, boolean useManagedTransactions, String schemaName) {
        this(dataSource, useManagedTransactions, true, schemaName);
    }

    public TaskanaEngineConfiguration(DataSource dataSource, boolean useManagedTransactions, boolean securityEnabled, String schemaName) {
        this(dataSource, useManagedTransactions, securityEnabled, null, null, schemaName);
    }

    public TaskanaEngineConfiguration(DataSource dataSource, boolean useManagedTransactions, boolean securityEnabled, String propertiesFileName, String propertySeparator, String schemaName) {
        this.useManagedTransactions = useManagedTransactions;
        this.securityEnabled = securityEnabled;
        if (propertiesFileName != null) {
            this.propertiesFileName = propertiesFileName;
        }
        if (propertySeparator != null) {
            this.propertiesSeparator = propertySeparator;
        }
        this.dataSource = dataSource != null ? dataSource : TaskanaEngineConfiguration.createDefaultDataSource();
        this.initSchemaName(schemaName);
        this.initTaskanaProperties(this.propertiesFileName, this.propertiesSeparator);
    }

    public static Properties loadProperties(String propertiesFile) {
        Properties properties;
        Properties properties2;
        String string = propertiesFile;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Properties props = new Properties();
        try {
            Throwable throwable = null;
            Object var3_7 = null;
            try (InputStream stream = FileLoaderUtil.openFileFromClasspathOrSystem((String)propertiesFile, TaskanaEngineConfiguration.class);){
                props.load(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("caught IOException when processing properties file {}.", (Object)propertiesFile);
            throw new SystemException("internal System error when processing properties file " + propertiesFile, e.getCause());
        }
        Properties properties3 = properties2 = (properties = props);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)properties2);
        return properties;
    }

    public void initTaskanaProperties(String propertiesFile, String separator) {
        String string = propertiesFile;
        String string2 = separator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, (Object)string2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Reading taskana configuration from {} with separator {}", (Object)propertiesFile, (Object)separator);
        }
        Properties props = TaskanaEngineConfiguration.loadProperties(propertiesFile);
        TaskanaConfigurationInitializer.configureAnnotatedFields((Object)this, (String)separator, (Properties)props);
        this.roleMap = TaskanaConfigurationInitializer.configureRoles((String)separator, (Properties)props, (boolean)TaskanaEngineConfiguration.shouldUseLowerCaseForAccessIds());
        this.classificationCategoriesByTypeMap = TaskanaConfigurationInitializer.configureClassificationCategoriesForType((Properties)props, this.classificationTypes);
        if (LOGGER.isDebugEnabled()) {
            this.roleMap.forEach((k, v) -> LOGGER.debug("Found Taskana RoleConfig {} : {} ", k, v));
            LOGGER.debug("Configured number of task and workbasket updates per transaction: {}", (Object)this.jobBatchSize);
            LOGGER.debug("Number of retries of failed task updates: {}", (Object)this.maxNumberOfJobRetries);
            LOGGER.debug("CleanupJob configuration: first run at {}", (Object)this.cleanupJobFirstRun);
            LOGGER.debug("CleanupJob configuration: runs every {}", (Object)this.cleanupJobRunEvery);
            LOGGER.debug("CleanupJob configuration: minimum age of tasks to be cleanup up is {}", (Object)this.cleanupJobMinimumAge);
            LOGGER.debug("TaskCleanupJob configuration: all completed task with the same parent business property id {}", (Object)this.taskCleanupJobAllCompletedSameParentBusiness);
            LOGGER.debug("Configured classification categories : {}", this.classificationCategoriesByTypeMap);
            LOGGER.debug("Configured domains: {}", this.domains);
            LOGGER.debug("Configured classificationTypes: {}", this.classificationTypes);
            LOGGER.debug("Configured custom Holidays : {}", this.customHolidays);
            LOGGER.debug("Configured minimalPermissionsToAssignDomains : {}", this.minimalPermissionsToAssignDomains);
        }
        Object var7_7 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_7);
    }

    public static DataSource createDefaultDataSource() {
        DataSource dataSource;
        DataSource dataSource2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String driverClass = "org.h2.Driver";
        String jdbcUrl = "jdbc:h2:mem:taskana;IGNORECASE=TRUE;LOCK_MODE=0;INIT=CREATE SCHEMA IF NOT EXISTS TASKANA\\;SET COLLATION DEFAULT_de_DE";
        String username = "sa";
        String password = "sa";
        LOGGER.info("No datasource is provided. An in-memory db is used: '{}', '{}', '{}', '{}'", new Object[]{driverClass, jdbcUrl, username, password});
        DataSource dataSource3 = dataSource2 = (dataSource = TaskanaEngineConfiguration.createDatasource(driverClass, jdbcUrl, username, password));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dataSource2);
        return dataSource;
    }

    public TaskanaEngine buildTaskanaEngine() throws SQLException {
        TaskanaEngine taskanaEngine;
        TaskanaEngine taskanaEngine2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskanaEngine taskanaEngine3 = taskanaEngine2 = (taskanaEngine = TaskanaEngineImpl.createTaskanaEngine(this));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskanaEngine2);
        return taskanaEngine;
    }

    public TaskanaEngine buildTaskanaEngine(TaskanaEngine.ConnectionManagementMode connectionManagementMode) throws SQLException {
        TaskanaEngine taskanaEngine;
        TaskanaEngine taskanaEngine2;
        TaskanaEngine.ConnectionManagementMode connectionManagementMode2 = connectionManagementMode;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)((Object)connectionManagementMode2));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskanaEngine taskanaEngine3 = taskanaEngine2 = (taskanaEngine = TaskanaEngineImpl.createTaskanaEngine(this, connectionManagementMode));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskanaEngine2);
        return taskanaEngine;
    }

    public static DataSource createDatasource(String driver, String jdbcUrl, String username, String password) {
        PooledDataSource pooledDataSource;
        PooledDataSource pooledDataSource2;
        String string = driver;
        String string2 = jdbcUrl;
        String string3 = username;
        String string4 = password;
        Object[] objectArray = new Object[]{string, string2, string3, string4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        PooledDataSource pooledDataSource3 = pooledDataSource2 = (pooledDataSource = new PooledDataSource(driver, jdbcUrl, username, password));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)pooledDataSource2);
        return pooledDataSource;
    }

    public boolean isSecurityEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.securityEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public DataSource getDatasource() {
        DataSource dataSource;
        DataSource dataSource2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DataSource dataSource3 = dataSource2 = (dataSource = this.dataSource);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dataSource2);
        return dataSource;
    }

    public boolean getUseManagedTransactions() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.useManagedTransactions);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public int getMaxNumberOfUpdatesPerTransaction() {
        int n;
        int n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = this.jobBatchSize);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public void setMaxNumberOfUpdatesPerTransaction(int jobBatchSize) {
        int n = jobBatchSize;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.jobBatchSize = jobBatchSize;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public int getMaxNumberOfJobRetries() {
        int n;
        int n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = this.maxNumberOfJobRetries);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public void setMaxNumberOfJobRetries(int maxNumberOfJobRetries) {
        int n = maxNumberOfJobRetries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.maxNumberOfJobRetries = maxNumberOfJobRetries;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public boolean isCorpusChristiEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.corpusChristiEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public void setCorpusChristiEnabled(boolean corpusChristiEnabled) {
        boolean bl = corpusChristiEnabled;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.corpusChristiEnabled = corpusChristiEnabled;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public boolean isGermanPublicHolidaysEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.germanPublicHolidaysEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public void setGermanPublicHolidaysEnabled(boolean germanPublicHolidaysEnabled) {
        boolean bl = germanPublicHolidaysEnabled;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.germanPublicHolidaysEnabled = germanPublicHolidaysEnabled;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public boolean isValidationAllowTimestampServiceLevelMismatch() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.validationAllowTimestampServiceLevelMismatch);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public void setValidationAllowTimestampServiceLevelMismatch(boolean validationAllowTimestampServiceLevelMismatch) {
        boolean bl = validationAllowTimestampServiceLevelMismatch;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.validationAllowTimestampServiceLevelMismatch = validationAllowTimestampServiceLevelMismatch;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public boolean isDeleteHistoryOnTaskDeletionEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.deleteHistoryOnTaskDeletionEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public void setDeleteHistoryOnTaskDeletionEnabled(boolean deleteHistoryOnTaskDeletionEnabled) {
        boolean bl = deleteHistoryOnTaskDeletionEnabled;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.deleteHistoryOnTaskDeletionEnabled = deleteHistoryOnTaskDeletionEnabled;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public List<CustomHoliday> getCustomHolidays() {
        List<CustomHoliday> list;
        List<CustomHoliday> list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<CustomHoliday> list3 = list2 = (list = this.customHolidays);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public void setCustomHolidays(List<CustomHoliday> customHolidays) {
        List<CustomHoliday> list = customHolidays;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.customHolidays = new ArrayList<CustomHoliday>(customHolidays);
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public void addCustomHolidays(List<CustomHoliday> customHolidays) {
        List<CustomHoliday> list = customHolidays;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.customHolidays.addAll(customHolidays);
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public Map<TaskanaRole, Set<String>> getRoleMap() {
        Map<TaskanaRole, Set<String>> map;
        Map<TaskanaRole, Set<String>> map2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<TaskanaRole, Set<String>> map3 = map2 = (map = this.roleMap);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    public void setRoleMap(Map<TaskanaRole, Set<String>> roleMap) {
        Map<TaskanaRole, Set<String>> map = roleMap;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.roleMap = roleMap;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public List<String> getDomains() {
        List<String> list;
        List<String> list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> list3 = list2 = (list = this.domains);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public void setDomains(List<String> domains) {
        List<String> list = domains;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.domains = domains;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public boolean getAddAdditionalUserInfo() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.addAdditionalUserInfo);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public void setAddAdditionalUserInfo(boolean addAdditionalUserInfo) {
        boolean bl = addAdditionalUserInfo;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.addAdditionalUserInfo = addAdditionalUserInfo;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public List<String> getClassificationTypes() {
        List<String> list;
        List<String> list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> list3 = list2 = (list = this.classificationTypes);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public void setClassificationTypes(List<String> classificationTypes) {
        List<String> list = classificationTypes;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.classificationTypes = classificationTypes;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public List<String> getAllClassificationCategories() {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ArrayList<String> classificationCategories = new ArrayList<String>();
        for (Map.Entry<String, List<String>> type : this.classificationCategoriesByTypeMap.entrySet()) {
            classificationCategories.addAll((Collection)type.getValue());
        }
        ArrayList<String> arrayList3 = arrayList2 = (arrayList = classificationCategories);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList2);
        return arrayList;
    }

    public Map<String, List<String>> getClassificationCategoriesByTypeMap() {
        Map<String, List<String>> map;
        Map<String, List<String>> map2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<String, List<String>> map3 = map2 = (map = this.classificationCategoriesByTypeMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ArrayList((Collection)e.getValue()))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    public List<String> getClassificationCategoriesByType(String type) {
        List<String> list;
        List<String> list2;
        String string = type;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> list3 = list2 = (list = this.classificationCategoriesByTypeMap.getOrDefault(type, Collections.emptyList()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public void setClassificationCategoriesByType(Map<String, List<String>> classificationCategoriesByType) {
        Map<String, List<String>> map = classificationCategoriesByType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.classificationCategoriesByTypeMap = classificationCategoriesByType;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public Instant getCleanupJobFirstRun() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.cleanupJobFirstRun);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public void setCleanupJobFirstRun(Instant cleanupJobFirstRun) {
        Instant instant = cleanupJobFirstRun;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, (Object)instant);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.cleanupJobFirstRun = cleanupJobFirstRun;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public Duration getCleanupJobRunEvery() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.cleanupJobRunEvery);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public void setCleanupJobRunEvery(Duration cleanupJobRunEvery) {
        Duration duration = cleanupJobRunEvery;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this, (Object)duration);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.cleanupJobRunEvery = cleanupJobRunEvery;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public Duration getCleanupJobMinimumAge() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.cleanupJobMinimumAge);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public void setCleanupJobMinimumAge(Duration cleanupJobMinimumAge) {
        Duration duration = cleanupJobMinimumAge;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, (Object)duration);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.cleanupJobMinimumAge = cleanupJobMinimumAge;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public boolean isTaskCleanupJobAllCompletedSameParentBusiness() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.taskCleanupJobAllCompletedSameParentBusiness);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public void setTaskCleanupJobAllCompletedSameParentBusiness(boolean taskCleanupJobAllCompletedSameParentBusiness) {
        boolean bl = taskCleanupJobAllCompletedSameParentBusiness;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskCleanupJobAllCompletedSameParentBusiness = taskCleanupJobAllCompletedSameParentBusiness;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public int getPriorityJobBatchSize() {
        int n;
        int n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = this.priorityJobBatchSize);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public void setPriorityJobBatchSize(int priorityJobBatchSize) {
        int n = priorityJobBatchSize;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.priorityJobBatchSize = priorityJobBatchSize;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public Instant getPriorityJobFirstRun() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.priorityJobFirstRun);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public void setPriorityJobFirstRun(Instant priorityJobFirstRun) {
        Instant instant = priorityJobFirstRun;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this, (Object)instant);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.priorityJobFirstRun = priorityJobFirstRun;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public Duration getPriorityJobRunEvery() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.priorityJobRunEvery);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public void setPriorityJobRunEvery(Duration priorityJobRunEvery) {
        Duration duration = priorityJobRunEvery;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this, (Object)duration);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.priorityJobRunEvery = priorityJobRunEvery;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public Duration getUserRefreshJobRunEvery() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.userRefreshJobRunEvery);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public void setUserRefreshJobRunEvery(Duration userRefreshJobRunEvery) {
        Duration duration = userRefreshJobRunEvery;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this, (Object)duration);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.userRefreshJobRunEvery = userRefreshJobRunEvery;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public List<WorkbasketPermission> getMinimalPermissionsToAssignDomains() {
        List<WorkbasketPermission> list;
        List<WorkbasketPermission> list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<WorkbasketPermission> list3 = list2 = (list = this.minimalPermissionsToAssignDomains);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public void setMinimalPermissionsToAssignDomains(List<WorkbasketPermission> minimalPermissionsToAssignDomains) {
        List<WorkbasketPermission> list = minimalPermissionsToAssignDomains;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_53, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.minimalPermissionsToAssignDomains = minimalPermissionsToAssignDomains;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public Instant getUserRefreshJobFirstRun() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_54, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.userRefreshJobFirstRun);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public void setUserRefreshJobFirstRun(Instant userRefreshJobFirstRun) {
        Instant instant = userRefreshJobFirstRun;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_55, (Object)this, (Object)this, (Object)instant);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.userRefreshJobFirstRun = userRefreshJobFirstRun;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public boolean isPriorityJobActive() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_56, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.priorityJobActive);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public void setPriorityJobActive(boolean priorityJobActive) {
        boolean bl = priorityJobActive;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_57, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.priorityJobActive = priorityJobActive;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public String getSchemaName() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_58, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.schemaName);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public void setSchemaName(String schemaName) {
        String string = schemaName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_59, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.schemaName = schemaName;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public static boolean shouldUseLowerCaseForAccessIds() {
        boolean bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_60, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl2 = true;
        boolean bl3 = bl = true;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl2;
    }

    public Properties readPropertiesFromFile() {
        Properties properties;
        Properties properties2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_61, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Properties properties3 = properties2 = (properties = TaskanaEngineConfiguration.loadProperties(this.propertiesFileName));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)properties2);
        return properties;
    }

    private void initSchemaName(String schemaName) {
        String string = schemaName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_62, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (schemaName != null && !schemaName.isEmpty()) {
            this.setSchemaName(schemaName);
        } else {
            this.setSchemaName(DEFAULT_SCHEMA_NAME);
        }
        try {
            Throwable throwable = null;
            Object var3_7 = null;
            try (Connection connection = this.dataSource.getConnection();){
                String databaseProductId = DB.getDatabaseProductId((String)connection.getMetaData().getDatabaseProductName());
                this.schemaName = DB.isPostgres((String)databaseProductId) ? this.schemaName.toLowerCase() : this.schemaName.toUpperCase();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException ex) {
            LOGGER.error("Caught exception when attempting to initialize the schema name", (Throwable)ex);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Using schema name {}", (Object)this.getSchemaName());
        }
        Object var8_11 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_11);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskanaEngineConfiguration.java", TaskanaEngineConfiguration.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "loadProperties", "pro.taskana.TaskanaEngineConfiguration", "java.lang.String", "propertiesFile", "", "java.util.Properties"), 178);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initTaskanaProperties", "pro.taskana.TaskanaEngineConfiguration", "java.lang.String:java.lang.String", "propertiesFile:separator", "", "void"), 192);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMaxNumberOfUpdatesPerTransaction", "pro.taskana.TaskanaEngineConfiguration", "int", "jobBatchSize", "", "void"), 288);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxNumberOfJobRetries", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "int"), 292);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMaxNumberOfJobRetries", "pro.taskana.TaskanaEngineConfiguration", "int", "maxNumberOfJobRetries", "", "void"), 296);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isCorpusChristiEnabled", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "boolean"), 300);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCorpusChristiEnabled", "pro.taskana.TaskanaEngineConfiguration", "boolean", "corpusChristiEnabled", "", "void"), 304);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isGermanPublicHolidaysEnabled", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "boolean"), 308);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setGermanPublicHolidaysEnabled", "pro.taskana.TaskanaEngineConfiguration", "boolean", "germanPublicHolidaysEnabled", "", "void"), 312);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isValidationAllowTimestampServiceLevelMismatch", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "boolean"), 316);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setValidationAllowTimestampServiceLevelMismatch", "pro.taskana.TaskanaEngineConfiguration", "boolean", "validationAllowTimestampServiceLevelMismatch", "", "void"), 320);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isDeleteHistoryOnTaskDeletionEnabled", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "boolean"), 326);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "createDefaultDataSource", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "javax.sql.DataSource"), 226);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDeleteHistoryOnTaskDeletionEnabled", "pro.taskana.TaskanaEngineConfiguration", "boolean", "deleteHistoryOnTaskDeletionEnabled", "", "void"), 330);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustomHolidays", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.util.List"), 334);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCustomHolidays", "pro.taskana.TaskanaEngineConfiguration", "java.util.List", "customHolidays", "", "void"), 338);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addCustomHolidays", "pro.taskana.TaskanaEngineConfiguration", "java.util.List", "customHolidays", "", "void"), 342);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRoleMap", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.util.Map"), 346);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRoleMap", "pro.taskana.TaskanaEngineConfiguration", "java.util.Map", "roleMap", "", "void"), 350);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDomains", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.util.List"), 354);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDomains", "pro.taskana.TaskanaEngineConfiguration", "java.util.List", "domains", "", "void"), 358);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAddAdditionalUserInfo", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "boolean"), 362);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAddAdditionalUserInfo", "pro.taskana.TaskanaEngineConfiguration", "boolean", "addAdditionalUserInfo", "", "void"), 366);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildTaskanaEngine", "pro.taskana.TaskanaEngineConfiguration", "", "", "java.sql.SQLException", "pro.taskana.common.api.TaskanaEngine"), 249);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationTypes", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.util.List"), 370);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setClassificationTypes", "pro.taskana.TaskanaEngineConfiguration", "java.util.List", "classificationTypes", "", "void"), 374);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAllClassificationCategories", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.util.List"), 378);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationCategoriesByTypeMap", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.util.Map"), 386);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationCategoriesByType", "pro.taskana.TaskanaEngineConfiguration", "java.lang.String", "type", "", "java.util.List"), 391);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setClassificationCategoriesByType", "pro.taskana.TaskanaEngineConfiguration", "java.util.Map", "classificationCategoriesByType", "", "void"), 395);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCleanupJobFirstRun", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.time.Instant"), 400);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCleanupJobFirstRun", "pro.taskana.TaskanaEngineConfiguration", "java.time.Instant", "cleanupJobFirstRun", "", "void"), 404);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCleanupJobRunEvery", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.time.Duration"), 408);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCleanupJobRunEvery", "pro.taskana.TaskanaEngineConfiguration", "java.time.Duration", "cleanupJobRunEvery", "", "void"), 412);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildTaskanaEngine", "pro.taskana.TaskanaEngineConfiguration", "pro.taskana.common.api.TaskanaEngine$ConnectionManagementMode", "connectionManagementMode", "java.sql.SQLException", "pro.taskana.common.api.TaskanaEngine"), 253);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCleanupJobMinimumAge", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.time.Duration"), 416);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCleanupJobMinimumAge", "pro.taskana.TaskanaEngineConfiguration", "java.time.Duration", "cleanupJobMinimumAge", "", "void"), 420);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isTaskCleanupJobAllCompletedSameParentBusiness", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "boolean"), 424);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTaskCleanupJobAllCompletedSameParentBusiness", "pro.taskana.TaskanaEngineConfiguration", "boolean", "taskCleanupJobAllCompletedSameParentBusiness", "", "void"), 428);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriorityJobBatchSize", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "int"), 434);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPriorityJobBatchSize", "pro.taskana.TaskanaEngineConfiguration", "int", "priorityJobBatchSize", "", "void"), 438);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriorityJobFirstRun", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.time.Instant"), 442);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPriorityJobFirstRun", "pro.taskana.TaskanaEngineConfiguration", "java.time.Instant", "priorityJobFirstRun", "", "void"), 446);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriorityJobRunEvery", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.time.Duration"), 450);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPriorityJobRunEvery", "pro.taskana.TaskanaEngineConfiguration", "java.time.Duration", "priorityJobRunEvery", "", "void"), 454);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "createDatasource", "pro.taskana.TaskanaEngineConfiguration", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "driver:jdbcUrl:username:password", "", "javax.sql.DataSource"), 267);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserRefreshJobRunEvery", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.time.Duration"), 458);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setUserRefreshJobRunEvery", "pro.taskana.TaskanaEngineConfiguration", "java.time.Duration", "userRefreshJobRunEvery", "", "void"), 462);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMinimalPermissionsToAssignDomains", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.util.List"), 466);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMinimalPermissionsToAssignDomains", "pro.taskana.TaskanaEngineConfiguration", "java.util.List", "minimalPermissionsToAssignDomains", "", "void"), 470);
        ajc$tjp_54 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserRefreshJobFirstRun", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.time.Instant"), 475);
        ajc$tjp_55 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setUserRefreshJobFirstRun", "pro.taskana.TaskanaEngineConfiguration", "java.time.Instant", "userRefreshJobFirstRun", "", "void"), 479);
        ajc$tjp_56 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isPriorityJobActive", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "boolean"), 483);
        ajc$tjp_57 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPriorityJobActive", "pro.taskana.TaskanaEngineConfiguration", "boolean", "priorityJobActive", "", "void"), 487);
        ajc$tjp_58 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSchemaName", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.lang.String"), 491);
        ajc$tjp_59 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSchemaName", "pro.taskana.TaskanaEngineConfiguration", "java.lang.String", "schemaName", "", "void"), 495);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSecurityEnabled", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "boolean"), 272);
        ajc$tjp_60 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "shouldUseLowerCaseForAccessIds", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "boolean"), 505);
        ajc$tjp_61 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "readPropertiesFromFile", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "java.util.Properties"), 509);
        ajc$tjp_62 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initSchemaName", "pro.taskana.TaskanaEngineConfiguration", "java.lang.String", "schemaName", "", "void"), 513);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDatasource", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "javax.sql.DataSource"), 276);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUseManagedTransactions", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "boolean"), 280);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxNumberOfUpdatesPerTransaction", "pro.taskana.TaskanaEngineConfiguration", "", "", "", "int"), 284);
    }
}

