/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal.jobs;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.ScheduledJob;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.JobServiceImpl;
import pro.taskana.common.internal.jobs.AbstractTaskanaJob;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.transaction.TaskanaTransactionProvider;

public class JobRunner {
    private static final Logger LOGGER;
    private final TaskanaEngine taskanaEngine;
    private final JobServiceImpl jobService;
    private TaskanaTransactionProvider txProvider;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    static {
        JobRunner.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(JobRunner.class);
    }

    public JobRunner(TaskanaEngine taskanaEngine) {
        this.taskanaEngine = taskanaEngine;
        this.jobService = (JobServiceImpl)taskanaEngine.getJobService();
    }

    public void registerTransactionProvider(TaskanaTransactionProvider txProvider) {
        TaskanaTransactionProvider taskanaTransactionProvider = txProvider;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)taskanaTransactionProvider);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.txProvider = txProvider;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public void runJobs() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.findAndLockJobsToRun().forEach(this::runJobTransactionally);
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    private List<ScheduledJob> findAndLockJobsToRun() {
        List list;
        List list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List list3 = list2 = (list = (List)TaskanaTransactionProvider.executeInTransactionIfPossible((TaskanaTransactionProvider)this.txProvider, () -> this.jobService.findJobsToRun().stream().map(this::lockJob).collect(Collectors.toList())));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    private void runJobTransactionally(ScheduledJob scheduledJob) {
        ScheduledJob scheduledJob2 = scheduledJob;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)scheduledJob2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskanaTransactionProvider.executeInTransactionIfPossible((TaskanaTransactionProvider)this.txProvider, () -> this.taskanaEngine.runAsAdmin(() -> this.runScheduledJob(scheduledJob)));
        this.jobService.deleteJob(scheduledJob);
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private void runScheduledJob(ScheduledJob scheduledJob) {
        ScheduledJob scheduledJob2 = scheduledJob;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)scheduledJob2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            AbstractTaskanaJob.createFromScheduledJob(this.taskanaEngine, this.txProvider, scheduledJob).run();
        }
        catch (Exception e) {
            LOGGER.error("Error running job: {} ", (Object)scheduledJob.getType(), (Object)e);
            throw new SystemException(String.format("Error running job '%s'", scheduledJob.getType()), (Throwable)e);
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    private ScheduledJob lockJob(ScheduledJob job) {
        ScheduledJob scheduledJob;
        ScheduledJob scheduledJob2;
        ScheduledJob scheduledJob3 = job;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)scheduledJob3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String hostAddress = this.getHostAddress();
        String owner = String.valueOf(hostAddress) + " - " + Thread.currentThread().getName();
        job.setLockedBy(owner);
        ScheduledJob lockedJob = this.jobService.lockJob(job, owner);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Locked job: {}", (Object)lockedJob);
        }
        ScheduledJob scheduledJob4 = scheduledJob2 = (scheduledJob = lockedJob);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)scheduledJob2);
        return scheduledJob;
    }

    private String getHostAddress() {
        String string;
        String string2;
        String hostAddress;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            hostAddress = "UNKNOWN_ADDRESS";
        }
        String string3 = string2 = (string = hostAddress);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JobRunner.java", JobRunner.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "registerTransactionProvider", "pro.taskana.common.internal.jobs.JobRunner", "pro.taskana.common.internal.transaction.TaskanaTransactionProvider", "txProvider", "", "void"), 29);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "runJobs", "pro.taskana.common.internal.jobs.JobRunner", "", "", "", "void"), 33);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "findAndLockJobsToRun", "pro.taskana.common.internal.jobs.JobRunner", "", "", "", "java.util.List"), 37);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "runJobTransactionally", "pro.taskana.common.internal.jobs.JobRunner", "pro.taskana.common.api.ScheduledJob", "scheduledJob", "", "void"), 43);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "runScheduledJob", "pro.taskana.common.internal.jobs.JobRunner", "pro.taskana.common.api.ScheduledJob", "scheduledJob", "", "void"), 49);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "lockJob", "pro.taskana.common.internal.jobs.JobRunner", "pro.taskana.common.api.ScheduledJob", "job", "", "pro.taskana.common.api.ScheduledJob"), 58);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getHostAddress", "pro.taskana.common.internal.jobs.JobRunner", "", "", "", "java.lang.String"), 69);
    }
}

