/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.user.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ibatis.exceptions.PersistenceException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngineConfiguration;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.CheckedSupplier;
import pro.taskana.user.api.UserService;
import pro.taskana.user.api.exceptions.UserAlreadyExistException;
import pro.taskana.user.api.exceptions.UserNotFoundException;
import pro.taskana.user.api.models.User;
import pro.taskana.user.internal.UserMapper;
import pro.taskana.user.internal.models.UserImpl;
import pro.taskana.workbasket.api.WorkbasketPermission;
import pro.taskana.workbasket.api.WorkbasketQueryColumnName;
import pro.taskana.workbasket.api.WorkbasketService;

public class UserServiceImpl
implements UserService {
    private static final Logger LOGGER;
    private final InternalTaskanaEngine internalTaskanaEngine;
    private final UserMapper userMapper;
    private final WorkbasketService workbasketService;
    private final List<WorkbasketPermission> minimalWorkbasketPermissions;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    static {
        UserServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(UserServiceImpl.class);
    }

    public UserServiceImpl(InternalTaskanaEngine internalTaskanaEngine, UserMapper userMapper) {
        this.internalTaskanaEngine = internalTaskanaEngine;
        this.userMapper = userMapper;
        this.workbasketService = internalTaskanaEngine.getEngine().getWorkbasketService();
        this.minimalWorkbasketPermissions = internalTaskanaEngine.getEngine().getConfiguration().getMinimalPermissionsToAssignDomains();
    }

    @Override
    public User newUser() {
        UserImpl userImpl;
        UserImpl userImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        UserImpl userImpl3 = userImpl2 = (userImpl = new UserImpl());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)userImpl2);
        return userImpl;
    }

    @Override
    public User getUser(String id) throws UserNotFoundException {
        UserImpl userImpl;
        UserImpl userImpl2;
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        UserImpl user = this.internalTaskanaEngine.executeInDatabaseConnection(() -> this.userMapper.findById(id));
        if (user == null) {
            throw new UserNotFoundException(id);
        }
        Set groups = this.internalTaskanaEngine.executeInDatabaseConnection(() -> this.userMapper.findGroupsById(id));
        if (groups != null) {
            user.setGroups(groups);
        }
        user.setDomains(this.determineDomains(user));
        UserImpl userImpl3 = userImpl2 = (userImpl = user);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)userImpl2);
        return userImpl;
    }

    @Override
    public User createUser(User userToCreate) throws InvalidArgumentException, NotAuthorizedException, UserAlreadyExistException {
        User user;
        User user2;
        User user3 = userToCreate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)user3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.internalTaskanaEngine.getEngine().checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        this.validateFields(userToCreate);
        this.standardCreateActions(userToCreate);
        this.insertIntoDatabase(userToCreate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Method createUser() created User '{}'.", (Object)userToCreate);
        }
        User user4 = user2 = (user = userToCreate);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)user2);
        return user;
    }

    @Override
    public User updateUser(User userToUpdate) throws UserNotFoundException, NotAuthorizedException, InvalidArgumentException {
        User user;
        User user2;
        User user3 = userToUpdate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)user3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.internalTaskanaEngine.getEngine().checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        this.validateFields(userToUpdate);
        this.standardUpdateActions(this.getUser(userToUpdate.getId()), userToUpdate);
        this.internalTaskanaEngine.executeInDatabaseConnection(() -> this.userMapper.update(userToUpdate));
        this.internalTaskanaEngine.executeInDatabaseConnection(() -> this.userMapper.deleteGroups(userToUpdate.getId()));
        if (userToUpdate.getGroups() != null && !userToUpdate.getGroups().isEmpty()) {
            this.internalTaskanaEngine.executeInDatabaseConnection(() -> this.userMapper.insertGroups(userToUpdate));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Method updateUser() updated User '{}'.", (Object)userToUpdate);
        }
        User user4 = user2 = (user = userToUpdate);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)user2);
        return user;
    }

    @Override
    public void deleteUser(String id) throws UserNotFoundException, NotAuthorizedException {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.internalTaskanaEngine.getEngine().checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        this.getUser(id);
        this.internalTaskanaEngine.executeInDatabaseConnection(() -> {
            this.userMapper.delete(id);
            this.userMapper.deleteGroups(id);
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Method deleteUser() deleted User with id '{}'.", (Object)id);
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private Set<String> determineDomains(User user) {
        Set<String> set;
        Set<String> set2;
        User user2 = user;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)user2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        HashSet<String> accessIds = new HashSet<String>(user.getGroups());
        accessIds.add(user.getId());
        Set<String> set3 = set2 = this.minimalWorkbasketPermissions != null && !this.minimalWorkbasketPermissions.isEmpty() ? (set = new HashSet<String>((Collection)this.internalTaskanaEngine.getEngine().runAsAdmin(CheckedSupplier.wrap(() -> this.workbasketService.createWorkbasketQuery().accessIdsHavePermissions(this.minimalWorkbasketPermissions, (String[])accessIds.toArray(String[]::new)).listValues(WorkbasketQueryColumnName.DOMAIN, BaseQuery.SortDirection.ASCENDING))))) : (set = Collections.emptySet());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, set2);
        return set;
    }

    private void insertIntoDatabase(User userToCreate) throws UserAlreadyExistException {
        User user = userToCreate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)user);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            try {
                this.internalTaskanaEngine.openConnection();
                this.userMapper.insert(userToCreate);
                if (userToCreate.getGroups() != null && !userToCreate.getGroups().isEmpty()) {
                    this.userMapper.insertGroups(userToCreate);
                }
            }
            catch (PersistenceException e) {
                throw new UserAlreadyExistException(userToCreate.getId(), (Exception)((Object)e));
            }
        }
        finally {
            this.internalTaskanaEngine.returnConnection();
        }
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private void validateFields(User userToValidate) throws InvalidArgumentException {
        User user = userToValidate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)user);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (userToValidate.getId() == null || userToValidate.getId().isEmpty()) {
            throw new InvalidArgumentException("UserId must not be empty when creating or updating User.");
        }
        if (userToValidate.getFirstName() == null || userToValidate.getLastName() == null) {
            throw new InvalidArgumentException("First and last name of User must be set or empty.");
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private void standardCreateActions(User user) {
        User user2 = user;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)user2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (user.getFullName() == null || user.getFullName().isEmpty()) {
            user.setFullName(String.valueOf(user.getLastName()) + ", " + user.getFirstName());
        }
        if (user.getLongName() == null || user.getLongName().isEmpty()) {
            user.setLongName(String.valueOf(user.getFullName()) + " - (" + user.getId() + ")");
        }
        if (TaskanaEngineConfiguration.shouldUseLowerCaseForAccessIds()) {
            user.setId(user.getId().toLowerCase());
            user.setGroups(user.getGroups().stream().map(String::toLowerCase).collect(Collectors.toSet()));
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private void standardUpdateActions(User oldUser, User newUser) {
        User user = oldUser;
        User user2 = newUser;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)user, (Object)user2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!newUser.getFirstName().equals(oldUser.getFirstName()) || !newUser.getLastName().equals(oldUser.getLastName())) {
            if (newUser.getFullName() == null || newUser.getFullName().isEmpty() || newUser.getFullName().equals(oldUser.getFullName())) {
                newUser.setFullName(String.valueOf(newUser.getLastName()) + ", " + newUser.getFirstName());
            }
            if (newUser.getLongName() == null || newUser.getLongName().isEmpty() || newUser.getLongName().equals(oldUser.getLongName())) {
                newUser.setLongName(String.valueOf(newUser.getFullName()) + " - (" + newUser.getId() + ")");
            }
        }
        if (TaskanaEngineConfiguration.shouldUseLowerCaseForAccessIds()) {
            newUser.setId(newUser.getId().toLowerCase());
            newUser.setGroups(newUser.getGroups().stream().map(String::toLowerCase).collect(Collectors.toSet()));
        }
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("UserServiceImpl.java", UserServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newUser", "pro.taskana.user.internal.UserServiceImpl", "", "", "", "pro.taskana.user.api.models.User"), 45);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUser", "pro.taskana.user.internal.UserServiceImpl", "java.lang.String", "id", "pro.taskana.user.api.exceptions.UserNotFoundException", "pro.taskana.user.api.models.User"), 50);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createUser", "pro.taskana.user.internal.UserServiceImpl", "pro.taskana.user.api.models.User", "userToCreate", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.user.api.exceptions.UserAlreadyExistException", "pro.taskana.user.api.models.User"), 68);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateUser", "pro.taskana.user.internal.UserServiceImpl", "pro.taskana.user.api.models.User", "userToUpdate", "pro.taskana.user.api.exceptions.UserNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.user.api.models.User"), 84);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteUser", "pro.taskana.user.internal.UserServiceImpl", "java.lang.String", "id", "pro.taskana.user.api.exceptions.UserNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException", "void"), 107);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "determineDomains", "pro.taskana.user.internal.UserServiceImpl", "pro.taskana.user.api.models.User", "user", "", "java.util.Set"), 123);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "insertIntoDatabase", "pro.taskana.user.internal.UserServiceImpl", "pro.taskana.user.api.models.User", "userToCreate", "pro.taskana.user.api.exceptions.UserAlreadyExistException", "void"), 146);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateFields", "pro.taskana.user.internal.UserServiceImpl", "pro.taskana.user.api.models.User", "userToValidate", "pro.taskana.common.api.exceptions.InvalidArgumentException", "void"), 160);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "standardCreateActions", "pro.taskana.user.internal.UserServiceImpl", "pro.taskana.user.api.models.User", "user", "", "void"), 170);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "standardUpdateActions", "pro.taskana.user.internal.UserServiceImpl", "pro.taskana.user.api.models.User:pro.taskana.user.api.models.User", "oldUser:newUser", "", "void"), 184);
    }
}

