/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.internal.reports;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.monitor.api.CombinedClassificationFilter;
import pro.taskana.monitor.api.TaskTimestamp;
import pro.taskana.monitor.api.reports.WorkbasketReport;
import pro.taskana.monitor.api.reports.header.TimeIntervalColumnHeader;
import pro.taskana.monitor.api.reports.item.MonitorQueryItem;
import pro.taskana.monitor.internal.MonitorMapper;
import pro.taskana.monitor.internal.preprocessor.DaysToWorkingDaysReportPreProcessor;
import pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.models.WorkbasketSummary;

public class WorkbasketReportBuilderImpl
extends TimeIntervalReportBuilderImpl<WorkbasketReport.Builder, MonitorQueryItem, TimeIntervalColumnHeader>
implements WorkbasketReport.Builder {
    private final WorkbasketService workbasketService;
    private List<CombinedClassificationFilter> combinedClassificationFilter;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public WorkbasketReportBuilderImpl(InternalTaskanaEngine taskanaEngine, MonitorMapper monitorMapper) {
        super(taskanaEngine, monitorMapper);
        this.workbasketService = taskanaEngine.getEngine().getWorkbasketService();
    }

    @Override
    public WorkbasketReport buildReport() throws NotAuthorizedException, InvalidArgumentException {
        WorkbasketReport workbasketReport;
        WorkbasketReport workbasketReport2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketReport workbasketReport3 = workbasketReport2 = (workbasketReport = this.buildReport(TaskTimestamp.DUE));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketReport2);
        return workbasketReport;
    }

    @Override
    public WorkbasketReport buildReport(TaskTimestamp timestamp) throws InvalidArgumentException, NotAuthorizedException {
        WorkbasketReport workbasketReport;
        WorkbasketReport workbasketReport2;
        TaskTimestamp taskTimestamp = timestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)((Object)taskTimestamp));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.MONITOR, TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            WorkbasketReport report = new WorkbasketReport(this.columnHeaders);
            List<MonitorQueryItem> monitorQueryItems = this.monitorMapper.getTaskCountOfWorkbaskets(Instant.now(), timestamp, this);
            report.addItems(monitorQueryItems, new DaysToWorkingDaysReportPreProcessor(this.columnHeaders, this.converter, this.inWorkingDays));
            Map displayMap = this.taskanaEngine.getEngine().runAsAdmin(() -> this.workbasketService.createWorkbasketQuery().keyIn(report.getRows().keySet().toArray(new String[0])).domainIn(this.domains).list().stream().collect(Collectors.toMap(WorkbasketSummary::getKey, WorkbasketSummary::getName, (a, b) -> a)));
            report.augmentDisplayNames(displayMap);
            WorkbasketReport workbasketReport3 = report;
            workbasketReport2 = workbasketReport3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        WorkbasketReport workbasketReport4 = workbasketReport = workbasketReport2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketReport);
        return workbasketReport2;
    }

    @Override
    public WorkbasketReport.Builder combinedClassificationFilterIn(List<CombinedClassificationFilter> combinedClassificationFilter) {
        WorkbasketReportBuilderImpl workbasketReportBuilderImpl;
        WorkbasketReportBuilderImpl workbasketReportBuilderImpl2;
        List<CombinedClassificationFilter> list = combinedClassificationFilter;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.combinedClassificationFilter = combinedClassificationFilter;
        WorkbasketReportBuilderImpl workbasketReportBuilderImpl3 = workbasketReportBuilderImpl2 = (workbasketReportBuilderImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketReportBuilderImpl2);
        return workbasketReportBuilderImpl;
    }

    @Override
    protected WorkbasketReport.Builder _this() {
        WorkbasketReportBuilderImpl workbasketReportBuilderImpl;
        WorkbasketReportBuilderImpl workbasketReportBuilderImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketReportBuilderImpl workbasketReportBuilderImpl3 = workbasketReportBuilderImpl2 = (workbasketReportBuilderImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketReportBuilderImpl2);
        return workbasketReportBuilderImpl;
    }

    @Override
    protected String determineGroupedBy() {
        String string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string2 = "WORKBASKET_KEY";
        String string3 = string = "WORKBASKET_KEY";
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
        return string2;
    }

    @Override
    protected List<CombinedClassificationFilter> getCombinedClassificationFilter() {
        List<CombinedClassificationFilter> list;
        List<CombinedClassificationFilter> list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<CombinedClassificationFilter> list3 = list2 = (list = this.combinedClassificationFilter);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    static {
        WorkbasketReportBuilderImpl.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WorkbasketReportBuilderImpl.java", WorkbasketReportBuilderImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildReport", "pro.taskana.monitor.internal.reports.WorkbasketReportBuilderImpl", "", "", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.monitor.api.reports.WorkbasketReport"), 37);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildReport", "pro.taskana.monitor.internal.reports.WorkbasketReportBuilderImpl", "pro.taskana.monitor.api.TaskTimestamp", "timestamp", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.monitor.api.reports.WorkbasketReport"), 42);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "combinedClassificationFilterIn", "pro.taskana.monitor.internal.reports.WorkbasketReportBuilderImpl", "java.util.List", "combinedClassificationFilter", "", "pro.taskana.monitor.api.reports.WorkbasketReport$Builder"), 79);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "_this", "pro.taskana.monitor.internal.reports.WorkbasketReportBuilderImpl", "", "", "", "pro.taskana.monitor.api.reports.WorkbasketReport$Builder"), 86);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "determineGroupedBy", "pro.taskana.monitor.internal.reports.WorkbasketReportBuilderImpl", "", "", "", "java.lang.String"), 91);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getCombinedClassificationFilter", "pro.taskana.monitor.internal.reports.WorkbasketReportBuilderImpl", "", "", "", "java.util.List"), 96);
    }
}

