/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.BulkOperationResults;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.EnumUtil;
import pro.taskana.common.internal.util.IdGenerator;
import pro.taskana.common.internal.util.ObjectAttributeChangeDetector;
import pro.taskana.spi.history.api.events.task.TaskTransferredEvent;
import pro.taskana.spi.history.internal.HistoryEventManager;
import pro.taskana.task.api.TaskState;
import pro.taskana.task.api.exceptions.InvalidStateException;
import pro.taskana.task.api.exceptions.InvalidTaskStateException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.task.api.models.Task;
import pro.taskana.task.api.models.TaskSummary;
import pro.taskana.task.internal.TaskMapper;
import pro.taskana.task.internal.TaskServiceImpl;
import pro.taskana.task.internal.models.TaskImpl;
import pro.taskana.task.internal.models.TaskSummaryImpl;
import pro.taskana.workbasket.api.WorkbasketPermission;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.exceptions.MismatchedWorkbasketPermissionException;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;
import pro.taskana.workbasket.api.models.WorkbasketSummary;
import pro.taskana.workbasket.internal.WorkbasketQueryImpl;

final class TaskTransferrer {
    private final InternalTaskanaEngine taskanaEngine;
    private final WorkbasketService workbasketService;
    private final TaskServiceImpl taskService;
    private final TaskMapper taskMapper;
    private final HistoryEventManager historyEventManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;

    TaskTransferrer(InternalTaskanaEngine taskanaEngine, TaskMapper taskMapper, TaskServiceImpl taskService) {
        this.taskanaEngine = taskanaEngine;
        this.taskService = taskService;
        this.taskMapper = taskMapper;
        this.workbasketService = taskanaEngine.getEngine().getWorkbasketService();
        this.historyEventManager = taskanaEngine.getHistoryEventManager();
    }

    Task transfer(String taskId, String destinationWorkbasketId, boolean setTransferFlag) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedException, InvalidStateException {
        Task task;
        Task task2;
        String string = taskId;
        String string2 = destinationWorkbasketId;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, string2, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketSummary destinationWorkbasket = this.workbasketService.getWorkbasket(destinationWorkbasketId).asSummary();
        Task task3 = task2 = (task = this.transferSingleTask(taskId, destinationWorkbasket, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    Task transfer(String taskId, String destinationWorkbasketKey, String destinationDomain, boolean setTransferFlag) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedException, InvalidStateException {
        Task task;
        Task task2;
        String string = taskId;
        String string2 = destinationWorkbasketKey;
        String string3 = destinationDomain;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, string2, string3, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketSummary destinationWorkbasket = this.workbasketService.getWorkbasket(destinationWorkbasketKey, destinationDomain).asSummary();
        Task task3 = task2 = (task = this.transferSingleTask(taskId, destinationWorkbasket, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    BulkOperationResults<String, TaskanaException> transfer(List<String> taskIds, String destinationWorkbasketId, boolean setTransferFlag) throws NotAuthorizedException, WorkbasketNotFoundException, InvalidArgumentException {
        BulkOperationResults<String, TaskanaException> bulkOperationResults;
        BulkOperationResults<String, TaskanaException> bulkOperationResults2;
        List<String> list = taskIds;
        String string = destinationWorkbasketId;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{list, string, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketSummary destinationWorkbasket = this.workbasketService.getWorkbasket(destinationWorkbasketId).asSummary();
        this.checkDestinationWorkbasket(destinationWorkbasket);
        BulkOperationResults<String, TaskanaException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.transferMultipleTasks(taskIds, destinationWorkbasket, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    BulkOperationResults<String, TaskanaException> transfer(List<String> taskIds, String destinationWorkbasketKey, String destinationDomain, boolean setTransferFlag) throws NotAuthorizedException, WorkbasketNotFoundException, InvalidArgumentException {
        BulkOperationResults<String, TaskanaException> bulkOperationResults;
        BulkOperationResults<String, TaskanaException> bulkOperationResults2;
        List<String> list = taskIds;
        String string = destinationWorkbasketKey;
        String string2 = destinationDomain;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{list, string, string2, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketSummary destinationWorkbasket = this.workbasketService.getWorkbasket(destinationWorkbasketKey, destinationDomain).asSummary();
        this.checkDestinationWorkbasket(destinationWorkbasket);
        BulkOperationResults<String, TaskanaException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.transferMultipleTasks(taskIds, destinationWorkbasket, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    private Task transferSingleTask(String taskId, WorkbasketSummary destinationWorkbasket, boolean setTransferFlag) throws NotAuthorizedException, TaskNotFoundException, WorkbasketNotFoundException, InvalidStateException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        String string = taskId;
        WorkbasketSummary workbasketSummary = destinationWorkbasket;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, workbasketSummary, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            this.taskanaEngine.openConnection();
            TaskImpl task = (TaskImpl)this.taskService.getTask(taskId);
            TaskImpl oldTask = task.copy();
            oldTask.setId(task.getId());
            oldTask.setExternalId(task.getExternalId());
            WorkbasketSummary originWorkbasket = task.getWorkbasketSummary();
            this.checkPreconditionsForTransferTask(task, destinationWorkbasket, originWorkbasket);
            this.applyTransferValuesForTask(task, destinationWorkbasket, setTransferFlag);
            this.taskMapper.update(task);
            if (this.historyEventManager.isEnabled()) {
                this.createTransferredEvent(oldTask, task, originWorkbasket.getId(), destinationWorkbasket.getId());
            }
            TaskImpl taskImpl3 = task;
            taskImpl2 = taskImpl3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        TaskImpl taskImpl4 = taskImpl = taskImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl);
        return taskImpl2;
    }

    private BulkOperationResults<String, TaskanaException> transferMultipleTasks(List<String> taskToBeTransferred, WorkbasketSummary destinationWorkbasket, boolean setTransferFlag) throws InvalidArgumentException {
        BulkOperationResults bulkOperationResults;
        BulkOperationResults bulkOperationResults2;
        List<String> list = taskToBeTransferred;
        WorkbasketSummary workbasketSummary = destinationWorkbasket;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{list, workbasketSummary, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskToBeTransferred == null || taskToBeTransferred.isEmpty()) {
            throw new InvalidArgumentException("TaskIds must not be null or empty.");
        }
        BulkOperationResults bulkLog = new BulkOperationResults();
        ArrayList<String> taskIds = new ArrayList<String>(taskToBeTransferred);
        try {
            this.taskanaEngine.openConnection();
            List<TaskSummary> taskSummaries = this.taskanaEngine.getEngine().runAsAdmin(() -> this.taskService.createTaskQuery().idIn(taskIds.toArray(new String[0])).list());
            taskSummaries = this.filterOutTasksWhichDoNotMatchTransferCriteria(taskIds, taskSummaries, (BulkOperationResults<String, TaskanaException>)bulkLog);
            this.updateTransferableTasks(taskSummaries, destinationWorkbasket, setTransferFlag);
            BulkOperationResults bulkOperationResults3 = bulkLog;
            bulkOperationResults2 = bulkOperationResults3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        BulkOperationResults bulkOperationResults4 = bulkOperationResults = bulkOperationResults2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkOperationResults);
        return bulkOperationResults2;
    }

    private void checkPreconditionsForTransferTask(Task task, WorkbasketSummary destinationWorkbasket, WorkbasketSummary originWorkbasket) throws NotAuthorizedException, WorkbasketNotFoundException, InvalidStateException {
        Task task2 = task;
        WorkbasketSummary workbasketSummary = destinationWorkbasket;
        WorkbasketSummary workbasketSummary2 = originWorkbasket;
        Object[] objectArray = new Object[]{task2, workbasketSummary, workbasketSummary2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (task.getState().isEndState()) {
            throw new InvalidTaskStateException(task.getId(), task.getState(), (TaskState[])EnumUtil.allValuesExceptFor((Enum[])TaskState.END_STATES));
        }
        this.workbasketService.checkAuthorization(originWorkbasket.getId(), WorkbasketPermission.TRANSFER);
        this.checkDestinationWorkbasket(destinationWorkbasket);
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    private void checkDestinationWorkbasket(WorkbasketSummary destinationWorkbasket) throws NotAuthorizedException, WorkbasketNotFoundException {
        WorkbasketSummary workbasketSummary = destinationWorkbasket;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)workbasketSummary);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.workbasketService.checkAuthorization(destinationWorkbasket.getId(), WorkbasketPermission.APPEND);
        if (destinationWorkbasket.isMarkedForDeletion()) {
            throw new WorkbasketNotFoundException(destinationWorkbasket.getId());
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private List<TaskSummary> filterOutTasksWhichDoNotMatchTransferCriteria(List<String> taskIds, List<TaskSummary> taskSummaries, BulkOperationResults<String, TaskanaException> bulkLog) {
        ArrayList<TaskSummary> arrayList;
        ArrayList<TaskSummary> arrayList2;
        List<String> list = taskIds;
        List<TaskSummary> list2 = taskSummaries;
        BulkOperationResults<String, TaskanaException> bulkOperationResults = bulkLog;
        Object[] objectArray = new Object[]{list, list2, bulkOperationResults};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map taskIdToTaskSummary = taskSummaries.stream().collect(Collectors.toMap(TaskSummary::getId, Function.identity()));
        Set<String> workbasketIds = this.getSourceWorkbasketIdsWithTransferPermission(taskSummaries);
        ArrayList<TaskSummary> filteredOutTasks = new ArrayList<TaskSummary>(taskIds.size());
        for (String taskId : new HashSet<String>(taskIds)) {
            TaskSummary taskSummary;
            Optional<TaskanaException> error = this.checkTaskForTransferCriteria(workbasketIds, taskId, taskSummary = (TaskSummary)taskIdToTaskSummary.get(taskId));
            if (error.isPresent()) {
                bulkLog.addError((Object)taskId, (Exception)((Object)error.get()));
                continue;
            }
            filteredOutTasks.add(taskSummary);
        }
        ArrayList<TaskSummary> arrayList3 = arrayList2 = (arrayList = filteredOutTasks);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList2);
        return arrayList;
    }

    private Optional<TaskanaException> checkTaskForTransferCriteria(Set<String> sourceWorkbasketIds, String taskId, TaskSummary taskSummary) {
        Optional<InvalidArgumentException> optional;
        Optional<InvalidArgumentException> optional2;
        Set<String> set = sourceWorkbasketIds;
        String string = taskId;
        TaskSummary taskSummary2 = taskSummary;
        Object[] objectArray = new Object[]{set, string, taskSummary2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Object error = null;
        if (taskId == null || taskId.isEmpty()) {
            error = new InvalidArgumentException("TaskId should not be null or empty");
        } else if (taskSummary == null) {
            error = new TaskNotFoundException(taskId);
        } else if (taskSummary.getState().isEndState()) {
            error = new InvalidTaskStateException(taskId, taskSummary.getState(), (TaskState[])EnumUtil.allValuesExceptFor((Enum[])TaskState.END_STATES));
        } else if (!sourceWorkbasketIds.contains(taskSummary.getWorkbasketSummary().getId())) {
            error = new MismatchedWorkbasketPermissionException(this.taskanaEngine.getEngine().getCurrentUserContext().getUserid(), taskSummary.getWorkbasketSummary().getId(), WorkbasketPermission.TRANSFER);
        }
        Optional<InvalidArgumentException> optional3 = optional2 = (optional = Optional.ofNullable(error));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, optional2);
        return optional;
    }

    private Set<String> getSourceWorkbasketIdsWithTransferPermission(List<TaskSummary> taskSummaries) {
        Set<String> set;
        Set<String> set2;
        Set<String> set3;
        List<TaskSummary> list = taskSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskSummaries.isEmpty()) {
            set2 = set3 = Collections.emptySet();
        } else {
            WorkbasketQueryImpl query = (WorkbasketQueryImpl)this.workbasketService.createWorkbasketQuery();
            query.setUsedToAugmentTasks(true);
            String[] workbasketIds = (String[])taskSummaries.stream().map(TaskSummary::getWorkbasketSummary).map(WorkbasketSummary::getId).distinct().toArray(String[]::new);
            List sourceWorkbaskets = query.callerHasPermissions(WorkbasketPermission.TRANSFER).idIn(workbasketIds).list();
            set2 = set3 = sourceWorkbaskets.stream().map(WorkbasketSummary::getId).collect(Collectors.toSet());
        }
        Set<String> set4 = set = set2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, set);
        return set3;
    }

    private void updateTransferableTasks(List<TaskSummary> taskSummaries, WorkbasketSummary destinationWorkbasket, boolean setTransferFlag) {
        List<TaskSummary> list = taskSummaries;
        WorkbasketSummary workbasketSummary = destinationWorkbasket;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{list, workbasketSummary, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<TaskState, List<TaskSummary>> summariesByState = this.groupTasksByState(taskSummaries);
        for (Map.Entry<TaskState, List<TaskSummary>> entry : summariesByState.entrySet()) {
            TaskState goalState = entry.getKey();
            List<TaskSummary> taskSummariesWithSameGoalState = entry.getValue();
            if (taskSummariesWithSameGoalState.isEmpty()) continue;
            TaskImpl updateObject = new TaskImpl();
            updateObject.setState(goalState);
            this.applyTransferValuesForTask(updateObject, destinationWorkbasket, setTransferFlag);
            this.taskMapper.updateTransfered(taskSummariesWithSameGoalState.stream().map(TaskSummary::getId).collect(Collectors.toSet()), updateObject);
            if (!this.historyEventManager.isEnabled()) continue;
            taskSummaries.forEach(oldSummary -> {
                TaskSummaryImpl newSummary = (TaskSummaryImpl)oldSummary.copy();
                newSummary.setId(oldSummary.getId());
                newSummary.setExternalId(oldSummary.getExternalId());
                this.applyTransferValuesForTask(newSummary, destinationWorkbasket, setTransferFlag);
                this.createTransferredEvent((TaskSummary)oldSummary, newSummary, oldSummary.getWorkbasketSummary().getId(), newSummary.getWorkbasketSummary().getId());
            });
        }
        Object var15_15 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var15_15);
    }

    private void applyTransferValuesForTask(TaskSummaryImpl task, WorkbasketSummary workbasket, boolean setTransferFlag) {
        TaskSummaryImpl taskSummaryImpl = task;
        WorkbasketSummary workbasketSummary = workbasket;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{taskSummaryImpl, workbasketSummary, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        task.setRead(false);
        task.setTransferred(setTransferFlag);
        task.setState(this.getStateAfterTransfer(task));
        task.setOwner(null);
        task.setWorkbasketSummary(workbasket);
        task.setDomain(workbasket.getDomain());
        task.setModified(Instant.now());
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    private void createTransferredEvent(TaskSummary oldTask, TaskSummary newTask, String originWorkbasketId, String destinationWorkbasketId) {
        TaskSummary taskSummary = oldTask;
        TaskSummary taskSummary2 = newTask;
        String string = originWorkbasketId;
        String string2 = destinationWorkbasketId;
        Object[] objectArray = new Object[]{taskSummary, taskSummary2, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String details = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)oldTask, (Object)newTask);
        this.historyEventManager.createEvent(new TaskTransferredEvent(IdGenerator.generateWithPrefix((String)"THI"), newTask, originWorkbasketId, destinationWorkbasketId, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid(), details));
        Object var12_12 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var12_12);
    }

    private TaskState getStateAfterTransfer(TaskSummary taskSummary) {
        TaskState taskState;
        TaskState taskState2;
        TaskSummary taskSummary2 = taskSummary;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)taskSummary2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskState stateBeforeTransfer = taskSummary.getState();
        TaskState taskState3 = taskState2 = stateBeforeTransfer.equals((Object)TaskState.CLAIMED) ? (taskState = TaskState.READY) : (stateBeforeTransfer.equals((Object)TaskState.IN_REVIEW) ? (taskState = TaskState.READY_FOR_REVIEW) : (taskState = stateBeforeTransfer));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskState2);
        return taskState;
    }

    private Map<TaskState, List<TaskSummary>> groupTasksByState(List<TaskSummary> taskSummaries) {
        Map<TaskState, List<TaskSummary>> map;
        Map<TaskState, List<TaskSummary>> map2;
        List<TaskSummary> list = taskSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<TaskState, List<TaskSummary>> result = Map.ofEntries(Map.entry(TaskState.READY, new ArrayList()), Map.entry(TaskState.READY_FOR_REVIEW, new ArrayList()));
        for (TaskSummary taskSummary : taskSummaries) {
            List relevantSummaries = (List)result.get((Object)this.getStateAfterTransfer(taskSummary));
            relevantSummaries.add(taskSummary);
        }
        Map<TaskState, List<TaskSummary>> map3 = map2 = (map = result);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    static {
        TaskTransferrer.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskTransferrer.java", TaskTransferrer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "transfer", "pro.taskana.task.internal.TaskTransferrer", "java.lang.String:java.lang.String:boolean", "taskId:destinationWorkbasketId:setTransferFlag", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.InvalidStateException", "pro.taskana.task.api.models.Task"), 59);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "transfer", "pro.taskana.task.internal.TaskTransferrer", "java.lang.String:java.lang.String:java.lang.String:boolean", "taskId:destinationWorkbasketKey:destinationDomain:setTransferFlag", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.InvalidStateException", "pro.taskana.task.api.models.Task"), 67);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getSourceWorkbasketIdsWithTransferPermission", "pro.taskana.task.internal.TaskTransferrer", "java.util.List", "taskSummaries", "", "java.util.Set"), 225);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateTransferableTasks", "pro.taskana.task.internal.TaskTransferrer", "java.util.List:pro.taskana.workbasket.api.models.WorkbasketSummary:boolean", "taskSummaries:destinationWorkbasket:setTransferFlag", "", "void"), 245);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "applyTransferValuesForTask", "pro.taskana.task.internal.TaskTransferrer", "pro.taskana.task.internal.models.TaskSummaryImpl:pro.taskana.workbasket.api.models.WorkbasketSummary:boolean", "task:workbasket:setTransferFlag", "", "void"), 282);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createTransferredEvent", "pro.taskana.task.internal.TaskTransferrer", "pro.taskana.task.api.models.TaskSummary:pro.taskana.task.api.models.TaskSummary:java.lang.String:java.lang.String", "oldTask:newTask:originWorkbasketId:destinationWorkbasketId", "", "void"), 293);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getStateAfterTransfer", "pro.taskana.task.internal.TaskTransferrer", "pro.taskana.task.api.models.TaskSummary", "taskSummary", "", "pro.taskana.task.api.TaskState"), 309);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "groupTasksByState", "pro.taskana.task.internal.TaskTransferrer", "java.util.List", "taskSummaries", "", "java.util.Map"), 321);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "transfer", "pro.taskana.task.internal.TaskTransferrer", "java.util.List:java.lang.String:boolean", "taskIds:destinationWorkbasketId:setTransferFlag", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.common.api.BulkOperationResults"), 79);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "transfer", "pro.taskana.task.internal.TaskTransferrer", "java.util.List:java.lang.String:java.lang.String:boolean", "taskIds:destinationWorkbasketKey:destinationDomain:setTransferFlag", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.common.api.BulkOperationResults"), 89);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "transferSingleTask", "pro.taskana.task.internal.TaskTransferrer", "java.lang.String:pro.taskana.workbasket.api.models.WorkbasketSummary:boolean", "taskId:destinationWorkbasket:setTransferFlag", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.task.api.exceptions.InvalidStateException", "pro.taskana.task.api.models.Task"), 102);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "transferMultipleTasks", "pro.taskana.task.internal.TaskTransferrer", "java.util.List:pro.taskana.workbasket.api.models.WorkbasketSummary:boolean", "taskToBeTransferred:destinationWorkbasket:setTransferFlag", "pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.common.api.BulkOperationResults"), 129);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkPreconditionsForTransferTask", "pro.taskana.task.internal.TaskTransferrer", "pro.taskana.task.api.models.Task:pro.taskana.workbasket.api.models.WorkbasketSummary:pro.taskana.workbasket.api.models.WorkbasketSummary", "task:destinationWorkbasket:originWorkbasket", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.task.api.exceptions.InvalidStateException", "void"), 158);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkDestinationWorkbasket", "pro.taskana.task.internal.TaskTransferrer", "pro.taskana.workbasket.api.models.WorkbasketSummary", "destinationWorkbasket", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException", "void"), 169);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "filterOutTasksWhichDoNotMatchTransferCriteria", "pro.taskana.task.internal.TaskTransferrer", "java.util.List:java.util.List:pro.taskana.common.api.BulkOperationResults", "taskIds:taskSummaries:bulkLog", "", "java.util.List"), 179);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkTaskForTransferCriteria", "pro.taskana.task.internal.TaskTransferrer", "java.util.Set:java.lang.String:pro.taskana.task.api.models.TaskSummary", "sourceWorkbasketIds:taskId:taskSummary", "", "java.util.Optional"), 204);
    }
}

