/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal.jobs;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.ScheduledJob;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.internal.jobs.AbstractTaskanaJob;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.transaction.TaskanaTransactionProvider;
import pro.taskana.task.internal.TaskServiceImpl;

public class TaskRefreshJob
extends AbstractTaskanaJob {
    public static final String TASK_IDS = "taskIds";
    public static final String PRIORITY_CHANGED = "priorityChanged";
    public static final String SERVICE_LEVEL_CHANGED = "serviceLevelChanged";
    private static final Logger LOGGER;
    private final List<String> affectedTaskIds;
    private final boolean priorityChanged;
    private final boolean serviceLevelChanged;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        TaskRefreshJob.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TaskRefreshJob.class);
    }

    public TaskRefreshJob(TaskanaEngine engine, TaskanaTransactionProvider txProvider, ScheduledJob job) {
        super(engine, txProvider, job, false);
        Map<String, String> args = job.getArguments();
        String taskIdsString = args.get(TASK_IDS);
        this.affectedTaskIds = Arrays.asList(taskIdsString.split(","));
        this.priorityChanged = Boolean.parseBoolean(args.get(PRIORITY_CHANGED));
        this.serviceLevelChanged = Boolean.parseBoolean(args.get(SERVICE_LEVEL_CHANGED));
    }

    @Override
    public void execute() throws TaskanaException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        LOGGER.info("Running TaskRefreshJob for {} tasks", (Object)this.affectedTaskIds.size());
        try {
            TaskServiceImpl taskService = (TaskServiceImpl)this.taskanaEngineImpl.getTaskService();
            taskService.refreshPriorityAndDueDatesOfTasksOnClassificationUpdate(this.affectedTaskIds, this.serviceLevelChanged, this.priorityChanged);
            LOGGER.info("TaskRefreshJob ended successfully.");
        }
        catch (Exception e) {
            throw new SystemException("Error while processing TaskRefreshJob.", (Throwable)e);
        }
        Object var3_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var3_4);
    }

    @Override
    protected String getType() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = TaskRefreshJob.class.getName());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String toString() {
        return "TaskRefreshJob [firstRun=" + this.firstRun + ", runEvery=" + this.runEvery + ", taskanaEngineImpl=" + this.taskanaEngineImpl + ", txProvider=" + this.txProvider + ", scheduledJob=" + this.scheduledJob + ", affectedTaskIds=" + this.affectedTaskIds + ", priorityChanged=" + this.priorityChanged + ", serviceLevelChanged=" + this.serviceLevelChanged + "]";
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskRefreshJob.java", TaskRefreshJob.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "pro.taskana.task.internal.jobs.TaskRefreshJob", "", "", "pro.taskana.common.api.exceptions.TaskanaException", "void"), 39);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getType", "pro.taskana.task.internal.jobs.TaskRefreshJob", "", "", "", "java.lang.String"), 52);
    }
}

