/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal.jobs;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.time.Instant;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.ScheduledJob;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.internal.JobServiceImpl;
import pro.taskana.common.internal.TaskanaEngineImpl;
import pro.taskana.common.internal.jobs.TaskanaJob;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.transaction.TaskanaTransactionProvider;

public abstract class AbstractTaskanaJob
implements TaskanaJob {
    protected final TaskanaEngineImpl taskanaEngineImpl;
    protected final TaskanaTransactionProvider txProvider;
    protected final ScheduledJob scheduledJob;
    private final boolean async;
    protected Instant firstRun;
    protected Duration runEvery;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    protected AbstractTaskanaJob(TaskanaEngine taskanaEngine, TaskanaTransactionProvider txProvider, ScheduledJob job, boolean async) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
        this.txProvider = txProvider;
        this.scheduledJob = job;
        this.async = async;
        this.firstRun = this.taskanaEngineImpl.getConfiguration().getJobFirstRun();
        this.runEvery = this.taskanaEngineImpl.getConfiguration().getJobRunEvery();
    }

    public static TaskanaJob createFromScheduledJob(TaskanaEngine engine, TaskanaTransactionProvider txProvider, ScheduledJob job) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        TaskanaJob taskanaJob;
        TaskanaJob taskanaJob2;
        TaskanaEngine taskanaEngine = engine;
        TaskanaTransactionProvider taskanaTransactionProvider = txProvider;
        ScheduledJob scheduledJob = job;
        Object[] objectArray = new Object[]{taskanaEngine, taskanaTransactionProvider, scheduledJob};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskanaJob taskanaJob3 = taskanaJob2 = (taskanaJob = (TaskanaJob)Thread.currentThread().getContextClassLoader().loadClass(job.getType()).getConstructors()[0].newInstance(engine, txProvider, job));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskanaJob2);
        return taskanaJob;
    }

    @Override
    public final void run() throws TaskanaException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.execute();
        if (this.async) {
            this.scheduleNextJob();
        }
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    public static void initializeSchedule(TaskanaEngine taskanaEngine, Class<?> jobClass) {
        AbstractTaskanaJob job;
        Constructor<?> constructor;
        TaskanaEngine taskanaEngine2 = taskanaEngine;
        Class<?> clazz = jobClass;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)taskanaEngine2, clazz);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!AbstractTaskanaJob.class.isAssignableFrom(jobClass)) {
            throw new SystemException(String.format("Job '%s' is not a subclass of '%s'", jobClass, AbstractTaskanaJob.class));
        }
        try {
            constructor = jobClass.getConstructor(TaskanaEngine.class, TaskanaTransactionProvider.class, ScheduledJob.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SystemException(String.format("Job '%s' does not have a constructor matching (%s, %s, %s)", jobClass, TaskanaEngine.class, TaskanaTransactionProvider.class, ScheduledJob.class));
        }
        try {
            job = (AbstractTaskanaJob)constructor.newInstance(taskanaEngine, null, null);
        }
        catch (InvocationTargetException e) {
            throw new SystemException(String.format("Required Constructor(%s, %s, %s) of job '%s' could not be invoked", TaskanaEngine.class, TaskanaTransactionProvider.class, ScheduledJob.class, jobClass), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new SystemException(String.format("Required Constructor(%s, %s, %s) of job '%s' could not be initialized", TaskanaEngine.class, TaskanaTransactionProvider.class, ScheduledJob.class, jobClass), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SystemException(String.format("Required Constructor(%s, %s, %s) of job '%s' is not public", TaskanaEngine.class, TaskanaTransactionProvider.class, ScheduledJob.class, jobClass), (Throwable)e);
        }
        if (!job.async) {
            throw new SystemException(String.format("Job '%s' is not an async job. Please declare it as async", jobClass));
        }
        JobServiceImpl jobService = (JobServiceImpl)taskanaEngine.getJobService();
        jobService.deleteJobs(job.getType());
        job.scheduleNextJob();
        Object var8_11 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_11);
    }

    public boolean isAsync() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.async);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public Instant getFirstRun() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.firstRun);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Duration getRunEvery() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.runEvery);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    protected abstract String getType();

    protected abstract void execute() throws TaskanaException;

    protected Instant getNextDueForJob() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant nextRun = this.firstRun;
        if (this.scheduledJob != null && this.scheduledJob.getDue() != null) {
            nextRun = this.scheduledJob.getDue();
        }
        while (nextRun.isBefore(Instant.now())) {
            nextRun = nextRun.plus(this.runEvery);
        }
        Instant instant3 = instant2 = (instant = nextRun);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    protected void scheduleNextJob() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ScheduledJob job = new ScheduledJob();
        job.setType(this.getType());
        job.setDue(this.getNextDueForJob());
        this.taskanaEngineImpl.getJobService().createJob(job);
        Object var3_3 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var3_3);
    }

    static {
        AbstractTaskanaJob.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractTaskanaJob.java", AbstractTaskanaJob.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "createFromScheduledJob", "pro.taskana.common.internal.jobs.AbstractTaskanaJob", "pro.taskana.common.api.TaskanaEngine:pro.taskana.common.internal.transaction.TaskanaTransactionProvider:pro.taskana.common.api.ScheduledJob", "engine:txProvider:job", "java.lang.ClassNotFoundException:java.lang.IllegalAccessException:java.lang.InstantiationException:java.lang.reflect.InvocationTargetException", "pro.taskana.common.internal.jobs.TaskanaJob"), 38);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "run", "pro.taskana.common.internal.jobs.AbstractTaskanaJob", "", "", "pro.taskana.common.api.exceptions.TaskanaException", "void"), 54);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "initializeSchedule", "pro.taskana.common.internal.jobs.AbstractTaskanaJob", "pro.taskana.common.api.TaskanaEngine:java.lang.Class", "taskanaEngine:jobClass", "", "void"), 69);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isAsync", "pro.taskana.common.internal.jobs.AbstractTaskanaJob", "", "", "", "boolean"), 116);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFirstRun", "pro.taskana.common.internal.jobs.AbstractTaskanaJob", "", "", "", "java.time.Instant"), 120);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRunEvery", "pro.taskana.common.internal.jobs.AbstractTaskanaJob", "", "", "", "java.time.Duration"), 124);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getNextDueForJob", "pro.taskana.common.internal.jobs.AbstractTaskanaJob", "", "", "", "java.time.Instant"), 132);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "scheduleNextJob", "pro.taskana.common.internal.jobs.AbstractTaskanaJob", "", "", "", "void"), 145);
    }
}

