/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal.jobs;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.jobs.AbstractTaskanaJob;
import pro.taskana.common.internal.jobs.Clock;
import pro.taskana.common.internal.jobs.JobRunner;
import pro.taskana.common.internal.jobs.PlainJavaTransactionProvider;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.task.internal.jobs.TaskCleanupJob;
import pro.taskana.task.internal.jobs.TaskUpdatePriorityJob;
import pro.taskana.workbasket.internal.jobs.WorkbasketCleanupJob;

public class JobScheduler {
    private static final Logger LOGGER;
    private final TaskanaEngine taskanaEngine;
    private final Clock clock;
    private final PlainJavaTransactionProvider plainJavaTransactionProvider;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        JobScheduler.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(JobScheduler.class);
    }

    public JobScheduler(TaskanaEngine taskanaEngine, Clock clock) {
        this.taskanaEngine = taskanaEngine;
        this.clock = clock;
        this.plainJavaTransactionProvider = new PlainJavaTransactionProvider(taskanaEngine, taskanaEngine.getConfiguration().getDataSource());
        this.plainJavaTransactionProvider.executeInTransaction(() -> {
            if (taskanaEngine.getConfiguration().isTaskCleanupJobEnabled()) {
                AbstractTaskanaJob.initializeSchedule(taskanaEngine, TaskCleanupJob.class);
                LOGGER.info("Job '{}' enabled", (Object)TaskCleanupJob.class.getName());
            }
            if (taskanaEngine.getConfiguration().isTaskUpdatePriorityJobEnabled()) {
                AbstractTaskanaJob.initializeSchedule(taskanaEngine, TaskUpdatePriorityJob.class);
                LOGGER.info("Job '{}' enabled", (Object)TaskUpdatePriorityJob.class.getName());
            }
            if (taskanaEngine.getConfiguration().isWorkbasketCleanupJobEnabled()) {
                AbstractTaskanaJob.initializeSchedule(taskanaEngine, WorkbasketCleanupJob.class);
                LOGGER.info("Job '{}' enabled", (Object)WorkbasketCleanupJob.class.getName());
            }
            if (taskanaEngine.getConfiguration().isUserInfoRefreshJobEnabled()) {
                this.initJobByClassName("pro.taskana.user.jobs.UserInfoRefreshJob");
            }
            if (taskanaEngine.getConfiguration().isSimpleHistoryCleanupJobEnabled()) {
                this.initJobByClassName("pro.taskana.simplehistory.impl.jobs.HistoryCleanupJob");
            }
            taskanaEngine.getConfiguration().getCustomJobs().forEach(this::initJobByClassName);
            return "Initialized Jobs successfully";
        });
        this.clock.register(this::runAsyncJobsAsAdmin);
    }

    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.clock.start();
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    public void stop() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.clock.stop();
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    private void initJobByClassName(String className) throws SystemException {
        String string = className;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            Class<?> jobClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            AbstractTaskanaJob.initializeSchedule(this.taskanaEngine, jobClass);
            LOGGER.info("Job '{}' enabled", (Object)className);
        }
        catch (ClassNotFoundException e) {
            throw new SystemException(String.format("Could not find class '%s'", className), (Throwable)e);
        }
        Object var5_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_6);
    }

    private void runAsyncJobsAsAdmin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.runAsAdmin(() -> {
            JobRunner runner = new JobRunner(this.taskanaEngine);
            runner.registerTransactionProvider(this.plainJavaTransactionProvider);
            LOGGER.info("Running Jobs");
            runner.runJobs();
            return "Successful";
        });
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JobScheduler.java", JobScheduler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "pro.taskana.common.internal.jobs.JobScheduler", "", "", "", "void"), 59);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "pro.taskana.common.internal.jobs.JobScheduler", "", "", "", "void"), 63);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initJobByClassName", "pro.taskana.common.internal.jobs.JobScheduler", "java.lang.String", "className", "pro.taskana.common.api.exceptions.SystemException", "void"), 67);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "runAsyncJobsAsAdmin", "pro.taskana.common.internal.jobs.JobScheduler", "", "", "", "void"), 77);
    }
}

