/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.api.reports.row;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.monitor.api.reports.item.QueryItem;
import pro.taskana.monitor.api.reports.row.Row;
import pro.taskana.monitor.api.reports.row.SingleRow;

public abstract class FoldableRow<I extends QueryItem>
extends SingleRow<I> {
    private final Map<String, Row<I>> foldableRows = new LinkedHashMap<String, Row<I>>();
    private final Function<? super I, String> calcFoldableRowKey;
    private final int columnSize;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    protected FoldableRow(String key, int columnSize, Function<? super I, String> calcFoldableRowKey) {
        super(key, columnSize);
        this.columnSize = columnSize;
        this.calcFoldableRowKey = calcFoldableRowKey;
    }

    public final int getFoldableRowCount() {
        int n;
        int n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = this.foldableRows.size());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public final Set<String> getFoldableRowKeySet() {
        Set<String> set;
        Set<String> set2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Set<String> set3 = set2 = (set = this.foldableRows.keySet());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, set2);
        return set;
    }

    @Override
    public void addItem(I item, int index) throws IndexOutOfBoundsException {
        I i = item;
        int n = index;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, i, (Object)Conversions.intObject((int)n));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        super.addItem(item, index);
        this.foldableRows.computeIfAbsent(this.calcFoldableRowKey.apply(item), key -> this.buildRow((String)key, this.columnSize)).addItem(item, index);
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    @Override
    public void updateTotalValue(I item) {
        I i = item;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, i);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        super.updateTotalValue(item);
        this.foldableRows.computeIfAbsent(this.calcFoldableRowKey.apply(item), key -> this.buildRow((String)key, this.columnSize)).updateTotalValue(item);
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    @Override
    public void setDisplayName(Map<String, String> displayMap) {
        Map<String, String> map = displayMap;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        super.setDisplayName(displayMap);
        this.foldableRows.values().forEach(row -> row.setDisplayName(displayMap));
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public Row<I> getFoldableRow(String key) {
        Row<I> row;
        Row<I> row2;
        String string = key;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Row<I> row3 = row2 = (row = this.foldableRows.get(key));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, row2);
        return row;
    }

    public Map<String, Row<I>> getFoldableRows() {
        Map<String, Row<I>> map;
        Map<String, Row<I>> map2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<String, Row<I>> map3 = map2 = (map = this.foldableRows);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    protected abstract Row<I> buildRow(String var1, int var2);

    public String toString() {
        return String.format("FoldableRow [detailRows= %s, columnSize= %d]", this.foldableRows, this.columnSize);
    }

    static {
        FoldableRow.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FoldableRow.java", FoldableRow.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getFoldableRowCount", "pro.taskana.monitor.api.reports.row.FoldableRow", "", "", "", "int"), 30);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getFoldableRowKeySet", "pro.taskana.monitor.api.reports.row.FoldableRow", "", "", "", "java.util.Set"), 34);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addItem", "pro.taskana.monitor.api.reports.row.FoldableRow", "pro.taskana.monitor.api.reports.item.QueryItem:int", "item:index", "java.lang.IndexOutOfBoundsException", "void"), 39);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTotalValue", "pro.taskana.monitor.api.reports.row.FoldableRow", "pro.taskana.monitor.api.reports.item.QueryItem", "item", "", "void"), 47);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDisplayName", "pro.taskana.monitor.api.reports.row.FoldableRow", "java.util.Map", "displayMap", "", "void"), 55);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFoldableRow", "pro.taskana.monitor.api.reports.row.FoldableRow", "java.lang.String", "key", "", "pro.taskana.monitor.api.reports.row.Row"), 60);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFoldableRows", "pro.taskana.monitor.api.reports.row.FoldableRow", "", "", "", "java.util.Map"), 64);
    }
}

