/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.api;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.classification.api.exceptions.ClassificationNotFoundException;
import pro.taskana.common.api.BulkOperationResults;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.task.api.CallbackState;
import pro.taskana.task.api.TaskCommentQuery;
import pro.taskana.task.api.TaskCustomField;
import pro.taskana.task.api.TaskQuery;
import pro.taskana.task.api.exceptions.AttachmentPersistenceException;
import pro.taskana.task.api.exceptions.InvalidCallbackStateException;
import pro.taskana.task.api.exceptions.InvalidOwnerException;
import pro.taskana.task.api.exceptions.InvalidTaskStateException;
import pro.taskana.task.api.exceptions.NotAuthorizedOnTaskCommentException;
import pro.taskana.task.api.exceptions.ObjectReferencePersistenceException;
import pro.taskana.task.api.exceptions.TaskAlreadyExistException;
import pro.taskana.task.api.exceptions.TaskCommentNotFoundException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.task.api.models.Attachment;
import pro.taskana.task.api.models.ObjectReference;
import pro.taskana.task.api.models.Task;
import pro.taskana.task.api.models.TaskComment;
import pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;

public interface TaskService {
    public static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    public static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    public static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    public static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public Task newTask();

    public Task newTask(String var1);

    public Task newTask(String var1, String var2);

    public Task createTask(Task var1) throws WorkbasketNotFoundException, ClassificationNotFoundException, TaskAlreadyExistException, InvalidArgumentException, AttachmentPersistenceException, ObjectReferencePersistenceException, NotAuthorizedOnWorkbasketException;

    public Task getTask(String var1) throws TaskNotFoundException, NotAuthorizedOnWorkbasketException;

    public Task claim(String var1) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    public Task forceClaim(String var1) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    public Optional<Task> selectAndClaim(TaskQuery var1) throws InvalidOwnerException, NotAuthorizedOnWorkbasketException;

    public Task cancelClaim(String var1) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    public Task forceCancelClaim(String var1) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    public Task requestReview(String var1) throws InvalidTaskStateException, TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException;

    public Task forceRequestReview(String var1) throws InvalidTaskStateException, TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException;

    public Task requestChanges(String var1) throws InvalidTaskStateException, TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException;

    public Task forceRequestChanges(String var1) throws InvalidTaskStateException, TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException;

    public Task completeTask(String var1) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    public Task forceCompleteTask(String var1) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    public BulkOperationResults<String, TaskanaException> completeTasks(List<String> var1) throws InvalidArgumentException;

    public BulkOperationResults<String, TaskanaException> forceCompleteTasks(List<String> var1) throws InvalidArgumentException;

    public Task cancelTask(String var1) throws TaskNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    public Task terminateTask(String var1) throws TaskNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    default public Task transfer(String taskId, String destinationWorkbasketId) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        String string2 = destinationWorkbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)string2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.transfer(taskId, destinationWorkbasketId, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    public Task transfer(String var1, String var2, boolean var3) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    default public Task transfer(String taskId, String workbasketKey, String domain) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        String string2 = workbasketKey;
        String string3 = domain;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.transfer(taskId, workbasketKey, domain, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    public Task transfer(String var1, String var2, String var3, boolean var4) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    default public BulkOperationResults<String, TaskanaException> transferTasks(String destinationWorkbasketId, List<String> taskIds) throws InvalidArgumentException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        BulkOperationResults<String, TaskanaException> bulkOperationResults;
        BulkOperationResults<String, TaskanaException> bulkOperationResults2;
        String string = destinationWorkbasketId;
        List<String> list = taskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults<String, TaskanaException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.transferTasks(destinationWorkbasketId, taskIds, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    public BulkOperationResults<String, TaskanaException> transferTasks(String var1, List<String> var2, boolean var3) throws InvalidArgumentException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException;

    default public BulkOperationResults<String, TaskanaException> transferTasks(String destinationWorkbasketKey, String destinationWorkbasketDomain, List<String> taskIds) throws InvalidArgumentException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        BulkOperationResults<String, TaskanaException> bulkOperationResults;
        BulkOperationResults<String, TaskanaException> bulkOperationResults2;
        String string = destinationWorkbasketKey;
        String string2 = destinationWorkbasketDomain;
        List<String> list = taskIds;
        Object[] objectArray = new Object[]{string, string2, list};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults<String, TaskanaException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.transferTasks(destinationWorkbasketKey, destinationWorkbasketDomain, taskIds, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    public BulkOperationResults<String, TaskanaException> transferTasks(String var1, String var2, List<String> var3, boolean var4) throws InvalidArgumentException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException;

    public Task updateTask(Task var1) throws InvalidArgumentException, TaskNotFoundException, ConcurrencyException, ClassificationNotFoundException, AttachmentPersistenceException, ObjectReferencePersistenceException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    public List<String> updateTasks(ObjectReference var1, Map<TaskCustomField, String> var2) throws InvalidArgumentException;

    public List<String> updateTasks(List<String> var1, Map<TaskCustomField, String> var2) throws InvalidArgumentException;

    public Task setTaskRead(String var1, boolean var2) throws TaskNotFoundException, NotAuthorizedOnWorkbasketException;

    public BulkOperationResults<String, TaskanaException> setCallbackStateForTasks(List<String> var1, CallbackState var2);

    public BulkOperationResults<String, TaskanaException> setOwnerOfTasks(String var1, List<String> var2);

    public BulkOperationResults<String, TaskanaException> setPlannedPropertyOfTasks(Instant var1, List<String> var2);

    public void deleteTask(String var1) throws TaskNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException, InvalidCallbackStateException;

    public void forceDeleteTask(String var1) throws TaskNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException, InvalidCallbackStateException;

    public BulkOperationResults<String, TaskanaException> deleteTasks(List<String> var1) throws InvalidArgumentException, NotAuthorizedException;

    public TaskComment newTaskComment(String var1);

    public TaskComment createTaskComment(TaskComment var1) throws TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnWorkbasketException;

    public TaskComment getTaskComment(String var1) throws TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnWorkbasketException;

    public List<TaskComment> getTaskComments(String var1) throws TaskNotFoundException, NotAuthorizedOnWorkbasketException;

    public TaskComment updateTaskComment(TaskComment var1) throws ConcurrencyException, TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnTaskCommentException, NotAuthorizedOnWorkbasketException;

    public void deleteTaskComment(String var1) throws TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnTaskCommentException, NotAuthorizedOnWorkbasketException;

    public Attachment newAttachment();

    public ObjectReference newObjectReference();

    public ObjectReference newObjectReference(String var1, String var2, String var3, String var4, String var5);

    public TaskQuery createTaskQuery();

    public TaskCommentQuery createTaskCommentQuery();

    static {
        Factory factory = new Factory("TaskService.java", TaskService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transfer", "pro.taskana.task.api.TaskService", "java.lang.String:java.lang.String", "taskId:destinationWorkbasketId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:pro.taskana.task.api.exceptions.InvalidTaskStateException", "pro.taskana.task.api.models.Task"), 443);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transfer", "pro.taskana.task.api.TaskService", "java.lang.String:java.lang.String:java.lang.String", "taskId:workbasketKey:domain", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:pro.taskana.task.api.exceptions.InvalidTaskStateException", "pro.taskana.task.api.models.Task"), 485);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transferTasks", "pro.taskana.task.api.TaskService", "java.lang.String:java.util.List", "destinationWorkbasketId:taskIds", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "pro.taskana.common.api.BulkOperationResults"), 529);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transferTasks", "pro.taskana.task.api.TaskService", "java.lang.String:java.lang.String:java.util.List", "destinationWorkbasketKey:destinationWorkbasketDomain:taskIds", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "pro.taskana.common.api.BulkOperationResults"), 570);
    }
}

