/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.exceptions.PersistenceException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.classification.api.exceptions.ClassificationNotFoundException;
import pro.taskana.classification.api.models.Classification;
import pro.taskana.classification.api.models.ClassificationSummary;
import pro.taskana.common.api.BulkOperationResults;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.CheckedConsumer;
import pro.taskana.common.internal.util.CheckedFunction;
import pro.taskana.common.internal.util.CollectionUtil;
import pro.taskana.common.internal.util.EnumUtil;
import pro.taskana.common.internal.util.IdGenerator;
import pro.taskana.common.internal.util.ObjectAttributeChangeDetector;
import pro.taskana.common.internal.util.Pair;
import pro.taskana.spi.history.api.events.task.TaskCancelledEvent;
import pro.taskana.spi.history.api.events.task.TaskClaimCancelledEvent;
import pro.taskana.spi.history.api.events.task.TaskClaimedEvent;
import pro.taskana.spi.history.api.events.task.TaskCompletedEvent;
import pro.taskana.spi.history.api.events.task.TaskCreatedEvent;
import pro.taskana.spi.history.api.events.task.TaskRequestChangesEvent;
import pro.taskana.spi.history.api.events.task.TaskRequestReviewEvent;
import pro.taskana.spi.history.api.events.task.TaskTerminatedEvent;
import pro.taskana.spi.history.api.events.task.TaskUpdatedEvent;
import pro.taskana.spi.history.internal.HistoryEventManager;
import pro.taskana.spi.priority.internal.PriorityServiceManager;
import pro.taskana.spi.task.internal.AfterRequestChangesManager;
import pro.taskana.spi.task.internal.AfterRequestReviewManager;
import pro.taskana.spi.task.internal.BeforeRequestChangesManager;
import pro.taskana.spi.task.internal.BeforeRequestReviewManager;
import pro.taskana.spi.task.internal.CreateTaskPreprocessorManager;
import pro.taskana.spi.task.internal.ReviewRequiredManager;
import pro.taskana.task.api.CallbackState;
import pro.taskana.task.api.TaskCommentQuery;
import pro.taskana.task.api.TaskCustomField;
import pro.taskana.task.api.TaskQuery;
import pro.taskana.task.api.TaskService;
import pro.taskana.task.api.TaskState;
import pro.taskana.task.api.exceptions.AttachmentPersistenceException;
import pro.taskana.task.api.exceptions.InvalidCallbackStateException;
import pro.taskana.task.api.exceptions.InvalidOwnerException;
import pro.taskana.task.api.exceptions.InvalidTaskStateException;
import pro.taskana.task.api.exceptions.NotAuthorizedOnTaskCommentException;
import pro.taskana.task.api.exceptions.ObjectReferencePersistenceException;
import pro.taskana.task.api.exceptions.TaskAlreadyExistException;
import pro.taskana.task.api.exceptions.TaskCommentNotFoundException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.task.api.models.Attachment;
import pro.taskana.task.api.models.AttachmentSummary;
import pro.taskana.task.api.models.ObjectReference;
import pro.taskana.task.api.models.Task;
import pro.taskana.task.api.models.TaskComment;
import pro.taskana.task.api.models.TaskSummary;
import pro.taskana.task.internal.AttachmentHandler;
import pro.taskana.task.internal.AttachmentMapper;
import pro.taskana.task.internal.ObjectReferenceHandler;
import pro.taskana.task.internal.ObjectReferenceMapper;
import pro.taskana.task.internal.ServiceLevelHandler;
import pro.taskana.task.internal.TaskCommentMapper;
import pro.taskana.task.internal.TaskCommentQueryImpl;
import pro.taskana.task.internal.TaskCommentServiceImpl;
import pro.taskana.task.internal.TaskCustomPropertySelector;
import pro.taskana.task.internal.TaskMapper;
import pro.taskana.task.internal.TaskQueryImpl;
import pro.taskana.task.internal.TaskTransferrer;
import pro.taskana.task.internal.models.AttachmentImpl;
import pro.taskana.task.internal.models.AttachmentSummaryImpl;
import pro.taskana.task.internal.models.MinimalTaskSummary;
import pro.taskana.task.internal.models.ObjectReferenceImpl;
import pro.taskana.task.internal.models.TaskImpl;
import pro.taskana.task.internal.models.TaskSummaryImpl;
import pro.taskana.user.internal.UserMapper;
import pro.taskana.user.internal.models.UserImpl;
import pro.taskana.workbasket.api.WorkbasketPermission;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;
import pro.taskana.workbasket.api.models.Workbasket;
import pro.taskana.workbasket.api.models.WorkbasketSummary;
import pro.taskana.workbasket.internal.WorkbasketQueryImpl;
import pro.taskana.workbasket.internal.models.WorkbasketSummaryImpl;

public class TaskServiceImpl
implements TaskService {
    private static final Logger LOGGER;
    private final InternalTaskanaEngine taskanaEngine;
    private final WorkbasketService workbasketService;
    private final ClassificationService classificationService;
    private final TaskMapper taskMapper;
    private final TaskTransferrer taskTransferrer;
    private final TaskCommentServiceImpl taskCommentService;
    private final ServiceLevelHandler serviceLevelHandler;
    private final AttachmentHandler attachmentHandler;
    private final AttachmentMapper attachmentMapper;
    private final ObjectReferenceMapper objectReferenceMapper;
    private final ObjectReferenceHandler objectReferenceHandler;
    private final UserMapper userMapper;
    private final HistoryEventManager historyEventManager;
    private final CreateTaskPreprocessorManager createTaskPreprocessorManager;
    private final PriorityServiceManager priorityServiceManager;
    private final ReviewRequiredManager reviewRequiredManager;
    private final BeforeRequestReviewManager beforeRequestReviewManager;
    private final AfterRequestReviewManager afterRequestReviewManager;
    private final BeforeRequestChangesManager beforeRequestChangesManager;
    private final AfterRequestChangesManager afterRequestChangesManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_53;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_54;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_55;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_56;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_57;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_58;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_59;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_60;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_61;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_62;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_63;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_64;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_65;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_66;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_67;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_68;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_69;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_70;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_71;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_72;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_73;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_74;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_75;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_76;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_77;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_78;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_79;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_80;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_81;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_82;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_83;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_84;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_85;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_86;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_87;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_88;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_89;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_90;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_91;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_92;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_93;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_94;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_95;

    static {
        TaskServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TaskServiceImpl.class);
    }

    public TaskServiceImpl(InternalTaskanaEngine taskanaEngine, TaskMapper taskMapper, TaskCommentMapper taskCommentMapper, AttachmentMapper attachmentMapper, ObjectReferenceMapper objectReferenceMapper, UserMapper userMapper) {
        this.taskanaEngine = taskanaEngine;
        this.taskMapper = taskMapper;
        this.workbasketService = taskanaEngine.getEngine().getWorkbasketService();
        this.attachmentMapper = attachmentMapper;
        this.objectReferenceMapper = objectReferenceMapper;
        this.userMapper = userMapper;
        this.classificationService = taskanaEngine.getEngine().getClassificationService();
        this.historyEventManager = taskanaEngine.getHistoryEventManager();
        this.createTaskPreprocessorManager = taskanaEngine.getCreateTaskPreprocessorManager();
        this.priorityServiceManager = taskanaEngine.getPriorityServiceManager();
        this.reviewRequiredManager = taskanaEngine.getReviewRequiredManager();
        this.beforeRequestReviewManager = taskanaEngine.getBeforeRequestReviewManager();
        this.afterRequestReviewManager = taskanaEngine.getAfterRequestReviewManager();
        this.beforeRequestChangesManager = taskanaEngine.getBeforeRequestChangesManager();
        this.afterRequestChangesManager = taskanaEngine.getAfterRequestChangesManager();
        this.taskTransferrer = new TaskTransferrer(taskanaEngine, taskMapper, this);
        this.taskCommentService = new TaskCommentServiceImpl(taskanaEngine, taskCommentMapper, userMapper, this);
        this.serviceLevelHandler = new ServiceLevelHandler(taskanaEngine, taskMapper, attachmentMapper, this);
        this.attachmentHandler = new AttachmentHandler(attachmentMapper, this.classificationService);
        this.objectReferenceHandler = new ObjectReferenceHandler(objectReferenceMapper);
    }

    @Override
    public Task claim(String taskId) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.claim(taskId, false));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task forceClaim(String taskId) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.claim(taskId, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task cancelClaim(String taskId) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.cancelClaim(taskId, false));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task forceCancelClaim(String taskId) throws TaskNotFoundException, InvalidTaskStateException, NotAuthorizedOnWorkbasketException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            task2 = this.cancelClaim(taskId, true);
        }
        catch (InvalidOwnerException e) {
            throw new SystemException("this should not have happened. You've discovered a new bug!", (Throwable)((Object)e));
        }
        Task task3 = task = task2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task);
        return task2;
    }

    @Override
    public Task requestReview(String taskId) throws InvalidTaskStateException, TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.requestReview(taskId, false));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task forceRequestReview(String taskId) throws InvalidTaskStateException, TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.requestReview(taskId, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task requestChanges(String taskId) throws InvalidTaskStateException, TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.requestChanges(taskId, false));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task forceRequestChanges(String taskId) throws InvalidTaskStateException, TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.requestChanges(taskId, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task completeTask(String taskId) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.completeTask(taskId, false));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task forceCompleteTask(String taskId) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.completeTask(taskId, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task createTask(Task taskToCreate) throws WorkbasketNotFoundException, ClassificationNotFoundException, TaskAlreadyExistException, InvalidArgumentException, AttachmentPersistenceException, ObjectReferencePersistenceException, NotAuthorizedOnWorkbasketException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        Task task = taskToCreate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)task);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (this.createTaskPreprocessorManager.isEnabled()) {
            taskToCreate = this.createTaskPreprocessorManager.processTaskBeforeCreation(taskToCreate);
        }
        TaskImpl task2 = (TaskImpl)taskToCreate;
        try {
            String classificationKey;
            Workbasket workbasket;
            this.taskanaEngine.openConnection();
            if (task2.getId() != null && !task2.getId().isEmpty()) {
                throw new InvalidArgumentException("taskId must be empty when creating a task");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Task {} cannot be found, so it can be created.", (Object)task2.getId());
            }
            if (task2.getWorkbasketSummary() != null && task2.getWorkbasketSummary().getId() != null) {
                workbasket = this.workbasketService.getWorkbasket(task2.getWorkbasketSummary().getId());
            } else if (task2.getWorkbasketKey() != null) {
                workbasket = this.workbasketService.getWorkbasket(task2.getWorkbasketKey(), task2.getDomain());
            } else {
                String workbasketId = this.taskanaEngine.getTaskRoutingManager().determineWorkbasketId(task2);
                if (workbasketId != null) {
                    workbasket = this.workbasketService.getWorkbasket(workbasketId);
                } else {
                    throw new InvalidArgumentException("Cannot create a Task outside a Workbasket");
                }
            }
            if (workbasket.isMarkedForDeletion()) {
                throw new WorkbasketNotFoundException(workbasket.getId());
            }
            task2.setWorkbasketSummary(workbasket.asSummary());
            task2.setDomain(workbasket.getDomain());
            if (!this.taskanaEngine.getEngine().isUserInRole(TaskanaRole.TASK_ROUTER)) {
                this.workbasketService.checkAuthorization(task2.getWorkbasketSummary().getId(), WorkbasketPermission.APPEND);
            }
            if ((classificationKey = task2.getClassificationKey()) == null || classificationKey.length() == 0) {
                throw new InvalidArgumentException("classificationKey of task must not be empty");
            }
            Classification classification = this.classificationService.getClassification(classificationKey, workbasket.getDomain());
            task2.setClassificationSummary(classification.asSummary());
            ObjectReferenceImpl.validate(task2.getPrimaryObjRef(), "primary ObjectReference", "Task");
            this.standardSettingsOnTaskCreation(task2, classification);
            this.setCallbackStateOnTaskCreation(task2);
            this.priorityServiceManager.calculatePriorityOfTask(task2).ifPresent(task2::setPriority);
            try {
                this.taskMapper.insert(task2);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Method createTask() created Task '{}'.", (Object)task2.getId());
                }
                if (this.historyEventManager.isEnabled()) {
                    String details = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)this.newTask(), (Object)task2);
                    this.historyEventManager.createEvent(new TaskCreatedEvent(IdGenerator.generateWithPrefix((String)"THI"), task2, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid(), details));
                }
            }
            catch (PersistenceException e) {
                String msg;
                String string = msg = e.getMessage() != null ? e.getMessage().toLowerCase() : null;
                if (msg != null && (msg.contains("violation") || msg.contains("violates") || msg.contains("violated") || msg.contains("verletzt")) && msg.contains("external_id")) {
                    throw new TaskAlreadyExistException(task2.getExternalId());
                }
                throw e;
            }
            TaskImpl taskImpl3 = task2;
            taskImpl2 = taskImpl3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        TaskImpl taskImpl4 = taskImpl = taskImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl);
        return taskImpl2;
    }

    @Override
    public Task getTask(String id) throws NotAuthorizedOnWorkbasketException, TaskNotFoundException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        JoinPoint joinPoint;
        block10: {
            String string = id;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            try {
                this.taskanaEngine.openConnection();
                TaskImpl resultTask = this.taskMapper.findById(id);
                if (resultTask != null) {
                    UserImpl owner;
                    List<ObjectReferenceImpl> secondaryObjectReferences;
                    WorkbasketQueryImpl query = (WorkbasketQueryImpl)this.workbasketService.createWorkbasketQuery();
                    query.setUsedToAugmentTasks(true);
                    String workbasketId = resultTask.getWorkbasketSummary().getId();
                    List workbaskets = query.idIn(workbasketId).list();
                    if (workbaskets.isEmpty()) {
                        throw new NotAuthorizedOnWorkbasketException(this.taskanaEngine.getEngine().getCurrentUserContext().getUserid(), workbasketId, WorkbasketPermission.READ);
                    }
                    resultTask.setWorkbasketSummary((WorkbasketSummary)workbaskets.get(0));
                    List<AttachmentImpl> attachmentImpls = this.attachmentMapper.findAttachmentsByTaskId(resultTask.getId());
                    if (attachmentImpls == null) {
                        attachmentImpls = new ArrayList<AttachmentImpl>();
                    }
                    if ((secondaryObjectReferences = this.objectReferenceMapper.findObjectReferencesByTaskId(resultTask.getId())) == null) {
                        secondaryObjectReferences = new ArrayList<ObjectReferenceImpl>();
                    }
                    Map<String, ClassificationSummary> classificationSummariesById = this.findClassificationForTaskImplAndAttachments(resultTask, attachmentImpls);
                    this.addClassificationSummariesToAttachments(attachmentImpls, classificationSummariesById);
                    resultTask.setAttachments(new ArrayList<Attachment>(attachmentImpls));
                    resultTask.setSecondaryObjectReferences(new ArrayList<ObjectReference>(secondaryObjectReferences));
                    String classificationId = resultTask.getClassificationSummary().getId();
                    ClassificationSummary classification = classificationSummariesById.get(classificationId);
                    if (classification == null) {
                        throw new SystemException("Could not find a Classification for task " + resultTask.getId());
                    }
                    resultTask.setClassificationSummary(classification);
                    if (resultTask.getOwner() != null && !resultTask.getOwner().isEmpty() && this.taskanaEngine.getEngine().getConfiguration().isAddAdditionalUserInfo() && (owner = this.userMapper.findById(resultTask.getOwner())) != null) {
                        resultTask.setOwnerLongName(owner.getLongName());
                    }
                    TaskImpl taskImpl3 = resultTask;
                    taskImpl2 = taskImpl3;
                    break block10;
                }
                throw new TaskNotFoundException(id);
            }
            finally {
                this.taskanaEngine.returnConnection();
            }
        }
        TaskImpl taskImpl4 = taskImpl = taskImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl);
        return taskImpl2;
    }

    @Override
    public Task transfer(String taskId, String destinationWorkbasketId, boolean setTransferFlag) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        String string2 = destinationWorkbasketId;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, string2, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.taskTransferrer.transfer(taskId, destinationWorkbasketId, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task transfer(String taskId, String workbasketKey, String domain, boolean setTransferFlag) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        String string2 = workbasketKey;
        String string3 = domain;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, string2, string3, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.taskTransferrer.transfer(taskId, workbasketKey, domain, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task setTaskRead(String taskId, boolean isRead) throws TaskNotFoundException, NotAuthorizedOnWorkbasketException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        String string = taskId;
        boolean bl = isRead;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            this.taskanaEngine.openConnection();
            TaskImpl task = (TaskImpl)this.getTask(taskId);
            task.setRead(isRead);
            task.setModified(Instant.now());
            this.taskMapper.update(task);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Method setTaskRead() set read property of Task '{}' to {} ", (Object)task, (Object)isRead);
            }
            TaskImpl taskImpl3 = task;
            taskImpl2 = taskImpl3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        TaskImpl taskImpl4 = taskImpl = taskImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl);
        return taskImpl2;
    }

    @Override
    public TaskQuery createTaskQuery() {
        TaskQueryImpl taskQueryImpl;
        TaskQueryImpl taskQueryImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskQueryImpl taskQueryImpl3 = taskQueryImpl2 = (taskQueryImpl = new TaskQueryImpl(this.taskanaEngine));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskQueryImpl2);
        return taskQueryImpl;
    }

    @Override
    public TaskCommentQuery createTaskCommentQuery() {
        TaskCommentQueryImpl taskCommentQueryImpl;
        TaskCommentQueryImpl taskCommentQueryImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskCommentQueryImpl taskCommentQueryImpl3 = taskCommentQueryImpl2 = (taskCommentQueryImpl = new TaskCommentQueryImpl(this.taskanaEngine));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQueryImpl2);
        return taskCommentQueryImpl;
    }

    @Override
    public Task newTask() {
        Task task;
        Task task2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.newTask(null));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task newTask(String workbasketId) {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        String string = workbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskImpl task = new TaskImpl();
        WorkbasketSummaryImpl wb = new WorkbasketSummaryImpl();
        wb.setId(workbasketId);
        task.setWorkbasketSummary(wb);
        task.setCallbackState(CallbackState.NONE);
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = task);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    @Override
    public Task newTask(String workbasketKey, String domain) {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        String string = workbasketKey;
        String string2 = domain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)string, (Object)string2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskImpl task = new TaskImpl();
        WorkbasketSummaryImpl wb = new WorkbasketSummaryImpl();
        wb.setKey(workbasketKey);
        wb.setDomain(domain);
        task.setWorkbasketSummary(wb);
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = task);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    @Override
    public TaskComment newTaskComment(String taskId) {
        TaskComment taskComment;
        TaskComment taskComment2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskComment taskComment3 = taskComment2 = (taskComment = this.taskCommentService.newTaskComment(taskId));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskComment2);
        return taskComment;
    }

    @Override
    public Attachment newAttachment() {
        AttachmentImpl attachmentImpl;
        AttachmentImpl attachmentImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        AttachmentImpl attachmentImpl3 = attachmentImpl2 = (attachmentImpl = new AttachmentImpl());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)attachmentImpl2);
        return attachmentImpl;
    }

    @Override
    public ObjectReference newObjectReference() {
        ObjectReferenceImpl objectReferenceImpl;
        ObjectReferenceImpl objectReferenceImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ObjectReferenceImpl objectReferenceImpl3 = objectReferenceImpl2 = (objectReferenceImpl = new ObjectReferenceImpl());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)objectReferenceImpl2);
        return objectReferenceImpl;
    }

    @Override
    public ObjectReference newObjectReference(String company, String system, String systemInstance, String type, String value) {
        ObjectReferenceImpl objectReferenceImpl;
        ObjectReferenceImpl objectReferenceImpl2;
        String string = company;
        String string2 = system;
        String string3 = systemInstance;
        String string4 = type;
        String string5 = value;
        Object[] objectArray = new Object[]{string, string2, string3, string4, string5};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ObjectReferenceImpl objectReferenceImpl3 = objectReferenceImpl2 = (objectReferenceImpl = new ObjectReferenceImpl(company, system, systemInstance, type, value));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)objectReferenceImpl2);
        return objectReferenceImpl;
    }

    @Override
    public Task updateTask(Task task) throws InvalidArgumentException, TaskNotFoundException, ConcurrencyException, AttachmentPersistenceException, ObjectReferencePersistenceException, ClassificationNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task2;
        Task task3;
        Task task4 = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)task4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
        TaskImpl newTaskImpl = (TaskImpl)task;
        try {
            this.taskanaEngine.openConnection();
            TaskImpl oldTaskImpl = (TaskImpl)this.getTask(newTaskImpl.getId());
            this.checkConcurrencyAndSetModified(newTaskImpl, oldTaskImpl);
            this.attachmentHandler.insertAndDeleteAttachmentsOnTaskUpdate(newTaskImpl, oldTaskImpl);
            this.objectReferenceHandler.insertAndDeleteObjectReferencesOnTaskUpdate(newTaskImpl, oldTaskImpl);
            ObjectReferenceImpl.validate(newTaskImpl.getPrimaryObjRef(), "primary ObjectReference", "Task");
            this.standardUpdateActions(oldTaskImpl, newTaskImpl);
            this.priorityServiceManager.calculatePriorityOfTask(newTaskImpl).ifPresent(newTaskImpl::setPriority);
            this.taskMapper.update(newTaskImpl);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Method updateTask() updated task '{}' for user '{}'.", (Object)task.getId(), (Object)userId);
            }
            if (this.historyEventManager.isEnabled()) {
                String changeDetails = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)oldTaskImpl, (Object)newTaskImpl);
                this.historyEventManager.createEvent(new TaskUpdatedEvent(IdGenerator.generateWithPrefix((String)"THI"), task, userId, changeDetails));
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        Task task5 = task3 = (task2 = task);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task3);
        return task2;
    }

    @Override
    public BulkOperationResults<String, TaskanaException> transferTasks(String destinationWorkbasketId, List<String> taskIds, boolean setTransferFlag) throws InvalidArgumentException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        BulkOperationResults<String, TaskanaException> bulkOperationResults;
        BulkOperationResults<String, TaskanaException> bulkOperationResults2;
        String string = destinationWorkbasketId;
        List<String> list = taskIds;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, list, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults<String, TaskanaException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.taskTransferrer.transfer(taskIds, destinationWorkbasketId, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    @Override
    public BulkOperationResults<String, TaskanaException> transferTasks(String destinationWorkbasketKey, String destinationWorkbasketDomain, List<String> taskIds, boolean setTransferFlag) throws InvalidArgumentException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        BulkOperationResults<String, TaskanaException> bulkOperationResults;
        BulkOperationResults<String, TaskanaException> bulkOperationResults2;
        String string = destinationWorkbasketKey;
        String string2 = destinationWorkbasketDomain;
        List<String> list = taskIds;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, string2, list, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults<String, TaskanaException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.taskTransferrer.transfer(taskIds, destinationWorkbasketKey, destinationWorkbasketDomain, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    @Override
    public void deleteTask(String taskId) throws TaskNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException, InvalidCallbackStateException {
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.deleteTask(taskId, false);
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    @Override
    public void forceDeleteTask(String taskId) throws TaskNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException, InvalidCallbackStateException {
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.deleteTask(taskId, true);
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    @Override
    public Optional<Task> selectAndClaim(TaskQuery taskQuery) {
        Optional optional;
        Optional optional2;
        TaskQuery taskQuery2 = taskQuery;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object)taskQuery2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ((TaskQueryImpl)taskQuery).selectAndClaimEquals(true);
        Optional optional3 = optional2 = (optional = this.taskanaEngine.executeInDatabaseConnection(() -> Optional.ofNullable((TaskSummary)taskQuery.single()).map(TaskSummary::getId).map(CheckedFunction.wrap(this::claim))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)optional2);
        return optional;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BulkOperationResults<String, TaskanaException> deleteTasks(List<String> taskIds) throws InvalidArgumentException, NotAuthorizedException {
        BulkOperationResults bulkOperationResults;
        BulkOperationResults bulkOperationResults2;
        BulkOperationResults bulkOperationResults3;
        JoinPoint joinPoint;
        block9: {
            List<String> list = taskIds;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this, list);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.ADMIN);
            this.taskanaEngine.openConnection();
            if (taskIds == null) {
                throw new InvalidArgumentException("List of TaskIds must not be null.");
            }
            taskIds = new ArrayList<String>(taskIds);
            BulkOperationResults bulkLog = new BulkOperationResults();
            if (taskIds.isEmpty()) {
                BulkOperationResults bulkOperationResults4 = bulkLog;
                bulkOperationResults2 = bulkOperationResults3 = bulkOperationResults4;
                break block9;
            }
            List<MinimalTaskSummary> taskSummaries = this.taskMapper.findExistingTasks(taskIds, null);
            Iterator<String> taskIdIterator = taskIds.iterator();
            while (taskIdIterator.hasNext()) {
                this.removeSingleTaskForTaskDeletionById((BulkOperationResults<String, TaskanaException>)bulkLog, taskSummaries, taskIdIterator);
            }
            if (!taskIds.isEmpty()) {
                this.attachmentMapper.deleteMultipleByTaskIds(taskIds);
                this.objectReferenceMapper.deleteMultipleByTaskIds(taskIds);
                this.taskMapper.deleteMultiple(taskIds);
                if (this.taskanaEngine.getEngine().isHistoryEnabled() && this.taskanaEngine.getEngine().getConfiguration().isDeleteHistoryEventsOnTaskDeletionEnabled()) {
                    this.historyEventManager.deleteEvents(taskIds);
                }
            }
            BulkOperationResults bulkOperationResults5 = bulkLog;
            bulkOperationResults2 = bulkOperationResults3 = bulkOperationResults5;
            break block9;
            finally {
                this.taskanaEngine.returnConnection();
            }
        }
        BulkOperationResults bulkOperationResults6 = bulkOperationResults = bulkOperationResults2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkOperationResults);
        return bulkOperationResults3;
    }

    @Override
    public BulkOperationResults<String, TaskanaException> completeTasks(List<String> taskIds) throws InvalidArgumentException {
        BulkOperationResults<String, TaskanaException> bulkOperationResults;
        BulkOperationResults<String, TaskanaException> bulkOperationResults2;
        List<String> list = taskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults<String, TaskanaException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.completeTasks(taskIds, false));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    @Override
    public BulkOperationResults<String, TaskanaException> forceCompleteTasks(List<String> taskIds) throws InvalidArgumentException {
        BulkOperationResults<String, TaskanaException> bulkOperationResults;
        BulkOperationResults<String, TaskanaException> bulkOperationResults2;
        List<String> list = taskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults<String, TaskanaException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.completeTasks(taskIds, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    @Override
    public List<String> updateTasks(ObjectReference selectionCriteria, Map<TaskCustomField, String> customFieldsToUpdate) throws InvalidArgumentException {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        ObjectReference objectReference = selectionCriteria;
        Map<TaskCustomField, String> map = customFieldsToUpdate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this, (Object)objectReference, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ObjectReferenceImpl.validate(selectionCriteria, "ObjectReference", "updateTasks call");
        this.validateCustomFields(customFieldsToUpdate);
        TaskCustomPropertySelector fieldSelector = new TaskCustomPropertySelector();
        TaskImpl updated = this.initUpdatedTask(customFieldsToUpdate, fieldSelector);
        try {
            this.taskanaEngine.openConnection();
            List<TaskSummary> taskSummaries = this.getTasksToChange(selectionCriteria);
            ArrayList<String> changedTasks = new ArrayList<String>();
            if (!taskSummaries.isEmpty()) {
                changedTasks = taskSummaries.stream().map(TaskSummary::getId).collect(Collectors.toList());
                this.taskMapper.updateTasks(changedTasks, updated, fieldSelector);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("updateTasks() updated the following tasks: {} ", changedTasks);
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("updateTasks() found no tasks for update ");
            }
            ArrayList<String> arrayList3 = changedTasks;
            arrayList2 = arrayList3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        ArrayList<String> arrayList4 = arrayList = arrayList2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList);
        return arrayList2;
    }

    @Override
    public List<String> updateTasks(List<String> taskIds, Map<TaskCustomField, String> customFieldsToUpdate) throws InvalidArgumentException {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        List<String> list = taskIds;
        Map<TaskCustomField, String> map = customFieldsToUpdate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, list, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.validateCustomFields(customFieldsToUpdate);
        TaskCustomPropertySelector fieldSelector = new TaskCustomPropertySelector();
        TaskImpl updatedTask = this.initUpdatedTask(customFieldsToUpdate, fieldSelector);
        try {
            this.taskanaEngine.openConnection();
            List<TaskSummary> taskSummaries = this.getTasksToChange(taskIds);
            ArrayList<String> changedTasks = new ArrayList<String>();
            if (!taskSummaries.isEmpty()) {
                changedTasks = taskSummaries.stream().map(TaskSummary::getId).collect(Collectors.toList());
                this.taskMapper.updateTasks(changedTasks, updatedTask, fieldSelector);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("updateTasks() updated the following tasks: {} ", changedTasks);
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("updateTasks() found no tasks for update ");
            }
            ArrayList<String> arrayList3 = changedTasks;
            arrayList2 = arrayList3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        ArrayList<String> arrayList4 = arrayList = arrayList2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList);
        return arrayList2;
    }

    @Override
    public TaskComment createTaskComment(TaskComment taskComment) throws TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnWorkbasketException {
        TaskComment taskComment2;
        TaskComment taskComment3;
        TaskComment taskComment4 = taskComment;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object)taskComment4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskComment taskComment5 = taskComment3 = (taskComment2 = this.taskCommentService.createTaskComment(taskComment));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskComment3);
        return taskComment2;
    }

    @Override
    public TaskComment updateTaskComment(TaskComment taskComment) throws ConcurrencyException, TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnTaskCommentException, NotAuthorizedOnWorkbasketException {
        TaskComment taskComment2;
        TaskComment taskComment3;
        TaskComment taskComment4 = taskComment;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)taskComment4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskComment taskComment5 = taskComment3 = (taskComment2 = this.taskCommentService.updateTaskComment(taskComment));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskComment3);
        return taskComment2;
    }

    @Override
    public void deleteTaskComment(String taskCommentId) throws TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnTaskCommentException, NotAuthorizedOnWorkbasketException {
        String string = taskCommentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskCommentService.deleteTaskComment(taskCommentId);
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    @Override
    public TaskComment getTaskComment(String taskCommentid) throws TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnWorkbasketException {
        TaskComment taskComment;
        TaskComment taskComment2;
        String string = taskCommentid;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskComment taskComment3 = taskComment2 = (taskComment = this.taskCommentService.getTaskComment(taskCommentid));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskComment2);
        return taskComment;
    }

    @Override
    public List<TaskComment> getTaskComments(String taskId) throws TaskNotFoundException, NotAuthorizedOnWorkbasketException {
        List<TaskComment> list;
        List<TaskComment> list2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<TaskComment> list3 = list2 = (list = this.taskCommentService.getTaskComments(taskId));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BulkOperationResults<String, TaskanaException> setCallbackStateForTasks(List<String> externalIds, CallbackState state) {
        BulkOperationResults bulkOperationResults;
        BulkOperationResults bulkOperationResults2;
        BulkOperationResults bulkOperationResults3;
        JoinPoint joinPoint;
        block7: {
            List<String> list = externalIds;
            CallbackState callbackState = state;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, list, (Object)((Object)callbackState));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.taskanaEngine.openConnection();
            BulkOperationResults bulkLog = new BulkOperationResults();
            if (externalIds == null || externalIds.isEmpty()) {
                BulkOperationResults bulkOperationResults4 = bulkLog;
                bulkOperationResults2 = bulkOperationResults3 = bulkOperationResults4;
                break block7;
            }
            List<MinimalTaskSummary> taskSummaries = this.taskMapper.findExistingTasks(null, externalIds);
            Iterator<String> taskIdIterator = new ArrayList<String>(externalIds).iterator();
            while (taskIdIterator.hasNext()) {
                this.removeSingleTaskForCallbackStateByExternalId((BulkOperationResults<String, TaskanaException>)bulkLog, taskSummaries, taskIdIterator, state);
            }
            if (!externalIds.isEmpty()) {
                this.taskMapper.setCallbackStateMultiple(externalIds, state);
            }
            BulkOperationResults bulkOperationResults5 = bulkLog;
            bulkOperationResults2 = bulkOperationResults3 = bulkOperationResults5;
            break block7;
            finally {
                this.taskanaEngine.returnConnection();
            }
        }
        BulkOperationResults bulkOperationResults6 = bulkOperationResults = bulkOperationResults2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkOperationResults);
        return bulkOperationResults3;
    }

    @Override
    public BulkOperationResults<String, TaskanaException> setOwnerOfTasks(String owner, List<String> taskIds) {
        BulkOperationResults bulkOperationResults;
        BulkOperationResults bulkOperationResults2;
        BulkOperationResults bulkOperationResults3;
        JoinPoint joinPoint;
        block7: {
            String string = owner;
            List<String> list = taskIds;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, (Object)string, list);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            BulkOperationResults bulkLog = new BulkOperationResults();
            if (taskIds == null || taskIds.isEmpty()) {
                bulkOperationResults2 = bulkOperationResults3 = bulkLog;
            } else {
                this.taskanaEngine.openConnection();
                Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> existingAndAuthorizedTasks = this.getMinimalTaskSummaries(taskIds);
                bulkLog.addAllErrors((BulkOperationResults)existingAndAuthorizedTasks.getRight());
                Pair<List<String>, ServiceLevelHandler.BulkLog> taskIdsToUpdate = this.filterOutTasksWhichAreInInvalidState((Collection)existingAndAuthorizedTasks.getLeft());
                bulkLog.addAllErrors((BulkOperationResults)taskIdsToUpdate.getRight());
                if (!((List)taskIdsToUpdate.getLeft()).isEmpty()) {
                    this.taskMapper.setOwnerOfTasks(owner, (List)taskIdsToUpdate.getLeft(), Instant.now());
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Received the Request to set owner on {} tasks, actually modified tasks = {}, could not set owner on {} tasks.", new Object[]{taskIds.size(), ((List)taskIdsToUpdate.getLeft()).size(), bulkLog.getFailedIds().size()});
                }
                BulkOperationResults bulkOperationResults4 = bulkLog;
                bulkOperationResults2 = bulkOperationResults3 = bulkOperationResults4;
            }
            break block7;
            finally {
                this.taskanaEngine.returnConnection();
            }
        }
        BulkOperationResults bulkOperationResults5 = bulkOperationResults = bulkOperationResults2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkOperationResults);
        return bulkOperationResults3;
    }

    @Override
    public BulkOperationResults<String, TaskanaException> setPlannedPropertyOfTasks(Instant planned, List<String> argTaskIds) {
        ServiceLevelHandler.BulkLog bulkLog;
        ServiceLevelHandler.BulkLog bulkLog2;
        ServiceLevelHandler.BulkLog bulkLog3;
        JoinPoint joinPoint;
        block5: {
            Instant instant = planned;
            List<String> list = argTaskIds;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, (Object)instant, list);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            ServiceLevelHandler.BulkLog bulkLog4 = new ServiceLevelHandler.BulkLog();
            if (argTaskIds == null || argTaskIds.isEmpty()) {
                bulkLog2 = bulkLog3 = bulkLog4;
            } else {
                this.taskanaEngine.openConnection();
                Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> resultsPair = this.getMinimalTaskSummaries(argTaskIds);
                List tasksToModify = (List)resultsPair.getLeft();
                bulkLog4.addAllErrors((BulkOperationResults)resultsPair.getRight());
                ServiceLevelHandler.BulkLog errorsFromProcessing = this.serviceLevelHandler.setPlannedPropertyOfTasksImpl(planned, tasksToModify);
                bulkLog4.addAllErrors(errorsFromProcessing);
                ServiceLevelHandler.BulkLog bulkLog5 = bulkLog4;
                bulkLog2 = bulkLog3 = bulkLog5;
            }
            break block5;
            finally {
                this.taskanaEngine.returnConnection();
            }
        }
        ServiceLevelHandler.BulkLog bulkLog6 = bulkLog = bulkLog2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkLog);
        return bulkLog3;
    }

    @Override
    public Task cancelTask(String taskId) throws TaskNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        TaskImpl cancelledTask;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            this.taskanaEngine.openConnection();
            cancelledTask = this.terminateCancelCommonActions(taskId, TaskState.CANCELLED);
            if (this.historyEventManager.isEnabled()) {
                this.historyEventManager.createEvent(new TaskCancelledEvent(IdGenerator.generateWithPrefix((String)"THI"), cancelledTask, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid()));
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = cancelledTask);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    @Override
    public Task terminateTask(String taskId) throws TaskNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        TaskImpl terminatedTask;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.ADMIN, TaskanaRole.TASK_ADMIN);
        try {
            this.taskanaEngine.openConnection();
            terminatedTask = this.terminateCancelCommonActions(taskId, TaskState.TERMINATED);
            if (this.historyEventManager.isEnabled()) {
                this.historyEventManager.createEvent(new TaskTerminatedEvent(IdGenerator.generateWithPrefix((String)"THI"), terminatedTask, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid()));
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = terminatedTask);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    public List<String> findTasksIdsAffectedByClassificationChange(String classificationId) {
        List<String> list;
        List<String> list2;
        String string = classificationId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List tasksAffectedDirectly = this.createTaskQuery().classificationIdIn(classificationId).stateIn(TaskState.READY, TaskState.CLAIMED).list();
        List affectedPairs = tasksAffectedDirectly.stream().map(t -> Pair.of((Object)t.getId(), (Object)t.getPlanned())).collect(Collectors.toList());
        List<Pair<String, Instant>> taskIdsAndPlannedFromAttachments = this.attachmentMapper.findTaskIdsAndPlannedAffectedByClassificationChange(classificationId);
        List<String> taskIdsFromAttachments = taskIdsAndPlannedFromAttachments.stream().map(Pair::getLeft).collect(Collectors.toList());
        List<Object> filteredTaskIdsAndPlannedFromAttachments = taskIdsFromAttachments.isEmpty() ? new ArrayList() : this.taskMapper.filterTaskIdsForReadyAndClaimed(taskIdsFromAttachments);
        affectedPairs.addAll(filteredTaskIdsAndPlannedFromAttachments);
        List<String> affectedTaskIds = affectedPairs.stream().sorted(Comparator.comparing(Pair::getRight)).distinct().map(Pair::getLeft).collect(Collectors.toList());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("the following tasks are affected by the update of classification {} : {}", (Object)classificationId, affectedTaskIds);
        }
        List<String> list3 = list2 = (list = affectedTaskIds);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public void refreshPriorityAndDueDatesOfTasksOnClassificationUpdate(List<String> taskIds, boolean serviceLevelChanged, boolean priorityChanged) {
        List<String> list = taskIds;
        boolean bl = serviceLevelChanged;
        boolean bl2 = priorityChanged;
        Object[] objectArray = new Object[]{list, Conversions.booleanObject((boolean)bl), Conversions.booleanObject((boolean)bl2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> resultsPair = this.getMinimalTaskSummaries(taskIds);
        List tasks = (List)resultsPair.getLeft();
        try {
            this.taskanaEngine.openConnection();
            Set<String> adminAccessIds = this.taskanaEngine.getEngine().getConfiguration().getRoleMap().get(TaskanaRole.ADMIN);
            if (adminAccessIds.contains(this.taskanaEngine.getEngine().getCurrentUserContext().getUserid())) {
                this.serviceLevelHandler.refreshPriorityAndDueDatesOfTasks(tasks, serviceLevelChanged, priorityChanged);
            } else {
                this.taskanaEngine.getEngine().runAsAdmin(() -> this.serviceLevelHandler.refreshPriorityAndDueDatesOfTasks(tasks, serviceLevelChanged, priorityChanged));
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        Object var13_13 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var13_13);
    }

    Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> getMinimalTaskSummaries(Collection<String> argTaskIds) {
        Pair pair;
        Pair pair2;
        Collection<String> collection = argTaskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this, collection);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ServiceLevelHandler.BulkLog bulkLog = new ServiceLevelHandler.BulkLog();
        HashSet<String> taskIds = new HashSet<String>(argTaskIds);
        List<MinimalTaskSummary> minimalTaskSummaries = this.taskMapper.findExistingTasks(taskIds, null);
        bulkLog.addAllErrors(this.addExceptionsForNonExistingTasksToBulkLog(taskIds, minimalTaskSummaries));
        Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> filteredPair = this.filterTasksAuthorizedForAndLogErrorsForNotAuthorized(minimalTaskSummaries);
        bulkLog.addAllErrors((BulkOperationResults)filteredPair.getRight());
        Pair pair3 = pair2 = (pair = Pair.of((Object)((List)filteredPair.getLeft()), (Object)((Object)bulkLog)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)pair2);
        return pair;
    }

    Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> filterTasksAuthorizedForAndLogErrorsForNotAuthorized(List<MinimalTaskSummary> existingTasks) {
        Pair pair;
        Pair pair2;
        Pair pair3;
        List<MinimalTaskSummary> list = existingTasks;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ServiceLevelHandler.BulkLog bulkLog = new ServiceLevelHandler.BulkLog();
        if (this.taskanaEngine.getEngine().isUserInRole(TaskanaRole.ADMIN, TaskanaRole.TASK_ADMIN)) {
            pair2 = pair3 = Pair.of(existingTasks, (Object)((Object)bulkLog));
        } else {
            List accessIds = this.taskanaEngine.getEngine().getCurrentUserContext().getAccessIds();
            List<Pair<String, String>> taskAndWorkbasketIdsNotAuthorizedFor = this.taskMapper.getTaskAndWorkbasketIdsNotAuthorizedFor(existingTasks, accessIds);
            String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
            for (Pair<String, String> taskAndWorkbasketIds : taskAndWorkbasketIdsNotAuthorizedFor) {
                bulkLog.addError((String)taskAndWorkbasketIds.getLeft(), (Exception)((Object)new NotAuthorizedOnWorkbasketException(userId, (String)taskAndWorkbasketIds.getRight(), WorkbasketPermission.READ)));
            }
            Set taskIdsToRemove = taskAndWorkbasketIdsNotAuthorizedFor.stream().map(Pair::getLeft).collect(Collectors.toSet());
            List tasksAuthorizedFor = existingTasks.stream().filter(Predicate.not(t -> taskIdsToRemove.contains(t.getTaskId()))).collect(Collectors.toList());
            pair2 = pair3 = Pair.of(tasksAuthorizedFor, (Object)((Object)bulkLog));
        }
        Pair pair4 = pair = pair2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)pair);
        return pair3;
    }

    ServiceLevelHandler.BulkLog addExceptionsForNonExistingTasksToBulkLog(Collection<String> requestTaskIds, List<MinimalTaskSummary> existingMinimalTaskSummaries) {
        ServiceLevelHandler.BulkLog bulkLog;
        ServiceLevelHandler.BulkLog bulkLog2;
        Collection<String> collection = requestTaskIds;
        List<MinimalTaskSummary> list = existingMinimalTaskSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this, collection, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ServiceLevelHandler.BulkLog bulkLog3 = new ServiceLevelHandler.BulkLog();
        Set existingTaskIds = existingMinimalTaskSummaries.stream().map(MinimalTaskSummary::getTaskId).collect(Collectors.toSet());
        requestTaskIds.stream().filter(Predicate.not(existingTaskIds::contains)).forEach(taskId -> bulkLog3.addError(taskId, (Exception)((Object)new TaskNotFoundException((String)taskId))));
        ServiceLevelHandler.BulkLog bulkLog4 = bulkLog2 = (bulkLog = bulkLog3);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkLog2);
        return bulkLog;
    }

    List<TaskSummary> augmentTaskSummariesByContainedSummariesWithPartitioning(List<TaskSummaryImpl> taskSummaries) {
        List<TaskSummary> list;
        List<TaskSummary> list2;
        List<TaskSummaryImpl> list3 = taskSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this, list3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<TaskSummary> list4 = list2 = (list = CollectionUtil.partitionBasedOnSize(taskSummaries, (int)32000).stream().map(this::appendComplexAttributesToTaskSummariesWithoutPartitioning).flatMap(Collection::stream).collect(Collectors.toList()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    private Pair<List<String>, ServiceLevelHandler.BulkLog> filterOutTasksWhichAreInInvalidState(Collection<MinimalTaskSummary> minimalTaskSummaries) {
        Pair pair;
        Pair pair2;
        Collection<MinimalTaskSummary> collection = minimalTaskSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this, collection);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ArrayList<String> filteredTasks = new ArrayList<String>(minimalTaskSummaries.size());
        ServiceLevelHandler.BulkLog bulkLog = new ServiceLevelHandler.BulkLog();
        for (MinimalTaskSummary taskSummary : minimalTaskSummaries) {
            if (!taskSummary.getTaskState().in(TaskState.READY, TaskState.READY_FOR_REVIEW)) {
                bulkLog.addError(taskSummary.getTaskId(), (Exception)((Object)new InvalidTaskStateException(taskSummary.getTaskId(), taskSummary.getTaskState(), TaskState.READY, TaskState.READY_FOR_REVIEW)));
                continue;
            }
            filteredTasks.add(taskSummary.getTaskId());
        }
        Pair pair3 = pair2 = (pair = Pair.of(filteredTasks, (Object)((Object)bulkLog)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)pair2);
        return pair;
    }

    private List<TaskSummaryImpl> appendComplexAttributesToTaskSummariesWithoutPartitioning(List<TaskSummaryImpl> taskSummaries) {
        List<TaskSummaryImpl> list;
        List<TaskSummaryImpl> list2;
        List<TaskSummaryImpl> list3 = taskSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, (Object)this, (Object)this, list3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Set<String> taskIds = taskSummaries.stream().map(TaskSummaryImpl::getId).collect(Collectors.toSet());
        if (taskIds.isEmpty()) {
            taskIds = null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("augmentTaskSummariesByContainedSummariesWithoutPartitioning() with sublist {} about to query for attachmentSummaries ", taskSummaries);
        }
        List<AttachmentSummaryImpl> attachmentSummaries = this.attachmentMapper.findAttachmentSummariesByTaskIds(taskIds);
        Map<String, ClassificationSummary> classificationSummariesById = this.findClassificationsForTasksAndAttachments(taskSummaries, attachmentSummaries);
        this.addClassificationSummariesToAttachments(attachmentSummaries, classificationSummariesById);
        this.addClassificationSummariesToTaskSummaries(taskSummaries, classificationSummariesById);
        this.addAttachmentSummariesToTaskSummaries(taskSummaries, attachmentSummaries);
        Map<String, WorkbasketSummary> workbasketSummariesById = this.findWorkbasketsForTasks(taskSummaries);
        List<ObjectReferenceImpl> objectReferences = this.objectReferenceMapper.findObjectReferencesByTaskIds(taskIds);
        this.addWorkbasketSummariesToTaskSummaries(taskSummaries, workbasketSummariesById);
        this.addObjectReferencesToTaskSummaries(taskSummaries, objectReferences);
        List<TaskSummaryImpl> list4 = list2 = (list = taskSummaries);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    private BulkOperationResults<String, TaskanaException> completeTasks(List<String> taskIds, boolean forced) throws InvalidArgumentException {
        BulkOperationResults bulkOperationResults;
        BulkOperationResults bulkOperationResults2;
        List<String> list = taskIds;
        boolean bl = forced;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_53, (Object)this, (Object)this, list, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            this.taskanaEngine.openConnection();
            if (taskIds == null) {
                throw new InvalidArgumentException("TaskIds can't be used as NULL-Parameter.");
            }
            BulkOperationResults bulkLog = new BulkOperationResults();
            Instant now = Instant.now().truncatedTo(ChronoUnit.MILLIS);
            Stream<TaskSummaryImpl> filteredSummaries = this.filterNotExistingTaskIds(taskIds, (BulkOperationResults<String, TaskanaException>)bulkLog).filter(task -> task.getState() != TaskState.COMPLETED).filter(TaskServiceImpl.addErrorToBulkLog((CheckedConsumer<TaskSummaryImpl, TaskanaException>)((CheckedConsumer)TaskServiceImpl::checkIfTaskIsTerminatedOrCancelled), (BulkOperationResults<String, TaskanaException>)bulkLog));
            if (!forced) {
                filteredSummaries = filteredSummaries.filter(TaskServiceImpl.addErrorToBulkLog((CheckedConsumer<TaskSummaryImpl, TaskanaException>)((CheckedConsumer)this::checkPreconditionsForCompleteTask), (BulkOperationResults<String, TaskanaException>)bulkLog));
            } else {
                UserImpl user;
                String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
                String userLongName = this.taskanaEngine.getEngine().getConfiguration().isAddAdditionalUserInfo() ? ((user = this.userMapper.findById(userId)) != null ? user.getLongName() : null) : null;
                filteredSummaries = filteredSummaries.filter(TaskServiceImpl.addErrorToBulkLog((CheckedConsumer<TaskSummaryImpl, TaskanaException>)((CheckedConsumer)summary -> {
                    if (TaskServiceImpl.taskIsNotClaimed(summary)) {
                        this.checkPreconditionsForClaimTask((TaskSummary)summary, true);
                        TaskServiceImpl.claimActionsOnTask(summary, userId, userLongName, now);
                    }
                }), (BulkOperationResults<String, TaskanaException>)bulkLog));
            }
            this.updateTasksToBeCompleted(filteredSummaries, now);
            BulkOperationResults bulkOperationResults3 = bulkLog;
            bulkOperationResults2 = bulkOperationResults3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        BulkOperationResults bulkOperationResults4 = bulkOperationResults = bulkOperationResults2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkOperationResults);
        return bulkOperationResults2;
    }

    private Stream<TaskSummaryImpl> filterNotExistingTaskIds(List<String> taskIds, BulkOperationResults<String, TaskanaException> bulkLog) {
        Stream<TaskSummaryImpl> stream;
        Stream<TaskSummaryImpl> stream2;
        List<String> list = taskIds;
        BulkOperationResults<String, TaskanaException> bulkOperationResults = bulkLog;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_54, (Object)this, (Object)this, list, bulkOperationResults);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<String, TaskSummaryImpl> taskSummaryMap = this.getTasksToChange(taskIds).stream().collect(Collectors.toMap(TaskSummary::getId, TaskSummaryImpl.class::cast));
        Stream<TaskSummaryImpl> stream3 = stream2 = (stream = taskIds.stream().map(id -> Pair.of((Object)id, (Object)((TaskSummaryImpl)taskSummaryMap.get(id)))).filter(pair -> {
            if (pair.getRight() != null) {
                return true;
            }
            String taskId = (String)pair.getLeft();
            bulkLog.addError((Object)taskId, (Exception)((Object)new TaskNotFoundException(taskId)));
            return false;
        }).map(Pair::getRight));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, stream2);
        return stream;
    }

    private static Predicate<TaskSummaryImpl> addErrorToBulkLog(CheckedConsumer<TaskSummaryImpl, TaskanaException> checkedConsumer, BulkOperationResults<String, TaskanaException> bulkLog) {
        Predicate<TaskSummaryImpl> predicate;
        Predicate<TaskSummaryImpl> predicate2;
        CheckedConsumer<TaskSummaryImpl, TaskanaException> checkedConsumer2 = checkedConsumer;
        BulkOperationResults<String, TaskanaException> bulkOperationResults = bulkLog;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_55, null, null, checkedConsumer2, bulkOperationResults);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Predicate<TaskSummaryImpl> predicate3 = predicate2 = (predicate = summary -> {
            try {
                checkedConsumer.accept(summary);
                return true;
            }
            catch (TaskanaException e) {
                bulkLog.addError((Object)summary.getId(), (Exception)((Object)e));
                return false;
            }
        });
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, predicate2);
        return predicate;
    }

    private void checkConcurrencyAndSetModified(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) throws ConcurrencyException {
        TaskImpl taskImpl = newTaskImpl;
        TaskImpl taskImpl2 = oldTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_56, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (oldTaskImpl.getModified() != null && !oldTaskImpl.getModified().equals(newTaskImpl.getModified()) || oldTaskImpl.getClaimed() != null && !oldTaskImpl.getClaimed().equals(newTaskImpl.getClaimed()) || oldTaskImpl.getState() != null && !oldTaskImpl.getState().equals((Object)newTaskImpl.getState())) {
            throw new ConcurrencyException(newTaskImpl.getId());
        }
        newTaskImpl.setModified(Instant.now());
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private TaskImpl terminateCancelCommonActions(String taskId, TaskState targetState) throws TaskNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        String string = taskId;
        TaskState taskState = targetState;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_57, (Object)this, (Object)this, (Object)string, (Object)((Object)taskState));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskId == null || taskId.isEmpty()) {
            throw new TaskNotFoundException(taskId);
        }
        TaskImpl task = (TaskImpl)this.getTask(taskId);
        TaskState state = task.getState();
        if (state.isEndState()) {
            throw new InvalidTaskStateException(taskId, state, TaskState.READY, TaskState.CLAIMED, TaskState.READY_FOR_REVIEW, TaskState.IN_REVIEW);
        }
        Instant now = Instant.now();
        task.setModified(now);
        task.setCompleted(now);
        task.setState(targetState);
        this.taskMapper.update(task);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Task '{}' cancelled by user '{}'.", (Object)taskId, (Object)this.taskanaEngine.getEngine().getCurrentUserContext().getUserid());
        }
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = task);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    private Task claim(String taskId, boolean forceClaim) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        TaskImpl task;
        String string = taskId;
        boolean bl = forceClaim;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_58, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            UserImpl user;
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            TaskImpl oldTask = this.duplicateTaskExactly(task);
            Instant now = Instant.now();
            this.checkPreconditionsForClaimTask(task, forceClaim);
            String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
            String userLongName = null;
            if (this.taskanaEngine.getEngine().getConfiguration().isAddAdditionalUserInfo() && (user = this.userMapper.findById(userId)) != null) {
                userLongName = user.getLongName();
            }
            TaskServiceImpl.claimActionsOnTask(task, userId, userLongName, now);
            this.taskMapper.update(task);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Task '{}' claimed by user '{}'.", (Object)taskId, (Object)userId);
            }
            if (this.historyEventManager.isEnabled()) {
                String changeDetails = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)oldTask, (Object)task);
                this.historyEventManager.createEvent(new TaskClaimedEvent(IdGenerator.generateWithPrefix((String)"THI"), task, userId, changeDetails));
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = task);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    private Task requestReview(String taskId, boolean force) throws TaskNotFoundException, InvalidTaskStateException, InvalidOwnerException, NotAuthorizedOnWorkbasketException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        TaskImpl task;
        String string = taskId;
        boolean bl = force;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_59, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
        try {
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            task = (TaskImpl)this.beforeRequestReviewManager.beforeRequestReview(task);
            TaskImpl oldTask = this.duplicateTaskExactly(task);
            if (force && task.getState().isEndState()) {
                throw new InvalidTaskStateException(task.getId(), task.getState(), (TaskState[])EnumUtil.allValuesExceptFor((Enum[])TaskState.END_STATES));
            }
            if (!force && TaskServiceImpl.taskIsNotClaimed(task)) {
                throw new InvalidTaskStateException(task.getId(), task.getState(), TaskState.CLAIMED, TaskState.IN_REVIEW);
            }
            if (!force && !task.getOwner().equals(userId)) {
                throw new InvalidOwnerException(userId, task.getId());
            }
            task.setState(TaskState.READY_FOR_REVIEW);
            task.setOwner(null);
            task.setModified(Instant.now());
            this.taskMapper.requestReview(task);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Requested review for Task '{}' by user '{}'.", (Object)taskId, (Object)userId);
            }
            if (this.historyEventManager.isEnabled()) {
                String changeDetails = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)oldTask, (Object)task);
                this.historyEventManager.createEvent(new TaskRequestReviewEvent(IdGenerator.generateWithPrefix((String)"THI"), task, userId, changeDetails));
            }
            task = (TaskImpl)this.afterRequestReviewManager.afterRequestReview(task);
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = task);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    private Task requestChanges(String taskId, boolean force) throws InvalidTaskStateException, TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        TaskImpl task;
        String string = taskId;
        boolean bl = force;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_60, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
        try {
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            task = (TaskImpl)this.beforeRequestChangesManager.beforeRequestChanges(task);
            TaskImpl oldTask = this.duplicateTaskExactly(task);
            if (force && task.getState().isEndState()) {
                throw new InvalidTaskStateException(task.getId(), task.getState(), (TaskState[])EnumUtil.allValuesExceptFor((Enum[])TaskState.END_STATES));
            }
            if (!force && task.getState() != TaskState.IN_REVIEW) {
                throw new InvalidTaskStateException(task.getId(), task.getState(), TaskState.IN_REVIEW);
            }
            if (!force && !task.getOwner().equals(userId)) {
                throw new InvalidOwnerException(userId, task.getId());
            }
            task.setState(TaskState.READY);
            task.setOwner(null);
            task.setModified(Instant.now());
            this.taskMapper.requestChanges(task);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Requested changes for Task '{}' by user '{}'.", (Object)taskId, (Object)userId);
            }
            if (this.historyEventManager.isEnabled()) {
                String changeDetails = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)oldTask, (Object)task);
                this.historyEventManager.createEvent(new TaskRequestChangesEvent(IdGenerator.generateWithPrefix((String)"THI"), task, userId, changeDetails));
            }
            task = (TaskImpl)this.afterRequestChangesManager.afterRequestChanges(task);
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = task);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    private static void claimActionsOnTask(TaskSummaryImpl task, String userId, String userLongName, Instant now) {
        TaskSummaryImpl taskSummaryImpl = task;
        String string = userId;
        String string2 = userLongName;
        Instant instant = now;
        Object[] objectArray = new Object[]{taskSummaryImpl, string, string2, instant};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_61, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        task.setOwner(userId);
        task.setOwnerLongName(userLongName);
        task.setModified(now);
        task.setClaimed(now);
        task.setRead(true);
        if (Set.of(TaskState.READY_FOR_REVIEW, TaskState.IN_REVIEW).contains((Object)task.getState())) {
            task.setState(TaskState.IN_REVIEW);
        } else {
            task.setState(TaskState.CLAIMED);
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    private static void cancelClaimActionsOnTask(TaskSummaryImpl task, Instant now) {
        TaskSummaryImpl taskSummaryImpl = task;
        Instant instant = now;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_62, null, null, (Object)taskSummaryImpl, (Object)instant);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        task.setOwner(null);
        task.setModified(now);
        task.setClaimed(null);
        task.setRead(true);
        if (task.getState() == TaskState.IN_REVIEW) {
            task.setState(TaskState.READY_FOR_REVIEW);
        } else {
            task.setState(TaskState.READY);
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    private static void completeActionsOnTask(TaskSummaryImpl task, String userId, Instant now) {
        TaskSummaryImpl taskSummaryImpl = task;
        String string = userId;
        Instant instant = now;
        Object[] objectArray = new Object[]{taskSummaryImpl, string, instant};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_63, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        task.setCompleted(now);
        task.setModified(now);
        task.setState(TaskState.COMPLETED);
        task.setOwner(userId);
        Object var8_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_8);
    }

    private void checkPreconditionsForClaimTask(TaskSummary task, boolean forced) throws InvalidOwnerException, InvalidTaskStateException {
        TaskSummary taskSummary = task;
        boolean bl = forced;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_64, (Object)this, (Object)this, (Object)taskSummary, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskState state = task.getState();
        if (state.isEndState()) {
            throw new InvalidTaskStateException(task.getId(), task.getState(), (TaskState[])EnumUtil.allValuesExceptFor((Enum[])TaskState.END_STATES));
        }
        String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
        if (!(forced || state != TaskState.CLAIMED && state != TaskState.IN_REVIEW || task.getOwner().equals(userId))) {
            throw new InvalidOwnerException(userId, task.getId());
        }
        Object var8_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_8);
    }

    private static boolean taskIsNotClaimed(TaskSummary task) {
        boolean bl;
        boolean bl2;
        TaskSummary taskSummary = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_65, null, null, (Object)taskSummary);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = task.getClaimed() != null && (task.getState() == TaskState.CLAIMED || task.getState() == TaskState.IN_REVIEW) ? (bl = false) : (bl = true);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    private static void checkIfTaskIsTerminatedOrCancelled(TaskSummary task) throws InvalidTaskStateException {
        TaskSummary taskSummary = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_66, null, null, (Object)taskSummary);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (task.getState().in(TaskState.CANCELLED, TaskState.TERMINATED)) {
            throw new InvalidTaskStateException(task.getId(), task.getState(), (TaskState[])EnumUtil.allValuesExceptFor((Enum[])new TaskState[]{TaskState.CANCELLED, TaskState.TERMINATED}));
        }
        Object var3_3 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var3_3);
    }

    private void checkPreconditionsForCompleteTask(TaskSummary task) throws InvalidOwnerException, InvalidTaskStateException {
        TaskSummary taskSummary = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_67, (Object)this, (Object)this, (Object)taskSummary);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (TaskServiceImpl.taskIsNotClaimed(task)) {
            throw new InvalidTaskStateException(task.getId(), task.getState(), TaskState.CLAIMED, TaskState.IN_REVIEW);
        }
        if (!this.taskanaEngine.getEngine().getCurrentUserContext().getAccessIds().contains(task.getOwner()) && !this.taskanaEngine.getEngine().isUserInRole(TaskanaRole.ADMIN)) {
            throw new InvalidOwnerException(this.taskanaEngine.getEngine().getCurrentUserContext().getUserid(), task.getId());
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private Task cancelClaim(String taskId, boolean forceUnclaim) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        TaskImpl task;
        String string = taskId;
        boolean bl = forceUnclaim;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_68, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
        try {
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            TaskImpl oldTask = this.duplicateTaskExactly(task);
            TaskState state = task.getState();
            if (state.isEndState()) {
                throw new InvalidTaskStateException(taskId, state, (TaskState[])EnumUtil.allValuesExceptFor((Enum[])TaskState.END_STATES));
            }
            if (!(state != TaskState.CLAIMED && state != TaskState.IN_REVIEW || forceUnclaim || userId.equals(task.getOwner()))) {
                throw new InvalidOwnerException(userId, taskId);
            }
            Instant now = Instant.now();
            TaskServiceImpl.cancelClaimActionsOnTask(task, now);
            this.taskMapper.update(task);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Task '{}' unclaimed by user '{}'.", (Object)taskId, (Object)userId);
            }
            if (this.historyEventManager.isEnabled()) {
                String changeDetails = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)oldTask, (Object)task);
                this.historyEventManager.createEvent(new TaskClaimCancelledEvent(IdGenerator.generateWithPrefix((String)"THI"), task, userId, changeDetails));
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = task);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Task completeTask(String taskId, boolean isForced) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        Task task3;
        JoinPoint joinPoint;
        block12: {
            TaskImpl task4;
            String string = taskId;
            boolean bl = isForced;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_69, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
            try {
                this.taskanaEngine.openConnection();
                task4 = (TaskImpl)this.getTask(taskId);
                if (this.reviewRequiredManager.reviewRequired(task4)) {
                    Task task5 = this.requestReview(taskId);
                    task2 = task3 = task5;
                    break block12;
                }
                if (task4.getState() == TaskState.COMPLETED) {
                    TaskImpl taskImpl = task4;
                    task2 = task3 = taskImpl;
                    break block12;
                }
                TaskServiceImpl.checkIfTaskIsTerminatedOrCancelled(task4);
                if (!isForced) {
                    this.checkPreconditionsForCompleteTask(task4);
                } else if (TaskServiceImpl.taskIsNotClaimed(task4)) {
                    task4 = (TaskImpl)this.forceClaim(taskId);
                }
                Instant now = Instant.now();
                TaskServiceImpl.completeActionsOnTask(task4, userId, now);
                this.taskMapper.update(task4);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Task '{}' completed by user '{}'.", (Object)taskId, (Object)userId);
                }
                if (this.historyEventManager.isEnabled()) {
                    this.historyEventManager.createEvent(new TaskCompletedEvent(IdGenerator.generateWithPrefix((String)"THI"), task4, userId));
                }
            }
            finally {
                this.taskanaEngine.returnConnection();
            }
            task2 = task3 = task4;
        }
        Task task6 = task = task2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task);
        return task3;
    }

    private void deleteTask(String taskId, boolean forceDelete) throws TaskNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException, InvalidCallbackStateException {
        String string = taskId;
        boolean bl = forceDelete;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_70, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            TaskImpl task = (TaskImpl)this.getTask(taskId);
            if (!task.getState().isEndState() && !forceDelete) {
                throw new InvalidTaskStateException(taskId, task.getState(), TaskState.END_STATES);
            }
            if (!task.getState().in(TaskState.TERMINATED, TaskState.CANCELLED) && CallbackState.CALLBACK_PROCESSING_REQUIRED.equals((Object)task.getCallbackState())) {
                throw new InvalidCallbackStateException(taskId, task.getCallbackState(), (CallbackState[])EnumUtil.allValuesExceptFor((Enum[])new CallbackState[]{CallbackState.CALLBACK_PROCESSING_REQUIRED}));
            }
            this.attachmentMapper.deleteMultipleByTaskIds(Collections.singletonList(taskId));
            this.objectReferenceMapper.deleteMultipleByTaskIds(Collections.singletonList(taskId));
            this.taskMapper.delete(taskId);
            if (this.taskanaEngine.getEngine().isHistoryEnabled() && this.taskanaEngine.getEngine().getConfiguration().isDeleteHistoryEventsOnTaskDeletionEnabled()) {
                this.historyEventManager.deleteEvents(Collections.singletonList(taskId));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Task {} deleted.", (Object)taskId);
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        Object var8_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_8);
    }

    private void removeSingleTaskForTaskDeletionById(BulkOperationResults<String, TaskanaException> bulkLog, List<MinimalTaskSummary> taskSummaries, Iterator<String> taskIdIterator) {
        BulkOperationResults<String, TaskanaException> bulkOperationResults = bulkLog;
        List<MinimalTaskSummary> list = taskSummaries;
        Iterator<String> iterator = taskIdIterator;
        Object[] objectArray = new Object[]{bulkOperationResults, list, iterator};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_71, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String currentTaskId = taskIdIterator.next();
        if (currentTaskId == null || currentTaskId.equals("")) {
            bulkLog.addError((Object)"", (Exception)((Object)new TaskNotFoundException(null)));
            taskIdIterator.remove();
        } else {
            MinimalTaskSummary foundSummary = taskSummaries.stream().filter(taskSummary -> currentTaskId.equals(taskSummary.getTaskId())).findFirst().orElse(null);
            if (foundSummary == null) {
                bulkLog.addError((Object)currentTaskId, (Exception)((Object)new TaskNotFoundException(currentTaskId)));
                taskIdIterator.remove();
            } else if (!foundSummary.getTaskState().isEndState()) {
                bulkLog.addError((Object)currentTaskId, (Exception)((Object)new InvalidTaskStateException(currentTaskId, foundSummary.getTaskState(), TaskState.END_STATES)));
                taskIdIterator.remove();
            } else if (!foundSummary.getTaskState().in(TaskState.CANCELLED, TaskState.TERMINATED) && CallbackState.CALLBACK_PROCESSING_REQUIRED.equals((Object)foundSummary.getCallbackState())) {
                bulkLog.addError((Object)currentTaskId, (Exception)((Object)new InvalidCallbackStateException(currentTaskId, foundSummary.getCallbackState(), (CallbackState[])EnumUtil.allValuesExceptFor((Enum[])new CallbackState[]{CallbackState.CALLBACK_PROCESSING_REQUIRED}))));
                taskIdIterator.remove();
            }
        }
        Object var11_11 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var11_11);
    }

    private void removeSingleTaskForCallbackStateByExternalId(BulkOperationResults<String, TaskanaException> bulkLog, List<MinimalTaskSummary> taskSummaries, Iterator<String> externalIdIterator, CallbackState desiredCallbackState) {
        BulkOperationResults<String, TaskanaException> bulkOperationResults = bulkLog;
        List<MinimalTaskSummary> list = taskSummaries;
        Iterator<String> iterator = externalIdIterator;
        CallbackState callbackState = desiredCallbackState;
        Object[] objectArray = new Object[]{bulkOperationResults, list, iterator, callbackState};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_72, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String currentExternalId = externalIdIterator.next();
        if (currentExternalId == null || currentExternalId.equals("")) {
            bulkLog.addError((Object)"", (Exception)((Object)new TaskNotFoundException(null)));
            externalIdIterator.remove();
        } else {
            Optional<MinimalTaskSummary> foundSummary = taskSummaries.stream().filter(taskSummary -> currentExternalId.equals(taskSummary.getExternalId())).findFirst();
            if (foundSummary.isPresent()) {
                Optional<TaskanaException> invalidStateException = this.desiredCallbackStateCanBeSetForFoundSummary(foundSummary.get(), desiredCallbackState);
                if (invalidStateException.isPresent()) {
                    bulkLog.addError((Object)currentExternalId, (Exception)((Object)invalidStateException.get()));
                    externalIdIterator.remove();
                }
            } else {
                bulkLog.addError((Object)currentExternalId, (Exception)((Object)new TaskNotFoundException(currentExternalId)));
                externalIdIterator.remove();
            }
        }
        Object var14_14 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var14_14);
    }

    private Optional<TaskanaException> desiredCallbackStateCanBeSetForFoundSummary(MinimalTaskSummary foundSummary, CallbackState desiredCallbackState) {
        Optional<TaskanaException> optional;
        Optional<TaskanaException> optional2;
        Optional<TaskanaException> optional3;
        JoinPoint joinPoint;
        block7: {
            MinimalTaskSummary minimalTaskSummary = foundSummary;
            CallbackState callbackState = desiredCallbackState;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_73, (Object)this, (Object)this, (Object)minimalTaskSummary, (Object)((Object)callbackState));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            CallbackState currentTaskCallbackState = foundSummary.getCallbackState();
            TaskState currentTaskState = foundSummary.getTaskState();
            switch (desiredCallbackState) {
                case CALLBACK_PROCESSING_COMPLETED: {
                    if (currentTaskState.isEndState()) break;
                    optional2 = optional3 = Optional.of(new InvalidTaskStateException(foundSummary.getTaskId(), foundSummary.getTaskState(), TaskState.END_STATES));
                    break block7;
                }
                case CLAIMED: {
                    if (!currentTaskState.equals((Object)TaskState.CLAIMED)) {
                        optional2 = optional3 = Optional.of(new InvalidTaskStateException(foundSummary.getTaskId(), foundSummary.getTaskState(), TaskState.CLAIMED));
                    } else {
                        if (currentTaskCallbackState.equals((Object)CallbackState.CALLBACK_PROCESSING_REQUIRED)) break;
                        optional2 = optional3 = Optional.of(new InvalidCallbackStateException(foundSummary.getTaskId(), currentTaskCallbackState, CallbackState.CALLBACK_PROCESSING_REQUIRED));
                    }
                    break block7;
                }
                case CALLBACK_PROCESSING_REQUIRED: {
                    if (!currentTaskCallbackState.equals((Object)CallbackState.CALLBACK_PROCESSING_COMPLETED)) break;
                    optional2 = optional3 = Optional.of(new InvalidCallbackStateException(foundSummary.getTaskId(), currentTaskCallbackState, (CallbackState[])EnumUtil.allValuesExceptFor((Enum[])new CallbackState[]{CallbackState.CALLBACK_PROCESSING_COMPLETED})));
                    break block7;
                }
                default: {
                    optional2 = optional3 = Optional.of(new InvalidCallbackStateException(foundSummary.getTaskId(), currentTaskCallbackState, CallbackState.CALLBACK_PROCESSING_COMPLETED, CallbackState.CLAIMED, CallbackState.CALLBACK_PROCESSING_REQUIRED));
                    break block7;
                }
            }
            optional2 = optional3 = Optional.empty();
        }
        Optional<TaskanaException> optional4 = optional = optional2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, optional);
        return optional3;
    }

    private void standardSettingsOnTaskCreation(TaskImpl task, Classification classification) throws InvalidArgumentException, ClassificationNotFoundException, AttachmentPersistenceException, ObjectReferencePersistenceException {
        UserImpl user;
        TaskImpl taskImpl = task;
        Classification classification2 = classification;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_74, (Object)this, (Object)this, (Object)taskImpl, (Object)classification2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant now = Instant.now();
        task.setId(IdGenerator.generateWithPrefix((String)"TKI"));
        if (task.getExternalId() == null) {
            task.setExternalId(IdGenerator.generateWithPrefix((String)"ETI"));
        }
        task.setState(TaskState.READY);
        task.setCreated(now);
        task.setModified(now);
        task.setRead(false);
        task.setTransferred(false);
        String creator = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
        if (this.taskanaEngine.getEngine().getConfiguration().isSecurityEnabled() && creator == null) {
            throw new SystemException("TaskanaSecurity is enabled, but the current UserId is NULL while creating a Task.");
        }
        task.setCreator(creator);
        if (task.getBusinessProcessId() == null) {
            task.setBusinessProcessId(IdGenerator.generateWithPrefix((String)"BPI"));
        }
        if (task.getPlanned() == null && (classification == null || task.getDue() == null)) {
            task.setPlanned(now);
        }
        if (task.getName() == null && classification != null) {
            task.setName(classification.getName());
        }
        if (task.getDescription() == null && classification != null) {
            task.setDescription(classification.getDescription());
        }
        if (task.getOwner() != null && this.taskanaEngine.getEngine().getConfiguration().isAddAdditionalUserInfo() && (user = this.userMapper.findById(task.getOwner())) != null) {
            task.setOwnerLongName(user.getLongName());
        }
        this.setDefaultTaskReceivedDateFromAttachments(task);
        this.attachmentHandler.insertNewAttachmentsOnTaskCreation(task);
        this.objectReferenceHandler.insertNewSecondaryObjectReferencesOnTaskCreation(task);
        this.serviceLevelHandler.updatePrioPlannedDueOfTask(task, null);
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    private void setDefaultTaskReceivedDateFromAttachments(TaskImpl task) {
        TaskImpl taskImpl = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_75, (Object)this, (Object)this, (Object)taskImpl);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (task.getReceived() == null) {
            task.getAttachments().stream().map(AttachmentSummary::getReceived).filter(Objects::nonNull).min(Instant::compareTo).ifPresent(task::setReceived);
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private void setCallbackStateOnTaskCreation(TaskImpl task) throws InvalidArgumentException {
        String value;
        TaskImpl taskImpl = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_76, (Object)this, (Object)this, (Object)taskImpl);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<String, String> callbackInfo = task.getCallbackInfo();
        if (callbackInfo != null && callbackInfo.containsKey("callbackState") && (value = callbackInfo.get("callbackState")) != null && !value.isEmpty()) {
            try {
                CallbackState state = CallbackState.valueOf(value);
                task.setCallbackState(state);
            }
            catch (Exception e) {
                LOGGER.warn("Attempted to determine callback state from {} and caught exception", (Object)value, (Object)e);
                throw new InvalidArgumentException(String.format("Attempted to set callback state for task %s.", task.getId()), (Throwable)e);
            }
        }
        Object var7_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_8);
    }

    private void updateTasksToBeCompleted(Stream<TaskSummaryImpl> taskSummaries, Instant now) {
        Stream<TaskSummaryImpl> stream = taskSummaries;
        Instant instant = now;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_77, (Object)this, (Object)this, stream, (Object)instant);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<String> updateClaimedTaskIds = new ArrayList<String>();
        List taskSummaryList = taskSummaries.peek(summary -> TaskServiceImpl.completeActionsOnTask(summary, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid(), now)).peek(summary -> {
            boolean bl = taskIds.add(summary.getId());
        }).peek(summary -> {
            if (summary.getClaimed().equals(now)) {
                updateClaimedTaskIds.add(summary.getId());
            }
        }).collect(Collectors.toList());
        TaskSummary claimedReference = taskSummaryList.stream().filter(summary -> updateClaimedTaskIds.contains(summary.getId())).findFirst().orElse(null);
        if (!taskSummaryList.isEmpty()) {
            this.taskMapper.updateCompleted(taskIds, (TaskSummary)taskSummaryList.get(0));
            if (!updateClaimedTaskIds.isEmpty()) {
                this.taskMapper.updateClaimed(updateClaimedTaskIds, claimedReference);
            }
            if (this.historyEventManager.isEnabled()) {
                this.createTasksCompletedEvents(taskSummaryList);
            }
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    private Map<String, WorkbasketSummary> findWorkbasketsForTasks(List<? extends TaskSummary> taskSummaries) {
        Map<String, WorkbasketSummary> map;
        Map<String, WorkbasketSummary> map2;
        Map<String, WorkbasketSummary> map3;
        List<? extends TaskSummary> list = taskSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_78, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskSummaries == null || taskSummaries.isEmpty()) {
            map2 = map3 = Collections.emptyMap();
        } else {
            Set<String> workbasketIds = taskSummaries.stream().map(TaskSummary::getWorkbasketSummary).map(WorkbasketSummary::getId).collect(Collectors.toSet());
            map2 = map3 = this.queryWorkbasketsForTasks(workbasketIds).stream().collect(Collectors.toMap(WorkbasketSummary::getId, Function.identity()));
        }
        Map<String, WorkbasketSummary> map4 = map = map2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map);
        return map3;
    }

    private Map<String, ClassificationSummary> findClassificationsForTasksAndAttachments(List<? extends TaskSummary> taskSummaries, List<? extends AttachmentSummaryImpl> attachmentSummaries) {
        Map<String, ClassificationSummary> map;
        Map<String, ClassificationSummary> map2;
        Map<String, ClassificationSummary> map3;
        List<? extends TaskSummary> list = taskSummaries;
        List<? extends AttachmentSummaryImpl> list2 = attachmentSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_79, (Object)this, (Object)this, list, list2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskSummaries == null || taskSummaries.isEmpty()) {
            map2 = map3 = Collections.emptyMap();
        } else {
            Set<String> classificationIds = Stream.concat(taskSummaries.stream().map(TaskSummary::getClassificationSummary), attachmentSummaries.stream().map(AttachmentSummary::getClassificationSummary)).map(ClassificationSummary::getId).collect(Collectors.toSet());
            map2 = map3 = this.queryClassificationsForTasksAndAttachments(classificationIds).stream().collect(Collectors.toMap(ClassificationSummary::getId, Function.identity()));
        }
        Map<String, ClassificationSummary> map4 = map = map2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map);
        return map3;
    }

    private Map<String, ClassificationSummary> findClassificationForTaskImplAndAttachments(TaskImpl task, List<AttachmentImpl> attachmentImpls) {
        Map<String, ClassificationSummary> map;
        Map<String, ClassificationSummary> map2;
        TaskImpl taskImpl = task;
        List<AttachmentImpl> list = attachmentImpls;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_80, (Object)this, (Object)this, (Object)taskImpl, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<String, ClassificationSummary> map3 = map2 = (map = this.findClassificationsForTasksAndAttachments(Collections.singletonList(task), attachmentImpls));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    private List<ClassificationSummary> queryClassificationsForTasksAndAttachments(Set<String> classificationIds) {
        List list;
        List list2;
        Set<String> set = classificationIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_81, (Object)this, (Object)this, set);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("queryClassificationsForTasksAndAttachments() about to query classifications and exit");
        }
        List list3 = list2 = (list = this.classificationService.createClassificationQuery().idIn(classificationIds.toArray(new String[0])).list());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    private List<WorkbasketSummary> queryWorkbasketsForTasks(Set<String> workbasketIds) {
        List list;
        List list2;
        Set<String> set = workbasketIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_82, (Object)this, (Object)this, set);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("queryWorkbasketsForTasks() about to query workbaskets and exit");
        }
        List list3 = list2 = (list = this.workbasketService.createWorkbasketQuery().idIn(workbasketIds.toArray(new String[0])).list());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    private void addClassificationSummariesToTaskSummaries(List<TaskSummaryImpl> tasks, Map<String, ClassificationSummary> classificationSummaryById) {
        List<TaskSummaryImpl> list = tasks;
        Map<String, ClassificationSummary> map = classificationSummaryById;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_83, (Object)this, (Object)this, list, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (tasks != null && !tasks.isEmpty()) {
            for (TaskSummaryImpl task : tasks) {
                String classificationId = task.getClassificationSummary().getId();
                ClassificationSummary classificationSummary = classificationSummaryById.get(classificationId);
                if (classificationSummary == null) {
                    throw new SystemException("Did not find a Classification for task (Id=" + task.getId() + ",Classification=" + task.getClassificationSummary().getId() + ")");
                }
                task.setClassificationSummary(classificationSummary);
            }
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    private void addWorkbasketSummariesToTaskSummaries(List<TaskSummaryImpl> tasks, Map<String, WorkbasketSummary> workbasketSummaryById) {
        List<TaskSummaryImpl> list = tasks;
        Map<String, WorkbasketSummary> map = workbasketSummaryById;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_84, (Object)this, (Object)this, list, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (tasks != null && !tasks.isEmpty()) {
            for (TaskSummaryImpl task : tasks) {
                String workbasketId = task.getWorkbasketSummary().getId();
                WorkbasketSummary workbasketSummary = workbasketSummaryById.get(workbasketId);
                if (workbasketSummary == null) {
                    throw new SystemException("Did not find a Workbasket for task (Id=" + task.getId() + ",Workbasket=" + task.getWorkbasketSummary().getId() + ")");
                }
                task.setWorkbasketSummary(workbasketSummary);
            }
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    private void addAttachmentSummariesToTaskSummaries(List<TaskSummaryImpl> taskSummaries, List<AttachmentSummaryImpl> attachmentSummaries) {
        List<TaskSummaryImpl> list = taskSummaries;
        List<AttachmentSummaryImpl> list2 = attachmentSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_85, (Object)this, (Object)this, list, list2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskSummaries != null && !taskSummaries.isEmpty()) {
            Map taskSummariesById = taskSummaries.stream().collect(Collectors.toMap(TaskSummary::getId, Function.identity(), (a, b) -> b));
            for (AttachmentSummaryImpl attachmentSummary : attachmentSummaries) {
                String taskId = attachmentSummary.getTaskId();
                TaskSummaryImpl taskSummary = (TaskSummaryImpl)taskSummariesById.get(taskId);
                if (taskSummary == null) continue;
                taskSummary.addAttachmentSummary(attachmentSummary);
            }
        }
        Object var11_11 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var11_11);
    }

    private void addClassificationSummariesToAttachments(List<? extends AttachmentSummaryImpl> attachments, Map<String, ClassificationSummary> classificationSummariesById) {
        List<? extends AttachmentSummaryImpl> list = attachments;
        Map<String, ClassificationSummary> map = classificationSummariesById;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_86, (Object)this, (Object)this, list, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (attachments != null && !attachments.isEmpty()) {
            for (AttachmentSummaryImpl attachmentSummaryImpl : attachments) {
                String classificationId = attachmentSummaryImpl.getClassificationSummary().getId();
                ClassificationSummary classificationSummary = classificationSummariesById.get(classificationId);
                if (classificationSummary == null) {
                    throw new SystemException("Could not find a Classification for attachment " + attachmentSummaryImpl);
                }
                attachmentSummaryImpl.setClassificationSummary(classificationSummary);
            }
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    private void addObjectReferencesToTaskSummaries(List<TaskSummaryImpl> taskSummaries, List<ObjectReferenceImpl> objectReferences) {
        List<TaskSummaryImpl> list = taskSummaries;
        List<ObjectReferenceImpl> list2 = objectReferences;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_87, (Object)this, (Object)this, list, list2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskSummaries != null && !taskSummaries.isEmpty()) {
            Map taskSummariesById = taskSummaries.stream().collect(Collectors.toMap(TaskSummary::getId, Function.identity(), (a, b) -> b));
            for (ObjectReferenceImpl objectReference : objectReferences) {
                String taskId = objectReference.getTaskId();
                TaskSummaryImpl taskSummary = (TaskSummaryImpl)taskSummariesById.get(taskId);
                if (taskSummary == null) continue;
                taskSummary.addSecondaryObjectReference(objectReference);
            }
        }
        Object var11_11 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var11_11);
    }

    private TaskImpl initUpdatedTask(Map<TaskCustomField, String> customFieldsToUpdate, TaskCustomPropertySelector fieldSelector) {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        Map<TaskCustomField, String> map = customFieldsToUpdate;
        TaskCustomPropertySelector taskCustomPropertySelector = fieldSelector;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_88, (Object)this, (Object)this, map, (Object)taskCustomPropertySelector);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskImpl newTask = new TaskImpl();
        newTask.setModified(Instant.now());
        for (Map.Entry<TaskCustomField, String> entry : customFieldsToUpdate.entrySet()) {
            TaskCustomField key = entry.getKey();
            fieldSelector.setCustomProperty(key, true);
            newTask.setCustomField(key, entry.getValue());
        }
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = newTask);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    private void validateCustomFields(Map<TaskCustomField, String> customFieldsToUpdate) throws InvalidArgumentException {
        Map<TaskCustomField, String> map = customFieldsToUpdate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_89, (Object)this, (Object)this, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (customFieldsToUpdate == null || customFieldsToUpdate.isEmpty()) {
            throw new InvalidArgumentException("The customFieldsToUpdate argument to updateTasks must not be empty.");
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private List<TaskSummary> getTasksToChange(List<String> taskIds) {
        List list;
        List list2;
        List<String> list3 = taskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_90, (Object)this, (Object)this, list3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List list4 = list2 = (list = this.createTaskQuery().idIn(taskIds.toArray(new String[0])).list());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    private List<TaskSummary> getTasksToChange(ObjectReference selectionCriteria) {
        List list;
        List list2;
        ObjectReference objectReference = selectionCriteria;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_91, (Object)this, (Object)this, (Object)objectReference);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List list3 = list2 = (list = this.createTaskQuery().primaryObjectReferenceCompanyIn(selectionCriteria.getCompany()).primaryObjectReferenceSystemIn(selectionCriteria.getSystem()).primaryObjectReferenceSystemInstanceIn(selectionCriteria.getSystemInstance()).primaryObjectReferenceTypeIn(selectionCriteria.getType()).primaryObjectReferenceValueIn(selectionCriteria.getValue()).list());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    private void standardUpdateActions(TaskImpl oldTaskImpl, TaskImpl newTaskImpl) throws InvalidArgumentException, ClassificationNotFoundException, InvalidTaskStateException {
        boolean isOwnerChanged;
        TaskImpl taskImpl = oldTaskImpl;
        TaskImpl taskImpl2 = newTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_92, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (oldTaskImpl.getExternalId() == null || !oldTaskImpl.getExternalId().equals(newTaskImpl.getExternalId())) {
            throw new InvalidArgumentException("A task's external Id cannot be changed via update of the task");
        }
        String newWorkbasketKey = newTaskImpl.getWorkbasketKey();
        if (newWorkbasketKey != null && !newWorkbasketKey.equals(oldTaskImpl.getWorkbasketKey())) {
            throw new InvalidArgumentException("A task's Workbasket cannot be changed via update of the task");
        }
        if (newTaskImpl.getClassificationSummary() == null) {
            newTaskImpl.setClassificationSummary(oldTaskImpl.getClassificationSummary());
        }
        this.setDefaultTaskReceivedDateFromAttachments(newTaskImpl);
        this.updateClassificationSummary(newTaskImpl, oldTaskImpl);
        TaskImpl newTaskImpl1 = this.serviceLevelHandler.updatePrioPlannedDueOfTask(newTaskImpl, oldTaskImpl);
        if (newTaskImpl1.getBusinessProcessId() == null) {
            newTaskImpl1.setBusinessProcessId(oldTaskImpl.getBusinessProcessId());
        }
        boolean bl = isOwnerChanged = !Objects.equals(newTaskImpl1.getOwner(), oldTaskImpl.getOwner());
        if (isOwnerChanged && !oldTaskImpl.getState().in(TaskState.READY, TaskState.READY_FOR_REVIEW)) {
            throw new InvalidTaskStateException(oldTaskImpl.getId(), oldTaskImpl.getState(), TaskState.READY, TaskState.READY_FOR_REVIEW);
        }
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    private void updateClassificationSummary(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) throws ClassificationNotFoundException {
        TaskImpl taskImpl = newTaskImpl;
        TaskImpl taskImpl2 = oldTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_93, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ClassificationSummary oldClassificationSummary = oldTaskImpl.getClassificationSummary();
        ClassificationSummary newClassificationSummary = newTaskImpl.getClassificationSummary();
        if (newClassificationSummary == null) {
            newClassificationSummary = oldClassificationSummary;
        }
        if (!oldClassificationSummary.getKey().equals(newClassificationSummary.getKey())) {
            Classification newClassification = this.classificationService.getClassification(newClassificationSummary.getKey(), newTaskImpl.getWorkbasketSummary().getDomain());
            newClassificationSummary = newClassification.asSummary();
            newTaskImpl.setClassificationSummary(newClassificationSummary);
        }
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    private void createTasksCompletedEvents(List<? extends TaskSummary> taskSummaries) {
        List<? extends TaskSummary> list = taskSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_94, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        taskSummaries.forEach(task -> this.historyEventManager.createEvent(new TaskCompletedEvent(IdGenerator.generateWithPrefix((String)"THI"), (TaskSummary)task, this.taskanaEngine.getEngine().getCurrentUserContext().getUserid())));
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private TaskImpl duplicateTaskExactly(TaskImpl task) {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        TaskImpl taskImpl3 = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_95, (Object)this, (Object)this, (Object)taskImpl3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskImpl oldTask = task.copy();
        oldTask.setId(task.getId());
        oldTask.setExternalId(task.getExternalId());
        oldTask.setAttachments(task.getAttachments());
        oldTask.setSecondaryObjectReferences(task.getSecondaryObjectReferences());
        TaskImpl taskImpl4 = taskImpl2 = (taskImpl = oldTask);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskServiceImpl.java", TaskServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "claim", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:pro.taskana.task.api.exceptions.InvalidTaskStateException", "pro.taskana.task.api.models.Task"), 159);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "forceClaim", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:pro.taskana.task.api.exceptions.InvalidTaskStateException", "pro.taskana.task.api.models.Task"), 168);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTask", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.api.models.Task", "taskToCreate", "pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.classification.api.exceptions.ClassificationNotFoundException:pro.taskana.task.api.exceptions.TaskAlreadyExistException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.task.api.exceptions.AttachmentPersistenceException:pro.taskana.task.api.exceptions.ObjectReferencePersistenceException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "pro.taskana.task.api.models.Task"), 250);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTask", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "id", "pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:pro.taskana.task.api.exceptions.TaskNotFoundException", "pro.taskana.task.api.models.Task"), 375);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transfer", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:java.lang.String:boolean", "taskId:destinationWorkbasketId:setTransferFlag", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:pro.taskana.task.api.exceptions.InvalidTaskStateException", "pro.taskana.task.api.models.Task"), 436);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transfer", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:java.lang.String:java.lang.String:boolean", "taskId:workbasketKey:domain:setTransferFlag", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:pro.taskana.task.api.exceptions.InvalidTaskStateException", "pro.taskana.task.api.models.Task"), 445);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTaskRead", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:boolean", "taskId:isRead", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "pro.taskana.task.api.models.Task"), 454);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTaskQuery", "pro.taskana.task.internal.TaskServiceImpl", "", "", "", "pro.taskana.task.api.TaskQuery"), 473);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTaskCommentQuery", "pro.taskana.task.internal.TaskServiceImpl", "", "", "", "pro.taskana.task.api.TaskCommentQuery"), 478);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newTask", "pro.taskana.task.internal.TaskServiceImpl", "", "", "", "pro.taskana.task.api.models.Task"), 483);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newTask", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "workbasketId", "", "pro.taskana.task.api.models.Task"), 488);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newTask", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:java.lang.String", "workbasketKey:domain", "", "pro.taskana.task.api.models.Task"), 498);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cancelClaim", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:pro.taskana.task.api.exceptions.InvalidTaskStateException", "pro.taskana.task.api.models.Task"), 177);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newTaskComment", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "", "pro.taskana.task.api.models.TaskComment"), 508);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newAttachment", "pro.taskana.task.internal.TaskServiceImpl", "", "", "", "pro.taskana.task.api.models.Attachment"), 513);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newObjectReference", "pro.taskana.task.internal.TaskServiceImpl", "", "", "", "pro.taskana.task.api.models.ObjectReference"), 518);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newObjectReference", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String", "company:system:systemInstance:type:value", "", "pro.taskana.task.api.models.ObjectReference"), 523);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTask", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.api.models.Task", "task", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.common.api.exceptions.ConcurrencyException:pro.taskana.task.api.exceptions.AttachmentPersistenceException:pro.taskana.task.api.exceptions.ObjectReferencePersistenceException:pro.taskana.classification.api.exceptions.ClassificationNotFoundException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:pro.taskana.task.api.exceptions.InvalidTaskStateException", "pro.taskana.task.api.models.Task"), 529);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transferTasks", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:java.util.List:boolean", "destinationWorkbasketId:taskIds:setTransferFlag", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "pro.taskana.common.api.BulkOperationResults"), 583);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transferTasks", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:java.lang.String:java.util.List:boolean", "destinationWorkbasketKey:destinationWorkbasketDomain:taskIds:setTransferFlag", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "pro.taskana.common.api.BulkOperationResults"), 592);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTask", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:pro.taskana.task.api.exceptions.InvalidTaskStateException:pro.taskana.task.api.exceptions.InvalidCallbackStateException", "void"), 605);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "forceDeleteTask", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:pro.taskana.task.api.exceptions.InvalidTaskStateException:pro.taskana.task.api.exceptions.InvalidCallbackStateException", "void"), 615);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "selectAndClaim", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.api.TaskQuery", "taskQuery", "", "java.util.Optional"), 625);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "forceCancelClaim", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidTaskStateException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "pro.taskana.task.api.models.Task"), 186);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTasks", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List", "taskIds", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.common.api.BulkOperationResults"), 633);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "completeTasks", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List", "taskIds", "pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.common.api.BulkOperationResults"), 678);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "forceCompleteTasks", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List", "taskIds", "pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.common.api.BulkOperationResults"), 684);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTasks", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.api.models.ObjectReference:java.util.Map", "selectionCriteria:customFieldsToUpdate", "pro.taskana.common.api.exceptions.InvalidArgumentException", "java.util.List"), 690);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTasks", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List:java.util.Map", "taskIds:customFieldsToUpdate", "pro.taskana.common.api.exceptions.InvalidArgumentException", "java.util.List"), 725);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTaskComment", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.api.models.TaskComment", "taskComment", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "pro.taskana.task.api.models.TaskComment"), 759);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTaskComment", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.api.models.TaskComment", "taskComment", "pro.taskana.common.api.exceptions.ConcurrencyException:pro.taskana.task.api.exceptions.TaskCommentNotFoundException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.task.api.exceptions.NotAuthorizedOnTaskCommentException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "pro.taskana.task.api.models.TaskComment"), 765);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTaskComment", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskCommentId", "pro.taskana.task.api.exceptions.TaskCommentNotFoundException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.task.api.exceptions.NotAuthorizedOnTaskCommentException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "void"), 776);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskComment", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskCommentid", "pro.taskana.task.api.exceptions.TaskCommentNotFoundException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "pro.taskana.task.api.models.TaskComment"), 786);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskComments", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "java.util.List"), 795);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "requestReview", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.InvalidTaskStateException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "pro.taskana.task.api.models.Task"), 196);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCallbackStateForTasks", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List:pro.taskana.task.api.CallbackState", "externalIds:state", "", "pro.taskana.common.api.BulkOperationResults"), 802);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setOwnerOfTasks", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:java.util.List", "owner:taskIds", "", "pro.taskana.common.api.BulkOperationResults"), 830);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPlannedPropertyOfTasks", "pro.taskana.task.internal.TaskServiceImpl", "java.time.Instant:java.util.List", "planned:argTaskIds", "", "pro.taskana.common.api.BulkOperationResults"), 867);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cancelTask", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:pro.taskana.task.api.exceptions.InvalidTaskStateException", "pro.taskana.task.api.models.Task"), 889);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "terminateTask", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:pro.taskana.task.api.exceptions.InvalidTaskStateException", "pro.taskana.task.api.models.Task"), 913);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findTasksIdsAffectedByClassificationChange", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "classificationId", "", "java.util.List"), 941);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refreshPriorityAndDueDatesOfTasksOnClassificationUpdate", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List:boolean:boolean", "taskIds:serviceLevelChanged:priorityChanged", "", "void"), 982);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getMinimalTaskSummaries", "pro.taskana.task.internal.TaskServiceImpl", "java.util.Collection", "argTaskIds", "", "pro.taskana.common.internal.util.Pair"), 1006);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "filterTasksAuthorizedForAndLogErrorsForNotAuthorized", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List", "existingTasks", "", "pro.taskana.common.internal.util.Pair"), 1019);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "addExceptionsForNonExistingTasksToBulkLog", "pro.taskana.task.internal.TaskServiceImpl", "java.util.Collection:java.util.List", "requestTaskIds:existingMinimalTaskSummaries", "", "pro.taskana.task.internal.ServiceLevelHandler$BulkLog"), 1050);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "forceRequestReview", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.InvalidTaskStateException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "pro.taskana.task.api.models.Task"), 205);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "augmentTaskSummariesByContainedSummariesWithPartitioning", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List", "taskSummaries", "", "java.util.List"), 1063);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "filterOutTasksWhichAreInInvalidState", "pro.taskana.task.internal.TaskServiceImpl", "java.util.Collection", "minimalTaskSummaries", "", "pro.taskana.common.internal.util.Pair"), 1073);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "appendComplexAttributesToTaskSummariesWithoutPartitioning", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List", "taskSummaries", "", "java.util.List"), 1094);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "completeTasks", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List:boolean", "taskIds:forced", "pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.common.api.BulkOperationResults"), 1127);
        ajc$tjp_54 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "filterNotExistingTaskIds", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List:pro.taskana.common.api.BulkOperationResults", "taskIds:bulkLog", "", "java.util.stream.Stream"), 1179);
        ajc$tjp_55 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "addErrorToBulkLog", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.common.internal.util.CheckedConsumer:pro.taskana.common.api.BulkOperationResults", "checkedConsumer:bulkLog", "", "java.util.function.Predicate"), 1199);
        ajc$tjp_56 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkConcurrencyAndSetModified", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.task.internal.models.TaskImpl", "newTaskImpl:oldTaskImpl", "pro.taskana.common.api.exceptions.ConcurrencyException", "void"), 1213);
        ajc$tjp_57 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "terminateCancelCommonActions", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:pro.taskana.task.api.TaskState", "taskId:targetState", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:pro.taskana.task.api.exceptions.InvalidTaskStateException", "pro.taskana.task.internal.models.TaskImpl"), 1228);
        ajc$tjp_58 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "claim", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:boolean", "taskId:forceClaim", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:pro.taskana.task.api.exceptions.InvalidTaskStateException", "pro.taskana.task.api.models.Task"), 1259);
        ajc$tjp_59 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "requestReview", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:boolean", "taskId:force", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidTaskStateException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "pro.taskana.task.api.models.Task"), 1305);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "requestChanges", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.InvalidTaskStateException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "pro.taskana.task.api.models.Task"), 214);
        ajc$tjp_60 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "requestChanges", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:boolean", "taskId:force", "pro.taskana.task.api.exceptions.InvalidTaskStateException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "pro.taskana.task.api.models.Task"), 1358);
        ajc$tjp_61 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "claimActionsOnTask", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.internal.models.TaskSummaryImpl:java.lang.String:java.lang.String:java.time.Instant", "task:userId:userLongName:now", "", "void"), 1409);
        ajc$tjp_62 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "cancelClaimActionsOnTask", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.internal.models.TaskSummaryImpl:java.time.Instant", "task:now", "", "void"), 1423);
        ajc$tjp_63 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "completeActionsOnTask", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.internal.models.TaskSummaryImpl:java.lang.String:java.time.Instant", "task:userId:now", "", "void"), 1435);
        ajc$tjp_64 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkPreconditionsForClaimTask", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.api.models.TaskSummary:boolean", "task:forced", "pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.task.api.exceptions.InvalidTaskStateException", "void"), 1442);
        ajc$tjp_65 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "taskIsNotClaimed", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.api.models.TaskSummary", "task", "", "boolean"), 1458);
        ajc$tjp_66 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "checkIfTaskIsTerminatedOrCancelled", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.api.models.TaskSummary", "task", "pro.taskana.task.api.exceptions.InvalidTaskStateException", "void"), 1463);
        ajc$tjp_67 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkPreconditionsForCompleteTask", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.api.models.TaskSummary", "task", "pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.task.api.exceptions.InvalidTaskStateException", "void"), 1473);
        ajc$tjp_68 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "cancelClaim", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:boolean", "taskId:forceUnclaim", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:pro.taskana.task.api.exceptions.InvalidTaskStateException", "pro.taskana.task.api.models.Task"), 1489);
        ajc$tjp_69 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "completeTask", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:boolean", "taskId:isForced", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:pro.taskana.task.api.exceptions.InvalidTaskStateException", "pro.taskana.task.api.models.Task"), 1535);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "forceRequestChanges", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.InvalidTaskStateException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "pro.taskana.task.api.models.Task"), 223);
        ajc$tjp_70 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteTask", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String:boolean", "taskId:forceDelete", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:pro.taskana.task.api.exceptions.InvalidTaskStateException:pro.taskana.task.api.exceptions.InvalidCallbackStateException", "void"), 1580);
        ajc$tjp_71 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "removeSingleTaskForTaskDeletionById", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.common.api.BulkOperationResults:java.util.List:java.util.Iterator", "bulkLog:taskSummaries:taskIdIterator", "", "void"), 1623);
        ajc$tjp_72 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "removeSingleTaskForCallbackStateByExternalId", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.common.api.BulkOperationResults:java.util.List:java.util.Iterator:pro.taskana.task.api.CallbackState", "bulkLog:taskSummaries:externalIdIterator:desiredCallbackState", "", "void"), 1661);
        ajc$tjp_73 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "desiredCallbackStateCanBeSetForFoundSummary", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.internal.models.MinimalTaskSummary:pro.taskana.task.api.CallbackState", "foundSummary:desiredCallbackState", "", "java.util.Optional"), 1689);
        ajc$tjp_74 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "standardSettingsOnTaskCreation", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.classification.api.models.Classification", "task:classification", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.classification.api.exceptions.ClassificationNotFoundException:pro.taskana.task.api.exceptions.AttachmentPersistenceException:pro.taskana.task.api.exceptions.ObjectReferencePersistenceException", "void"), 1738);
        ajc$tjp_75 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setDefaultTaskReceivedDateFromAttachments", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.internal.models.TaskImpl", "task", "", "void"), 1793);
        ajc$tjp_76 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setCallbackStateOnTaskCreation", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.internal.models.TaskImpl", "task", "pro.taskana.common.api.exceptions.InvalidArgumentException", "void"), 1803);
        ajc$tjp_77 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateTasksToBeCompleted", "pro.taskana.task.internal.TaskServiceImpl", "java.util.stream.Stream:java.time.Instant", "taskSummaries:now", "", "void"), 1821);
        ajc$tjp_78 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "findWorkbasketsForTasks", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List", "taskSummaries", "", "java.util.Map"), 1858);
        ajc$tjp_79 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "findClassificationsForTasksAndAttachments", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List:java.util.List", "taskSummaries:attachmentSummaries", "", "java.util.Map"), 1874);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "completeTask", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:pro.taskana.task.api.exceptions.InvalidTaskStateException", "pro.taskana.task.api.models.Task"), 232);
        ajc$tjp_80 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "findClassificationForTaskImplAndAttachments", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.internal.models.TaskImpl:java.util.List", "task:attachmentImpls", "", "java.util.Map"), 1892);
        ajc$tjp_81 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "queryClassificationsForTasksAndAttachments", "pro.taskana.task.internal.TaskServiceImpl", "java.util.Set", "classificationIds", "", "java.util.List"), 1898);
        ajc$tjp_82 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "queryWorkbasketsForTasks", "pro.taskana.task.internal.TaskServiceImpl", "java.util.Set", "workbasketIds", "", "java.util.List"), 1911);
        ajc$tjp_83 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addClassificationSummariesToTaskSummaries", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List:java.util.Map", "tasks:classificationSummaryById", "", "void"), 1923);
        ajc$tjp_84 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addWorkbasketSummariesToTaskSummaries", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List:java.util.Map", "tasks:workbasketSummaryById", "", "void"), 1945);
        ajc$tjp_85 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addAttachmentSummariesToTaskSummaries", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List:java.util.List", "taskSummaries:attachmentSummaries", "", "void"), 1966);
        ajc$tjp_86 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addClassificationSummariesToAttachments", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List:java.util.Map", "attachments:classificationSummariesById", "", "void"), 1993);
        ajc$tjp_87 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addObjectReferencesToTaskSummaries", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List:java.util.List", "taskSummaries:objectReferences", "", "void"), 2013);
        ajc$tjp_88 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initUpdatedTask", "pro.taskana.task.internal.TaskServiceImpl", "java.util.Map:pro.taskana.task.internal.TaskCustomPropertySelector", "customFieldsToUpdate:fieldSelector", "", "pro.taskana.task.internal.models.TaskImpl"), 2039);
        ajc$tjp_89 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateCustomFields", "pro.taskana.task.internal.TaskServiceImpl", "java.util.Map", "customFieldsToUpdate", "pro.taskana.common.api.exceptions.InvalidArgumentException", "void"), 2053);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "forceCompleteTask", "pro.taskana.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.InvalidOwnerException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:pro.taskana.task.api.exceptions.InvalidTaskStateException", "pro.taskana.task.api.models.Task"), 241);
        ajc$tjp_90 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getTasksToChange", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List", "taskIds", "", "java.util.List"), 2062);
        ajc$tjp_91 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getTasksToChange", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.api.models.ObjectReference", "selectionCriteria", "", "java.util.List"), 2066);
        ajc$tjp_92 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "standardUpdateActions", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.task.internal.models.TaskImpl", "oldTaskImpl:newTaskImpl", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.classification.api.exceptions.ClassificationNotFoundException:pro.taskana.task.api.exceptions.InvalidTaskStateException", "void"), 2076);
        ajc$tjp_93 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateClassificationSummary", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.internal.models.TaskImpl:pro.taskana.task.internal.models.TaskImpl", "newTaskImpl:oldTaskImpl", "pro.taskana.classification.api.exceptions.ClassificationNotFoundException", "void"), 2115);
        ajc$tjp_94 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createTasksCompletedEvents", "pro.taskana.task.internal.TaskServiceImpl", "java.util.List", "taskSummaries", "", "void"), 2131);
        ajc$tjp_95 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "duplicateTaskExactly", "pro.taskana.task.internal.TaskServiceImpl", "pro.taskana.task.internal.models.TaskImpl", "task", "", "pro.taskana.task.internal.models.TaskImpl"), 2141);
    }
}

