/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.CustomHoliday;
import pro.taskana.common.api.LocalTimeInterval;
import pro.taskana.common.api.SharedConstants;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.configuration.TaskanaProperty;
import pro.taskana.common.internal.configuration.parser.PropertyParser;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.FileLoaderUtil;
import pro.taskana.common.internal.util.Pair;
import pro.taskana.common.internal.util.ReflectionUtil;
import pro.taskana.workbasket.api.WorkbasketPermission;

public class TaskanaConfiguration {
    private final DataSource dataSource;
    private final boolean useManagedTransactions;
    private final String schemaName;
    private final boolean securityEnabled;
    private final List<String> domains;
    private final boolean enforceServiceLevel;
    private final Map<TaskanaRole, Set<String>> roleMap;
    private final List<String> classificationTypes;
    private final Map<String, List<String>> classificationCategoriesByType;
    private final Map<DayOfWeek, Set<LocalTimeInterval>> workingTimeSchedule;
    private final ZoneId workingTimeScheduleTimeZone;
    private final Set<CustomHoliday> customHolidays;
    private final boolean germanPublicHolidaysEnabled;
    private final boolean germanPublicHolidaysCorpusChristiEnabled;
    private final boolean deleteHistoryEventsOnTaskDeletionEnabled;
    private final String logHistoryLoggerName;
    private final boolean jobSchedulerEnabled;
    private final long jobSchedulerInitialStartDelay;
    private final long jobSchedulerPeriod;
    private final TimeUnit jobSchedulerPeriodTimeUnit;
    private final int maxNumberOfJobRetries;
    private final int jobBatchSize;
    private final Instant jobFirstRun;
    private final Duration jobRunEvery;
    private final boolean taskCleanupJobEnabled;
    private final Duration taskCleanupJobMinimumAge;
    private final boolean taskCleanupJobAllCompletedSameParentBusiness;
    private final boolean workbasketCleanupJobEnabled;
    private final boolean simpleHistoryCleanupJobEnabled;
    private final int simpleHistoryCleanupJobBatchSize;
    private final Duration simpleHistoryCleanupJobMinimumAge;
    private final boolean simpleHistoryCleanupJobAllCompletedSameParentBusiness;
    private final boolean taskUpdatePriorityJobEnabled;
    private final int taskUpdatePriorityJobBatchSize;
    private final Instant taskUpdatePriorityJobFirstRun;
    private final Duration taskUpdatePriorityJobRunEvery;
    private final boolean userInfoRefreshJobEnabled;
    private final Instant userRefreshJobFirstRun;
    private final Duration userRefreshJobRunEvery;
    private final Set<String> customJobs;
    private final boolean addAdditionalUserInfo;
    private final Set<WorkbasketPermission> minimalPermissionsToAssignDomains;
    private final boolean useSpecificDb2Taskquery;
    private final Map<String, String> properties;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;

    private TaskanaConfiguration(Builder builder) {
        this.dataSource = builder.dataSource;
        this.useManagedTransactions = builder.useManagedTransactions;
        this.schemaName = builder.schemaName;
        this.securityEnabled = builder.securityEnabled;
        this.domains = Collections.unmodifiableList(builder.domains);
        this.enforceServiceLevel = builder.enforceServiceLevel;
        this.roleMap = builder.roleMap.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> Collections.unmodifiableSet((Set)e.getValue())));
        this.classificationTypes = Collections.unmodifiableList(builder.classificationTypes);
        this.classificationCategoriesByType = builder.classificationCategoriesByType.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> Collections.unmodifiableList((List)e.getValue())));
        this.workingTimeSchedule = builder.workingTimeSchedule.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> Collections.unmodifiableSet((Set)e.getValue())));
        this.workingTimeScheduleTimeZone = builder.workingTimeScheduleTimeZone;
        this.customHolidays = Collections.unmodifiableSet(builder.customHolidays);
        this.germanPublicHolidaysEnabled = builder.germanPublicHolidaysEnabled;
        this.germanPublicHolidaysCorpusChristiEnabled = builder.germanPublicHolidaysCorpusChristiEnabled;
        this.deleteHistoryEventsOnTaskDeletionEnabled = builder.deleteHistoryEventsOnTaskDeletionEnabled;
        this.logHistoryLoggerName = builder.logHistoryLoggerName;
        this.jobSchedulerEnabled = builder.jobSchedulerEnabled;
        this.jobSchedulerInitialStartDelay = builder.jobSchedulerInitialStartDelay;
        this.jobSchedulerPeriod = builder.jobSchedulerPeriod;
        this.jobSchedulerPeriodTimeUnit = builder.jobSchedulerPeriodTimeUnit;
        this.maxNumberOfJobRetries = builder.maxNumberOfJobRetries;
        this.jobBatchSize = builder.jobBatchSize;
        this.jobFirstRun = builder.jobFirstRun;
        this.jobRunEvery = builder.jobRunEvery;
        this.taskCleanupJobEnabled = builder.taskCleanupJobEnabled;
        this.taskCleanupJobMinimumAge = builder.taskCleanupJobMinimumAge;
        this.taskCleanupJobAllCompletedSameParentBusiness = builder.taskCleanupJobAllCompletedSameParentBusiness;
        this.workbasketCleanupJobEnabled = builder.workbasketCleanupJobEnabled;
        this.simpleHistoryCleanupJobEnabled = builder.simpleHistoryCleanupJobEnabled;
        this.simpleHistoryCleanupJobBatchSize = builder.simpleHistoryCleanupJobBatchSize;
        this.simpleHistoryCleanupJobMinimumAge = builder.simpleHistoryCleanupJobMinimumAge;
        this.simpleHistoryCleanupJobAllCompletedSameParentBusiness = builder.simpleHistoryCleanupJobAllCompletedSameParentBusiness;
        this.taskUpdatePriorityJobEnabled = builder.taskUpdatePriorityJobEnabled;
        this.taskUpdatePriorityJobBatchSize = builder.taskUpdatePriorityJobBatchSize;
        this.taskUpdatePriorityJobFirstRun = builder.taskUpdatePriorityJobFirstRun;
        this.taskUpdatePriorityJobRunEvery = builder.taskUpdatePriorityJobRunEvery;
        this.userInfoRefreshJobEnabled = builder.userInfoRefreshJobEnabled;
        this.userRefreshJobFirstRun = builder.userRefreshJobFirstRun;
        this.userRefreshJobRunEvery = builder.userRefreshJobRunEvery;
        this.customJobs = Collections.unmodifiableSet(builder.customJobs);
        this.addAdditionalUserInfo = builder.addAdditionalUserInfo;
        this.minimalPermissionsToAssignDomains = Collections.unmodifiableSet(builder.minimalPermissionsToAssignDomains);
        this.useSpecificDb2Taskquery = builder.useSpecificDb2Taskquery;
        this.properties = Map.copyOf(builder.properties);
    }

    public static boolean shouldUseLowerCaseForAccessIds() {
        boolean bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl2 = true;
        boolean bl3 = bl = true;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl2;
    }

    public List<String> getAllClassificationCategories() {
        List<String> list;
        List<String> list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> list3 = list2 = (list = this.classificationCategoriesByType.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public List<String> getClassificationCategoriesByType(String type) {
        List<String> list;
        List<String> list2;
        String string = type;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> list3 = list2 = (list = this.classificationCategoriesByType.getOrDefault(type, Collections.emptyList()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public Map<String, List<String>> getClassificationCategoriesByType() {
        Map<String, List<String>> map;
        Map<String, List<String>> map2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<String, List<String>> map3 = map2 = (map = this.classificationCategoriesByType);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    public DataSource getDataSource() {
        DataSource dataSource;
        DataSource dataSource2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DataSource dataSource3 = dataSource2 = (dataSource = this.dataSource);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dataSource2);
        return dataSource;
    }

    public boolean isUseManagedTransactions() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.useManagedTransactions);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public String getSchemaName() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.schemaName);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public boolean isSecurityEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.securityEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public List<String> getDomains() {
        List<String> list;
        List<String> list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> list3 = list2 = (list = this.domains);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public boolean isEnforceServiceLevel() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.enforceServiceLevel);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public Map<TaskanaRole, Set<String>> getRoleMap() {
        Map<TaskanaRole, Set<String>> map;
        Map<TaskanaRole, Set<String>> map2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<TaskanaRole, Set<String>> map3 = map2 = (map = this.roleMap);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    public List<String> getClassificationTypes() {
        List<String> list;
        List<String> list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> list3 = list2 = (list = this.classificationTypes);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public Map<DayOfWeek, Set<LocalTimeInterval>> getWorkingTimeSchedule() {
        Map<DayOfWeek, Set<LocalTimeInterval>> map;
        Map<DayOfWeek, Set<LocalTimeInterval>> map2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<DayOfWeek, Set<LocalTimeInterval>> map3 = map2 = (map = this.workingTimeSchedule);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    public ZoneId getWorkingTimeScheduleTimeZone() {
        ZoneId zoneId;
        ZoneId zoneId2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ZoneId zoneId3 = zoneId2 = (zoneId = this.workingTimeScheduleTimeZone);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)zoneId2);
        return zoneId;
    }

    public Set<CustomHoliday> getCustomHolidays() {
        Set<CustomHoliday> set;
        Set<CustomHoliday> set2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Set<CustomHoliday> set3 = set2 = (set = this.customHolidays);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, set2);
        return set;
    }

    public boolean isGermanPublicHolidaysEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.germanPublicHolidaysEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public boolean isGermanPublicHolidaysCorpusChristiEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.germanPublicHolidaysCorpusChristiEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public boolean isDeleteHistoryEventsOnTaskDeletionEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.deleteHistoryEventsOnTaskDeletionEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public String getLogHistoryLoggerName() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.logHistoryLoggerName);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public boolean isJobSchedulerEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.jobSchedulerEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public long getJobSchedulerInitialStartDelay() {
        long l;
        long l2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        long l3 = l2 = (l = this.jobSchedulerInitialStartDelay);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.longObject((long)l2));
        return l;
    }

    public long getJobSchedulerPeriod() {
        long l;
        long l2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        long l3 = l2 = (l = this.jobSchedulerPeriod);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.longObject((long)l2));
        return l;
    }

    public TimeUnit getJobSchedulerPeriodTimeUnit() {
        TimeUnit timeUnit;
        TimeUnit timeUnit2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TimeUnit timeUnit3 = timeUnit2 = (timeUnit = this.jobSchedulerPeriodTimeUnit);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)timeUnit2);
        return timeUnit;
    }

    public int getMaxNumberOfJobRetries() {
        int n;
        int n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = this.maxNumberOfJobRetries);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public int getJobBatchSize() {
        int n;
        int n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = this.jobBatchSize);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public Instant getJobFirstRun() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.jobFirstRun);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Duration getJobRunEvery() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.jobRunEvery);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public boolean isTaskCleanupJobEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.taskCleanupJobEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public Duration getTaskCleanupJobMinimumAge() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.taskCleanupJobMinimumAge);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public boolean isTaskCleanupJobAllCompletedSameParentBusiness() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.taskCleanupJobAllCompletedSameParentBusiness);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public boolean isWorkbasketCleanupJobEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.workbasketCleanupJobEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public boolean isSimpleHistoryCleanupJobEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.simpleHistoryCleanupJobEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public int getSimpleHistoryCleanupJobBatchSize() {
        int n;
        int n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = this.simpleHistoryCleanupJobBatchSize);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public Duration getSimpleHistoryCleanupJobMinimumAge() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.simpleHistoryCleanupJobMinimumAge);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public boolean isSimpleHistoryCleanupJobAllCompletedSameParentBusiness() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.simpleHistoryCleanupJobAllCompletedSameParentBusiness);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public boolean isTaskUpdatePriorityJobEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.taskUpdatePriorityJobEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public int getTaskUpdatePriorityJobBatchSize() {
        int n;
        int n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = this.taskUpdatePriorityJobBatchSize);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public Instant getTaskUpdatePriorityJobFirstRun() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.taskUpdatePriorityJobFirstRun);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Duration getTaskUpdatePriorityJobRunEvery() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.taskUpdatePriorityJobRunEvery);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public boolean isUserInfoRefreshJobEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.userInfoRefreshJobEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public Instant getUserRefreshJobFirstRun() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.userRefreshJobFirstRun);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Duration getUserRefreshJobRunEvery() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.userRefreshJobRunEvery);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public Set<String> getCustomJobs() {
        Set<String> set;
        Set<String> set2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Set<String> set3 = set2 = (set = this.customJobs);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, set2);
        return set;
    }

    public boolean isAddAdditionalUserInfo() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.addAdditionalUserInfo);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public Set<WorkbasketPermission> getMinimalPermissionsToAssignDomains() {
        Set<WorkbasketPermission> set;
        Set<WorkbasketPermission> set2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Set<WorkbasketPermission> set3 = set2 = (set = this.minimalPermissionsToAssignDomains);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, set2);
        return set;
    }

    public boolean isUseSpecificDb2Taskquery() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.useSpecificDb2Taskquery);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public Map<String, String> getProperties() {
        Map<String, String> map;
        Map<String, String> map2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<String, String> map3 = map2 = (map = this.properties);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataSource, this.useManagedTransactions, this.schemaName, this.securityEnabled, this.domains, this.enforceServiceLevel, this.roleMap, this.classificationTypes, this.classificationCategoriesByType, this.workingTimeSchedule, this.workingTimeScheduleTimeZone, this.customHolidays, this.germanPublicHolidaysEnabled, this.germanPublicHolidaysCorpusChristiEnabled, this.deleteHistoryEventsOnTaskDeletionEnabled, this.logHistoryLoggerName, this.jobSchedulerEnabled, this.jobSchedulerInitialStartDelay, this.jobSchedulerPeriod, this.jobSchedulerPeriodTimeUnit, this.maxNumberOfJobRetries, this.jobBatchSize, this.jobFirstRun, this.jobRunEvery, this.taskCleanupJobEnabled, this.taskCleanupJobMinimumAge, this.taskCleanupJobAllCompletedSameParentBusiness, this.workbasketCleanupJobEnabled, this.simpleHistoryCleanupJobEnabled, this.simpleHistoryCleanupJobBatchSize, this.simpleHistoryCleanupJobMinimumAge, this.simpleHistoryCleanupJobAllCompletedSameParentBusiness, this.taskUpdatePriorityJobEnabled, this.taskUpdatePriorityJobBatchSize, this.taskUpdatePriorityJobFirstRun, this.taskUpdatePriorityJobRunEvery, this.userInfoRefreshJobEnabled, this.userRefreshJobFirstRun, this.userRefreshJobRunEvery, this.customJobs, this.addAdditionalUserInfo, this.minimalPermissionsToAssignDomains, this.useSpecificDb2Taskquery, this.properties});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TaskanaConfiguration)) {
            return false;
        }
        TaskanaConfiguration other = (TaskanaConfiguration)obj;
        return this.useManagedTransactions == other.useManagedTransactions && this.securityEnabled == other.securityEnabled && this.enforceServiceLevel == other.enforceServiceLevel && this.germanPublicHolidaysEnabled == other.germanPublicHolidaysEnabled && this.germanPublicHolidaysCorpusChristiEnabled == other.germanPublicHolidaysCorpusChristiEnabled && this.deleteHistoryEventsOnTaskDeletionEnabled == other.deleteHistoryEventsOnTaskDeletionEnabled && this.jobSchedulerEnabled == other.jobSchedulerEnabled && this.jobSchedulerInitialStartDelay == other.jobSchedulerInitialStartDelay && this.jobSchedulerPeriod == other.jobSchedulerPeriod && this.maxNumberOfJobRetries == other.maxNumberOfJobRetries && this.jobBatchSize == other.jobBatchSize && this.taskCleanupJobEnabled == other.taskCleanupJobEnabled && this.taskCleanupJobAllCompletedSameParentBusiness == other.taskCleanupJobAllCompletedSameParentBusiness && this.workbasketCleanupJobEnabled == other.workbasketCleanupJobEnabled && this.simpleHistoryCleanupJobEnabled == other.simpleHistoryCleanupJobEnabled && this.simpleHistoryCleanupJobBatchSize == other.simpleHistoryCleanupJobBatchSize && this.simpleHistoryCleanupJobAllCompletedSameParentBusiness == other.simpleHistoryCleanupJobAllCompletedSameParentBusiness && this.taskUpdatePriorityJobEnabled == other.taskUpdatePriorityJobEnabled && this.useSpecificDb2Taskquery == other.useSpecificDb2Taskquery && this.taskUpdatePriorityJobBatchSize == other.taskUpdatePriorityJobBatchSize && this.userInfoRefreshJobEnabled == other.userInfoRefreshJobEnabled && this.addAdditionalUserInfo == other.addAdditionalUserInfo && Objects.equals(this.dataSource, other.dataSource) && Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.domains, other.domains) && Objects.equals(this.roleMap, other.roleMap) && Objects.equals(this.classificationTypes, other.classificationTypes) && Objects.equals(this.classificationCategoriesByType, other.classificationCategoriesByType) && Objects.equals(this.workingTimeSchedule, other.workingTimeSchedule) && Objects.equals(this.workingTimeScheduleTimeZone, other.workingTimeScheduleTimeZone) && Objects.equals(this.customHolidays, other.customHolidays) && Objects.equals(this.logHistoryLoggerName, other.logHistoryLoggerName) && this.jobSchedulerPeriodTimeUnit == other.jobSchedulerPeriodTimeUnit && Objects.equals(this.jobFirstRun, other.jobFirstRun) && Objects.equals(this.jobRunEvery, other.jobRunEvery) && Objects.equals(this.taskCleanupJobMinimumAge, other.taskCleanupJobMinimumAge) && Objects.equals(this.simpleHistoryCleanupJobMinimumAge, other.simpleHistoryCleanupJobMinimumAge) && Objects.equals(this.taskUpdatePriorityJobFirstRun, other.taskUpdatePriorityJobFirstRun) && Objects.equals(this.taskUpdatePriorityJobRunEvery, other.taskUpdatePriorityJobRunEvery) && Objects.equals(this.userRefreshJobFirstRun, other.userRefreshJobFirstRun) && Objects.equals(this.userRefreshJobRunEvery, other.userRefreshJobRunEvery) && Objects.equals(this.customJobs, other.customJobs) && Objects.equals(this.minimalPermissionsToAssignDomains, other.minimalPermissionsToAssignDomains) && Objects.equals(this.properties, other.properties);
    }

    public String toString() {
        return "TaskanaConfiguration [dataSource=" + this.dataSource + ", useManagedTransactions=" + this.useManagedTransactions + ", schemaName=" + this.schemaName + ", securityEnabled=" + this.securityEnabled + ", domains=" + this.domains + ", enforceServiceLevel=" + this.enforceServiceLevel + ", roleMap=" + this.roleMap + ", classificationTypes=" + this.classificationTypes + ", classificationCategoriesByType=" + this.classificationCategoriesByType + ", workingTimeSchedule=" + this.workingTimeSchedule + ", workingTimeScheduleTimeZone=" + this.workingTimeScheduleTimeZone + ", customHolidays=" + this.customHolidays + ", germanPublicHolidaysEnabled=" + this.germanPublicHolidaysEnabled + ", germanPublicHolidaysCorpusChristiEnabled=" + this.germanPublicHolidaysCorpusChristiEnabled + ", deleteHistoryEventsOnTaskDeletionEnabled=" + this.deleteHistoryEventsOnTaskDeletionEnabled + ", logHistoryLoggerName=" + this.logHistoryLoggerName + ", jobSchedulerEnabled=" + this.jobSchedulerEnabled + ", jobSchedulerInitialStartDelay=" + this.jobSchedulerInitialStartDelay + ", jobSchedulerPeriod=" + this.jobSchedulerPeriod + ", jobSchedulerPeriodTimeUnit=" + (Object)((Object)this.jobSchedulerPeriodTimeUnit) + ", maxNumberOfJobRetries=" + this.maxNumberOfJobRetries + ", jobBatchSize=" + this.jobBatchSize + ", jobFirstRun=" + this.jobFirstRun + ", jobRunEvery=" + this.jobRunEvery + ", taskCleanupJobEnabled=" + this.taskCleanupJobEnabled + ", taskCleanupJobMinimumAge=" + this.taskCleanupJobMinimumAge + ", taskCleanupJobAllCompletedSameParentBusiness=" + this.taskCleanupJobAllCompletedSameParentBusiness + ", workbasketCleanupJobEnabled=" + this.workbasketCleanupJobEnabled + ", simpleHistoryCleanupJobEnabled=" + this.simpleHistoryCleanupJobEnabled + ", simpleHistoryCleanupJobBatchSize=" + this.simpleHistoryCleanupJobBatchSize + ", simpleHistoryCleanupJobMinimumAge=" + this.simpleHistoryCleanupJobMinimumAge + ", simpleHistoryCleanupJobAllCompletedSameParentBusiness=" + this.simpleHistoryCleanupJobAllCompletedSameParentBusiness + ", taskUpdatePriorityJobEnabled=" + this.taskUpdatePriorityJobEnabled + ", taskUpdatePriorityJobBatchSize=" + this.taskUpdatePriorityJobBatchSize + ", taskUpdatePriorityJobFirstRun=" + this.taskUpdatePriorityJobFirstRun + ", taskUpdatePriorityJobRunEvery=" + this.taskUpdatePriorityJobRunEvery + ", userInfoRefreshJobEnabled=" + this.userInfoRefreshJobEnabled + ", userRefreshJobFirstRun=" + this.userRefreshJobFirstRun + ", userRefreshJobRunEvery=" + this.userRefreshJobRunEvery + ", customJobs=" + this.customJobs + ", addAdditionalUserInfo=" + this.addAdditionalUserInfo + ", minimalPermissionsToAssignDomains=" + this.minimalPermissionsToAssignDomains + ", useSpecificDb2Taskquery=" + this.useSpecificDb2Taskquery + ", properties=" + this.properties + "]";
    }

    /* synthetic */ TaskanaConfiguration(Builder builder, TaskanaConfiguration taskanaConfiguration) {
        this(builder);
    }

    static {
        TaskanaConfiguration.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskanaConfiguration.java", TaskanaConfiguration.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "shouldUseLowerCaseForAccessIds", "pro.taskana.TaskanaConfiguration", "", "", "", "boolean"), 213);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAllClassificationCategories", "pro.taskana.TaskanaConfiguration", "", "", "", "java.util.List"), 217);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRoleMap", "pro.taskana.TaskanaConfiguration", "", "", "", "java.util.Map"), 257);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationTypes", "pro.taskana.TaskanaConfiguration", "", "", "", "java.util.List"), 261);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkingTimeSchedule", "pro.taskana.TaskanaConfiguration", "", "", "", "java.util.Map"), 265);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkingTimeScheduleTimeZone", "pro.taskana.TaskanaConfiguration", "", "", "", "java.time.ZoneId"), 269);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustomHolidays", "pro.taskana.TaskanaConfiguration", "", "", "", "java.util.Set"), 273);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isGermanPublicHolidaysEnabled", "pro.taskana.TaskanaConfiguration", "", "", "", "boolean"), 277);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isGermanPublicHolidaysCorpusChristiEnabled", "pro.taskana.TaskanaConfiguration", "", "", "", "boolean"), 281);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isDeleteHistoryEventsOnTaskDeletionEnabled", "pro.taskana.TaskanaConfiguration", "", "", "", "boolean"), 285);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLogHistoryLoggerName", "pro.taskana.TaskanaConfiguration", "", "", "", "java.lang.String"), 289);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isJobSchedulerEnabled", "pro.taskana.TaskanaConfiguration", "", "", "", "boolean"), 293);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationCategoriesByType", "pro.taskana.TaskanaConfiguration", "java.lang.String", "type", "", "java.util.List"), 223);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJobSchedulerInitialStartDelay", "pro.taskana.TaskanaConfiguration", "", "", "", "long"), 297);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJobSchedulerPeriod", "pro.taskana.TaskanaConfiguration", "", "", "", "long"), 301);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJobSchedulerPeriodTimeUnit", "pro.taskana.TaskanaConfiguration", "", "", "", "java.util.concurrent.TimeUnit"), 305);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxNumberOfJobRetries", "pro.taskana.TaskanaConfiguration", "", "", "", "int"), 309);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJobBatchSize", "pro.taskana.TaskanaConfiguration", "", "", "", "int"), 313);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJobFirstRun", "pro.taskana.TaskanaConfiguration", "", "", "", "java.time.Instant"), 317);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJobRunEvery", "pro.taskana.TaskanaConfiguration", "", "", "", "java.time.Duration"), 321);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isTaskCleanupJobEnabled", "pro.taskana.TaskanaConfiguration", "", "", "", "boolean"), 325);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskCleanupJobMinimumAge", "pro.taskana.TaskanaConfiguration", "", "", "", "java.time.Duration"), 329);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isTaskCleanupJobAllCompletedSameParentBusiness", "pro.taskana.TaskanaConfiguration", "", "", "", "boolean"), 333);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationCategoriesByType", "pro.taskana.TaskanaConfiguration", "", "", "", "java.util.Map"), 227);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isWorkbasketCleanupJobEnabled", "pro.taskana.TaskanaConfiguration", "", "", "", "boolean"), 337);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSimpleHistoryCleanupJobEnabled", "pro.taskana.TaskanaConfiguration", "", "", "", "boolean"), 341);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSimpleHistoryCleanupJobBatchSize", "pro.taskana.TaskanaConfiguration", "", "", "", "int"), 345);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSimpleHistoryCleanupJobMinimumAge", "pro.taskana.TaskanaConfiguration", "", "", "", "java.time.Duration"), 349);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSimpleHistoryCleanupJobAllCompletedSameParentBusiness", "pro.taskana.TaskanaConfiguration", "", "", "", "boolean"), 353);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isTaskUpdatePriorityJobEnabled", "pro.taskana.TaskanaConfiguration", "", "", "", "boolean"), 357);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskUpdatePriorityJobBatchSize", "pro.taskana.TaskanaConfiguration", "", "", "", "int"), 361);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskUpdatePriorityJobFirstRun", "pro.taskana.TaskanaConfiguration", "", "", "", "java.time.Instant"), 365);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskUpdatePriorityJobRunEvery", "pro.taskana.TaskanaConfiguration", "", "", "", "java.time.Duration"), 369);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isUserInfoRefreshJobEnabled", "pro.taskana.TaskanaConfiguration", "", "", "", "boolean"), 373);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDataSource", "pro.taskana.TaskanaConfiguration", "", "", "", "javax.sql.DataSource"), 233);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserRefreshJobFirstRun", "pro.taskana.TaskanaConfiguration", "", "", "", "java.time.Instant"), 377);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserRefreshJobRunEvery", "pro.taskana.TaskanaConfiguration", "", "", "", "java.time.Duration"), 381);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustomJobs", "pro.taskana.TaskanaConfiguration", "", "", "", "java.util.Set"), 385);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isAddAdditionalUserInfo", "pro.taskana.TaskanaConfiguration", "", "", "", "boolean"), 389);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMinimalPermissionsToAssignDomains", "pro.taskana.TaskanaConfiguration", "", "", "", "java.util.Set"), 393);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isUseSpecificDb2Taskquery", "pro.taskana.TaskanaConfiguration", "", "", "", "boolean"), 397);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getProperties", "pro.taskana.TaskanaConfiguration", "", "", "", "java.util.Map"), 408);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isUseManagedTransactions", "pro.taskana.TaskanaConfiguration", "", "", "", "boolean"), 237);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSchemaName", "pro.taskana.TaskanaConfiguration", "", "", "", "java.lang.String"), 241);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSecurityEnabled", "pro.taskana.TaskanaConfiguration", "", "", "", "boolean"), 245);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDomains", "pro.taskana.TaskanaConfiguration", "", "", "", "java.util.List"), 249);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isEnforceServiceLevel", "pro.taskana.TaskanaConfiguration", "", "", "", "boolean"), 253);
    }

    public static class Builder {
        private static final Logger LOGGER;
        private static final String DEFAULT_TASKANA_PROPERTIES = "/taskana.properties";
        private static final String DEFAULT_TASKANA_PROPERTY_SEPARATOR = "|";
        private final DataSource dataSource;
        private final boolean useManagedTransactions;
        private final String schemaName;
        private final boolean securityEnabled;
        @TaskanaProperty(value="taskana.domains")
        private List<String> domains = new ArrayList<String>();
        @TaskanaProperty(value="taskana.servicelevel.validation.enforce")
        private boolean enforceServiceLevel = true;
        @TaskanaProperty(value="taskana.roles")
        private Map<TaskanaRole, Set<String>> roleMap = new EnumMap<TaskanaRole, Set<String>>(TaskanaRole.class);
        @TaskanaProperty(value="taskana.classification.types")
        private List<String> classificationTypes = new ArrayList<String>();
        @TaskanaProperty(value="taskana.classification.categories")
        private Map<String, List<String>> classificationCategoriesByType = new HashMap<String, List<String>>();
        @TaskanaProperty(value="taskana.workingTime.schedule")
        private Map<DayOfWeek, Set<LocalTimeInterval>> workingTimeSchedule = Builder.initDefaultWorkingTimeSchedule();
        @TaskanaProperty(value="taskana.workingTime.timezone")
        private ZoneId workingTimeScheduleTimeZone = ZoneId.of("Europe/Berlin");
        @TaskanaProperty(value="taskana.workingTime.holidays.custom")
        private Set<CustomHoliday> customHolidays = new HashSet<CustomHoliday>();
        @TaskanaProperty(value="taskana.workingTime.holidays.german.enabled")
        private boolean germanPublicHolidaysEnabled = true;
        @TaskanaProperty(value="taskana.workingTime.holidays.german.corpus-christi.enabled")
        private boolean germanPublicHolidaysCorpusChristiEnabled = false;
        @TaskanaProperty(value="taskana.history.simple.deleteOnTaskDeletion.enabled")
        private boolean deleteHistoryEventsOnTaskDeletionEnabled = false;
        @TaskanaProperty(value="taskana.history.logger.name")
        private String logHistoryLoggerName = null;
        @TaskanaProperty(value="taskana.jobs.scheduler.enabled")
        private boolean jobSchedulerEnabled = true;
        @TaskanaProperty(value="taskana.jobs.scheduler.initialStartDelay")
        private long jobSchedulerInitialStartDelay = 100L;
        @TaskanaProperty(value="taskana.jobs.scheduler.period")
        private long jobSchedulerPeriod = 5L;
        @TaskanaProperty(value="taskana.jobs.scheduler.periodTimeUnit")
        private TimeUnit jobSchedulerPeriodTimeUnit = TimeUnit.MINUTES;
        @TaskanaProperty(value="taskana.jobs.maxRetries")
        private int maxNumberOfJobRetries = 3;
        @TaskanaProperty(value="taskana.jobs.batchSize")
        private int jobBatchSize = 100;
        @TaskanaProperty(value="taskana.jobs.firstRunAt")
        private Instant jobFirstRun = Instant.parse("2023-01-01T00:00:00Z");
        @TaskanaProperty(value="taskana.jobs.runEvery")
        private Duration jobRunEvery = Duration.ofDays(1L);
        @TaskanaProperty(value="taskana.jobs.cleanup.task.enable")
        private boolean taskCleanupJobEnabled = true;
        @TaskanaProperty(value="taskana.jobs.cleanup.task.minimumAge")
        private Duration taskCleanupJobMinimumAge = Duration.ofDays(14L);
        @TaskanaProperty(value="taskana.jobs.cleanup.task.allCompletedSameParentBusiness")
        private boolean taskCleanupJobAllCompletedSameParentBusiness = true;
        @TaskanaProperty(value="taskana.jobs.cleanup.workbasket.enable")
        private boolean workbasketCleanupJobEnabled = true;
        @TaskanaProperty(value="taskana.jobs.cleanup.history.simple.enable")
        private boolean simpleHistoryCleanupJobEnabled = false;
        @TaskanaProperty(value="taskana.jobs.cleanup.history.simple.batchSize")
        private int simpleHistoryCleanupJobBatchSize = 100;
        @TaskanaProperty(value="taskana.jobs.cleanup.history.simple.minimumAge")
        private Duration simpleHistoryCleanupJobMinimumAge = Duration.ofDays(14L);
        @TaskanaProperty(value="taskana.jobs.cleanup.history.simple.allCompletedSameParentBusiness")
        private boolean simpleHistoryCleanupJobAllCompletedSameParentBusiness = true;
        @TaskanaProperty(value="taskana.jobs.priority.task.enable")
        private boolean taskUpdatePriorityJobEnabled = false;
        @TaskanaProperty(value="taskana.jobs.priority.task.batchSize")
        private int taskUpdatePriorityJobBatchSize = 100;
        @TaskanaProperty(value="taskana.jobs.priority.task.firstRunAt")
        private Instant taskUpdatePriorityJobFirstRun = Instant.parse("2023-01-01T00:00:00Z");
        @TaskanaProperty(value="taskana.jobs.priority.task.runEvery")
        private Duration taskUpdatePriorityJobRunEvery = Duration.ofDays(1L);
        @TaskanaProperty(value="taskana.jobs.refresh.user.enable")
        private boolean userInfoRefreshJobEnabled = false;
        @TaskanaProperty(value="taskana.jobs.refresh.user.firstRunAt")
        private Instant userRefreshJobFirstRun = Instant.parse("2023-01-01T23:00:00Z");
        @TaskanaProperty(value="taskana.jobs.refresh.user.runEvery")
        private Duration userRefreshJobRunEvery = Duration.ofDays(1L);
        @TaskanaProperty(value="taskana.jobs.customJobs")
        private Set<String> customJobs = new HashSet<String>();
        @TaskanaProperty(value="taskana.user.addAdditionalUserInfo")
        private boolean addAdditionalUserInfo = false;
        @TaskanaProperty(value="taskana.user.minimalPermissionsToAssignDomains")
        private Set<WorkbasketPermission> minimalPermissionsToAssignDomains = new HashSet<WorkbasketPermission>();
        @TaskanaProperty(value="taskana.feature.useSpecificDb2Taskquery")
        private boolean useSpecificDb2Taskquery = true;
        private Map<String, String> properties = Collections.emptyMap();
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;

        static {
            Builder.ajc$preClinit();
            LOGGER = LoggerFactory.getLogger(Builder.class);
        }

        public Builder(DataSource dataSource, boolean useManagedTransactions, String schemaName) {
            this(dataSource, useManagedTransactions, schemaName, true);
        }

        public Builder(DataSource dataSource, boolean useManagedTransactions, String schemaName, boolean securityEnabled) {
            this.useManagedTransactions = useManagedTransactions;
            this.securityEnabled = securityEnabled;
            this.dataSource = Objects.requireNonNull(dataSource);
            this.schemaName = this.initSchemaName(schemaName);
        }

        public Builder(TaskanaConfiguration conf) {
            this(conf, conf.dataSource, conf.useManagedTransactions, conf.schemaName, conf.securityEnabled);
        }

        public Builder(TaskanaConfiguration conf, DataSource dataSource) {
            this(conf, dataSource, conf.useManagedTransactions, conf.schemaName, conf.securityEnabled);
        }

        public Builder(TaskanaConfiguration conf, DataSource dataSource, boolean useManagedTransactions) {
            this(conf, dataSource, useManagedTransactions, conf.schemaName, conf.securityEnabled);
        }

        public Builder(TaskanaConfiguration conf, DataSource dataSource, boolean useManagedTransactions, String schemaName) {
            this(conf, dataSource, useManagedTransactions, schemaName, conf.securityEnabled);
        }

        public Builder(TaskanaConfiguration conf, DataSource dataSource, boolean useManagedTransactions, String schemaName, boolean securityEnabled) {
            this.dataSource = dataSource;
            this.useManagedTransactions = useManagedTransactions;
            this.schemaName = this.initSchemaName(schemaName);
            this.securityEnabled = securityEnabled;
            this.domains = conf.domains;
            this.enforceServiceLevel = conf.enforceServiceLevel;
            this.roleMap = conf.roleMap;
            this.classificationTypes = conf.classificationTypes;
            this.classificationCategoriesByType = conf.classificationCategoriesByType;
            this.workingTimeSchedule = conf.workingTimeSchedule;
            this.workingTimeScheduleTimeZone = conf.workingTimeScheduleTimeZone;
            this.customHolidays = conf.customHolidays;
            this.germanPublicHolidaysEnabled = conf.germanPublicHolidaysEnabled;
            this.germanPublicHolidaysCorpusChristiEnabled = conf.germanPublicHolidaysCorpusChristiEnabled;
            this.deleteHistoryEventsOnTaskDeletionEnabled = conf.deleteHistoryEventsOnTaskDeletionEnabled;
            this.logHistoryLoggerName = conf.logHistoryLoggerName;
            this.jobSchedulerEnabled = conf.jobSchedulerEnabled;
            this.jobSchedulerInitialStartDelay = conf.jobSchedulerInitialStartDelay;
            this.jobSchedulerPeriod = conf.jobSchedulerPeriod;
            this.jobSchedulerPeriodTimeUnit = conf.jobSchedulerPeriodTimeUnit;
            this.maxNumberOfJobRetries = conf.maxNumberOfJobRetries;
            this.jobBatchSize = conf.jobBatchSize;
            this.jobFirstRun = conf.jobFirstRun;
            this.jobRunEvery = conf.jobRunEvery;
            this.taskCleanupJobEnabled = conf.taskCleanupJobEnabled;
            this.taskCleanupJobMinimumAge = conf.taskCleanupJobMinimumAge;
            this.taskCleanupJobAllCompletedSameParentBusiness = conf.taskCleanupJobAllCompletedSameParentBusiness;
            this.workbasketCleanupJobEnabled = conf.workbasketCleanupJobEnabled;
            this.simpleHistoryCleanupJobEnabled = conf.simpleHistoryCleanupJobEnabled;
            this.simpleHistoryCleanupJobBatchSize = conf.simpleHistoryCleanupJobBatchSize;
            this.simpleHistoryCleanupJobMinimumAge = conf.simpleHistoryCleanupJobMinimumAge;
            this.simpleHistoryCleanupJobAllCompletedSameParentBusiness = conf.simpleHistoryCleanupJobAllCompletedSameParentBusiness;
            this.taskUpdatePriorityJobEnabled = conf.taskUpdatePriorityJobEnabled;
            this.taskUpdatePriorityJobBatchSize = conf.taskUpdatePriorityJobBatchSize;
            this.taskUpdatePriorityJobFirstRun = conf.taskUpdatePriorityJobFirstRun;
            this.taskUpdatePriorityJobRunEvery = conf.taskUpdatePriorityJobRunEvery;
            this.userInfoRefreshJobEnabled = conf.userInfoRefreshJobEnabled;
            this.userRefreshJobFirstRun = conf.userRefreshJobFirstRun;
            this.userRefreshJobRunEvery = conf.userRefreshJobRunEvery;
            this.customJobs = conf.customJobs;
            this.addAdditionalUserInfo = conf.addAdditionalUserInfo;
            this.minimalPermissionsToAssignDomains = conf.minimalPermissionsToAssignDomains;
            this.useSpecificDb2Taskquery = conf.useSpecificDb2Taskquery;
            this.properties = conf.properties;
        }

        public Builder initTaskanaProperties() {
            Builder builder;
            Builder builder2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Builder builder3 = builder2 = (builder = this.initTaskanaProperties(DEFAULT_TASKANA_PROPERTIES, DEFAULT_TASKANA_PROPERTY_SEPARATOR));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder initTaskanaProperties(String propertiesFile) {
            Builder builder;
            Builder builder2;
            String string = propertiesFile;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Builder builder3 = builder2 = (builder = this.initTaskanaProperties(propertiesFile, DEFAULT_TASKANA_PROPERTY_SEPARATOR));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder initTaskanaProperties(String propertiesFile, String separator) {
            Builder builder;
            Builder builder2;
            String string = propertiesFile;
            String string2 = separator;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)string2);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            if (propertiesFile == null || propertiesFile.isEmpty() || propertiesFile.isBlank()) {
                throw new SystemException("property file can't be null or empty");
            }
            if (separator == null || separator.isEmpty() || separator.isBlank()) {
                throw new SystemException("separator file can't be null or empty");
            }
            LOGGER.debug("Reading taskana configuration from {} with separator {}", (Object)propertiesFile, (Object)separator);
            this.properties = this.loadProperties(propertiesFile);
            this.configureAnnotatedFields(separator, this.properties);
            this.addMasterDomain();
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder domains(List<String> domains) {
            Builder builder;
            Builder builder2;
            List<String> list = domains;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, list);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.domains = domains;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder enforceServiceLevel(boolean enforceServiceLevel) {
            Builder builder;
            Builder builder2;
            boolean bl = enforceServiceLevel;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.enforceServiceLevel = enforceServiceLevel;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder roleMap(Map<TaskanaRole, Set<String>> roleMap) {
            Builder builder;
            Builder builder2;
            Map<TaskanaRole, Set<String>> map = roleMap;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, map);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.roleMap = roleMap;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder classificationTypes(List<String> classificationTypes) {
            Builder builder;
            Builder builder2;
            List<String> list = classificationTypes;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, list);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.classificationTypes = classificationTypes;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder classificationCategoriesByType(Map<String, List<String>> classificationCategoriesByType) {
            Builder builder;
            Builder builder2;
            Map<String, List<String>> map = classificationCategoriesByType;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, map);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.classificationCategoriesByType = classificationCategoriesByType;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder workingTimeSchedule(Map<DayOfWeek, Set<LocalTimeInterval>> workingTimeSchedule) {
            Builder builder;
            Builder builder2;
            Map<DayOfWeek, Set<LocalTimeInterval>> map = workingTimeSchedule;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, map);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.workingTimeSchedule = workingTimeSchedule;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder workingTimeScheduleTimeZone(ZoneId workingTimeScheduleTimeZone) {
            Builder builder;
            Builder builder2;
            ZoneId zoneId = workingTimeScheduleTimeZone;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)zoneId);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.workingTimeScheduleTimeZone = workingTimeScheduleTimeZone;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder customHolidays(Set<CustomHoliday> customHolidays) {
            Builder builder;
            Builder builder2;
            Set<CustomHoliday> set = customHolidays;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, set);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.customHolidays = customHolidays;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder germanPublicHolidaysEnabled(boolean germanPublicHolidaysEnabled) {
            Builder builder;
            Builder builder2;
            boolean bl = germanPublicHolidaysEnabled;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.germanPublicHolidaysEnabled = germanPublicHolidaysEnabled;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder germanPublicHolidaysCorpusChristiEnabled(boolean germanPublicHolidaysCorpusChristiEnabled) {
            Builder builder;
            Builder builder2;
            boolean bl = germanPublicHolidaysCorpusChristiEnabled;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.germanPublicHolidaysCorpusChristiEnabled = germanPublicHolidaysCorpusChristiEnabled;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder deleteHistoryEventsOnTaskDeletionEnabled(boolean deleteHistoryEventsOnTaskDeletionEnabled) {
            Builder builder;
            Builder builder2;
            boolean bl = deleteHistoryEventsOnTaskDeletionEnabled;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.deleteHistoryEventsOnTaskDeletionEnabled = deleteHistoryEventsOnTaskDeletionEnabled;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder logHistoryLoggerName(String loggerName) {
            Builder builder;
            Builder builder2;
            String string = loggerName;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.logHistoryLoggerName = loggerName;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder jobSchedulerEnabled(boolean jobSchedulerEnabled) {
            Builder builder;
            Builder builder2;
            boolean bl = jobSchedulerEnabled;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.jobSchedulerEnabled = jobSchedulerEnabled;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder jobSchedulerInitialStartDelay(long jobSchedulerInitialStartDelay) {
            Builder builder;
            Builder builder2;
            long l = jobSchedulerInitialStartDelay;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.jobSchedulerInitialStartDelay = jobSchedulerInitialStartDelay;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder jobSchedulerPeriod(long jobSchedulerPeriod) {
            Builder builder;
            Builder builder2;
            long l = jobSchedulerPeriod;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.jobSchedulerPeriod = jobSchedulerPeriod;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder jobSchedulerPeriodTimeUnit(TimeUnit jobSchedulerPeriodTimeUnit) {
            Builder builder;
            Builder builder2;
            TimeUnit timeUnit = jobSchedulerPeriodTimeUnit;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)((Object)timeUnit));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.jobSchedulerPeriodTimeUnit = jobSchedulerPeriodTimeUnit;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder maxNumberOfJobRetries(int maxNumberOfJobRetries) {
            Builder builder;
            Builder builder2;
            int n = maxNumberOfJobRetries;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.maxNumberOfJobRetries = maxNumberOfJobRetries;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder jobBatchSize(int jobBatchSize) {
            Builder builder;
            Builder builder2;
            int n = jobBatchSize;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.jobBatchSize = jobBatchSize;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder jobFirstRun(Instant jobFirstRun) {
            Builder builder;
            Builder builder2;
            Instant instant = jobFirstRun;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)instant);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.jobFirstRun = jobFirstRun;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder jobRunEvery(Duration jobRunEvery) {
            Builder builder;
            Builder builder2;
            Duration duration = jobRunEvery;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object)duration);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.jobRunEvery = jobRunEvery;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder taskCleanupJobEnabled(boolean taskCleanupJobEnabled) {
            Builder builder;
            Builder builder2;
            boolean bl = taskCleanupJobEnabled;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.taskCleanupJobEnabled = taskCleanupJobEnabled;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder taskCleanupJobMinimumAge(Duration taskCleanupJobMinimumAge) {
            Builder builder;
            Builder builder2;
            Duration duration = taskCleanupJobMinimumAge;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)duration);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.taskCleanupJobMinimumAge = taskCleanupJobMinimumAge;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder taskCleanupJobAllCompletedSameParentBusiness(boolean taskCleanupJobAllCompletedSameParentBusiness) {
            Builder builder;
            Builder builder2;
            boolean bl = taskCleanupJobAllCompletedSameParentBusiness;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.taskCleanupJobAllCompletedSameParentBusiness = taskCleanupJobAllCompletedSameParentBusiness;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder workbasketCleanupJobEnabled(boolean workbasketCleanupJobEnabled) {
            Builder builder;
            Builder builder2;
            boolean bl = workbasketCleanupJobEnabled;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.workbasketCleanupJobEnabled = workbasketCleanupJobEnabled;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder simpleHistoryCleanupJobEnabled(boolean simpleHistoryCleanupJobEnabled) {
            Builder builder;
            Builder builder2;
            boolean bl = simpleHistoryCleanupJobEnabled;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.simpleHistoryCleanupJobEnabled = simpleHistoryCleanupJobEnabled;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder simpleHistoryCleanupJobBatchSize(int simpleHistoryCleanupJobBatchSize) {
            Builder builder;
            Builder builder2;
            int n = simpleHistoryCleanupJobBatchSize;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.simpleHistoryCleanupJobBatchSize = simpleHistoryCleanupJobBatchSize;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder simpleHistoryCleanupJobMinimumAge(Duration simpleHistoryCleanupJobMinimumAge) {
            Builder builder;
            Builder builder2;
            Duration duration = simpleHistoryCleanupJobMinimumAge;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object)duration);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.simpleHistoryCleanupJobMinimumAge = simpleHistoryCleanupJobMinimumAge;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder simpleHistoryCleanupJobAllCompletedSameParentBusiness(boolean simpleHistoryCleanupJobAllCompletedSameParentBusiness) {
            Builder builder;
            Builder builder2;
            boolean bl = simpleHistoryCleanupJobAllCompletedSameParentBusiness;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.simpleHistoryCleanupJobAllCompletedSameParentBusiness = simpleHistoryCleanupJobAllCompletedSameParentBusiness;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder taskUpdatePriorityJobEnabled(boolean taskUpdatePriorityJobEnabled) {
            Builder builder;
            Builder builder2;
            boolean bl = taskUpdatePriorityJobEnabled;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.taskUpdatePriorityJobEnabled = taskUpdatePriorityJobEnabled;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder taskUpdatePriorityJobBatchSize(int priorityJobBatchSize) {
            Builder builder;
            Builder builder2;
            int n = priorityJobBatchSize;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.taskUpdatePriorityJobBatchSize = priorityJobBatchSize;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder taskUpdatePriorityJobFirstRun(Instant taskUpdatePriorityJobFirstRun) {
            Builder builder;
            Builder builder2;
            Instant instant = taskUpdatePriorityJobFirstRun;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this, (Object)instant);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.taskUpdatePriorityJobFirstRun = taskUpdatePriorityJobFirstRun;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder taskUpdatePriorityJobRunEvery(Duration taskUpdatePriorityJobRunEvery) {
            Builder builder;
            Builder builder2;
            Duration duration = taskUpdatePriorityJobRunEvery;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object)duration);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.taskUpdatePriorityJobRunEvery = taskUpdatePriorityJobRunEvery;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder userInfoRefreshJobEnabled(boolean userInfoRefreshJobEnabled) {
            Builder builder;
            Builder builder2;
            boolean bl = userInfoRefreshJobEnabled;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.userInfoRefreshJobEnabled = userInfoRefreshJobEnabled;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder userRefreshJobFirstRun(Instant userRefreshJobFirstRun) {
            Builder builder;
            Builder builder2;
            Instant instant = userRefreshJobFirstRun;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)instant);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.userRefreshJobFirstRun = userRefreshJobFirstRun;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder userRefreshJobRunEvery(Duration userRefreshJobRunEvery) {
            Builder builder;
            Builder builder2;
            Duration duration = userRefreshJobRunEvery;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, (Object)duration);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.userRefreshJobRunEvery = userRefreshJobRunEvery;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder customJobs(Set<String> customJobs) {
            Builder builder;
            Builder builder2;
            Set<String> set = customJobs;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, set);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.customJobs = customJobs;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder addAdditionalUserInfo(boolean addAdditionalUserInfo) {
            Builder builder;
            Builder builder2;
            boolean bl = addAdditionalUserInfo;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.addAdditionalUserInfo = addAdditionalUserInfo;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder minimalPermissionsToAssignDomains(Set<WorkbasketPermission> minimalPermissionsToAssignDomains) {
            Builder builder;
            Builder builder2;
            Set<WorkbasketPermission> set = minimalPermissionsToAssignDomains;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, set);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.minimalPermissionsToAssignDomains = minimalPermissionsToAssignDomains;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder useSpecificDb2Taskquery(boolean useSpecificDb2Taskquery) {
            Builder builder;
            Builder builder2;
            boolean bl = useSpecificDb2Taskquery;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.useSpecificDb2Taskquery = useSpecificDb2Taskquery;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public TaskanaConfiguration build() {
            TaskanaConfiguration taskanaConfiguration;
            TaskanaConfiguration taskanaConfiguration2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.adjustConfiguration();
            this.validateConfiguration();
            TaskanaConfiguration taskanaConfiguration3 = taskanaConfiguration2 = (taskanaConfiguration = new TaskanaConfiguration(this, null));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskanaConfiguration2);
            return taskanaConfiguration;
        }

        private void addMasterDomain() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            if (!this.domains.contains(SharedConstants.MASTER_DOMAIN)) {
                this.domains.add(SharedConstants.MASTER_DOMAIN);
            }
            Object var2_2 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
        }

        private void configureAnnotatedFields(String separator, Map<String, String> props) {
            String string = separator;
            Map<String, String> map = props;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this, (Object)string, map);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            List fields = ReflectionUtil.retrieveAllFields(this.getClass());
            for (Field field : fields) {
                Optional.ofNullable(field.getAnnotation(TaskanaProperty.class)).flatMap(taskanaProperty -> PropertyParser.getPropertyParser(field.getType()).parse(props, separator, field, taskanaProperty)).ifPresent(value -> this.setFieldValue(field, value));
            }
            Object var9_9 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
        }

        private void setFieldValue(Field field, Object value) {
            Field field2 = field;
            Object object = value;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this, (Object)field2, (Object)object);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            try {
                field.set(this, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new SystemException(String.format("Property value '%s' is invalid for field '%s'", value, field.getName()), (Throwable)e);
            }
            Object var7_7 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_7);
        }

        private void adjustConfiguration() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.domains = this.domains.stream().map(String::toUpperCase).collect(Collectors.toList());
            this.classificationTypes = this.classificationTypes.stream().map(String::toUpperCase).collect(Collectors.toList());
            this.classificationCategoriesByType = this.classificationCategoriesByType.entrySet().stream().map(e -> Map.entry(((String)e.getKey()).toUpperCase(), ((List)e.getValue()).stream().map(String::toUpperCase).collect(Collectors.toList()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.roleMap = Arrays.stream(TaskanaRole.values()).map(role -> Pair.of((Object)role, this.roleMap.getOrDefault(role, Set.of()))).map(pair -> {
                if (TaskanaConfiguration.shouldUseLowerCaseForAccessIds()) {
                    return Pair.of((Object)((TaskanaRole)pair.getLeft()), ((Set)pair.getRight()).stream().map(String::toLowerCase).collect(Collectors.toSet()));
                }
                return pair;
            }).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
            Object var2_2 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
        }

        private void validateConfiguration() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            if (this.jobBatchSize <= 0) {
                throw new InvalidArgumentException("Parameter jobBatchSize (taskana.jobs.batchSize) must be a positive integer");
            }
            if (this.maxNumberOfJobRetries <= 0) {
                throw new InvalidArgumentException("Parameter maxNumberOfJobRetries (taskana.jobs.maxRetries) must be a positive integer");
            }
            if (this.jobRunEvery == null || this.jobRunEvery.isNegative() || this.jobRunEvery.isZero()) {
                throw new InvalidArgumentException("Parameter jobRunEvery (taskana.jobs.runEvery) must be a positive duration");
            }
            if (this.simpleHistoryCleanupJobMinimumAge == null || this.simpleHistoryCleanupJobMinimumAge.isNegative()) {
                throw new InvalidArgumentException("Parameter simpleHistoryCleanupJobMinimumAge (taskana.jobs.cleanup.history.simple.minimumAge) must not be negative");
            }
            if (this.taskCleanupJobMinimumAge == null || this.taskCleanupJobMinimumAge.isNegative()) {
                throw new InvalidArgumentException("Parameter taskCleanupJobMinimumAge (taskana.jobs.cleanup.task.minimumAge) must not be negative");
            }
            if (this.taskUpdatePriorityJobBatchSize <= 0) {
                throw new InvalidArgumentException("Parameter taskUpdatePriorityJobBatchSize (taskana.jobs.priority.task.batchSize) must be a positive integer");
            }
            if (this.taskUpdatePriorityJobRunEvery == null || this.taskUpdatePriorityJobRunEvery.isNegative() || this.taskUpdatePriorityJobRunEvery.isZero()) {
                throw new InvalidArgumentException("Parameter taskUpdatePriorityJobRunEvery (taskana.jobs.priority.task.runEvery) must be a positive duration");
            }
            if (this.userRefreshJobRunEvery == null || this.userRefreshJobRunEvery.isNegative() || this.userRefreshJobRunEvery.isZero()) {
                throw new InvalidArgumentException("Parameter userRefreshJobRunEvery (taskana.jobs.refresh.user.runEvery) must be a positive duration");
            }
            if (this.jobSchedulerInitialStartDelay < 0L) {
                throw new InvalidArgumentException("Parameter jobSchedulerInitialStartDelay (taskana.jobs.scheduler.initialStartDelay) must be a natural integer");
            }
            if (this.jobSchedulerPeriod <= 0L) {
                throw new InvalidArgumentException("Parameter jobSchedulerPeriod (taskana.jobs.scheduler.period) must be a positive integer");
            }
            if (!new HashSet<String>(this.classificationTypes).containsAll(this.classificationCategoriesByType.keySet())) {
                throw new InvalidArgumentException(String.format("Parameter classificationCategoriesByType (taskana.classification.categories.<KEY>) contains invalid Classification Types. configured: %s detected: %s", this.classificationTypes, this.classificationCategoriesByType.keySet()));
            }
            if (!this.classificationCategoriesByType.keySet().containsAll(this.classificationTypes)) {
                throw new InvalidArgumentException(String.format("Some Classification Categories for parameter classificationTypes (taskana.classification.types) are missing. configured: %s detected: %s", this.classificationTypes, this.classificationCategoriesByType.keySet()));
            }
            Object var2_2 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
        }

        /*
         * Exception decompiling
         */
        private String initSchemaName(String schemaName) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private Map<String, String> loadProperties(String propertiesFile) {
            Map<String, String> map;
            Map<String, String> map2;
            String string = propertiesFile;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Properties props = new Properties();
            try {
                Throwable throwable = null;
                Object var4_8 = null;
                try (InputStream stream = FileLoaderUtil.openFileFromClasspathOrSystem((String)propertiesFile, TaskanaConfiguration.class);){
                    props.load(stream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e2) {
                throw new SystemException(String.format("Could not process properties file '%s'", propertiesFile), (Throwable)e2);
            }
            Map<String, String> map3 = map2 = (map = props.entrySet().stream().collect(Collectors.toUnmodifiableMap(e -> e.getKey().toString(), e -> e.getValue().toString())));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
            return map;
        }

        private static Map<DayOfWeek, Set<LocalTimeInterval>> initDefaultWorkingTimeSchedule() {
            EnumMap<DayOfWeek, Set<LocalTimeInterval>> enumMap;
            EnumMap<DayOfWeek, Set<LocalTimeInterval>> enumMap2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, null, null);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            EnumMap<DayOfWeek, Set<LocalTimeInterval>> workingTime = new EnumMap<DayOfWeek, Set<LocalTimeInterval>>(DayOfWeek.class);
            Set<LocalTimeInterval> standardWorkingSlots = Set.of(new LocalTimeInterval(LocalTime.MIN, LocalTime.MAX));
            workingTime.put(DayOfWeek.MONDAY, standardWorkingSlots);
            workingTime.put(DayOfWeek.TUESDAY, standardWorkingSlots);
            workingTime.put(DayOfWeek.WEDNESDAY, standardWorkingSlots);
            workingTime.put(DayOfWeek.THURSDAY, standardWorkingSlots);
            workingTime.put(DayOfWeek.FRIDAY, standardWorkingSlots);
            EnumMap<DayOfWeek, Set<LocalTimeInterval>> enumMap3 = enumMap2 = (enumMap = workingTime);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, enumMap2);
            return enumMap;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskanaConfiguration.java", Builder.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initTaskanaProperties", "pro.taskana.TaskanaConfiguration$Builder", "", "", "", "pro.taskana.TaskanaConfiguration$Builder"), 881);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initTaskanaProperties", "pro.taskana.TaskanaConfiguration$Builder", "java.lang.String", "propertiesFile", "", "pro.taskana.TaskanaConfiguration$Builder"), 892);
            ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "customHolidays", "pro.taskana.TaskanaConfiguration$Builder", "java.util.Set", "customHolidays", "", "pro.taskana.TaskanaConfiguration$Builder"), 977);
            ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "germanPublicHolidaysEnabled", "pro.taskana.TaskanaConfiguration$Builder", "boolean", "germanPublicHolidaysEnabled", "", "pro.taskana.TaskanaConfiguration$Builder"), 982);
            ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "germanPublicHolidaysCorpusChristiEnabled", "pro.taskana.TaskanaConfiguration$Builder", "boolean", "germanPublicHolidaysCorpusChristiEnabled", "", "pro.taskana.TaskanaConfiguration$Builder"), 987);
            ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteHistoryEventsOnTaskDeletionEnabled", "pro.taskana.TaskanaConfiguration$Builder", "boolean", "deleteHistoryEventsOnTaskDeletionEnabled", "", "pro.taskana.TaskanaConfiguration$Builder"), 997);
            ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logHistoryLoggerName", "pro.taskana.TaskanaConfiguration$Builder", "java.lang.String", "loggerName", "", "pro.taskana.TaskanaConfiguration$Builder"), 1003);
            ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "jobSchedulerEnabled", "pro.taskana.TaskanaConfiguration$Builder", "boolean", "jobSchedulerEnabled", "", "pro.taskana.TaskanaConfiguration$Builder"), 1012);
            ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "jobSchedulerInitialStartDelay", "pro.taskana.TaskanaConfiguration$Builder", "long", "jobSchedulerInitialStartDelay", "", "pro.taskana.TaskanaConfiguration$Builder"), 1017);
            ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "jobSchedulerPeriod", "pro.taskana.TaskanaConfiguration$Builder", "long", "jobSchedulerPeriod", "", "pro.taskana.TaskanaConfiguration$Builder"), 1022);
            ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "jobSchedulerPeriodTimeUnit", "pro.taskana.TaskanaConfiguration$Builder", "java.util.concurrent.TimeUnit", "jobSchedulerPeriodTimeUnit", "", "pro.taskana.TaskanaConfiguration$Builder"), 1027);
            ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "maxNumberOfJobRetries", "pro.taskana.TaskanaConfiguration$Builder", "int", "maxNumberOfJobRetries", "", "pro.taskana.TaskanaConfiguration$Builder"), 1032);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initTaskanaProperties", "pro.taskana.TaskanaConfiguration$Builder", "java.lang.String:java.lang.String", "propertiesFile:separator", "", "pro.taskana.TaskanaConfiguration$Builder"), 909);
            ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "jobBatchSize", "pro.taskana.TaskanaConfiguration$Builder", "int", "jobBatchSize", "", "pro.taskana.TaskanaConfiguration$Builder"), 1037);
            ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "jobFirstRun", "pro.taskana.TaskanaConfiguration$Builder", "java.time.Instant", "jobFirstRun", "", "pro.taskana.TaskanaConfiguration$Builder"), 1042);
            ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "jobRunEvery", "pro.taskana.TaskanaConfiguration$Builder", "java.time.Duration", "jobRunEvery", "", "pro.taskana.TaskanaConfiguration$Builder"), 1047);
            ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "taskCleanupJobEnabled", "pro.taskana.TaskanaConfiguration$Builder", "boolean", "taskCleanupJobEnabled", "", "pro.taskana.TaskanaConfiguration$Builder"), 1052);
            ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "taskCleanupJobMinimumAge", "pro.taskana.TaskanaConfiguration$Builder", "java.time.Duration", "taskCleanupJobMinimumAge", "", "pro.taskana.TaskanaConfiguration$Builder"), 1057);
            ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "taskCleanupJobAllCompletedSameParentBusiness", "pro.taskana.TaskanaConfiguration$Builder", "boolean", "taskCleanupJobAllCompletedSameParentBusiness", "", "pro.taskana.TaskanaConfiguration$Builder"), 1062);
            ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "workbasketCleanupJobEnabled", "pro.taskana.TaskanaConfiguration$Builder", "boolean", "workbasketCleanupJobEnabled", "", "pro.taskana.TaskanaConfiguration$Builder"), 1069);
            ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "simpleHistoryCleanupJobEnabled", "pro.taskana.TaskanaConfiguration$Builder", "boolean", "simpleHistoryCleanupJobEnabled", "", "pro.taskana.TaskanaConfiguration$Builder"), 1074);
            ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "simpleHistoryCleanupJobBatchSize", "pro.taskana.TaskanaConfiguration$Builder", "int", "simpleHistoryCleanupJobBatchSize", "", "pro.taskana.TaskanaConfiguration$Builder"), 1079);
            ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "simpleHistoryCleanupJobMinimumAge", "pro.taskana.TaskanaConfiguration$Builder", "java.time.Duration", "simpleHistoryCleanupJobMinimumAge", "", "pro.taskana.TaskanaConfiguration$Builder"), 1084);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "domains", "pro.taskana.TaskanaConfiguration$Builder", "java.util.List", "domains", "", "pro.taskana.TaskanaConfiguration$Builder"), 929);
            ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "simpleHistoryCleanupJobAllCompletedSameParentBusiness", "pro.taskana.TaskanaConfiguration$Builder", "boolean", "simpleHistoryCleanupJobAllCompletedSameParentBusiness", "", "pro.taskana.TaskanaConfiguration$Builder"), 1089);
            ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "taskUpdatePriorityJobEnabled", "pro.taskana.TaskanaConfiguration$Builder", "boolean", "taskUpdatePriorityJobEnabled", "", "pro.taskana.TaskanaConfiguration$Builder"), 1096);
            ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "taskUpdatePriorityJobBatchSize", "pro.taskana.TaskanaConfiguration$Builder", "int", "priorityJobBatchSize", "", "pro.taskana.TaskanaConfiguration$Builder"), 1101);
            ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "taskUpdatePriorityJobFirstRun", "pro.taskana.TaskanaConfiguration$Builder", "java.time.Instant", "taskUpdatePriorityJobFirstRun", "", "pro.taskana.TaskanaConfiguration$Builder"), 1106);
            ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "taskUpdatePriorityJobRunEvery", "pro.taskana.TaskanaConfiguration$Builder", "java.time.Duration", "taskUpdatePriorityJobRunEvery", "", "pro.taskana.TaskanaConfiguration$Builder"), 1111);
            ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "userInfoRefreshJobEnabled", "pro.taskana.TaskanaConfiguration$Builder", "boolean", "userInfoRefreshJobEnabled", "", "pro.taskana.TaskanaConfiguration$Builder"), 1116);
            ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "userRefreshJobFirstRun", "pro.taskana.TaskanaConfiguration$Builder", "java.time.Instant", "userRefreshJobFirstRun", "", "pro.taskana.TaskanaConfiguration$Builder"), 1121);
            ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "userRefreshJobRunEvery", "pro.taskana.TaskanaConfiguration$Builder", "java.time.Duration", "userRefreshJobRunEvery", "", "pro.taskana.TaskanaConfiguration$Builder"), 1126);
            ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "customJobs", "pro.taskana.TaskanaConfiguration$Builder", "java.util.Set", "customJobs", "", "pro.taskana.TaskanaConfiguration$Builder"), 1131);
            ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addAdditionalUserInfo", "pro.taskana.TaskanaConfiguration$Builder", "boolean", "addAdditionalUserInfo", "", "pro.taskana.TaskanaConfiguration$Builder"), 1140);
            ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "enforceServiceLevel", "pro.taskana.TaskanaConfiguration$Builder", "boolean", "enforceServiceLevel", "", "pro.taskana.TaskanaConfiguration$Builder"), 934);
            ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "minimalPermissionsToAssignDomains", "pro.taskana.TaskanaConfiguration$Builder", "java.util.Set", "minimalPermissionsToAssignDomains", "", "pro.taskana.TaskanaConfiguration$Builder"), 1145);
            ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "useSpecificDb2Taskquery", "pro.taskana.TaskanaConfiguration$Builder", "boolean", "useSpecificDb2Taskquery", "", "pro.taskana.TaskanaConfiguration$Builder"), 1153);
            ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "build", "pro.taskana.TaskanaConfiguration$Builder", "", "", "", "pro.taskana.TaskanaConfiguration"), 1158);
            ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addMasterDomain", "pro.taskana.TaskanaConfiguration$Builder", "", "", "", "void"), 1166);
            ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "configureAnnotatedFields", "pro.taskana.TaskanaConfiguration$Builder", "java.lang.String:java.util.Map", "separator:props", "", "void"), 1175);
            ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setFieldValue", "pro.taskana.TaskanaConfiguration$Builder", "java.lang.reflect.Field:java.lang.Object", "field:value", "", "void"), 1187);
            ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "adjustConfiguration", "pro.taskana.TaskanaConfiguration$Builder", "", "", "", "void"), 1197);
            ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateConfiguration", "pro.taskana.TaskanaConfiguration$Builder", "", "", "", "void"), 1228);
            ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initSchemaName", "pro.taskana.TaskanaConfiguration$Builder", "java.lang.String", "schemaName", "", "java.lang.String"), 1304);
            ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "loadProperties", "pro.taskana.TaskanaConfiguration$Builder", "java.lang.String", "propertiesFile", "", "java.util.Map"), 1322);
            ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "roleMap", "pro.taskana.TaskanaConfiguration$Builder", "java.util.Map", "roleMap", "", "pro.taskana.TaskanaConfiguration$Builder"), 943);
            ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "initDefaultWorkingTimeSchedule", "pro.taskana.TaskanaConfiguration$Builder", "", "", "", "java.util.Map"), 1338);
            ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "classificationTypes", "pro.taskana.TaskanaConfiguration$Builder", "java.util.List", "classificationTypes", "", "pro.taskana.TaskanaConfiguration$Builder"), 952);
            ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "classificationCategoriesByType", "pro.taskana.TaskanaConfiguration$Builder", "java.util.Map", "classificationCategoriesByType", "", "pro.taskana.TaskanaConfiguration$Builder"), 957);
            ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "workingTimeSchedule", "pro.taskana.TaskanaConfiguration$Builder", "java.util.Map", "workingTimeSchedule", "", "pro.taskana.TaskanaConfiguration$Builder"), 967);
            ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "workingTimeScheduleTimeZone", "pro.taskana.TaskanaConfiguration$Builder", "java.time.ZoneId", "workingTimeScheduleTimeZone", "", "pro.taskana.TaskanaConfiguration$Builder"), 972);
        }
    }
}

