package pro.taskana.spi.history.api.exceptions;

import java.util.Map;
import pro.taskana.common.api.exceptions.ErrorCode;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.spi.history.api.events.task.TaskHistoryEvent;

/**
 * This exception is thrown when the {@linkplain TaskHistoryEvent} with the specified {@linkplain
 * TaskHistoryEvent#getId() id} was not found.
 */
public class TaskanaHistoryEventNotFoundException extends TaskanaException {

  public static final String ERROR_KEY = "HISTORY_EVENT_NOT_FOUND";
  private final String historyEventId;

  public TaskanaHistoryEventNotFoundException(String historyEventId) {
    super(
        String.format("TaskHistoryEvent with id '%s' was not found", historyEventId),
        ErrorCode.of(ERROR_KEY, Map.of("historyEventId", ensureNullIsHandled(historyEventId))));
    this.historyEventId = historyEventId;
  }

  public String getHistoryEventId() {
    return historyEventId;
  }
}
