/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.internal.preprocessor;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.WorkingTimeCalculator;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.monitor.api.reports.header.TimeIntervalColumnHeader;

public class WorkingDaysToDaysReportConverter {
    private static final Logger LOGGER;
    private final WorkingTimeCalculator workingTimeCalculator;
    private final Map<Integer, Integer> cacheDaysToWorkingDays;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    static {
        WorkingDaysToDaysReportConverter.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(WorkingDaysToDaysReportConverter.class);
    }

    WorkingDaysToDaysReportConverter(List<? extends TimeIntervalColumnHeader> columnHeaders, WorkingTimeCalculator workingTimeCalculator, Instant referenceDate) {
        this.workingTimeCalculator = workingTimeCalculator;
        this.cacheDaysToWorkingDays = this.generateDaysToWorkingDays(columnHeaders, referenceDate);
    }

    public static WorkingDaysToDaysReportConverter initialize(List<? extends TimeIntervalColumnHeader> columnHeaders, WorkingTimeCalculator workingTimeCalculator) throws InvalidArgumentException {
        WorkingDaysToDaysReportConverter workingDaysToDaysReportConverter;
        WorkingDaysToDaysReportConverter workingDaysToDaysReportConverter2;
        List<? extends TimeIntervalColumnHeader> list = columnHeaders;
        WorkingTimeCalculator workingTimeCalculator2 = workingTimeCalculator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, list, (Object)workingTimeCalculator2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkingDaysToDaysReportConverter workingDaysToDaysReportConverter3 = workingDaysToDaysReportConverter2 = (workingDaysToDaysReportConverter = WorkingDaysToDaysReportConverter.initialize(columnHeaders, workingTimeCalculator, Instant.now()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workingDaysToDaysReportConverter2);
        return workingDaysToDaysReportConverter;
    }

    public static WorkingDaysToDaysReportConverter initialize(List<? extends TimeIntervalColumnHeader> columnHeaders, WorkingTimeCalculator workingTimeCalculator, Instant referenceDate) throws InvalidArgumentException {
        WorkingDaysToDaysReportConverter workingDaysToDaysReportConverter;
        WorkingDaysToDaysReportConverter workingDaysToDaysReportConverter2;
        List<? extends TimeIntervalColumnHeader> list = columnHeaders;
        WorkingTimeCalculator workingTimeCalculator2 = workingTimeCalculator;
        Instant instant = referenceDate;
        Object[] objectArray = new Object[]{list, workingTimeCalculator2, instant};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Initialize WorkingDaysToDaysConverter with columnHeaders: {}", columnHeaders);
        }
        if (workingTimeCalculator == null) {
            throw new InvalidArgumentException("WorkingDaysToDaysConverter can't be null");
        }
        if (columnHeaders == null) {
            throw new InvalidArgumentException("TimeIntervalColumnHeaders can't be null");
        }
        if (referenceDate == null) {
            throw new InvalidArgumentException("ReferenceDate can't be null");
        }
        WorkingDaysToDaysReportConverter workingDaysToDaysReportConverter3 = workingDaysToDaysReportConverter2 = (workingDaysToDaysReportConverter = new WorkingDaysToDaysReportConverter(columnHeaders, workingTimeCalculator, referenceDate));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workingDaysToDaysReportConverter2);
        return workingDaysToDaysReportConverter;
    }

    public int convertDaysToWorkingDays(int amountOfDays) {
        int n;
        int n2;
        int n3 = amountOfDays;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.intObject((int)n3));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n4 = n2 = (n = this.cacheDaysToWorkingDays.getOrDefault(amountOfDays, amountOfDays).intValue());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public List<Integer> convertWorkingDaysToDays(int amountOfWorkdays) {
        List<Integer> list;
        List<Integer> list2;
        int n = amountOfWorkdays;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<Integer> listOfAllMatchingDays = this.cacheDaysToWorkingDays.entrySet().stream().filter(entry -> (Integer)entry.getValue() == amountOfWorkdays).map(Map.Entry::getKey).toList();
        List<Integer> list3 = list2 = listOfAllMatchingDays.isEmpty() ? (list = Collections.singletonList(amountOfWorkdays)) : (list = listOfAllMatchingDays);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    protected Map<Integer, Integer> generateDaysToWorkingDays(List<? extends TimeIntervalColumnHeader> columnHeaders, Instant referenceDate) {
        HashMap<Integer, Integer> hashMap;
        HashMap<Integer, Integer> hashMap2;
        List<? extends TimeIntervalColumnHeader> list = columnHeaders;
        Instant instant = referenceDate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, list, (Object)instant);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        HashMap<Integer, Integer> daysToWorkingDaysMap = new HashMap<Integer, Integer>();
        daysToWorkingDaysMap.put(0, 0);
        int positiveWorkdayLimit = TimeIntervalColumnHeader.getLargestLowerLimit(columnHeaders);
        this.calculateFutureDaysToWorkingDays(daysToWorkingDaysMap, referenceDate, positiveWorkdayLimit);
        int negativeWorkdayLimit = TimeIntervalColumnHeader.getSmallestUpperLimit(columnHeaders);
        this.calculateNegativeDaysToWorkingDays(daysToWorkingDaysMap, referenceDate, negativeWorkdayLimit);
        HashMap<Integer, Integer> hashMap3 = hashMap2 = (hashMap = daysToWorkingDaysMap);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, hashMap2);
        return hashMap;
    }

    private void calculateFutureDaysToWorkingDays(HashMap<Integer, Integer> daysToWorkingDaysMap, Instant referenceDate, int workdayLimit) {
        HashMap<Integer, Integer> hashMap = daysToWorkingDaysMap;
        Instant instant = referenceDate;
        int n = workdayLimit;
        Object[] objectArray = new Object[]{hashMap, instant, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.calculateDaysToWorkingDays(daysToWorkingDaysMap, referenceDate, workdayLimit, 1);
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    private void calculateNegativeDaysToWorkingDays(HashMap<Integer, Integer> daysToWorkingDaysMap, Instant referenceDate, int workdayLimit) {
        HashMap<Integer, Integer> hashMap = daysToWorkingDaysMap;
        Instant instant = referenceDate;
        int n = workdayLimit;
        Object[] objectArray = new Object[]{hashMap, instant, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.calculateDaysToWorkingDays(daysToWorkingDaysMap, referenceDate, workdayLimit, -1);
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    private void calculateDaysToWorkingDays(HashMap<Integer, Integer> daysToWorkingDaysMap, Instant referenceDate, int workdayLimit, int direction) {
        HashMap<Integer, Integer> hashMap = daysToWorkingDaysMap;
        Instant instant = referenceDate;
        int n = workdayLimit;
        int n2 = direction;
        Object[] objectArray = new Object[]{hashMap, instant, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int amountOfDays = 0;
        int amountOfWorkdays = 0;
        while (Math.abs(amountOfWorkdays) < Math.abs(workdayLimit)) {
            if (this.workingTimeCalculator.isWorkingDay(referenceDate.plus((long)(amountOfDays += direction), ChronoUnit.DAYS))) {
                amountOfWorkdays += direction;
            }
            daysToWorkingDaysMap.put(amountOfDays, amountOfWorkdays);
        }
        Object var13_13 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var13_13);
    }

    public String toString() {
        return "DaysToWorkingDaysReportConverter [cacheDaysToWorkingDays=" + this.cacheDaysToWorkingDays + ", daysToWorkingDaysConverter=" + this.workingTimeCalculator + "]";
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WorkingDaysToDaysReportConverter.java", WorkingDaysToDaysReportConverter.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "initialize", "pro.taskana.monitor.internal.preprocessor.WorkingDaysToDaysReportConverter", "java.util.List:pro.taskana.common.api.WorkingTimeCalculator", "columnHeaders:workingTimeCalculator", "pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.monitor.internal.preprocessor.WorkingDaysToDaysReportConverter"), 41);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "initialize", "pro.taskana.monitor.internal.preprocessor.WorkingDaysToDaysReportConverter", "java.util.List:pro.taskana.common.api.WorkingTimeCalculator:java.time.Instant", "columnHeaders:workingTimeCalculator:referenceDate", "pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.monitor.internal.preprocessor.WorkingDaysToDaysReportConverter"), 61);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "convertDaysToWorkingDays", "pro.taskana.monitor.internal.preprocessor.WorkingDaysToDaysReportConverter", "int", "amountOfDays", "", "int"), 84);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "convertWorkingDaysToDays", "pro.taskana.monitor.internal.preprocessor.WorkingDaysToDaysReportConverter", "int", "amountOfWorkdays", "", "java.util.List"), 88);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "generateDaysToWorkingDays", "pro.taskana.monitor.internal.preprocessor.WorkingDaysToDaysReportConverter", "java.util.List:java.time.Instant", "columnHeaders:referenceDate", "", "java.util.Map"), 100);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "calculateFutureDaysToWorkingDays", "pro.taskana.monitor.internal.preprocessor.WorkingDaysToDaysReportConverter", "java.util.HashMap:java.time.Instant:int", "daysToWorkingDaysMap:referenceDate:workdayLimit", "", "void"), 114);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "calculateNegativeDaysToWorkingDays", "pro.taskana.monitor.internal.preprocessor.WorkingDaysToDaysReportConverter", "java.util.HashMap:java.time.Instant:int", "daysToWorkingDaysMap:referenceDate:workdayLimit", "", "void"), 119);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "calculateDaysToWorkingDays", "pro.taskana.monitor.internal.preprocessor.WorkingDaysToDaysReportConverter", "java.util.HashMap:java.time.Instant:int:int", "daysToWorkingDaysMap:referenceDate:workdayLimit:direction", "", "void"), 124);
    }
}

