/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.internal.reports;

import java.time.Instant;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.monitor.api.TaskTimestamp;
import pro.taskana.monitor.api.reports.TaskCustomFieldValueReport;
import pro.taskana.monitor.api.reports.header.TimeIntervalColumnHeader;
import pro.taskana.monitor.api.reports.item.MonitorQueryItem;
import pro.taskana.monitor.internal.MonitorMapper;
import pro.taskana.monitor.internal.preprocessor.DaysToWorkingDaysReportPreProcessor;
import pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl;
import pro.taskana.task.api.TaskCustomField;

public class TaskCustomFieldValueReportBuilderImpl
extends TimeIntervalReportBuilderImpl<TaskCustomFieldValueReport.Builder, MonitorQueryItem, TimeIntervalColumnHeader>
implements TaskCustomFieldValueReport.Builder {
    private final TaskCustomField taskCustomField;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public TaskCustomFieldValueReportBuilderImpl(InternalTaskanaEngine taskanaEngine, MonitorMapper monitorMapper, TaskCustomField taskCustomField) {
        super(taskanaEngine, monitorMapper);
        this.taskCustomField = taskCustomField;
    }

    @Override
    public TaskCustomFieldValueReport buildReport() throws InvalidArgumentException, NotAuthorizedException {
        TaskCustomFieldValueReport taskCustomFieldValueReport;
        TaskCustomFieldValueReport taskCustomFieldValueReport2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskCustomFieldValueReport taskCustomFieldValueReport3 = taskCustomFieldValueReport2 = (taskCustomFieldValueReport = this.buildReport(TaskTimestamp.DUE));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCustomFieldValueReport2);
        return taskCustomFieldValueReport;
    }

    @Override
    public TaskCustomFieldValueReport buildReport(TaskTimestamp timestamp) throws InvalidArgumentException, NotAuthorizedException {
        TaskCustomFieldValueReport taskCustomFieldValueReport;
        TaskCustomFieldValueReport taskCustomFieldValueReport2;
        TaskTimestamp taskTimestamp = timestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)((Object)taskTimestamp));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.MONITOR, TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            TaskCustomFieldValueReport report = new TaskCustomFieldValueReport(this.columnHeaders);
            List<MonitorQueryItem> monitorQueryItems = this.monitorMapper.getTaskCountOfTaskCustomFieldValues(Instant.now(), timestamp, this);
            report.addItems(monitorQueryItems, new DaysToWorkingDaysReportPreProcessor(this.columnHeaders, this.workingTimeCalculator, this.inWorkingDays));
            TaskCustomFieldValueReport taskCustomFieldValueReport3 = report;
            taskCustomFieldValueReport2 = taskCustomFieldValueReport3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        TaskCustomFieldValueReport taskCustomFieldValueReport4 = taskCustomFieldValueReport = taskCustomFieldValueReport2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCustomFieldValueReport);
        return taskCustomFieldValueReport2;
    }

    @Override
    protected TaskCustomFieldValueReport.Builder _this() {
        TaskCustomFieldValueReportBuilderImpl taskCustomFieldValueReportBuilderImpl;
        TaskCustomFieldValueReportBuilderImpl taskCustomFieldValueReportBuilderImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskCustomFieldValueReportBuilderImpl taskCustomFieldValueReportBuilderImpl3 = taskCustomFieldValueReportBuilderImpl2 = (taskCustomFieldValueReportBuilderImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCustomFieldValueReportBuilderImpl2);
        return taskCustomFieldValueReportBuilderImpl;
    }

    @Override
    protected String determineGroupedBy() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.taskCustomField.name());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    static {
        TaskCustomFieldValueReportBuilderImpl.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskCustomFieldValueReportBuilderImpl.java", TaskCustomFieldValueReportBuilderImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildReport", "pro.taskana.monitor.internal.reports.TaskCustomFieldValueReportBuilderImpl", "", "", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.monitor.api.reports.TaskCustomFieldValueReport"), 34);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildReport", "pro.taskana.monitor.internal.reports.TaskCustomFieldValueReportBuilderImpl", "pro.taskana.monitor.api.TaskTimestamp", "timestamp", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.monitor.api.reports.TaskCustomFieldValueReport"), 40);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "_this", "pro.taskana.monitor.internal.reports.TaskCustomFieldValueReportBuilderImpl", "", "", "", "pro.taskana.monitor.api.reports.TaskCustomFieldValueReport$Builder"), 60);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "determineGroupedBy", "pro.taskana.monitor.internal.reports.TaskCustomFieldValueReportBuilderImpl", "", "", "", "java.lang.String"), 65);
    }
}

