/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.internal.reports;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.monitor.api.SelectedItem;
import pro.taskana.monitor.api.TaskTimestamp;
import pro.taskana.monitor.api.reports.Report;
import pro.taskana.monitor.api.reports.TimestampReport;
import pro.taskana.monitor.api.reports.header.TimeIntervalColumnHeader;
import pro.taskana.monitor.api.reports.item.TimestampQueryItem;
import pro.taskana.monitor.internal.MonitorMapper;
import pro.taskana.monitor.internal.preprocessor.DaysToWorkingDaysReportPreProcessor;
import pro.taskana.monitor.internal.reports.TimeIntervalReportBuilderImpl;
import pro.taskana.task.api.TaskState;

public class TimestampReportBuilderImpl
extends TimeIntervalReportBuilderImpl<TimestampReport.Builder, TimestampQueryItem, TimeIntervalColumnHeader>
implements TimestampReport.Builder {
    private List<TaskTimestamp> status = Arrays.asList(TaskTimestamp.CREATED, TaskTimestamp.COMPLETED);
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    public TimestampReportBuilderImpl(InternalTaskanaEngine taskanaEngine, MonitorMapper monitorMapper) {
        super(taskanaEngine, monitorMapper);
    }

    @Override
    public TimestampReport.Builder stateIn(List<TaskState> states) {
        List<TaskState> list = states;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        throw new UnsupportedOperationException("The states have no influence regarding this report. Use withTimestamps instead");
    }

    @Override
    public List<String> listTaskIdsForSelectedItems(List<SelectedItem> selectedItems, TaskTimestamp timestamp) {
        List<SelectedItem> list = selectedItems;
        TaskTimestamp taskTimestamp = timestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, list, (Object)((Object)taskTimestamp));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        throw new UnsupportedOperationException();
    }

    @Override
    public TimestampReport.Builder withTimestamps(List<TaskTimestamp> taskTimestamps) {
        TimestampReport.Builder builder;
        TimestampReport.Builder builder2;
        List<TaskTimestamp> list = taskTimestamps;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.status = new ArrayList<TaskTimestamp>(taskTimestamps);
        TimestampReport.Builder builder3 = builder2 = (builder = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
        return builder;
    }

    @Override
    public Report<TimestampQueryItem, TimeIntervalColumnHeader> buildReport(TaskTimestamp timestamp) throws InvalidArgumentException, NotAuthorizedException {
        TimestampReport timestampReport;
        TimestampReport timestampReport2;
        TaskTimestamp taskTimestamp = timestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)((Object)taskTimestamp));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TimestampReport timestampReport3 = timestampReport2 = (timestampReport = this.buildReport());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)timestampReport2);
        return timestampReport;
    }

    @Override
    public TimestampReport buildReport() throws InvalidArgumentException, NotAuthorizedException {
        TimestampReport timestampReport;
        TimestampReport timestampReport2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.MONITOR, TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            TimestampReport report = new TimestampReport(this.columnHeaders);
            List items = this.status.stream().map(this::getTasksCountForStatusGroupedByOrgLevel).flatMap(Collection::stream).toList();
            report.addItems(items, new DaysToWorkingDaysReportPreProcessor(this.columnHeaders, this.workingTimeCalculator, this.inWorkingDays));
            TimestampReport timestampReport3 = report;
            timestampReport2 = timestampReport3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        TimestampReport timestampReport4 = timestampReport = timestampReport2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)timestampReport);
        return timestampReport2;
    }

    @Override
    protected TimestampReport.Builder _this() {
        TimestampReportBuilderImpl timestampReportBuilderImpl;
        TimestampReportBuilderImpl timestampReportBuilderImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TimestampReportBuilderImpl timestampReportBuilderImpl3 = timestampReportBuilderImpl2 = (timestampReportBuilderImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)timestampReportBuilderImpl2);
        return timestampReportBuilderImpl;
    }

    @Override
    protected String determineGroupedBy() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        throw new UnsupportedOperationException();
    }

    private List<TimestampQueryItem> getTasksCountForStatusGroupedByOrgLevel(TaskTimestamp s) {
        List<TimestampQueryItem> list;
        List<TimestampQueryItem> list2;
        TaskTimestamp taskTimestamp = s;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)((Object)taskTimestamp));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<TimestampQueryItem> list3 = list2 = (list = this.monitorMapper.getTasksCountForStatusGroupedByOrgLevel(Instant.now(), s, this));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    static {
        TimestampReportBuilderImpl.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TimestampReportBuilderImpl.java", TimestampReportBuilderImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stateIn", "pro.taskana.monitor.internal.reports.TimestampReportBuilderImpl", "java.util.List", "states", "", "pro.taskana.monitor.api.reports.TimestampReport$Builder"), 37);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listTaskIdsForSelectedItems", "pro.taskana.monitor.internal.reports.TimestampReportBuilderImpl", "java.util.List:pro.taskana.monitor.api.TaskTimestamp", "selectedItems:timestamp", "", "java.util.List"), 43);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withTimestamps", "pro.taskana.monitor.internal.reports.TimestampReportBuilderImpl", "java.util.List", "taskTimestamps", "", "pro.taskana.monitor.api.reports.TimestampReport$Builder"), 49);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildReport", "pro.taskana.monitor.internal.reports.TimestampReportBuilderImpl", "pro.taskana.monitor.api.TaskTimestamp", "timestamp", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.monitor.api.reports.Report"), 55);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildReport", "pro.taskana.monitor.internal.reports.TimestampReportBuilderImpl", "", "", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.monitor.api.reports.TimestampReport"), 61);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "_this", "pro.taskana.monitor.internal.reports.TimestampReportBuilderImpl", "", "", "", "pro.taskana.monitor.api.reports.TimestampReport$Builder"), 86);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "determineGroupedBy", "pro.taskana.monitor.internal.reports.TimestampReportBuilderImpl", "", "", "", "java.lang.String"), 91);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getTasksCountForStatusGroupedByOrgLevel", "pro.taskana.monitor.internal.reports.TimestampReportBuilderImpl", "pro.taskana.monitor.api.TaskTimestamp", "s", "", "java.util.List"), 95);
    }
}

