/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.api;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Supplier;
import org.apache.ibatis.transaction.TransactionFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.TaskanaConfiguration;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.common.api.ConfigurationService;
import pro.taskana.common.api.JobService;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.WorkingTimeCalculator;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.security.CurrentUserContext;
import pro.taskana.common.internal.TaskanaEngineImpl;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.monitor.api.MonitorService;
import pro.taskana.task.api.TaskService;
import pro.taskana.user.api.UserService;
import pro.taskana.workbasket.api.WorkbasketService;

public interface TaskanaEngine {
    public static final String MINIMAL_TASKANA_SCHEMA_VERSION = "7.1.0";
    public static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    public static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    public static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    public static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public TaskService getTaskService();

    public MonitorService getMonitorService();

    public WorkbasketService getWorkbasketService();

    public ClassificationService getClassificationService();

    public JobService getJobService();

    public UserService getUserService();

    public ConfigurationService getConfigurationService();

    public TaskanaConfiguration getConfiguration();

    public static TaskanaEngine buildTaskanaEngine(TaskanaConfiguration configuration) throws SQLException {
        TaskanaEngine taskanaEngine;
        TaskanaEngine taskanaEngine2;
        TaskanaConfiguration taskanaConfiguration = configuration;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)taskanaConfiguration);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskanaEngine taskanaEngine3 = taskanaEngine2 = (taskanaEngine = TaskanaEngine.buildTaskanaEngine(configuration, ConnectionManagementMode.PARTICIPATE, null));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskanaEngine2);
        return taskanaEngine;
    }

    public static TaskanaEngine buildTaskanaEngine(TaskanaConfiguration configuration, ConnectionManagementMode connectionManagementMode) throws SQLException {
        TaskanaEngine taskanaEngine;
        TaskanaEngine taskanaEngine2;
        TaskanaConfiguration taskanaConfiguration = configuration;
        ConnectionManagementMode connectionManagementMode2 = connectionManagementMode;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)taskanaConfiguration, (Object)((Object)connectionManagementMode2));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskanaEngine taskanaEngine3 = taskanaEngine2 = (taskanaEngine = TaskanaEngine.buildTaskanaEngine(configuration, connectionManagementMode, null));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskanaEngine2);
        return taskanaEngine;
    }

    public static TaskanaEngine buildTaskanaEngine(TaskanaConfiguration configuration, ConnectionManagementMode connectionManagementMode, TransactionFactory transactionFactory) throws SQLException {
        TaskanaEngine taskanaEngine;
        TaskanaEngine taskanaEngine2;
        TaskanaConfiguration taskanaConfiguration = configuration;
        ConnectionManagementMode connectionManagementMode2 = connectionManagementMode;
        TransactionFactory transactionFactory2 = transactionFactory;
        Object[] objectArray = new Object[]{taskanaConfiguration, connectionManagementMode2, transactionFactory2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskanaEngine taskanaEngine3 = taskanaEngine2 = (taskanaEngine = TaskanaEngineImpl.createTaskanaEngine(configuration, connectionManagementMode, transactionFactory));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskanaEngine2);
        return taskanaEngine;
    }

    public WorkingTimeCalculator getWorkingTimeCalculator();

    public boolean isHistoryEnabled();

    public ConnectionManagementMode getConnectionManagementMode();

    public void setConnectionManagementMode(ConnectionManagementMode var1);

    public void setConnection(Connection var1) throws SQLException;

    public void closeConnection();

    public boolean isUserInRole(TaskanaRole ... var1);

    public void checkRoleMembership(TaskanaRole ... var1) throws NotAuthorizedException;

    public <T> T runAsAdmin(Supplier<T> var1);

    default public void runAsAdmin(Runnable runnable) {
        Runnable runnable2 = runnable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)runnable2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.runAsAdmin(() -> {
            runnable.run();
            return null;
        });
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public CurrentUserContext getCurrentUserContext();

    public void clearSqlSessionCache();

    static {
        Factory factory = new Factory("TaskanaEngine.java", TaskanaEngine.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "buildTaskanaEngine", "pro.taskana.common.api.TaskanaEngine", "pro.taskana.TaskanaConfiguration", "configuration", "java.sql.SQLException", "pro.taskana.common.api.TaskanaEngine"), 96);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "buildTaskanaEngine", "pro.taskana.common.api.TaskanaEngine", "pro.taskana.TaskanaConfiguration:pro.taskana.common.api.TaskanaEngine$ConnectionManagementMode", "configuration:connectionManagementMode", "java.sql.SQLException", "pro.taskana.common.api.TaskanaEngine"), 109);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "buildTaskanaEngine", "pro.taskana.common.api.TaskanaEngine", "pro.taskana.TaskanaConfiguration:pro.taskana.common.api.TaskanaEngine$ConnectionManagementMode:org.apache.ibatis.transaction.TransactionFactory", "configuration:connectionManagementMode:transactionFactory", "java.sql.SQLException", "pro.taskana.common.api.TaskanaEngine"), 125);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "runAsAdmin", "pro.taskana.common.api.TaskanaEngine", "java.lang.Runnable", "runnable", "", "void"), 234);
    }

    public static final class ConnectionManagementMode
    extends Enum<ConnectionManagementMode> {
        public static final /* enum */ ConnectionManagementMode PARTICIPATE;
        public static final /* enum */ ConnectionManagementMode AUTOCOMMIT;
        public static final /* enum */ ConnectionManagementMode EXPLICIT;
        private static final /* synthetic */ ConnectionManagementMode[] ENUM$VALUES;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        static {
            ConnectionManagementMode.ajc$preClinit();
            PARTICIPATE = new ConnectionManagementMode();
            AUTOCOMMIT = new ConnectionManagementMode();
            EXPLICIT = new ConnectionManagementMode();
            ENUM$VALUES = new ConnectionManagementMode[]{PARTICIPATE, AUTOCOMMIT, EXPLICIT};
        }

        public static ConnectionManagementMode[] values() {
            ConnectionManagementMode[] connectionManagementModeArray;
            ConnectionManagementMode[] connectionManagementModeArray2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            ConnectionManagementMode[] connectionManagementModeArray3 = ENUM$VALUES;
            int n = connectionManagementModeArray3.length;
            ConnectionManagementMode[] connectionManagementModeArray4 = new ConnectionManagementMode[n];
            System.arraycopy(ENUM$VALUES, 0, connectionManagementModeArray4, 0, n);
            ConnectionManagementMode[] connectionManagementModeArray5 = connectionManagementModeArray2 = (connectionManagementModeArray = connectionManagementModeArray4);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)connectionManagementModeArray2);
            return connectionManagementModeArray;
        }

        public static ConnectionManagementMode valueOf(String arg0) {
            ConnectionManagementMode connectionManagementMode;
            ConnectionManagementMode connectionManagementMode2;
            String string = arg0;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            ConnectionManagementMode connectionManagementMode3 = connectionManagementMode2 = (connectionManagementMode = Enum.valueOf(ConnectionManagementMode.class, arg0));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)connectionManagementMode2);
            return connectionManagementMode;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskanaEngine.java", ConnectionManagementMode.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "values", "pro.taskana.common.api.TaskanaEngine$ConnectionManagementMode", "", "", "", "[Lpro.taskana.common.api.TaskanaEngine$ConnectionManagementMode;"), 1);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "valueOf", "pro.taskana.common.api.TaskanaEngine$ConnectionManagementMode", "java.lang.String", "arg0", "", "pro.taskana.common.api.TaskanaEngine$ConnectionManagementMode"), 1);
        }
    }
}

