/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal;

import java.security.Principal;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.security.auth.Subject;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaConfiguration;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.classification.internal.ClassificationMapper;
import pro.taskana.classification.internal.ClassificationQueryMapper;
import pro.taskana.classification.internal.ClassificationServiceImpl;
import pro.taskana.common.api.ConfigurationService;
import pro.taskana.common.api.JobService;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.WorkingTimeCalculator;
import pro.taskana.common.api.exceptions.AutocommitFailedException;
import pro.taskana.common.api.exceptions.ConnectionNotSetException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.api.security.CurrentUserContext;
import pro.taskana.common.api.security.UserPrincipal;
import pro.taskana.common.internal.ConfigurationMapper;
import pro.taskana.common.internal.ConfigurationServiceImpl;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.JobMapper;
import pro.taskana.common.internal.JobServiceImpl;
import pro.taskana.common.internal.OracleSqlSessionFactory;
import pro.taskana.common.internal.configuration.DB;
import pro.taskana.common.internal.configuration.DbSchemaCreator;
import pro.taskana.common.internal.jobs.JobScheduler;
import pro.taskana.common.internal.jobs.RealClock;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.persistence.InstantTypeHandler;
import pro.taskana.common.internal.persistence.MapTypeHandler;
import pro.taskana.common.internal.persistence.StringTypeHandler;
import pro.taskana.common.internal.security.CurrentUserContextImpl;
import pro.taskana.common.internal.workingtime.HolidaySchedule;
import pro.taskana.common.internal.workingtime.WorkingDayCalculatorImpl;
import pro.taskana.common.internal.workingtime.WorkingTimeCalculatorImpl;
import pro.taskana.monitor.api.MonitorService;
import pro.taskana.monitor.internal.MonitorMapper;
import pro.taskana.monitor.internal.MonitorServiceImpl;
import pro.taskana.spi.history.internal.HistoryEventManager;
import pro.taskana.spi.priority.internal.PriorityServiceManager;
import pro.taskana.spi.routing.internal.TaskRoutingManager;
import pro.taskana.spi.task.internal.AfterRequestChangesManager;
import pro.taskana.spi.task.internal.AfterRequestReviewManager;
import pro.taskana.spi.task.internal.BeforeRequestChangesManager;
import pro.taskana.spi.task.internal.BeforeRequestReviewManager;
import pro.taskana.spi.task.internal.CreateTaskPreprocessorManager;
import pro.taskana.spi.task.internal.ReviewRequiredManager;
import pro.taskana.spi.task.internal.TaskEndstatePreprocessorManager;
import pro.taskana.task.api.TaskService;
import pro.taskana.task.internal.AttachmentMapper;
import pro.taskana.task.internal.ObjectReferenceMapper;
import pro.taskana.task.internal.TaskCommentMapper;
import pro.taskana.task.internal.TaskCommentQueryMapper;
import pro.taskana.task.internal.TaskMapper;
import pro.taskana.task.internal.TaskQueryMapper;
import pro.taskana.task.internal.TaskServiceImpl;
import pro.taskana.user.api.UserService;
import pro.taskana.user.internal.UserMapper;
import pro.taskana.user.internal.UserServiceImpl;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.internal.DistributionTargetMapper;
import pro.taskana.workbasket.internal.WorkbasketAccessMapper;
import pro.taskana.workbasket.internal.WorkbasketMapper;
import pro.taskana.workbasket.internal.WorkbasketQueryMapper;
import pro.taskana.workbasket.internal.WorkbasketServiceImpl;

public class TaskanaEngineImpl
implements TaskanaEngine {
    private static final Logger LOGGER;
    private static final SessionStack SESSION_STACK;
    protected final TaskanaConfiguration taskanaConfiguration;
    private final TaskRoutingManager taskRoutingManager;
    private final CreateTaskPreprocessorManager createTaskPreprocessorManager;
    private final PriorityServiceManager priorityServiceManager;
    private final ReviewRequiredManager reviewRequiredManager;
    private final BeforeRequestReviewManager beforeRequestReviewManager;
    private final AfterRequestReviewManager afterRequestReviewManager;
    private final BeforeRequestChangesManager beforeRequestChangesManager;
    private final AfterRequestChangesManager afterRequestChangesManager;
    private final TaskEndstatePreprocessorManager taskEndstatePreprocessorManager;
    private final InternalTaskanaEngineImpl internalTaskanaEngineImpl;
    private final WorkingTimeCalculator workingTimeCalculator;
    private final HistoryEventManager historyEventManager;
    private final CurrentUserContext currentUserContext;
    private final JobScheduler jobScheduler;
    protected TaskanaEngine.ConnectionManagementMode mode;
    protected TransactionFactory transactionFactory;
    protected SqlSessionManager sessionManager;
    protected Connection connection;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;

    static {
        TaskanaEngineImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TaskanaEngineImpl.class);
        SESSION_STACK = new SessionStack();
    }

    protected TaskanaEngineImpl(TaskanaConfiguration taskanaConfiguration, TaskanaEngine.ConnectionManagementMode connectionManagementMode, TransactionFactory transactionFactory) throws SQLException {
        LOGGER.info("initializing TASKANA with this configuration: {} and this mode: {}", (Object)taskanaConfiguration, (Object)connectionManagementMode);
        this.mode = connectionManagementMode == TaskanaEngine.ConnectionManagementMode.EXPLICIT ? TaskanaEngine.ConnectionManagementMode.AUTOCOMMIT : connectionManagementMode;
        this.taskanaConfiguration = taskanaConfiguration;
        this.internalTaskanaEngineImpl = new InternalTaskanaEngineImpl();
        HolidaySchedule holidaySchedule = new HolidaySchedule(taskanaConfiguration.isGermanPublicHolidaysEnabled(), taskanaConfiguration.isGermanPublicHolidaysCorpusChristiEnabled(), taskanaConfiguration.getCustomHolidays());
        this.workingTimeCalculator = taskanaConfiguration.isUseWorkingTimeCalculation() ? new WorkingTimeCalculatorImpl(holidaySchedule, taskanaConfiguration.getWorkingTimeSchedule(), taskanaConfiguration.getWorkingTimeScheduleTimeZone()) : new WorkingDayCalculatorImpl(holidaySchedule, taskanaConfiguration.getWorkingTimeScheduleTimeZone());
        this.currentUserContext = new CurrentUserContextImpl(TaskanaConfiguration.shouldUseLowerCaseForAccessIds());
        if (transactionFactory == null) {
            this.createTransactionFactory(taskanaConfiguration.isUseManagedTransactions());
        } else {
            this.transactionFactory = transactionFactory;
        }
        this.sessionManager = this.createSqlSessionManager();
        this.initializeDbSchema(taskanaConfiguration);
        if (this.taskanaConfiguration.isJobSchedulerEnabled()) {
            TaskanaConfiguration configuration = new TaskanaConfiguration.Builder(this.taskanaConfiguration).jobSchedulerEnabled(false).build();
            TaskanaEngine taskanaEngine = TaskanaEngine.buildTaskanaEngine(configuration, TaskanaEngine.ConnectionManagementMode.EXPLICIT, transactionFactory);
            RealClock clock = new RealClock(this.taskanaConfiguration.getJobSchedulerInitialStartDelay(), this.taskanaConfiguration.getJobSchedulerPeriod(), this.taskanaConfiguration.getJobSchedulerPeriodTimeUnit());
            this.jobScheduler = new JobScheduler(taskanaEngine, clock);
            this.jobScheduler.start();
        } else {
            this.jobScheduler = null;
        }
        this.createTaskPreprocessorManager = new CreateTaskPreprocessorManager();
        this.priorityServiceManager = new PriorityServiceManager(this);
        this.historyEventManager = new HistoryEventManager(this);
        this.taskRoutingManager = new TaskRoutingManager(this);
        this.reviewRequiredManager = new ReviewRequiredManager(this);
        this.beforeRequestReviewManager = new BeforeRequestReviewManager(this);
        this.afterRequestReviewManager = new AfterRequestReviewManager(this);
        this.beforeRequestChangesManager = new BeforeRequestChangesManager(this);
        this.afterRequestChangesManager = new AfterRequestChangesManager(this);
        this.taskEndstatePreprocessorManager = new TaskEndstatePreprocessorManager();
        this.mode = connectionManagementMode;
    }

    public static TaskanaEngine createTaskanaEngine(TaskanaConfiguration taskanaConfiguration, TaskanaEngine.ConnectionManagementMode connectionManagementMode, TransactionFactory transactionFactory) throws SQLException {
        TaskanaEngineImpl taskanaEngineImpl;
        TaskanaEngineImpl taskanaEngineImpl2;
        TaskanaConfiguration taskanaConfiguration2 = taskanaConfiguration;
        TaskanaEngine.ConnectionManagementMode connectionManagementMode2 = connectionManagementMode;
        TransactionFactory transactionFactory2 = transactionFactory;
        Object[] objectArray = new Object[]{taskanaConfiguration2, connectionManagementMode2, transactionFactory2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskanaEngineImpl taskanaEngineImpl3 = taskanaEngineImpl2 = (taskanaEngineImpl = new TaskanaEngineImpl(taskanaConfiguration, connectionManagementMode, transactionFactory));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskanaEngineImpl2);
        return taskanaEngineImpl;
    }

    @Override
    public ConfigurationService getConfigurationService() {
        ConfigurationServiceImpl configurationServiceImpl;
        ConfigurationServiceImpl configurationServiceImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ConfigurationServiceImpl configurationServiceImpl3 = configurationServiceImpl2 = (configurationServiceImpl = new ConfigurationServiceImpl(this.internalTaskanaEngineImpl, (ConfigurationMapper)this.sessionManager.getMapper(ConfigurationMapper.class)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)configurationServiceImpl2);
        return configurationServiceImpl;
    }

    @Override
    public TaskService getTaskService() {
        TaskServiceImpl taskServiceImpl;
        TaskServiceImpl taskServiceImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskServiceImpl taskServiceImpl3 = taskServiceImpl2 = (taskServiceImpl = new TaskServiceImpl(this.internalTaskanaEngineImpl, (TaskMapper)this.sessionManager.getMapper(TaskMapper.class), (TaskCommentMapper)this.sessionManager.getMapper(TaskCommentMapper.class), (AttachmentMapper)this.sessionManager.getMapper(AttachmentMapper.class), (ObjectReferenceMapper)this.sessionManager.getMapper(ObjectReferenceMapper.class), (UserMapper)this.sessionManager.getMapper(UserMapper.class)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskServiceImpl2);
        return taskServiceImpl;
    }

    @Override
    public MonitorService getMonitorService() {
        MonitorServiceImpl monitorServiceImpl;
        MonitorServiceImpl monitorServiceImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        MonitorServiceImpl monitorServiceImpl3 = monitorServiceImpl2 = (monitorServiceImpl = new MonitorServiceImpl(this.internalTaskanaEngineImpl, (MonitorMapper)this.sessionManager.getMapper(MonitorMapper.class)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)monitorServiceImpl2);
        return monitorServiceImpl;
    }

    @Override
    public WorkbasketService getWorkbasketService() {
        WorkbasketServiceImpl workbasketServiceImpl;
        WorkbasketServiceImpl workbasketServiceImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketServiceImpl workbasketServiceImpl3 = workbasketServiceImpl2 = (workbasketServiceImpl = new WorkbasketServiceImpl(this.internalTaskanaEngineImpl, this.historyEventManager, (WorkbasketMapper)this.sessionManager.getMapper(WorkbasketMapper.class), (DistributionTargetMapper)this.sessionManager.getMapper(DistributionTargetMapper.class), (WorkbasketAccessMapper)this.sessionManager.getMapper(WorkbasketAccessMapper.class)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketServiceImpl2);
        return workbasketServiceImpl;
    }

    @Override
    public ClassificationService getClassificationService() {
        ClassificationServiceImpl classificationServiceImpl;
        ClassificationServiceImpl classificationServiceImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ClassificationServiceImpl classificationServiceImpl3 = classificationServiceImpl2 = (classificationServiceImpl = new ClassificationServiceImpl(this.internalTaskanaEngineImpl, this.priorityServiceManager, (ClassificationMapper)this.sessionManager.getMapper(ClassificationMapper.class), (TaskMapper)this.sessionManager.getMapper(TaskMapper.class)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classificationServiceImpl2);
        return classificationServiceImpl;
    }

    public Connection getConnection() {
        Connection connection;
        Connection connection2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Connection connection3 = connection2 = (connection = this.connection);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)connection2);
        return connection;
    }

    @Override
    public void setConnection(Connection connection) throws SQLException {
        Connection connection2 = connection;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)connection2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (connection != null) {
            this.connection = connection;
            connection.setAutoCommit(false);
            connection.setSchema(this.taskanaConfiguration.getSchemaName());
            this.mode = TaskanaEngine.ConnectionManagementMode.EXPLICIT;
            if (this.transactionFactory.getClass().getSimpleName().equals("SpringManagedTransactionFactory")) {
                this.sessionManager.startManagedSession();
            } else {
                this.sessionManager.startManagedSession(connection);
            }
        } else if (this.connection != null) {
            this.closeConnection();
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public PriorityServiceManager getPriorityServiceManager() {
        PriorityServiceManager priorityServiceManager;
        PriorityServiceManager priorityServiceManager2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        PriorityServiceManager priorityServiceManager3 = priorityServiceManager2 = (priorityServiceManager = this.priorityServiceManager);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)priorityServiceManager2);
        return priorityServiceManager;
    }

    @Override
    public JobService getJobService() {
        JobServiceImpl jobServiceImpl;
        JobServiceImpl jobServiceImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        JobServiceImpl jobServiceImpl3 = jobServiceImpl2 = (jobServiceImpl = new JobServiceImpl(this.internalTaskanaEngineImpl, (JobMapper)this.sessionManager.getMapper(JobMapper.class)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)jobServiceImpl2);
        return jobServiceImpl;
    }

    @Override
    public UserService getUserService() {
        UserServiceImpl userServiceImpl;
        UserServiceImpl userServiceImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        UserServiceImpl userServiceImpl3 = userServiceImpl2 = (userServiceImpl = new UserServiceImpl(this.internalTaskanaEngineImpl, (UserMapper)this.sessionManager.getMapper(UserMapper.class)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)userServiceImpl2);
        return userServiceImpl;
    }

    public JobScheduler getJobScheduler() {
        JobScheduler jobScheduler;
        JobScheduler jobScheduler2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        JobScheduler jobScheduler3 = jobScheduler2 = (jobScheduler = this.jobScheduler);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)jobScheduler2);
        return jobScheduler;
    }

    @Override
    public TaskanaConfiguration getConfiguration() {
        TaskanaConfiguration taskanaConfiguration;
        TaskanaConfiguration taskanaConfiguration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskanaConfiguration taskanaConfiguration3 = taskanaConfiguration2 = (taskanaConfiguration = this.taskanaConfiguration);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskanaConfiguration2);
        return taskanaConfiguration;
    }

    @Override
    public WorkingTimeCalculator getWorkingTimeCalculator() {
        WorkingTimeCalculator workingTimeCalculator;
        WorkingTimeCalculator workingTimeCalculator2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkingTimeCalculator workingTimeCalculator3 = workingTimeCalculator2 = (workingTimeCalculator = this.workingTimeCalculator);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workingTimeCalculator2);
        return workingTimeCalculator;
    }

    @Override
    public boolean isHistoryEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.historyEventManager.isEnabled());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    @Override
    public TaskanaEngine.ConnectionManagementMode getConnectionManagementMode() {
        TaskanaEngine.ConnectionManagementMode connectionManagementMode;
        TaskanaEngine.ConnectionManagementMode connectionManagementMode2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskanaEngine.ConnectionManagementMode connectionManagementMode3 = connectionManagementMode2 = (connectionManagementMode = this.mode);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)connectionManagementMode2);
        return connectionManagementMode;
    }

    @Override
    public void setConnectionManagementMode(TaskanaEngine.ConnectionManagementMode mode) {
        TaskanaEngine.ConnectionManagementMode connectionManagementMode = mode;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)((Object)connectionManagementMode));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (this.mode == TaskanaEngine.ConnectionManagementMode.EXPLICIT && this.connection != null && mode != TaskanaEngine.ConnectionManagementMode.EXPLICIT) {
            if (this.sessionManager.isManagedSessionStarted()) {
                this.sessionManager.close();
            }
            this.connection = null;
        }
        this.mode = mode;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    @Override
    public void closeConnection() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (this.mode == TaskanaEngine.ConnectionManagementMode.EXPLICIT) {
            this.connection = null;
            if (this.sessionManager.isManagedSessionStarted()) {
                this.sessionManager.close();
            }
            this.mode = TaskanaEngine.ConnectionManagementMode.PARTICIPATE;
        }
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    @Override
    public boolean isUserInRole(TaskanaRole ... roles) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        JoinPoint joinPoint;
        block4: {
            TaskanaRole[] taskanaRoleArray = roles;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)taskanaRoleArray);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            if (!this.getConfiguration().isSecurityEnabled()) {
                bl2 = bl3 = true;
            } else {
                List accessIds = this.currentUserContext.getAccessIds();
                HashSet rolesMembers = new HashSet();
                TaskanaRole[] taskanaRoleArray2 = roles;
                int n = roles.length;
                int n2 = 0;
                while (n2 < n) {
                    TaskanaRole role = taskanaRoleArray2[n2];
                    rolesMembers.addAll(this.getConfiguration().getRoleMap().get(role));
                    ++n2;
                }
                for (String accessId : accessIds) {
                    if (!rolesMembers.contains(accessId)) continue;
                    bl2 = bl3 = true;
                    break block4;
                }
                bl2 = bl3 = false;
            }
        }
        boolean bl4 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl3;
    }

    @Override
    public void checkRoleMembership(TaskanaRole ... roles) throws NotAuthorizedException {
        TaskanaRole[] taskanaRoleArray = roles;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)taskanaRoleArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!this.isUserInRole(roles)) {
            if (LOGGER.isDebugEnabled()) {
                String rolesAsString = Arrays.toString(roles);
                LOGGER.debug("Throwing NotAuthorizedException because accessIds {} are not member of roles {}", (Object)this.currentUserContext.getAccessIds(), (Object)rolesAsString);
            }
            throw new NotAuthorizedException(this.currentUserContext.getUserid(), roles);
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    @Override
    public <T> T runAsAdmin(Supplier<T> supplier) {
        T t;
        Object object;
        Object object2;
        Supplier<T> supplier2 = supplier;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, supplier2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (this.isUserInRole(TaskanaRole.ADMIN)) {
            object = object2 = supplier.get();
        } else {
            String adminName = (String)this.getConfiguration().getRoleMap().get(TaskanaRole.ADMIN).stream().findFirst().orElseThrow(() -> new SystemException("There is no admin configured"));
            Subject subject = new Subject();
            subject.getPrincipals().add((Principal)new UserPrincipal(adminName));
            object = object2 = Subject.doAs(subject, supplier::get);
        }
        T t2 = t = object;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, t);
        return object2;
    }

    @Override
    public CurrentUserContext getCurrentUserContext() {
        CurrentUserContext currentUserContext;
        CurrentUserContext currentUserContext2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        CurrentUserContext currentUserContext3 = currentUserContext2 = (currentUserContext = this.currentUserContext);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)currentUserContext2);
        return currentUserContext;
    }

    @Override
    public void clearSqlSessionCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.sessionManager.clearCache();
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    protected SqlSessionManager createSqlSessionManager() {
        SqlSessionManager sqlSessionManager;
        SqlSessionManager sqlSessionManager2;
        DB db;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Environment environment = new Environment("default", this.transactionFactory, this.taskanaConfiguration.getDataSource());
        Configuration configuration = new Configuration(environment);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection con = this.taskanaConfiguration.getDataSource().getConnection();){
                db = DB.getDB((Connection)con);
                configuration.setDatabaseId(db.dbProductId);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new SystemException("Method createSqlSessionManager() could not open a connection to the database. No databaseId has been set.", e.getCause());
        }
        if (DB.ORACLE == db) {
            configuration.setJdbcTypeForNull(JdbcType.NULL);
            configuration.getTypeHandlerRegistry().register(String.class, (TypeHandler)new StringTypeHandler());
        }
        configuration.getTypeHandlerRegistry().register((TypeHandler)new MapTypeHandler());
        configuration.getTypeHandlerRegistry().register(Instant.class, (TypeHandler)new InstantTypeHandler());
        configuration.getTypeHandlerRegistry().register(JdbcType.TIMESTAMP, (TypeHandler)new InstantTypeHandler());
        configuration.addMapper(TaskMapper.class);
        configuration.addMapper(MonitorMapper.class);
        configuration.addMapper(WorkbasketMapper.class);
        configuration.addMapper(DistributionTargetMapper.class);
        configuration.addMapper(ClassificationMapper.class);
        configuration.addMapper(WorkbasketAccessMapper.class);
        configuration.addMapper(ObjectReferenceMapper.class);
        configuration.addMapper(WorkbasketQueryMapper.class);
        configuration.addMapper(TaskQueryMapper.class);
        configuration.addMapper(TaskCommentMapper.class);
        configuration.addMapper(TaskCommentQueryMapper.class);
        configuration.addMapper(ClassificationQueryMapper.class);
        configuration.addMapper(AttachmentMapper.class);
        configuration.addMapper(JobMapper.class);
        configuration.addMapper(UserMapper.class);
        configuration.addMapper(ConfigurationMapper.class);
        SqlSessionFactory localSessionFactory = DB.ORACLE == db ? new SqlSessionFactoryBuilder(){

            public SqlSessionFactory build(Configuration config) {
                return new OracleSqlSessionFactory(config);
            }
        }.build(configuration) : new SqlSessionFactoryBuilder().build(configuration);
        SqlSessionManager sqlSessionManager3 = sqlSessionManager2 = (sqlSessionManager = SqlSessionManager.newInstance((SqlSessionFactory)localSessionFactory));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)sqlSessionManager2);
        return sqlSessionManager;
    }

    private void initializeDbSchema(TaskanaConfiguration taskanaConfiguration) throws SQLException {
        TaskanaConfiguration taskanaConfiguration2 = taskanaConfiguration;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)taskanaConfiguration2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DbSchemaCreator dbSchemaCreator = new DbSchemaCreator(taskanaConfiguration.getDataSource(), taskanaConfiguration.getSchemaName());
        boolean schemaCreated = dbSchemaCreator.run();
        if (!schemaCreated && !dbSchemaCreator.isValidSchemaVersion("7.1.0")) {
            throw new SystemException("The Database Schema Version doesn't match the expected minimal version 7.1.0");
        }
        ((ConfigurationServiceImpl)this.getConfigurationService()).checkSecureAccess(taskanaConfiguration.isSecurityEnabled());
        ((ConfigurationServiceImpl)this.getConfigurationService()).setupDefaultCustomAttributes();
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private void createTransactionFactory(boolean useManagedTransactions) {
        boolean bl = useManagedTransactions;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.transactionFactory = useManagedTransactions ? new ManagedTransactionFactory() : new JdbcTransactionFactory();
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskanaEngineImpl.java", TaskanaEngineImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "createTaskanaEngine", "pro.taskana.common.internal.TaskanaEngineImpl", "pro.taskana.TaskanaConfiguration:pro.taskana.common.api.TaskanaEngine$ConnectionManagementMode:org.apache.ibatis.transaction.TransactionFactory", "taskanaConfiguration:connectionManagementMode:transactionFactory", "java.sql.SQLException", "pro.taskana.common.api.TaskanaEngine"), 195);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConfigurationService", "pro.taskana.common.internal.TaskanaEngineImpl", "", "", "", "pro.taskana.common.api.ConfigurationService"), 205);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserService", "pro.taskana.common.internal.TaskanaEngineImpl", "", "", "", "pro.taskana.user.api.UserService"), 282);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJobScheduler", "pro.taskana.common.internal.TaskanaEngineImpl", "", "", "", "pro.taskana.common.internal.jobs.JobScheduler"), 287);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConfiguration", "pro.taskana.common.internal.TaskanaEngineImpl", "", "", "", "pro.taskana.TaskanaConfiguration"), 292);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkingTimeCalculator", "pro.taskana.common.internal.TaskanaEngineImpl", "", "", "", "pro.taskana.common.api.WorkingTimeCalculator"), 297);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isHistoryEnabled", "pro.taskana.common.internal.TaskanaEngineImpl", "", "", "", "boolean"), 302);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConnectionManagementMode", "pro.taskana.common.internal.TaskanaEngineImpl", "", "", "", "pro.taskana.common.api.TaskanaEngine$ConnectionManagementMode"), 307);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setConnectionManagementMode", "pro.taskana.common.internal.TaskanaEngineImpl", "pro.taskana.common.api.TaskanaEngine$ConnectionManagementMode", "mode", "", "void"), 312);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "closeConnection", "pro.taskana.common.internal.TaskanaEngineImpl", "", "", "", "void"), 323);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "isUserInRole", "pro.taskana.common.internal.TaskanaEngineImpl", "[Lpro.taskana.common.api.TaskanaRole;", "roles", "", "boolean"), 334);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "checkRoleMembership", "pro.taskana.common.internal.TaskanaEngineImpl", "[Lpro.taskana.common.api.TaskanaRole;", "roles", "pro.taskana.common.api.exceptions.NotAuthorizedException", "void"), 354);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskService", "pro.taskana.common.internal.TaskanaEngineImpl", "", "", "", "pro.taskana.task.api.TaskService"), 211);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "runAsAdmin", "pro.taskana.common.internal.TaskanaEngineImpl", "java.util.function.Supplier", "supplier", "", "java.lang.Object"), 367);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCurrentUserContext", "pro.taskana.common.internal.TaskanaEngineImpl", "", "", "", "pro.taskana.common.api.security.CurrentUserContext"), 384);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clearSqlSessionCache", "pro.taskana.common.internal.TaskanaEngineImpl", "", "", "", "void"), 389);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createSqlSessionManager", "pro.taskana.common.internal.TaskanaEngineImpl", "", "", "", "org.apache.ibatis.session.SqlSessionManager"), 400);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initializeDbSchema", "pro.taskana.common.internal.TaskanaEngineImpl", "pro.taskana.TaskanaConfiguration", "taskanaConfiguration", "java.sql.SQLException", "void"), 462);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createTransactionFactory", "pro.taskana.common.internal.TaskanaEngineImpl", "boolean", "useManagedTransactions", "", "void"), 483);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMonitorService", "pro.taskana.common.internal.TaskanaEngineImpl", "", "", "", "pro.taskana.monitor.api.MonitorService"), 222);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasketService", "pro.taskana.common.internal.TaskanaEngineImpl", "", "", "", "pro.taskana.workbasket.api.WorkbasketService"), 228);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationService", "pro.taskana.common.internal.TaskanaEngineImpl", "", "", "", "pro.taskana.classification.api.ClassificationService"), 238);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConnection", "pro.taskana.common.internal.TaskanaEngineImpl", "", "", "", "java.sql.Connection"), 246);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setConnection", "pro.taskana.common.internal.TaskanaEngineImpl", "java.sql.Connection", "connection", "java.sql.SQLException", "void"), 251);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriorityServiceManager", "pro.taskana.common.internal.TaskanaEngineImpl", "", "", "", "pro.taskana.spi.priority.internal.PriorityServiceManager"), 272);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJobService", "pro.taskana.common.internal.TaskanaEngineImpl", "", "", "", "pro.taskana.common.api.JobService"), 277);
    }

    private class InternalTaskanaEngineImpl
    implements InternalTaskanaEngine {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;

        private InternalTaskanaEngineImpl() {
        }

        @Override
        public void openConnection() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.initSqlSession();
            try {
                TaskanaEngineImpl.this.sessionManager.getConnection().setSchema(TaskanaEngineImpl.this.taskanaConfiguration.getSchemaName());
            }
            catch (SQLException e) {
                throw new SystemException("Method openConnection() could not open a connection to the database. No schema has been created.", e.getCause());
            }
            if (TaskanaEngineImpl.this.mode != TaskanaEngine.ConnectionManagementMode.EXPLICIT) {
                SESSION_STACK.pushSessionToStack(TaskanaEngineImpl.this.sessionManager);
            }
            Object var3_3 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var3_3);
        }

        @Override
        public void returnConnection() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            if (TaskanaEngineImpl.this.mode != TaskanaEngine.ConnectionManagementMode.EXPLICIT) {
                SESSION_STACK.popSessionFromStack();
                if (SESSION_STACK.getSessionStack().isEmpty() && TaskanaEngineImpl.this.sessionManager != null && TaskanaEngineImpl.this.sessionManager.isManagedSessionStarted()) {
                    if (TaskanaEngineImpl.this.mode == TaskanaEngine.ConnectionManagementMode.AUTOCOMMIT) {
                        try {
                            TaskanaEngineImpl.this.sessionManager.commit();
                        }
                        catch (Exception e) {
                            throw new AutocommitFailedException(e.getCause());
                        }
                    }
                    TaskanaEngineImpl.this.sessionManager.close();
                }
            }
            Object var3_3 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var3_3);
        }

        @Override
        public <T> T executeInDatabaseConnection(Supplier<T> supplier) {
            T t;
            T t2;
            Supplier<T> supplier2 = supplier;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, supplier2);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            try {
                this.openConnection();
                T t3 = supplier.get();
                t2 = t3;
            }
            finally {
                this.returnConnection();
            }
            T t4 = t = t2;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, t);
            return t2;
        }

        @Override
        public void initSqlSession() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            if (TaskanaEngineImpl.this.mode == TaskanaEngine.ConnectionManagementMode.EXPLICIT && TaskanaEngineImpl.this.connection == null) {
                throw new ConnectionNotSetException();
            }
            if (TaskanaEngineImpl.this.mode != TaskanaEngine.ConnectionManagementMode.EXPLICIT && !TaskanaEngineImpl.this.sessionManager.isManagedSessionStarted()) {
                TaskanaEngineImpl.this.sessionManager.startManagedSession();
            }
            Object var2_2 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
        }

        @Override
        public boolean domainExists(String domain) {
            boolean bl;
            boolean bl2;
            String string = domain;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            boolean bl3 = bl2 = (bl = TaskanaEngineImpl.this.getConfiguration().getDomains().contains(domain));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
            return bl;
        }

        @Override
        public SqlSession getSqlSession() {
            SqlSessionManager sqlSessionManager;
            SqlSessionManager sqlSessionManager2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            SqlSessionManager sqlSessionManager3 = sqlSessionManager2 = (sqlSessionManager = TaskanaEngineImpl.this.sessionManager);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)sqlSessionManager2);
            return sqlSessionManager;
        }

        @Override
        public TaskanaEngine getEngine() {
            TaskanaEngineImpl taskanaEngineImpl;
            TaskanaEngineImpl taskanaEngineImpl2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            TaskanaEngineImpl taskanaEngineImpl3 = taskanaEngineImpl2 = (taskanaEngineImpl = TaskanaEngineImpl.this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskanaEngineImpl2);
            return taskanaEngineImpl;
        }

        @Override
        public HistoryEventManager getHistoryEventManager() {
            HistoryEventManager historyEventManager;
            HistoryEventManager historyEventManager2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            HistoryEventManager historyEventManager3 = historyEventManager2 = (historyEventManager = TaskanaEngineImpl.this.historyEventManager);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)historyEventManager2);
            return historyEventManager;
        }

        @Override
        public TaskRoutingManager getTaskRoutingManager() {
            TaskRoutingManager taskRoutingManager;
            TaskRoutingManager taskRoutingManager2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            TaskRoutingManager taskRoutingManager3 = taskRoutingManager2 = (taskRoutingManager = TaskanaEngineImpl.this.taskRoutingManager);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskRoutingManager2);
            return taskRoutingManager;
        }

        @Override
        public CreateTaskPreprocessorManager getCreateTaskPreprocessorManager() {
            CreateTaskPreprocessorManager createTaskPreprocessorManager;
            CreateTaskPreprocessorManager createTaskPreprocessorManager2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            CreateTaskPreprocessorManager createTaskPreprocessorManager3 = createTaskPreprocessorManager2 = (createTaskPreprocessorManager = TaskanaEngineImpl.this.createTaskPreprocessorManager);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)createTaskPreprocessorManager2);
            return createTaskPreprocessorManager;
        }

        @Override
        public PriorityServiceManager getPriorityServiceManager() {
            PriorityServiceManager priorityServiceManager;
            PriorityServiceManager priorityServiceManager2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            PriorityServiceManager priorityServiceManager3 = priorityServiceManager2 = (priorityServiceManager = TaskanaEngineImpl.this.priorityServiceManager);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)priorityServiceManager2);
            return priorityServiceManager;
        }

        @Override
        public ReviewRequiredManager getReviewRequiredManager() {
            ReviewRequiredManager reviewRequiredManager;
            ReviewRequiredManager reviewRequiredManager2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            ReviewRequiredManager reviewRequiredManager3 = reviewRequiredManager2 = (reviewRequiredManager = TaskanaEngineImpl.this.reviewRequiredManager);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)reviewRequiredManager2);
            return reviewRequiredManager;
        }

        @Override
        public BeforeRequestReviewManager getBeforeRequestReviewManager() {
            BeforeRequestReviewManager beforeRequestReviewManager;
            BeforeRequestReviewManager beforeRequestReviewManager2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            BeforeRequestReviewManager beforeRequestReviewManager3 = beforeRequestReviewManager2 = (beforeRequestReviewManager = TaskanaEngineImpl.this.beforeRequestReviewManager);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)beforeRequestReviewManager2);
            return beforeRequestReviewManager;
        }

        @Override
        public AfterRequestReviewManager getAfterRequestReviewManager() {
            AfterRequestReviewManager afterRequestReviewManager;
            AfterRequestReviewManager afterRequestReviewManager2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            AfterRequestReviewManager afterRequestReviewManager3 = afterRequestReviewManager2 = (afterRequestReviewManager = TaskanaEngineImpl.this.afterRequestReviewManager);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)afterRequestReviewManager2);
            return afterRequestReviewManager;
        }

        @Override
        public BeforeRequestChangesManager getBeforeRequestChangesManager() {
            BeforeRequestChangesManager beforeRequestChangesManager;
            BeforeRequestChangesManager beforeRequestChangesManager2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            BeforeRequestChangesManager beforeRequestChangesManager3 = beforeRequestChangesManager2 = (beforeRequestChangesManager = TaskanaEngineImpl.this.beforeRequestChangesManager);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)beforeRequestChangesManager2);
            return beforeRequestChangesManager;
        }

        @Override
        public AfterRequestChangesManager getAfterRequestChangesManager() {
            AfterRequestChangesManager afterRequestChangesManager;
            AfterRequestChangesManager afterRequestChangesManager2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            AfterRequestChangesManager afterRequestChangesManager3 = afterRequestChangesManager2 = (afterRequestChangesManager = TaskanaEngineImpl.this.afterRequestChangesManager);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)afterRequestChangesManager2);
            return afterRequestChangesManager;
        }

        @Override
        public TaskEndstatePreprocessorManager getTaskEndstatePreprocessorManager() {
            TaskEndstatePreprocessorManager taskEndstatePreprocessorManager;
            TaskEndstatePreprocessorManager taskEndstatePreprocessorManager2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            TaskEndstatePreprocessorManager taskEndstatePreprocessorManager3 = taskEndstatePreprocessorManager2 = (taskEndstatePreprocessorManager = TaskanaEngineImpl.this.taskEndstatePreprocessorManager);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskEndstatePreprocessorManager2);
            return taskEndstatePreprocessorManager;
        }

        static {
            InternalTaskanaEngineImpl.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskanaEngineImpl.java", InternalTaskanaEngineImpl.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "openConnection", "pro.taskana.common.internal.TaskanaEngineImpl$InternalTaskanaEngineImpl", "", "", "", "void"), 537);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "returnConnection", "pro.taskana.common.internal.TaskanaEngineImpl$InternalTaskanaEngineImpl", "", "", "", "void"), 553);
            ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriorityServiceManager", "pro.taskana.common.internal.TaskanaEngineImpl$InternalTaskanaEngineImpl", "", "", "", "pro.taskana.spi.priority.internal.PriorityServiceManager"), 622);
            ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getReviewRequiredManager", "pro.taskana.common.internal.TaskanaEngineImpl$InternalTaskanaEngineImpl", "", "", "", "pro.taskana.spi.task.internal.ReviewRequiredManager"), 627);
            ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBeforeRequestReviewManager", "pro.taskana.common.internal.TaskanaEngineImpl$InternalTaskanaEngineImpl", "", "", "", "pro.taskana.spi.task.internal.BeforeRequestReviewManager"), 632);
            ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAfterRequestReviewManager", "pro.taskana.common.internal.TaskanaEngineImpl$InternalTaskanaEngineImpl", "", "", "", "pro.taskana.spi.task.internal.AfterRequestReviewManager"), 637);
            ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBeforeRequestChangesManager", "pro.taskana.common.internal.TaskanaEngineImpl$InternalTaskanaEngineImpl", "", "", "", "pro.taskana.spi.task.internal.BeforeRequestChangesManager"), 642);
            ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAfterRequestChangesManager", "pro.taskana.common.internal.TaskanaEngineImpl$InternalTaskanaEngineImpl", "", "", "", "pro.taskana.spi.task.internal.AfterRequestChangesManager"), 647);
            ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskEndstatePreprocessorManager", "pro.taskana.common.internal.TaskanaEngineImpl$InternalTaskanaEngineImpl", "", "", "", "pro.taskana.spi.task.internal.TaskEndstatePreprocessorManager"), 652);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeInDatabaseConnection", "pro.taskana.common.internal.TaskanaEngineImpl$InternalTaskanaEngineImpl", "java.util.function.Supplier", "supplier", "", "java.lang.Object"), 572);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initSqlSession", "pro.taskana.common.internal.TaskanaEngineImpl$InternalTaskanaEngineImpl", "", "", "", "void"), 583);
            ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "domainExists", "pro.taskana.common.internal.TaskanaEngineImpl$InternalTaskanaEngineImpl", "java.lang.String", "domain", "", "boolean"), 592);
            ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSqlSession", "pro.taskana.common.internal.TaskanaEngineImpl$InternalTaskanaEngineImpl", "", "", "", "org.apache.ibatis.session.SqlSession"), 597);
            ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEngine", "pro.taskana.common.internal.TaskanaEngineImpl$InternalTaskanaEngineImpl", "", "", "", "pro.taskana.common.api.TaskanaEngine"), 602);
            ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getHistoryEventManager", "pro.taskana.common.internal.TaskanaEngineImpl$InternalTaskanaEngineImpl", "", "", "", "pro.taskana.spi.history.internal.HistoryEventManager"), 607);
            ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskRoutingManager", "pro.taskana.common.internal.TaskanaEngineImpl$InternalTaskanaEngineImpl", "", "", "", "pro.taskana.spi.routing.internal.TaskRoutingManager"), 612);
            ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCreateTaskPreprocessorManager", "pro.taskana.common.internal.TaskanaEngineImpl$InternalTaskanaEngineImpl", "", "", "", "pro.taskana.spi.task.internal.CreateTaskPreprocessorManager"), 617);
        }
    }

    private static class SessionStack {
        private final ThreadLocal<Deque<SqlSessionManager>> sessionStack = new ThreadLocal();
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        private SessionStack() {
        }

        private Deque<SqlSessionManager> getSessionStack() {
            Deque<SqlSessionManager> deque;
            Deque<SqlSessionManager> deque2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Deque<SqlSessionManager> stack = this.sessionStack.get();
            if (stack == null) {
                stack = new ArrayDeque<SqlSessionManager>();
                this.sessionStack.set(stack);
            }
            Deque<SqlSessionManager> deque3 = deque2 = (deque = stack);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, deque2);
            return deque;
        }

        private void pushSessionToStack(SqlSessionManager session) {
            SqlSessionManager sqlSessionManager = session;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)sqlSessionManager);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.getSessionStack().push(session);
            Object var4_4 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
        }

        private void popSessionFromStack() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Deque<SqlSessionManager> stack = this.getSessionStack();
            if (!stack.isEmpty()) {
                stack.pop();
            }
            Object var3_3 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var3_3);
        }

        static {
            SessionStack.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskanaEngineImpl.java", SessionStack.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getSessionStack", "pro.taskana.common.internal.TaskanaEngineImpl$SessionStack", "", "", "", "java.util.Deque"), 512);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "pushSessionToStack", "pro.taskana.common.internal.TaskanaEngineImpl$SessionStack", "org.apache.ibatis.session.SqlSessionManager", "session", "", "void"), 521);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "popSessionFromStack", "pro.taskana.common.internal.TaskanaEngineImpl$SessionStack", "", "", "", "void"), 525);
        }
    }
}

