/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.internal;

import java.time.Instant;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.IdGenerator;
import pro.taskana.task.api.exceptions.NotAuthorizedOnTaskCommentException;
import pro.taskana.task.api.exceptions.TaskCommentNotFoundException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.task.api.models.TaskComment;
import pro.taskana.task.internal.TaskCommentMapper;
import pro.taskana.task.internal.TaskMapper;
import pro.taskana.task.internal.TaskServiceImpl;
import pro.taskana.task.internal.models.TaskCommentImpl;
import pro.taskana.user.internal.UserMapper;
import pro.taskana.user.internal.models.UserImpl;
import pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException;

class TaskCommentServiceImpl {
    private static final Logger LOGGER;
    private final InternalTaskanaEngine taskanaEngine;
    private final TaskServiceImpl taskService;
    private final TaskCommentMapper taskCommentMapper;
    private final TaskMapper taskMapper;
    private final UserMapper userMapper;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    static {
        TaskCommentServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TaskCommentServiceImpl.class);
    }

    TaskCommentServiceImpl(InternalTaskanaEngine taskanaEngine, TaskCommentMapper taskCommentMapper, UserMapper userMapper, TaskMapper taskMapper, TaskServiceImpl taskService) {
        this.taskanaEngine = taskanaEngine;
        this.taskService = taskService;
        this.taskCommentMapper = taskCommentMapper;
        this.userMapper = userMapper;
        this.taskMapper = taskMapper;
    }

    TaskComment newTaskComment(String taskId) {
        TaskCommentImpl taskCommentImpl;
        TaskCommentImpl taskCommentImpl2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskCommentImpl taskComment = new TaskCommentImpl();
        taskComment.setTaskId(taskId);
        TaskCommentImpl taskCommentImpl3 = taskCommentImpl2 = (taskCommentImpl = taskComment);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentImpl2);
        return taskCommentImpl;
    }

    TaskComment updateTaskComment(TaskComment taskCommentToUpdate) throws ConcurrencyException, TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnTaskCommentException, NotAuthorizedOnWorkbasketException {
        TaskCommentImpl taskCommentImpl;
        TaskCommentImpl taskCommentImpl2;
        TaskCommentImpl taskCommentImplToUpdate;
        JoinPoint joinPoint;
        block5: {
            TaskComment taskComment = taskCommentToUpdate;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)taskComment);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
            taskCommentImplToUpdate = (TaskCommentImpl)taskCommentToUpdate;
            try {
                this.taskanaEngine.openConnection();
                TaskComment originalTaskComment = this.getTaskComment(taskCommentImplToUpdate.getId());
                if (originalTaskComment.getCreator().equals(userId) && taskCommentImplToUpdate.getCreator().equals(originalTaskComment.getCreator()) || this.taskanaEngine.getEngine().isUserInRole(TaskanaRole.ADMIN) || this.taskanaEngine.getEngine().isUserInRole(TaskanaRole.TASK_ADMIN)) {
                    this.checkModifiedHasNotChanged(originalTaskComment, taskCommentImplToUpdate);
                    taskCommentImplToUpdate.setModified(Instant.now());
                    this.taskCommentMapper.update(taskCommentImplToUpdate);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Method updateTaskComment() updated taskComment '{}' for user '{}'.", (Object)taskCommentImplToUpdate.getId(), (Object)userId);
                    }
                    break block5;
                }
                throw new NotAuthorizedOnTaskCommentException(userId, taskCommentImplToUpdate.getId());
            }
            finally {
                this.taskanaEngine.returnConnection();
            }
        }
        TaskCommentImpl taskCommentImpl3 = taskCommentImpl2 = (taskCommentImpl = taskCommentImplToUpdate);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentImpl2);
        return taskCommentImpl;
    }

    TaskComment createTaskComment(TaskComment taskCommentToCreate) throws TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnWorkbasketException {
        TaskCommentImpl taskCommentImpl;
        TaskCommentImpl taskCommentImpl2;
        TaskComment taskComment = taskCommentToCreate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)taskComment);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskCommentImpl taskCommentImplToCreate = (TaskCommentImpl)taskCommentToCreate;
        try {
            this.taskanaEngine.openConnection();
            this.taskService.getTask(taskCommentImplToCreate.getTaskId());
            this.validateNoneExistingTaskCommentId(taskCommentImplToCreate.getId());
            this.initDefaultTaskCommentValues(taskCommentImplToCreate);
            this.taskCommentMapper.insert(taskCommentImplToCreate);
            this.taskMapper.incrementNumberOfComments(taskCommentImplToCreate.getTaskId(), Instant.now());
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        TaskCommentImpl taskCommentImpl3 = taskCommentImpl2 = (taskCommentImpl = taskCommentImplToCreate);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentImpl2);
        return taskCommentImpl;
    }

    void deleteTaskComment(String taskCommentId) throws TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnTaskCommentException, NotAuthorizedOnWorkbasketException {
        JoinPoint joinPoint;
        block5: {
            String string = taskCommentId;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            String userId = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
            try {
                this.taskanaEngine.openConnection();
                TaskComment taskCommentToDelete = this.getTaskComment(taskCommentId);
                if (taskCommentToDelete.getCreator().equals(userId) || this.taskanaEngine.getEngine().isUserInRole(TaskanaRole.ADMIN) || this.taskanaEngine.getEngine().isUserInRole(TaskanaRole.TASK_ADMIN)) {
                    this.taskCommentMapper.delete(taskCommentId);
                    this.taskMapper.decrementNumberOfComments(taskCommentToDelete.getTaskId(), Instant.now());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("taskComment {} deleted", (Object)taskCommentToDelete.getId());
                    }
                    break block5;
                }
                throw new NotAuthorizedOnTaskCommentException(userId, taskCommentToDelete.getId());
            }
            finally {
                this.taskanaEngine.returnConnection();
            }
        }
        Object var7_7 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_7);
    }

    List<TaskComment> getTaskComments(String taskId) throws TaskNotFoundException, NotAuthorizedOnWorkbasketException {
        List list;
        List list2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            this.taskanaEngine.openConnection();
            this.taskService.getTask(taskId);
            List taskComments = this.taskService.createTaskCommentQuery().taskIdIn(taskId).list();
            if (taskComments.isEmpty() && LOGGER.isDebugEnabled()) {
                LOGGER.debug("getTaskComments() found no comments for the provided taskId");
            }
            List list3 = taskComments;
            list2 = list3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        List list4 = list = list2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list);
        return list2;
    }

    TaskComment getTaskComment(String taskCommentId) throws TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnWorkbasketException {
        TaskCommentImpl taskCommentImpl;
        TaskCommentImpl taskCommentImpl2;
        String string = taskCommentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.verifyTaskCommentIdIsNotNullOrEmpty(taskCommentId);
        try {
            UserImpl creator;
            this.taskanaEngine.openConnection();
            TaskCommentImpl result = this.taskCommentMapper.findById(taskCommentId);
            if (result == null) {
                throw new TaskCommentNotFoundException(taskCommentId);
            }
            this.taskService.getTask(result.getTaskId());
            if (this.taskanaEngine.getEngine().getConfiguration().isAddAdditionalUserInfo() && (creator = this.userMapper.findById(result.getCreator())) != null) {
                result.setCreatorFullName(creator.getFullName());
            }
            TaskCommentImpl taskCommentImpl3 = result;
            taskCommentImpl2 = taskCommentImpl3;
        }
        finally {
            this.taskanaEngine.returnConnection();
        }
        TaskCommentImpl taskCommentImpl4 = taskCommentImpl = taskCommentImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentImpl);
        return taskCommentImpl2;
    }

    private void checkModifiedHasNotChanged(TaskComment oldTaskComment, TaskComment taskCommentImplToUpdate) throws ConcurrencyException {
        TaskComment taskComment = oldTaskComment;
        TaskComment taskComment2 = taskCommentImplToUpdate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)taskComment, (Object)taskComment2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!oldTaskComment.getModified().equals(taskCommentImplToUpdate.getModified())) {
            throw new ConcurrencyException(taskCommentImplToUpdate.getId());
        }
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private void initDefaultTaskCommentValues(TaskCommentImpl taskCommentImplToCreate) {
        TaskCommentImpl taskCommentImpl = taskCommentImplToCreate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)taskCommentImpl);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant now = Instant.now();
        taskCommentImplToCreate.setId(IdGenerator.generateWithPrefix((String)"TCI"));
        taskCommentImplToCreate.setModified(now);
        taskCommentImplToCreate.setCreated(now);
        String creator = this.taskanaEngine.getEngine().getCurrentUserContext().getUserid();
        if (this.taskanaEngine.getEngine().getConfiguration().isSecurityEnabled() && creator == null) {
            throw new SystemException("TaskanaSecurity is enabled, but the current UserId is NULL while creating a TaskComment.");
        }
        taskCommentImplToCreate.setCreator(creator);
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private void validateNoneExistingTaskCommentId(String taskCommentId) throws InvalidArgumentException {
        String string = taskCommentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskCommentId != null && !taskCommentId.equals("")) {
            throw new InvalidArgumentException(String.format("taskCommentId must be null/empty for creation, but found %s", taskCommentId));
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private void verifyTaskCommentIdIsNotNullOrEmpty(String taskCommentId) throws InvalidArgumentException {
        String string = taskCommentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskCommentId == null || taskCommentId.isEmpty()) {
            throw new InvalidArgumentException("taskCommentId must not be null/empty for retrieval/deletion");
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskCommentServiceImpl.java", TaskCommentServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "newTaskComment", "pro.taskana.task.internal.TaskCommentServiceImpl", "java.lang.String", "taskId", "", "pro.taskana.task.api.models.TaskComment"), 45);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "updateTaskComment", "pro.taskana.task.internal.TaskCommentServiceImpl", "pro.taskana.task.api.models.TaskComment", "taskCommentToUpdate", "pro.taskana.common.api.exceptions.ConcurrencyException:pro.taskana.task.api.exceptions.TaskCommentNotFoundException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.task.api.exceptions.NotAuthorizedOnTaskCommentException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "pro.taskana.task.api.models.TaskComment"), 53);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "createTaskComment", "pro.taskana.task.internal.TaskCommentServiceImpl", "pro.taskana.task.api.models.TaskComment", "taskCommentToCreate", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "pro.taskana.task.api.models.TaskComment"), 99);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "deleteTaskComment", "pro.taskana.task.internal.TaskCommentServiceImpl", "java.lang.String", "taskCommentId", "pro.taskana.task.api.exceptions.TaskCommentNotFoundException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.task.api.exceptions.NotAuthorizedOnTaskCommentException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "void"), 125);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getTaskComments", "pro.taskana.task.internal.TaskCommentServiceImpl", "java.lang.String", "taskId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "java.util.List"), 160);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getTaskComment", "pro.taskana.task.internal.TaskCommentServiceImpl", "java.lang.String", "taskCommentId", "pro.taskana.task.api.exceptions.TaskCommentNotFoundException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "pro.taskana.task.api.models.TaskComment"), 182);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkModifiedHasNotChanged", "pro.taskana.task.internal.TaskCommentServiceImpl", "pro.taskana.task.api.models.TaskComment:pro.taskana.task.api.models.TaskComment", "oldTaskComment:taskCommentImplToUpdate", "pro.taskana.common.api.exceptions.ConcurrencyException", "void"), 218);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initDefaultTaskCommentValues", "pro.taskana.task.internal.TaskCommentServiceImpl", "pro.taskana.task.internal.models.TaskCommentImpl", "taskCommentImplToCreate", "", "void"), 226);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateNoneExistingTaskCommentId", "pro.taskana.task.internal.TaskCommentServiceImpl", "java.lang.String", "taskCommentId", "pro.taskana.common.api.exceptions.InvalidArgumentException", "void"), 244);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "verifyTaskCommentIdIsNotNullOrEmpty", "pro.taskana.task.internal.TaskCommentServiceImpl", "java.lang.String", "taskCommentId", "pro.taskana.common.api.exceptions.InvalidArgumentException", "void"), 254);
    }
}

