/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.sampledata;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.ibatis.jdbc.RuntimeSqlException;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.jdbc.SqlRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.sampledata.SampleDataProvider;
import pro.taskana.sampledata.SqlReplacer;

public class SampleDataGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SampleDataGenerator.class);
    private static final String CACHED_TEST = "TEST";
    private static final String CACHED_SAMPLE = "SAMPLE";
    private static final String CACHED_EVENTSAMPLE = "EVENTSAMPLE";
    private static final String CACHED_MONITOR = "MONITOR";
    private static final String CACHED_CLEARDB = "CLEARDB";
    private static final String CACHED_DROPDB = "DROPDB";
    private static HashMap<String, List<String>> cachedScripts = new HashMap();
    private final DataSource dataSource;
    private final ZonedDateTime now;
    private final String schema;

    public SampleDataGenerator(DataSource dataSource, String schema) {
        this(dataSource, schema, Instant.now().atZone(ZoneId.of("UTC")));
    }

    public SampleDataGenerator(DataSource dataSource, String schema, ZonedDateTime now) {
        this.dataSource = dataSource;
        this.schema = schema;
        this.now = now;
    }

    public void generateSampleData() {
        this.runScripts(runner -> {
            String cacheKey;
            Stream<String> scripts;
            this.clearDb();
            if (this.tableExists("HISTORY_EVENTS")) {
                scripts = SampleDataProvider.getScriptsWithEvents();
                cacheKey = CACHED_EVENTSAMPLE;
            } else {
                scripts = SampleDataProvider.getDefaultScripts();
                cacheKey = CACHED_SAMPLE;
            }
            this.executeAndCacheScripts(scripts, cacheKey);
        });
    }

    public void generateTestData() {
        Stream<String> scripts = SampleDataProvider.getTestDataScripts();
        this.executeAndCacheScripts(scripts, CACHED_TEST);
    }

    public void generateMonitorData() {
        Stream<String> scripts = SampleDataProvider.getMonitorDataScripts();
        this.executeAndCacheScripts(scripts, CACHED_MONITOR);
    }

    public void clearDb() {
        Stream<String> scripts = SampleDataProvider.getScriptsToClearDatabase();
        this.executeAndCacheScripts(scripts, CACHED_CLEARDB);
    }

    public void dropDb() {
        Stream<String> scripts = SampleDataProvider.getScriptsToDropDatabase();
        this.executeAndCacheScripts(scripts, CACHED_DROPDB);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean tableExists(String table) {
        try (Connection connection = this.dataSource.getConnection();){
            connection.setSchema(this.schema);
            SqlRunner runner = new SqlRunner(connection);
            String tableSafe = SqlReplacer.getSanitizedTableName(table);
            String query = "SELECT 1 FROM " + tableSafe + " LIMIT 1;";
            runner.run(query);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> parseScripts(Stream<String> scripts) {
        try (Connection connection = this.dataSource.getConnection();){
            String dbProductName = connection.getMetaData().getDatabaseProductName();
            List<String> list = scripts.map(script -> SqlReplacer.getScriptAsSql(dbProductName, this.now, script)).collect(Collectors.toList());
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeSqlException("Connection to database failed.", (Throwable)e);
        }
    }

    private void runScripts(Consumer<ScriptRunner> consumer) {
        try (Connection connection = this.dataSource.getConnection();){
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(connection.getMetaData().toString());
            }
            StringWriter outWriter = new StringWriter();
            StringWriter errorWriter = new StringWriter();
            ScriptRunner runner = this.getScriptRunner(connection, outWriter, errorWriter);
            consumer.accept(runner);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(outWriter.toString());
                String trimmedErrorString = errorWriter.toString().trim();
                if (!trimmedErrorString.isEmpty()) {
                    LOGGER.error(trimmedErrorString);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException("Failed to execute script.", (Throwable)e);
        }
    }

    private void executeAndCacheScripts(Stream<String> scripts, String cacheKey) {
        this.runScripts(runner -> cachedScripts.computeIfAbsent(cacheKey, key -> this.parseScripts(scripts)).stream().map(s -> s.getBytes(StandardCharsets.UTF_8)).map(ByteArrayInputStream::new).map(s -> new InputStreamReader((InputStream)s, StandardCharsets.UTF_8)).forEach(arg_0 -> ((ScriptRunner)runner).runScript(arg_0)));
    }

    private ScriptRunner getScriptRunner(Connection connection, StringWriter outWriter, StringWriter errorWriter) throws SQLException {
        PrintWriter logWriter = new PrintWriter(outWriter);
        PrintWriter errorLogWriter = new PrintWriter(errorWriter);
        ScriptRunner runner = new ScriptRunner(connection);
        connection.setSchema(this.schema);
        runner.setLogWriter(logWriter);
        runner.setErrorLogWriter(errorLogWriter);
        return runner;
    }
}

