/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.sampledata;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import pro.taskana.sampledata.SampleDataGenerator;

final class SqlReplacer {
    static final String RELATIVE_DATE_REGEX = "RELATIVE_DATE\\((-?\\d+)\\)";
    static final Pattern RELATIVE_DATE_PATTERN = Pattern.compile("RELATIVE_DATE\\((-?\\d+)\\)");
    static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    private SqlReplacer() {
    }

    static String getScriptAsSql(String dbProductName, ZonedDateTime now, String scriptPath) {
        return SqlReplacer.parseAndReplace(SqlReplacer.getScriptBufferedStream(scriptPath), now, dbProductName);
    }

    static boolean isPostgreSql(String databaseProductName) {
        return "PostgreSQL".equals(databaseProductName);
    }

    static boolean isDb2(String dbProductName) {
        return dbProductName != null && dbProductName.contains("DB2");
    }

    static String replaceDatePlaceholder(ZonedDateTime now, String sql) {
        Matcher m = RELATIVE_DATE_PATTERN.matcher(sql);
        StringBuffer sb = new StringBuffer(sql.length());
        while (m.find()) {
            long daysToShift = Long.parseLong(m.group(1));
            String daysAsStringDate = SqlReplacer.formatToSqlDate(now, daysToShift);
            m.appendReplacement(sb, daysAsStringDate);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    static BufferedReader getScriptBufferedStream(String script) {
        return Optional.ofNullable(SampleDataGenerator.class.getResourceAsStream(script)).map(inputStream -> new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8))).orElse(null);
    }

    static String getSanitizedTableName(String table) {
        return table.replaceAll("[^a-zA-Z0-9_]", "__");
    }

    private static String replaceBooleanWithInteger(String sql) {
        return sql.replaceAll("(?i)true", "1").replaceAll("(?i)false", "0");
    }

    private static String parseAndReplace(BufferedReader bufferedReader, ZonedDateTime now, String dbProductname) {
        boolean isDb2 = SqlReplacer.isDb2(dbProductname);
        String sql = bufferedReader.lines().collect(Collectors.joining(System.lineSeparator()));
        if (isDb2) {
            sql = SqlReplacer.replaceBooleanWithInteger(sql);
        }
        return SqlReplacer.replaceDatePlaceholder(now, sql);
    }

    private static String formatToSqlDate(ZonedDateTime now, long days) {
        return "'" + now.plusDays(days).format(DATE_TIME_FORMATTER) + "'";
    }
}

