/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.sampledata;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.impl.TaskanaEngineImpl;

public class SampleDataGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SampleDataGenerator.class);
    private static final String SQL = "/sql";
    private static final String TEST_DATA = "/sample-data";
    private static final String CLEAR = "/sql/sample-data/clear-db.sql";
    private static final String CLEAR_HISTORY_EVENTS = "/sql/sample-data/clear-history-events.sql";
    private static final String TASK = "/sql/sample-data/task.sql";
    private static final String WORKBASKET = "/sql/sample-data/workbasket.sql";
    private static final String DISTRIBUTION_TARGETS = "/sql/sample-data/distribution-targets.sql";
    private static final String WORKBASKET_ACCESS_LIST = "/sql/sample-data/workbasket-access-list.sql";
    private static final String CLASSIFICATION = "/sql/sample-data/classification.sql";
    private static final String OBJECT_REFERENCE = "/sql/sample-data/object-reference.sql";
    private static final String ATTACHMENT = "/sql/sample-data/attachment.sql";
    private static final String HISTORY_EVENT = "/sql/sample-data/history-event.sql";
    private static final String CHECK_HISTORY_EVENT_EXIST = "/sql/sample-data/check-history-event-exist.sql";
    private static final String RELATIVE_DATE_REGEX = "RELATIVE_DATE\\((-?\\d+)\\)";
    private static final Pattern RELATIVE_DATE_PATTERN = Pattern.compile("RELATIVE_DATE\\((-?\\d+)\\)");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private DataSource dataSource;
    private ScriptRunner runner;

    public SampleDataGenerator(DataSource dataSource) throws SQLException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(dataSource.getConnection().getMetaData().toString());
        }
        this.dataSource = dataSource;
        this.runner = new ScriptRunner(dataSource.getConnection());
    }

    public void generateSampleData(String schemaName) {
        StringWriter outWriter = new StringWriter();
        PrintWriter logWriter = new PrintWriter(outWriter);
        StringWriter errorWriter = new StringWriter();
        PrintWriter errorLogWriter = new PrintWriter(errorWriter);
        try {
            this.runner.runScript((Reader)this.selectSchemaScript(this.dataSource.getConnection().getMetaData().getDatabaseProductName(), schemaName));
            this.runner.setStopOnError(false);
            this.runner.runScript((Reader)new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(CLEAR), StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            LOGGER.error("caught Exception {}", (Throwable)e);
        }
        this.runner.setStopOnError(true);
        this.runner.setLogWriter(logWriter);
        this.runner.setErrorLogWriter(errorLogWriter);
        String[] script = this.getScriptList();
        LocalDateTime now = LocalDateTime.now();
        Stream.of(script).map(this.getClass()::getResourceAsStream).map(s -> SampleDataGenerator.parseAndReplace(now, s)).map(StringReader::new).map(BufferedReader::new).forEachOrdered(arg_0 -> ((ScriptRunner)this.runner).runScript(arg_0));
        this.runner.closeConnection();
        LOGGER.trace(outWriter.toString());
        if (!errorWriter.toString().trim().isEmpty()) {
            LOGGER.error(errorWriter.toString());
        }
    }

    private static String replaceRelativeTimeFunction(LocalDateTime now, String sql) {
        Matcher m = RELATIVE_DATE_PATTERN.matcher(sql);
        StringBuffer sb = new StringBuffer(sql.length());
        while (m.find()) {
            m.appendReplacement(sb, "'" + now.plusDays(Long.parseLong(m.group(1))).format(DATE_TIME_FORMATTER) + "'");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String parseAndReplace(LocalDateTime now, InputStream stream) {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String string = SampleDataGenerator.replaceRelativeTimeFunction(now, bufferedReader.lines().collect(Collectors.joining(System.lineSeparator())));
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private StringReader selectSchemaScript(String dbProductName, String schemaName) {
        return new StringReader(TaskanaEngineImpl.isPostgreSQL((String)dbProductName) ? "SET search_path TO " + schemaName + ";" : "SET SCHEMA " + schemaName + ";");
    }

    private String[] getScriptList() {
        String[] script = new String[]{WORKBASKET, DISTRIBUTION_TARGETS, CLASSIFICATION, TASK, ATTACHMENT, WORKBASKET_ACCESS_LIST, OBJECT_REFERENCE};
        ArrayList<String> scriptsList = new ArrayList<String>(Arrays.asList(script));
        try {
            this.runner.runScript((Reader)new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(CHECK_HISTORY_EVENT_EXIST), StandardCharsets.UTF_8)));
            this.runner.runScript((Reader)new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(CLEAR_HISTORY_EVENTS), StandardCharsets.UTF_8)));
            scriptsList.add(HISTORY_EVENT);
        }
        catch (Exception e) {
            LOGGER.error("The HISTORY_EVENTS table is not created");
        }
        return scriptsList.toArray(new String[0]);
    }
}

