/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.security;

import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.spi.LoginModule;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import pro.taskana.ldap.LdapCacheTestImpl;
import pro.taskana.rest.resource.AccessIdResource;
import pro.taskana.security.GroupPrincipal;
import pro.taskana.security.UserPrincipal;

public class SampleLoginModule
extends UsernamePasswordAuthenticationFilter
implements LoginModule {
    private NameCallback nameCallback;
    private PasswordCallback passwordCallback;
    private Subject subject;

    @Override
    public boolean abort() {
        return true;
    }

    @Override
    public boolean commit() {
        this.addUserPrincipalToSubject();
        this.addGroupSubjectsDerivedFromUsername();
        return true;
    }

    private void addGroupSubjectsDerivedFromUsername() {
        LdapCacheTestImpl ldapCacheTest = new LdapCacheTestImpl();
        String username = this.nameCallback.getName().toLowerCase();
        List<AccessIdResource> groups = ldapCacheTest.findGroupsOfUser(username, Integer.MAX_VALUE);
        groups.forEach(group -> {
            if (group.getAccessId().contains("ou=groups")) {
                this.subject.getPrincipals().add((Principal)new GroupPrincipal(group.getName()));
            }
        });
    }

    private void addUserPrincipalToSubject() {
        this.subject.getPrincipals().add((Principal)new UserPrincipal(this.nameCallback.getName()));
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        try {
            this.nameCallback = new NameCallback("prompt");
            this.passwordCallback = new PasswordCallback("prompt", false);
            callbackHandler.handle(new Callback[]{this.nameCallback, this.passwordCallback});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean login() {
        return this.nameCallback.getName().equals(new String(this.passwordCallback.getPassword()));
    }

    @Override
    public boolean logout() {
        return true;
    }
}

