/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.jobs;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import pro.taskana.TaskanaEngine;
import pro.taskana.TaskanaRole;
import pro.taskana.jobs.JobRunner;
import pro.taskana.jobs.TaskCleanupJob;
import pro.taskana.jobs.WorkbasketCleanupJob;
import pro.taskana.security.UserPrincipal;
import pro.taskana.transaction.TaskanaTransactionProvider;

@Component
public class JobScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobScheduler.class);
    @Autowired
    TaskanaTransactionProvider<Object> springTransactionProvider;
    @Autowired
    private TaskanaEngine taskanaEngine;

    @PostConstruct
    public void scheduleCleanupJob() {
        LOGGER.debug("Entry to scheduleCleanupJob.");
        TaskCleanupJob.initializeSchedule((TaskanaEngine)this.taskanaEngine);
        WorkbasketCleanupJob.initializeSchedule((TaskanaEngine)this.taskanaEngine);
        LOGGER.debug("Exit from scheduleCleanupJob.");
    }

    @Scheduled(cron="${taskana.jobscheduler.async.cron}")
    public void triggerJobs() {
        LOGGER.info("AsyncJobs started.");
        try {
            this.runAsyncJobsAsAdmin();
            LOGGER.info("AsyncJobs completed.");
        }
        catch (PrivilegedActionException e) {
            LOGGER.info("AsyncJobs failed.", (Throwable)e);
        }
    }

    private void runAsyncJobsAsAdmin() throws PrivilegedActionException {
        Subject.doAs(this.getAdminSubject(), new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                try {
                    JobRunner runner = new JobRunner(JobScheduler.this.taskanaEngine);
                    runner.registerTransactionProvider(JobScheduler.this.springTransactionProvider);
                    LOGGER.info("Running Jobs");
                    runner.runJobs();
                    return "Successful";
                }
                catch (Throwable e) {
                    throw new Exception(e);
                }
            }
        });
    }

    private Subject getAdminSubject() {
        Subject subject = new Subject();
        ArrayList<UserPrincipal> principalList = new ArrayList<UserPrincipal>();
        try {
            principalList.add(new UserPrincipal((String)((Set)this.taskanaEngine.getConfiguration().getRoleMap().get(TaskanaRole.ADMIN)).iterator().next()));
        }
        catch (Throwable t) {
            LOGGER.warn("Could not determine a configured admin user.", t);
        }
        subject.getPrincipals().addAll(principalList);
        return subject;
    }
}

