/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.security;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.ldap.core.ContextSource;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.SimpleAuthorityMapper;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.web.jaasapi.JaasApiIntegrationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import pro.taskana.rest.security.SpringSecurityToJaasFilter;

@Configuration
@EnableWebSecurity
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    @Value(value="${taskana.ldap.serverUrl:ldap://localhost:10389}")
    private String ldapServerUrl;
    @Value(value="${taskana.ldap.baseDn:OU=Test,O=TASKANA}")
    private String ldapBaseDn;
    @Value(value="${taskana.ldap.groupSearchBase:cn=groups}")
    private String ldapGroupSearchBase;
    @Value(value="${taskana.ldap.userDnPatterns:uid={0},cn=users}")
    private String ldapUserDnPatterns;
    @Value(value="${taskana.ldap.groupSearchFilter:uniqueMember={0}}")
    private String ldapGroupSearchFilter;
    @Value(value="${devMode:false}")
    private boolean devMode;

    @Bean
    public WebMvcConfigurer corsConfigurer() {
        return new CorsWebMvcConfigurer();
    }

    @Bean
    public FilterRegistrationBean<CorsFilter> corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addAllowedOrigin("*");
        config.addAllowedHeader("*");
        config.addAllowedMethod("*");
        config.addAllowedMethod("POST");
        source.registerCorsConfiguration("/**", config);
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new CorsFilter((CorsConfigurationSource)source), new ServletRegistrationBean[0]);
        bean.setOrder(0);
        return bean;
    }

    @Bean
    public DefaultSpringSecurityContextSource defaultSpringSecurityContextSource() {
        return new DefaultSpringSecurityContextSource(this.ldapServerUrl + "/" + this.ldapBaseDn);
    }

    @Bean
    public LdapAuthoritiesPopulator authoritiesPopulator() {
        Function<Map, GrantedAuthority> authorityMapper = record -> {
            String role = (String)((List)record.get("spring.security.ldap.dn")).get(0);
            return new SimpleGrantedAuthority(role);
        };
        DefaultLdapAuthoritiesPopulator populator = new DefaultLdapAuthoritiesPopulator((ContextSource)this.defaultSpringSecurityContextSource(), this.ldapGroupSearchBase);
        populator.setGroupSearchFilter(this.ldapGroupSearchFilter);
        populator.setSearchSubtree(true);
        populator.setRolePrefix("");
        populator.setAuthorityMapper(authorityMapper);
        return populator;
    }

    @Bean
    public GrantedAuthoritiesMapper grantedAuthoritiesMapper() {
        SimpleAuthorityMapper grantedAuthoritiesMapper = new SimpleAuthorityMapper();
        grantedAuthoritiesMapper.setPrefix("");
        return grantedAuthoritiesMapper;
    }

    public void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.ldapAuthentication().userDnPatterns(new String[]{this.ldapUserDnPatterns}).groupSearchBase(this.ldapGroupSearchBase).ldapAuthoritiesPopulator(this.authoritiesPopulator()).authoritiesMapper(this.grantedAuthoritiesMapper()).contextSource().url(this.ldapServerUrl + "/" + this.ldapBaseDn).and().passwordCompare().passwordAttribute("userPassword");
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/css/**", "/img/**"})).permitAll().and()).csrf().disable()).httpBasic().and()).authorizeRequests().antMatchers(HttpMethod.GET, new String[]{"/docs/**"})).permitAll().and()).addFilter((Filter)this.jaasApiIntegrationFilter()).addFilterAfter((Filter)new SpringSecurityToJaasFilter(), JaasApiIntegrationFilter.class);
        if (this.devMode) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.headers().frameOptions().sameOrigin().and()).authorizeRequests().antMatchers(new String[]{"/h2-console/**"})).permitAll();
        } else {
            this.addLoginPageConfiguration(http);
        }
    }

    protected void addLoginPageConfiguration(HttpSecurity http) throws Exception {
        ((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).fullyAuthenticated().and()).formLogin().loginPage("/login").failureUrl("/login?error")).defaultSuccessUrl("/")).permitAll()).and()).logout().invalidateHttpSession(true).clearAuthentication(true).logoutRequestMatcher((RequestMatcher)new AntPathRequestMatcher("/logout")).logoutSuccessUrl("/login?logout").deleteCookies(new String[]{"JSESSIONID"}).permitAll();
    }

    protected JaasApiIntegrationFilter jaasApiIntegrationFilter() {
        JaasApiIntegrationFilter filter = new JaasApiIntegrationFilter();
        filter.setCreateEmptySubject(true);
        return filter;
    }

    private static class CorsWebMvcConfigurer
    implements WebMvcConfigurer {
        private CorsWebMvcConfigurer() {
        }

        public void addCorsMappings(CorsRegistry registry) {
            registry.addMapping("/**").allowedOrigins(new String[]{"*"});
        }
    }
}

