/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.Task;
import pro.taskana.TaskService;
import pro.taskana.TaskState;
import pro.taskana.TaskSummary;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.InvalidOwnerException;
import pro.taskana.exceptions.InvalidStateException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.NotAuthorizedToQueryWorkbasketException;
import pro.taskana.exceptions.TaskNotFoundException;
import pro.taskana.rest.query.TaskFilter;

@RestController
@RequestMapping(path={"/v1/tasks"}, produces={"application/json"})
public class TaskController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskController.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private TaskFilter taskLogic;

    @GetMapping
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<List<TaskSummary>> getTasks(@RequestParam MultiValueMap<String, String> params) {
        try {
            if (params.keySet().size() == 0) {
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(this.taskLogic.getAll());
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(this.taskLogic.inspectPrams(params));
        }
        catch (NotAuthorizedException e) {
            LOGGER.error("Something went wrong with the Authorisation, while getting all Tasks.", (Throwable)e);
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
        }
        catch (InvalidArgumentException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return ResponseEntity.status((HttpStatus)HttpStatus.PRECONDITION_FAILED).build();
        }
    }

    @GetMapping(path={"/{taskId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<Task> getTask(@PathVariable String taskId) {
        try {
            Task task = this.taskService.getTask(taskId);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)task);
        }
        catch (TaskNotFoundException e) {
            LOGGER.error("The searched Task couldn\u00b4t be found or does not exist.", (Throwable)e);
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).build();
        }
    }

    @GetMapping(path={"/workbasket/{workbasketId}/state/{taskState}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<List<TaskSummary>> getTasksByWorkbasketIdAndState(@PathVariable String workbasketId, @PathVariable TaskState taskState) {
        try {
            List taskList = this.taskService.createTaskQuery().workbasketIdIn(new String[]{workbasketId}).stateIn(new TaskState[]{taskState}).list();
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)taskList);
        }
        catch (NotAuthorizedToQueryWorkbasketException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).build();
        }
        catch (Exception e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PostMapping(path={"/{taskId}/claim"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Task> claimTask(@PathVariable String taskId, @RequestBody String userName) {
        try {
            this.taskService.claim(taskId);
            Task updatedTask = this.taskService.getTask(taskId);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)updatedTask);
        }
        catch (TaskNotFoundException e) {
            LOGGER.error("The given Task coundn\u00b4t be found/claimd or does not Exist.", (Throwable)e);
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).build();
        }
        catch (InvalidOwnerException | InvalidStateException e) {
            LOGGER.error("The given Task could not be claimed. Reason: {}", e);
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).build();
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{taskId}/complete"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Task> completeTask(@PathVariable String taskId) {
        try {
            this.taskService.completeTask(taskId, true);
            Task updatedTask = this.taskService.getTask(taskId);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)updatedTask);
        }
        catch (TaskNotFoundException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).build();
        }
        catch (InvalidOwnerException | InvalidStateException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return ResponseEntity.status((HttpStatus)HttpStatus.PRECONDITION_FAILED).build();
        }
    }

    @RequestMapping(method={RequestMethod.POST})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Task> createTask(@RequestBody Task task) {
        try {
            Task createdTask = this.taskService.createTask(task);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdTask);
        }
        catch (Exception e) {
            LOGGER.error("Something went wrong: ", (Throwable)e);
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @RequestMapping(path={"/{taskId}/transfer/{workbasketKey}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Task> transferTask(@PathVariable String taskId, @PathVariable String workbasketKey) {
        try {
            Task updatedTask = this.taskService.transfer(taskId, workbasketKey);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)updatedTask);
        }
        catch (Exception e) {
            LOGGER.error("Something went wrong: ", (Throwable)e);
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(path={"/workbasket/{workbasketId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<List<TaskSummary>> getTasksummariesByWorkbasketId(@PathVariable String workbasketId) {
        List taskSummaries = null;
        try {
            taskSummaries = this.taskService.createTaskQuery().workbasketIdIn(new String[]{workbasketId}).list();
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)taskSummaries);
        }
        catch (NotAuthorizedToQueryWorkbasketException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).build();
        }
        catch (Exception ex) {
            if (taskSummaries == null) {
                taskSummaries = Collections.emptyList();
            }
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }
}

