/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.BaseQuery;
import pro.taskana.Workbasket;
import pro.taskana.WorkbasketAccessItem;
import pro.taskana.WorkbasketPermission;
import pro.taskana.WorkbasketQuery;
import pro.taskana.WorkbasketService;
import pro.taskana.WorkbasketSummary;
import pro.taskana.WorkbasketType;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.InvalidWorkbasketException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.WorkbasketInUseException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.rest.resource.WorkbasketAccessItemResource;
import pro.taskana.rest.resource.WorkbasketResource;
import pro.taskana.rest.resource.WorkbasketSummaryResource;
import pro.taskana.rest.resource.mapper.WorkbasketAccessItemMapper;
import pro.taskana.rest.resource.mapper.WorkbasketMapper;
import pro.taskana.rest.resource.mapper.WorkbasketSummaryMapper;

@RestController
@RequestMapping(path={"/v1/workbaskets"}, produces={"application/json"})
public class WorkbasketController {
    private static final String LIKE = "%";
    private static final String NAME = "name";
    private static final String KEY = "key";
    private static final String DESCRIPTION = "description";
    private static final String OWNER = "owner";
    private static final String TYPE = "type";
    private static final String DESC = "desc";
    @Autowired
    private WorkbasketService workbasketService;
    @Autowired
    private WorkbasketSummaryMapper workbasketSummaryMapper;
    @Autowired
    private WorkbasketMapper workbasketMapper;
    @Autowired
    private WorkbasketAccessItemMapper workbasketAccessItemMapper;

    @GetMapping
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<List<WorkbasketSummaryResource>> getWorkbaskets(@RequestParam(value="sortBy", defaultValue="name", required=false) String sortBy, @RequestParam(value="order", defaultValue="asc", required=false) String order, @RequestParam(value="name", required=false) String name, @RequestParam(value="nameLike", required=false) String nameLike, @RequestParam(value="key", required=false) String key, @RequestParam(value="keyLike", required=false) String keyLike, @RequestParam(value="descLike", required=false) String descLike, @RequestParam(value="owner", required=false) String owner, @RequestParam(value="ownerLike", required=false) String ownerLike, @RequestParam(value="type", required=false) String type, @RequestParam(value="requiredPermission", required=false) String requiredPermission) {
        try {
            WorkbasketQuery query = this.workbasketService.createWorkbasketQuery();
            this.addSortingToQuery(query, sortBy, order);
            this.addAttributeFilter(query, name, nameLike, key, keyLike, descLike, owner, ownerLike, type);
            this.addAuthorizationFilter(query, requiredPermission);
            List workbasketsSummary = query.list();
            return new ResponseEntity(workbasketsSummary.stream().map(workbasket -> this.workbasketSummaryMapper.toResource((WorkbasketSummary)workbasket)).collect(Collectors.toList()), HttpStatus.OK);
        }
        catch (InvalidArgumentException ex) {
            return new ResponseEntity(HttpStatus.PRECONDITION_FAILED);
        }
    }

    @GetMapping(path={"/{workbasketId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketResource> getWorkbasket(@PathVariable(value="workbasketId") String workbasketId) {
        ResponseEntity result;
        try {
            Workbasket workbasket = this.workbasketService.getWorkbasket(workbasketId);
            result = new ResponseEntity((Object)this.workbasketMapper.toResource(workbasket), HttpStatus.OK);
        }
        catch (WorkbasketNotFoundException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            result = new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (NotAuthorizedException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            result = new ResponseEntity(HttpStatus.UNAUTHORIZED);
        }
        return result;
    }

    @DeleteMapping(path={"/{workbasketId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<?> deleteWorkbasket(@PathVariable(value="workbasketId") String workbasketId) {
        ResponseEntity result = ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).build();
        try {
            this.workbasketService.deleteWorkbasket(workbasketId);
        }
        catch (WorkbasketNotFoundException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            result = ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).build();
        }
        catch (NotAuthorizedException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            result = ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
        }
        catch (WorkbasketInUseException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            result = ResponseEntity.status((HttpStatus)HttpStatus.LOCKED).build();
        }
        catch (InvalidArgumentException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            result = ResponseEntity.status((HttpStatus)HttpStatus.PRECONDITION_FAILED).build();
        }
        return result;
    }

    @PostMapping
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketResource> createWorkbasket(@RequestBody WorkbasketResource workbasketResource) throws NotAuthorizedException {
        try {
            Workbasket workbasket = this.workbasketMapper.toModel(workbasketResource);
            workbasket = this.workbasketService.createWorkbasket(workbasket);
            return new ResponseEntity((Object)this.workbasketMapper.toResource(workbasket), HttpStatus.CREATED);
        }
        catch (InvalidWorkbasketException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
    }

    @PutMapping(path={"/{workbasketId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketResource> updateWorkbasket(@PathVariable(value="workbasketId") String workbasketId, @RequestBody WorkbasketResource workbasketResource) {
        ResponseEntity result;
        try {
            if (!workbasketId.equals(workbasketResource.workbasketId)) {
                throw new InvalidWorkbasketException("Target-WB-ID('" + workbasketId + "') is not identical with the WB-ID of to object which should be updated. ID=('" + workbasketResource.getId() + "')");
            }
            Workbasket workbasket = this.workbasketMapper.toModel(workbasketResource);
            workbasket = this.workbasketService.updateWorkbasket(workbasket);
            result = ResponseEntity.ok((Object)((Object)this.workbasketMapper.toResource(workbasket)));
        }
        catch (InvalidWorkbasketException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            result = new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        catch (WorkbasketNotFoundException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            result = new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (NotAuthorizedException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            result = new ResponseEntity(HttpStatus.UNAUTHORIZED);
        }
        return result;
    }

    @GetMapping(path={"/{workbasketId}/workbasketAccessItems"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<List<WorkbasketAccessItemResource>> getWorkbasketAccessItems(@PathVariable(value="workbasketId") String workbasketId) {
        List wbAuthorizations;
        ArrayList result = new ArrayList();
        try {
            wbAuthorizations = this.workbasketService.getWorkbasketAccessItems(workbasketId);
        }
        catch (NotAuthorizedException e1) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity(result, HttpStatus.UNAUTHORIZED);
        }
        wbAuthorizations.forEach(accItem -> {
            try {
                result.add(this.workbasketAccessItemMapper.toResource((WorkbasketAccessItem)accItem));
            }
            catch (NotAuthorizedException e) {
                e.printStackTrace();
            }
        });
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @PostMapping(path={"/workbasketAccessItems"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketAccessItemResource> createWorkbasketAccessItem(@RequestBody WorkbasketAccessItemResource workbasketAccessItemResource) throws NotAuthorizedException {
        try {
            WorkbasketAccessItem workbasketAccessItem = this.workbasketAccessItemMapper.toModel(workbasketAccessItemResource);
            workbasketAccessItem = this.workbasketService.createWorkbasketAccessItem(workbasketAccessItem);
            return new ResponseEntity((Object)this.workbasketAccessItemMapper.toResource(workbasketAccessItem), HttpStatus.OK);
        }
        catch (InvalidArgumentException e) {
            return new ResponseEntity(HttpStatus.PRECONDITION_FAILED);
        }
    }

    @PutMapping(path={"/workbasketAccessItems/{workbasketAccessItemId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketAccessItemResource> updateWorkbasketAccessItem(@PathVariable(value="authId") String authId, @RequestBody WorkbasketAccessItemResource workbasketAccessItemResource) {
        try {
            WorkbasketAccessItem workbasketAccessItem = this.workbasketAccessItemMapper.toModel(workbasketAccessItemResource);
            workbasketAccessItem = this.workbasketService.updateWorkbasketAccessItem(workbasketAccessItem);
            return new ResponseEntity((Object)this.workbasketAccessItemMapper.toResource(workbasketAccessItem), HttpStatus.OK);
        }
        catch (InvalidArgumentException | NotAuthorizedException e) {
            return new ResponseEntity(HttpStatus.PRECONDITION_FAILED);
        }
    }

    @PutMapping(value={"/{workbasketId}/workbasketAccessItems/"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<?> setWorkbasketAccessItems(@PathVariable(value="workbasketId") String workbasketId, @RequestBody List<WorkbasketAccessItemResource> workbasketAccessResourceItems) {
        try {
            if (workbasketAccessResourceItems == null) {
                throw new InvalidArgumentException("Can\u00b4t create something with NULL body-value.");
            }
            ArrayList wbAccessItems = new ArrayList();
            workbasketAccessResourceItems.forEach(item -> wbAccessItems.add(this.workbasketAccessItemMapper.toModel((WorkbasketAccessItemResource)((Object)item))));
            try {
                this.workbasketService.setWorkbasketAccessItems(workbasketId, wbAccessItems);
            }
            catch (NotAuthorizedException e) {
                TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
                return new ResponseEntity(HttpStatus.UNAUTHORIZED);
            }
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        catch (NullPointerException | InvalidArgumentException e) {
            return new ResponseEntity(HttpStatus.PRECONDITION_FAILED);
        }
    }

    @DeleteMapping(path={"/workbasketAccessItems/{workbasketAccessItemId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<?> deleteWorkbasketAccessItem(@PathVariable(value="authId") String authId) throws NotAuthorizedException {
        this.workbasketService.deleteWorkbasketAccessItem(authId);
        return ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).build();
    }

    @GetMapping(path={"/{workbasketId}/distributiontargets"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<List<WorkbasketSummaryResource>> getDistributionTargetsForWorkbasketId(@PathVariable(value="workbasketId") String workbasketId) {
        ResponseEntity result;
        try {
            List distributionTargets = this.workbasketService.getDistributionTargets(workbasketId);
            result = new ResponseEntity(distributionTargets.stream().map(workbasket -> this.workbasketSummaryMapper.toResource((WorkbasketSummary)workbasket)).collect(Collectors.toList()), HttpStatus.OK);
        }
        catch (WorkbasketNotFoundException e) {
            result = new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (NotAuthorizedException e) {
            result = new ResponseEntity(HttpStatus.UNAUTHORIZED);
        }
        return result;
    }

    @PutMapping(path={"/{workbasketId}/distributiontargets"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<?> setDistributionTargetsForWorkbasketId(@PathVariable(value="workbasketId") String sourceWorkbasketId, @RequestBody List<String> targetWorkbasketIds) {
        ResponseEntity result;
        try {
            this.workbasketService.setDistributionTargets(sourceWorkbasketId, targetWorkbasketIds);
            result = ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).build();
        }
        catch (WorkbasketNotFoundException e) {
            result = ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).build();
        }
        catch (NotAuthorizedException e) {
            result = ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
        }
        return result;
    }

    private void addAuthorizationFilter(WorkbasketQuery query, String requiredPermission) throws InvalidArgumentException {
        if (requiredPermission == null) {
            return;
        }
        block38: for (String authorization : Arrays.asList(requiredPermission.split(","))) {
            switch (authorization.trim()) {
                case "READ": {
                    query.callerHasPermission(WorkbasketPermission.READ);
                    continue block38;
                }
                case "OPEN": {
                    query.callerHasPermission(WorkbasketPermission.OPEN);
                    continue block38;
                }
                case "APPEND": {
                    query.callerHasPermission(WorkbasketPermission.APPEND);
                    continue block38;
                }
                case "TRANSFER": {
                    query.callerHasPermission(WorkbasketPermission.TRANSFER);
                    continue block38;
                }
                case "DISTRIBUTE": {
                    query.callerHasPermission(WorkbasketPermission.DISTRIBUTE);
                    continue block38;
                }
                case "CUSTOM_1": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_1);
                    continue block38;
                }
                case "CUSTOM_2": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_2);
                    continue block38;
                }
                case "CUSTOM_3": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_3);
                    continue block38;
                }
                case "CUSTOM_4": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_4);
                    continue block38;
                }
                case "CUSTOM_5": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_5);
                    continue block38;
                }
                case "CUSTOM_6": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_6);
                    continue block38;
                }
                case "CUSTOM_7": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_7);
                    continue block38;
                }
                case "CUSTOM_8": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_8);
                    continue block38;
                }
                case "CUSTOM_9": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_9);
                    continue block38;
                }
                case "CUSTOM_10": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_10);
                    continue block38;
                }
                case "CUSTOM_11": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_11);
                    continue block38;
                }
                case "CUSTOM_12": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_12);
                    continue block38;
                }
            }
            throw new InvalidArgumentException("Unknown authorization '" + authorization + "'");
        }
    }

    private void addSortingToQuery(WorkbasketQuery query, String sortBy, String order) throws IllegalArgumentException {
        BaseQuery.SortDirection sortDirection = this.getSortDirection(order);
        switch (sortBy) {
            case "name": {
                query.orderByName(sortDirection);
                break;
            }
            case "key": {
                query.orderByKey(sortDirection);
                break;
            }
            case "description": {
                query.orderByDescription(sortDirection);
                break;
            }
            case "owner": {
                query.orderByOwner(sortDirection);
                break;
            }
            case "type": {
                query.orderByType(sortDirection);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown order '" + sortBy + "'");
            }
        }
    }

    private BaseQuery.SortDirection getSortDirection(String order) {
        if (order.equals(DESC)) {
            return BaseQuery.SortDirection.DESCENDING;
        }
        return BaseQuery.SortDirection.ASCENDING;
    }

    private void addAttributeFilter(WorkbasketQuery query, String name, String nameLike, String key, String keyLike, String descLike, String owner, String ownerLike, String type) throws InvalidArgumentException {
        if (name != null) {
            query.nameIn(new String[]{name});
        }
        if (nameLike != null) {
            query.nameLike(new String[]{LIKE + nameLike + LIKE});
        }
        if (key != null) {
            query.keyIn(new String[]{key});
        }
        if (keyLike != null) {
            query.keyLike(new String[]{LIKE + keyLike + LIKE});
        }
        if (owner != null) {
            query.ownerIn(new String[]{owner});
        }
        if (ownerLike != null) {
            query.ownerLike(new String[]{LIKE + ownerLike + LIKE});
        }
        if (descLike != null) {
            query.descriptionLike(new String[]{LIKE + descLike + LIKE});
        }
        if (type != null) {
            switch (type) {
                case "PERSONAL": {
                    query.typeIn(new WorkbasketType[]{WorkbasketType.PERSONAL});
                    break;
                }
                case "GROUP": {
                    query.typeIn(new WorkbasketType[]{WorkbasketType.GROUP});
                    break;
                }
                case "CLEARANCE": {
                    query.typeIn(new WorkbasketType[]{WorkbasketType.CLEARANCE});
                    break;
                }
                case "TOPIC": {
                    query.typeIn(new WorkbasketType[]{WorkbasketType.TOPIC});
                    break;
                }
                default: {
                    throw new InvalidArgumentException("Unknown Workbaskettype '" + type + "'");
                }
            }
        }
    }
}

