/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import pro.taskana.TaskQuery;
import pro.taskana.TaskService;
import pro.taskana.TaskState;
import pro.taskana.TaskSummary;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.NotAuthorizedException;

@Component
public class TaskFilter {
    private static final String CLASSIFICATION = "classification";
    private static final String POR = "por";
    private static final String DOT = ".";
    private static final String STATE = "state";
    private static final String PRIORITY = "priority";
    private static final String DESCRIPTION = "description";
    private static final String NAME = "name";
    private static final String OWNER = "owner";
    private static final String WORKBASKET_ID = "workbasketId";
    private static final String CUSTOM = "custom";
    private static final String IS_TRANSFERRED = "isTransferred";
    private static final String IS_READ = "isRead";
    private static final String CLASSIFICATION_KEY = "classification.key";
    private static final String POR_VALUE = "por.value";
    private static final String POR_TYPE = "por.type";
    private static final String POR_SYSTEM_INSTANCE = "por.systemInstance";
    private static final String POR_SYSTEM = "por.system";
    private static final String POR_COMPANY = "por.company";
    private static final String CLAIMED = "CLAIMED";
    private static final String COMPLETED = "COMPLETED";
    private static final String READY = "READY";
    private static final String COMMA = ",";
    @Autowired
    private TaskService taskService;

    public List<TaskSummary> getAll() throws NotAuthorizedException {
        return this.taskService.createTaskQuery().list();
    }

    public List<TaskSummary> inspectPrams(MultiValueMap<String, String> params) throws NotAuthorizedException, InvalidArgumentException {
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        if (params.containsKey((Object)NAME)) {
            String[] names = this.extractCommaSeperatedFields((List)params.get((Object)NAME));
            taskQuery.nameIn(names);
        }
        if (params.containsKey((Object)DESCRIPTION)) {
            taskQuery.descriptionLike(new String[]{(String)((List)params.get((Object)DESCRIPTION)).get(0)});
        }
        if (params.containsKey((Object)PRIORITY)) {
            String[] prioritesInString = this.extractCommaSeperatedFields((List)params.get((Object)PRIORITY));
            int[] priorites = this.extractPriorities(prioritesInString);
            taskQuery.priorityIn(priorites);
        }
        if (params.containsKey((Object)STATE)) {
            TaskState[] states = this.extractStates(params);
            taskQuery.stateIn(states);
        }
        if (params.containsKey((Object)CLASSIFICATION_KEY)) {
            String[] classificationKeys = this.extractCommaSeperatedFields((List)params.get((Object)CLASSIFICATION_KEY));
            taskQuery.classificationKeyIn(classificationKeys);
        }
        if (params.containsKey((Object)WORKBASKET_ID)) {
            String[] workbaskets = this.extractCommaSeperatedFields((List)params.get((Object)WORKBASKET_ID));
            taskQuery.workbasketIdIn(workbaskets);
        }
        if (params.containsKey((Object)OWNER)) {
            String[] owners = this.extractCommaSeperatedFields((List)params.get((Object)OWNER));
            taskQuery.ownerIn(owners);
        }
        if (params.keySet().stream().filter(s -> s.startsWith(POR)).toArray().length > 0) {
            if (params.containsKey((Object)POR_COMPANY)) {
                String[] companies = this.extractCommaSeperatedFields((List)params.get((Object)POR_COMPANY));
                taskQuery.primaryObjectReferenceCompanyIn(companies);
            }
            if (params.containsKey((Object)POR_SYSTEM)) {
                String[] systems = this.extractCommaSeperatedFields((List)params.get((Object)POR_SYSTEM));
                taskQuery.primaryObjectReferenceSystemIn(systems);
            }
            if (params.containsKey((Object)POR_SYSTEM_INSTANCE)) {
                String[] systemInstances = this.extractCommaSeperatedFields((List)params.get((Object)POR_SYSTEM_INSTANCE));
                taskQuery.primaryObjectReferenceSystemInstanceIn(systemInstances);
            }
            if (params.containsKey((Object)POR_TYPE)) {
                String[] types = this.extractCommaSeperatedFields((List)params.get((Object)POR_TYPE));
                taskQuery.primaryObjectReferenceTypeIn(types);
            }
            if (params.containsKey((Object)POR_VALUE)) {
                String[] values = this.extractCommaSeperatedFields((List)params.get((Object)POR_VALUE));
                taskQuery.primaryObjectReferenceValueIn(values);
            }
        }
        if (params.containsKey((Object)IS_READ)) {
            taskQuery.readEquals(Boolean.valueOf(Boolean.getBoolean((String)((List)params.get((Object)IS_READ)).get(0))));
        }
        if (params.containsKey((Object)IS_TRANSFERRED)) {
            taskQuery.transferredEquals(Boolean.valueOf(Boolean.getBoolean((String)((List)params.get((Object)IS_TRANSFERRED)).get(0))));
        }
        if (params.containsKey((Object)CUSTOM)) {
            String[] custom = this.extractCommaSeperatedFields((List)params.get((Object)CUSTOM));
            taskQuery.customFieldsIn(custom);
        }
        return taskQuery.list();
    }

    private int[] extractPriorities(String[] prioritesInString) {
        int[] priorites = new int[prioritesInString.length];
        for (int i = 0; i < prioritesInString.length; ++i) {
            priorites[i] = Integer.getInteger(prioritesInString[i]);
        }
        return priorites;
    }

    private String[] extractCommaSeperatedFields(List<String> list) {
        ArrayList values = new ArrayList();
        list.forEach(item -> values.addAll(Arrays.asList(item.split(COMMA))));
        return values.toArray(new String[0]);
    }

    private TaskState[] extractStates(MultiValueMap<String, String> params) throws InvalidArgumentException {
        ArrayList<TaskState> states = new ArrayList<TaskState>();
        for (String item : (List)params.get((Object)STATE)) {
            String[] stringArray = item.split(COMMA);
            int n = stringArray.length;
            block11: for (int i = 0; i < n; ++i) {
                String state;
                switch (state = stringArray[i]) {
                    case "READY": {
                        states.add(TaskState.READY);
                        continue block11;
                    }
                    case "COMPLETED": {
                        states.add(TaskState.COMPLETED);
                        continue block11;
                    }
                    case "CLAIMED": {
                        states.add(TaskState.CLAIMED);
                        continue block11;
                    }
                    default: {
                        throw new InvalidArgumentException("Unknown status '" + state + "'");
                    }
                }
            }
        }
        return states.toArray(new TaskState[0]);
    }
}

