/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource.mapper;

import java.time.Instant;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Component;
import pro.taskana.Workbasket;
import pro.taskana.WorkbasketService;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.impl.WorkbasketImpl;
import pro.taskana.rest.WorkbasketController;
import pro.taskana.rest.resource.WorkbasketResource;

@Component
public class WorkbasketMapper {
    @Autowired
    private WorkbasketService workbasketService;

    public WorkbasketResource toResource(Workbasket wb) throws NotAuthorizedException {
        WorkbasketResource resource = new WorkbasketResource();
        BeanUtils.copyProperties((Object)wb, (Object)((Object)resource));
        resource.setWorkbasketId(wb.getId());
        resource.setModified(wb.getModified().toString());
        resource.setCreated(wb.getCreated().toString());
        return this.addLinks(resource, wb);
    }

    public Workbasket toModel(WorkbasketResource wbResource) throws NotAuthorizedException {
        WorkbasketImpl workbasket = (WorkbasketImpl)this.workbasketService.newWorkbasket(wbResource.key, wbResource.domain);
        BeanUtils.copyProperties((Object)((Object)wbResource), (Object)workbasket);
        workbasket.setId(wbResource.workbasketId);
        workbasket.setModified(Instant.parse(wbResource.modified));
        workbasket.setCreated(Instant.parse(wbResource.created));
        return workbasket;
    }

    private WorkbasketResource addLinks(WorkbasketResource resource, Workbasket wb) throws NotAuthorizedException {
        resource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getWorkbasket(wb.getId())).withSelfRel());
        resource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).createWorkbasket(resource)).withRel("createWorkbasket"));
        resource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).updateWorkbasket(wb.getId(), resource)).withRel("updateWorkbasket"));
        resource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).deleteWorkbasket(wb.getId())).withRel("deleteWorkbasket"));
        return resource;
    }
}

