/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.Task;
import pro.taskana.TaskService;
import pro.taskana.TaskState;
import pro.taskana.TaskSummary;
import pro.taskana.exceptions.ClassificationNotFoundException;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.InvalidOwnerException;
import pro.taskana.exceptions.InvalidStateException;
import pro.taskana.exceptions.InvalidWorkbasketException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.TaskAlreadyExistException;
import pro.taskana.exceptions.TaskNotFoundException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.rest.query.TaskFilter;

@RestController
@RequestMapping(path={"/v1/tasks"}, produces={"application/json"})
public class TaskController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskController.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private TaskFilter taskLogic;

    @GetMapping
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<List<TaskSummary>> getTasks(@RequestParam MultiValueMap<String, String> params) throws NotAuthorizedException, InvalidArgumentException {
        if (params.keySet().size() == 0) {
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(this.taskLogic.getAll());
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(this.taskLogic.inspectParams(params));
    }

    @GetMapping(path={"/{taskId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<Task> getTask(@PathVariable String taskId) throws TaskNotFoundException, NotAuthorizedException {
        Task task = this.taskService.getTask(taskId);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)task);
    }

    @GetMapping(path={"/workbasket/{workbasketId}/state/{taskState}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<List<TaskSummary>> getTasksByWorkbasketIdAndState(@PathVariable String workbasketId, @PathVariable TaskState taskState) {
        List taskList = this.taskService.createTaskQuery().workbasketIdIn(new String[]{workbasketId}).stateIn(new TaskState[]{taskState}).list();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)taskList);
    }

    @PostMapping(path={"/{taskId}/claim"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Task> claimTask(@PathVariable String taskId, @RequestBody String userName) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        this.taskService.claim(taskId);
        Task updatedTask = this.taskService.getTask(taskId);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)updatedTask);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{taskId}/complete"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Task> completeTask(@PathVariable String taskId) throws TaskNotFoundException, InvalidOwnerException, InvalidStateException, NotAuthorizedException {
        this.taskService.completeTask(taskId, true);
        Task updatedTask = this.taskService.getTask(taskId);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)updatedTask);
    }

    @RequestMapping(method={RequestMethod.POST})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Task> createTask(@RequestBody Task task) throws WorkbasketNotFoundException, ClassificationNotFoundException, NotAuthorizedException, TaskAlreadyExistException, InvalidWorkbasketException, InvalidArgumentException {
        Task createdTask = this.taskService.createTask(task);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdTask);
    }

    @RequestMapping(path={"/{taskId}/transfer/{workbasketKey}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Task> transferTask(@PathVariable String taskId, @PathVariable String workbasketKey) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedException, InvalidWorkbasketException {
        Task updatedTask = this.taskService.transfer(taskId, workbasketKey);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)updatedTask);
    }

    @GetMapping(path={"/workbasket/{workbasketId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<List<TaskSummary>> getTasksummariesByWorkbasketId(@PathVariable String workbasketId) {
        List taskSummaries = null;
        taskSummaries = this.taskService.createTaskQuery().workbasketIdIn(new String[]{workbasketId}).list();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)taskSummaries);
    }
}

