/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource.mapper;

import java.time.Instant;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Component;
import pro.taskana.Classification;
import pro.taskana.ClassificationService;
import pro.taskana.exceptions.ClassificationAlreadyExistException;
import pro.taskana.exceptions.ClassificationNotFoundException;
import pro.taskana.exceptions.ConcurrencyException;
import pro.taskana.exceptions.DomainNotFoundException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.impl.ClassificationImpl;
import pro.taskana.rest.ClassificationController;
import pro.taskana.rest.resource.ClassificationResource;

@Component
public class ClassificationMapper {
    @Autowired
    ClassificationService classificationService;

    public ClassificationResource toResource(Classification classification) throws ClassificationNotFoundException, NotAuthorizedException, ClassificationAlreadyExistException, ConcurrencyException, DomainNotFoundException {
        ClassificationResource resource = new ClassificationResource();
        BeanUtils.copyProperties((Object)classification, (Object)((Object)resource));
        resource.setClassificationId(classification.getId());
        resource.setCreated(classification.getCreated().toString());
        resource.setModified(classification.getModified().toString());
        return this.addLinks(resource, classification);
    }

    public Classification toModel(ClassificationResource classificationResource) throws NotAuthorizedException {
        ClassificationImpl classification = (ClassificationImpl)this.classificationService.newClassification(classificationResource.domain, classificationResource.key, classificationResource.type);
        BeanUtils.copyProperties((Object)((Object)classificationResource), (Object)classification);
        classification.setId(classificationResource.getClassificationId());
        classification.setCreated(Instant.parse(classificationResource.getCreated()));
        classification.setModified(Instant.parse(classificationResource.getModified()));
        return classification;
    }

    private ClassificationResource addLinks(ClassificationResource resource, Classification classification) throws ClassificationNotFoundException, NotAuthorizedException, ClassificationAlreadyExistException, ConcurrencyException, DomainNotFoundException {
        resource.add(ControllerLinkBuilder.linkTo(((ClassificationController)ControllerLinkBuilder.methodOn(ClassificationController.class, (Object[])new Object[0])).getClassification(classification.getId())).withSelfRel());
        resource.add(ControllerLinkBuilder.linkTo(((ClassificationController)ControllerLinkBuilder.methodOn(ClassificationController.class, (Object[])new Object[0])).getClassification(classification.getKey(), classification.getDomain())).withRel("getClassificationByKeyAndDomain"));
        resource.add(ControllerLinkBuilder.linkTo(((ClassificationController)ControllerLinkBuilder.methodOn(ClassificationController.class, (Object[])new Object[0])).getClassifications()).withRel("getAllClassifications"));
        resource.add(ControllerLinkBuilder.linkTo(((ClassificationController)ControllerLinkBuilder.methodOn(ClassificationController.class, (Object[])new Object[0])).createClassification(resource)).withRel("createClassification"));
        resource.add(ControllerLinkBuilder.linkTo(((ClassificationController)ControllerLinkBuilder.methodOn(ClassificationController.class, (Object[])new Object[0])).updateClassification(resource)).withRel("updateClassification"));
        return resource;
    }
}

