/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import org.springframework.hateoas.PagedResources;
import pro.taskana.exceptions.InvalidArgumentException;

public abstract class AbstractPagingController {
    protected PagedResources.PageMetadata initPageMetadata(String pagesizeParam, String pageParam, long totalElements) throws InvalidArgumentException {
        long page;
        long pagesize;
        try {
            pagesize = Long.valueOf(pagesizeParam);
            page = Long.valueOf(pageParam);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException("page and pagesize must be a integer value.");
        }
        PagedResources.PageMetadata pageMetadata = new PagedResources.PageMetadata(pagesize, page, totalElements);
        if (pageMetadata.getNumber() > pageMetadata.getTotalPages()) {
            pageMetadata = new PagedResources.PageMetadata(pagesize, pageMetadata.getTotalPages(), totalElements);
        }
        return pageMetadata;
    }
}

