/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.BaseQuery;
import pro.taskana.Task;
import pro.taskana.TaskQuery;
import pro.taskana.TaskService;
import pro.taskana.TaskState;
import pro.taskana.exceptions.ClassificationNotFoundException;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.InvalidOwnerException;
import pro.taskana.exceptions.InvalidStateException;
import pro.taskana.exceptions.InvalidWorkbasketException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.TaskAlreadyExistException;
import pro.taskana.exceptions.TaskNotFoundException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.rest.AbstractPagingController;
import pro.taskana.rest.resource.TaskResource;
import pro.taskana.rest.resource.TaskSummaryResource;
import pro.taskana.rest.resource.mapper.TaskResourceAssembler;
import pro.taskana.rest.resource.mapper.TaskSummaryResourcesAssembler;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
@RequestMapping(path={"/v1/tasks"}, produces={"application/hal+json"})
public class TaskController
extends AbstractPagingController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskController.class);
    private static final String STATE = "state";
    private static final String STATE_VALUE_CLAIMED = "CLAIMED";
    private static final String STATE_VALUE_COMPLETED = "COMPLETED";
    private static final String STATE_VALUE_READY = "READY";
    private static final String PRIORITY = "priority";
    private static final String NAME = "name";
    private static final String OWNER = "owner";
    private static final String WORKBASKET_ID = "workbasketId";
    private static final String CLASSIFICATION_KEY = "classification.key";
    private static final String POR_PREFIX = "por.";
    private static final String POR_VALUE = "por.value";
    private static final String POR_TYPE = "por.type";
    private static final String POR_SYSTEM_INSTANCE = "por.instance";
    private static final String POR_SYSTEM = "por.system";
    private static final String POR_COMPANY = "por.company";
    private static final String DUE = "due";
    private static final String PLANNED = "planned";
    private static final String SORT_BY = "sortBy";
    private static final String SORT_DIRECTION = "order";
    private static final String PAGING_PAGE = "page";
    private static final String PAGING_PAGE_SIZE = "pageSize";
    @Autowired
    private TaskService taskService;

    @GetMapping
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<PagedResources<TaskSummaryResource>> getTasks(@RequestParam MultiValueMap<String, String> params) throws InvalidArgumentException, NotAuthorizedException {
        TaskQuery query = this.taskService.createTaskQuery();
        query = this.applyFilterParams(query, params);
        query = this.applySortingParams(query, params);
        PagedResources.PageMetadata pageMetadata = null;
        List taskSummaries = null;
        String page = (String)params.getFirst((Object)PAGING_PAGE);
        String pageSize = (String)params.getFirst((Object)PAGING_PAGE_SIZE);
        if (page != null && pageSize != null) {
            long totalElements = query.count();
            pageMetadata = this.initPageMetadata(pageSize, page, totalElements);
            taskSummaries = query.listPage((int)pageMetadata.getNumber(), (int)pageMetadata.getSize());
        } else if (page == null && pageSize == null) {
            taskSummaries = query.list();
        } else {
            throw new InvalidArgumentException("Paging information is incomplete.");
        }
        TaskSummaryResourcesAssembler taskSummaryResourcesAssembler = new TaskSummaryResourcesAssembler();
        PagedResources<TaskSummaryResource> pagedResources = taskSummaryResourcesAssembler.toResources(taskSummaries, pageMetadata);
        return new ResponseEntity(pagedResources, HttpStatus.OK);
    }

    @GetMapping(path={"/{taskId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskResource> getTask(@PathVariable String taskId) throws TaskNotFoundException, NotAuthorizedException {
        Task task = this.taskService.getTask(taskId);
        TaskResourceAssembler taskResourceAssembler = new TaskResourceAssembler();
        ResponseEntity result = new ResponseEntity((Object)taskResourceAssembler.toResource(task), HttpStatus.OK);
        return result;
    }

    @PostMapping(path={"/{taskId}/claim"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskResource> claimTask(@PathVariable String taskId, @RequestBody String userName) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException, NotAuthorizedException {
        this.taskService.claim(taskId);
        Task updatedTask = this.taskService.getTask(taskId);
        TaskResourceAssembler taskResourceAssembler = new TaskResourceAssembler();
        ResponseEntity result = new ResponseEntity((Object)taskResourceAssembler.toResource(updatedTask), HttpStatus.OK);
        return result;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{taskId}/complete"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskResource> completeTask(@PathVariable String taskId) throws TaskNotFoundException, InvalidOwnerException, InvalidStateException, NotAuthorizedException {
        this.taskService.completeTask(taskId, true);
        Task updatedTask = this.taskService.getTask(taskId);
        TaskResourceAssembler taskResourceAssembler = new TaskResourceAssembler();
        ResponseEntity result = new ResponseEntity((Object)taskResourceAssembler.toResource(updatedTask), HttpStatus.OK);
        return result;
    }

    @RequestMapping(method={RequestMethod.POST})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskResource> createTask(@RequestBody Task task) throws WorkbasketNotFoundException, ClassificationNotFoundException, NotAuthorizedException, TaskAlreadyExistException, InvalidWorkbasketException, InvalidArgumentException {
        Task createdTask = this.taskService.createTask(task);
        TaskResourceAssembler taskResourceAssembler = new TaskResourceAssembler();
        ResponseEntity result = new ResponseEntity((Object)taskResourceAssembler.toResource(createdTask), HttpStatus.CREATED);
        return result;
    }

    @RequestMapping(path={"/{taskId}/transfer/{workbasketKey}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskResource> transferTask(@PathVariable String taskId, @PathVariable String workbasketKey) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedException, InvalidWorkbasketException {
        Task updatedTask = this.taskService.transfer(taskId, workbasketKey);
        TaskResourceAssembler taskResourceAssembler = new TaskResourceAssembler();
        ResponseEntity result = new ResponseEntity((Object)taskResourceAssembler.toResource(updatedTask), HttpStatus.OK);
        return result;
    }

    private TaskQuery applyFilterParams(TaskQuery taskQuery, MultiValueMap<String, String> params) throws NotAuthorizedException, InvalidArgumentException {
        if (params.containsKey((Object)NAME)) {
            String[] names = this.extractCommaSeperatedFields((List)params.get((Object)NAME));
            taskQuery.nameIn(names);
        }
        if (params.containsKey((Object)PRIORITY)) {
            String[] prioritesInString = this.extractCommaSeperatedFields((List)params.get((Object)PRIORITY));
            int[] priorites = this.extractPriorities(prioritesInString);
            taskQuery.priorityIn(priorites);
        }
        if (params.containsKey((Object)STATE)) {
            TaskState[] states = this.extractStates(params);
            taskQuery.stateIn(states);
        }
        if (params.containsKey((Object)CLASSIFICATION_KEY)) {
            String[] classificationKeys = this.extractCommaSeperatedFields((List)params.get((Object)CLASSIFICATION_KEY));
            taskQuery.classificationKeyIn(classificationKeys);
        }
        if (params.containsKey((Object)WORKBASKET_ID)) {
            String[] workbaskets = this.extractCommaSeperatedFields((List)params.get((Object)WORKBASKET_ID));
            taskQuery.workbasketIdIn(workbaskets);
        }
        if (params.containsKey((Object)OWNER)) {
            String[] owners = this.extractCommaSeperatedFields((List)params.get((Object)OWNER));
            taskQuery.ownerIn(owners);
        }
        if (params.containsKey((Object)POR_COMPANY)) {
            String[] companies = this.extractCommaSeperatedFields((List)params.get((Object)POR_COMPANY));
            taskQuery.primaryObjectReferenceCompanyIn(companies);
        }
        if (params.containsKey((Object)POR_SYSTEM)) {
            String[] systems = this.extractCommaSeperatedFields((List)params.get((Object)POR_SYSTEM));
            taskQuery.primaryObjectReferenceSystemIn(systems);
        }
        if (params.containsKey((Object)POR_SYSTEM_INSTANCE)) {
            String[] systemInstances = this.extractCommaSeperatedFields((List)params.get((Object)POR_SYSTEM_INSTANCE));
            taskQuery.primaryObjectReferenceSystemInstanceIn(systemInstances);
        }
        if (params.containsKey((Object)POR_TYPE)) {
            String[] types = this.extractCommaSeperatedFields((List)params.get((Object)POR_TYPE));
            taskQuery.primaryObjectReferenceTypeIn(types);
        }
        if (params.containsKey((Object)POR_VALUE)) {
            String[] values = this.extractCommaSeperatedFields((List)params.get((Object)POR_VALUE));
            taskQuery.primaryObjectReferenceValueIn(values);
        }
        return taskQuery;
    }

    private TaskQuery applySortingParams(TaskQuery taskQuery, MultiValueMap<String, String> params) throws NotAuthorizedException, InvalidArgumentException {
        String sortBy = (String)params.getFirst((Object)SORT_BY);
        if (sortBy != null) {
            BaseQuery.SortDirection sortDirection = params.getFirst((Object)SORT_DIRECTION) != null && "desc".equals(params.getFirst((Object)SORT_DIRECTION)) ? BaseQuery.SortDirection.DESCENDING : BaseQuery.SortDirection.ASCENDING;
            switch (sortBy) {
                case "classification.key": {
                    taskQuery = taskQuery.orderByClassificationKey(sortDirection);
                    break;
                }
                case "por.type": {
                    taskQuery = taskQuery.orderByPrimaryObjectReferenceType(sortDirection);
                    break;
                }
                case "por.value": {
                    taskQuery = taskQuery.orderByPrimaryObjectReferenceValue(sortDirection);
                    break;
                }
                case "state": {
                    taskQuery = taskQuery.orderByState(sortDirection);
                    break;
                }
                case "name": {
                    taskQuery = taskQuery.orderByName(sortDirection);
                    break;
                }
                case "due": {
                    taskQuery = taskQuery.orderByDue(sortDirection);
                    break;
                }
                case "planned": {
                    taskQuery = taskQuery.orderByPlanned(sortDirection);
                    break;
                }
                case "priority": {
                    taskQuery = taskQuery.orderByPriority(sortDirection);
                    break;
                }
                default: {
                    throw new InvalidArgumentException("Unknown filter attribute: " + sortBy);
                }
            }
        }
        return taskQuery;
    }

    private int[] extractPriorities(String[] prioritesInString) {
        int[] priorites = new int[prioritesInString.length];
        for (int i = 0; i < prioritesInString.length; ++i) {
            priorites[i] = Integer.getInteger(prioritesInString[i]);
        }
        return priorites;
    }

    private String[] extractCommaSeperatedFields(List<String> list) {
        ArrayList values = new ArrayList();
        list.forEach(item -> values.addAll(Arrays.asList(item.split(","))));
        return values.toArray(new String[0]);
    }

    private TaskState[] extractStates(MultiValueMap<String, String> params) throws InvalidArgumentException {
        ArrayList<TaskState> states = new ArrayList<TaskState>();
        for (String item : (List)params.get((Object)STATE)) {
            String[] stringArray = item.split(",");
            int n = stringArray.length;
            block11: for (int i = 0; i < n; ++i) {
                String state;
                switch (state = stringArray[i]) {
                    case "READY": {
                        states.add(TaskState.READY);
                        continue block11;
                    }
                    case "COMPLETED": {
                        states.add(TaskState.COMPLETED);
                        continue block11;
                    }
                    case "CLAIMED": {
                        states.add(TaskState.CLAIMED);
                        continue block11;
                    }
                    default: {
                        throw new InvalidArgumentException("Unknown status '" + state + "'");
                    }
                }
            }
        }
        return states.toArray(new TaskState[0]);
    }
}

