/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.BaseQuery;
import pro.taskana.Workbasket;
import pro.taskana.WorkbasketPermission;
import pro.taskana.WorkbasketQuery;
import pro.taskana.WorkbasketService;
import pro.taskana.WorkbasketType;
import pro.taskana.exceptions.DomainNotFoundException;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.InvalidWorkbasketException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.WorkbasketAlreadyExistException;
import pro.taskana.exceptions.WorkbasketInUseException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.rest.AbstractPagingController;
import pro.taskana.rest.resource.DistributionTargetResource;
import pro.taskana.rest.resource.WorkbasketAccessItemResource;
import pro.taskana.rest.resource.WorkbasketResource;
import pro.taskana.rest.resource.WorkbasketSummaryResource;
import pro.taskana.rest.resource.mapper.DistributionTargetListMapper;
import pro.taskana.rest.resource.mapper.WorkbasketAccessItemListMapper;
import pro.taskana.rest.resource.mapper.WorkbasketAccessItemMapper;
import pro.taskana.rest.resource.mapper.WorkbasketMapper;
import pro.taskana.rest.resource.mapper.WorkbasketSummaryResourcesAssembler;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
@RequestMapping(path={"/v1/workbaskets"}, produces={"application/hal+json"})
public class WorkbasketController
extends AbstractPagingController {
    private static final String LIKE = "%";
    private static final String NAME = "name";
    private static final String KEY = "key";
    private static final String DESCRIPTION = "description";
    private static final String OWNER = "owner";
    private static final String TYPE = "type";
    private static final String DESC = "desc";
    @Autowired
    private WorkbasketService workbasketService;
    @Autowired
    private WorkbasketMapper workbasketMapper;
    @Autowired
    private DistributionTargetListMapper distributionTargetListMapper;
    @Autowired
    private WorkbasketAccessItemListMapper accessItemListMapper;
    @Autowired
    private WorkbasketAccessItemMapper workbasketAccessItemMapper;

    @GetMapping
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<PagedResources<WorkbasketSummaryResource>> getWorkbaskets(@RequestParam(value="sortBy", defaultValue="name", required=false) String sortBy, @RequestParam(value="order", defaultValue="asc", required=false) String order, @RequestParam(value="name", required=false) String name, @RequestParam(value="nameLike", required=false) String nameLike, @RequestParam(value="key", required=false) String key, @RequestParam(value="keyLike", required=false) String keyLike, @RequestParam(value="descLike", required=false) String descLike, @RequestParam(value="owner", required=false) String owner, @RequestParam(value="ownerLike", required=false) String ownerLike, @RequestParam(value="type", required=false) String type, @RequestParam(value="requiredPermission", required=false) String requiredPermission, @RequestParam(value="page", required=false) String page, @RequestParam(value="pagesize", required=false) String pageSize) throws InvalidArgumentException {
        WorkbasketQuery query = this.workbasketService.createWorkbasketQuery();
        this.addSortingToQuery(query, sortBy, order);
        this.addAttributeFilter(query, name, nameLike, key, keyLike, descLike, owner, ownerLike, type);
        this.addAuthorizationFilter(query, requiredPermission);
        PagedResources.PageMetadata pageMetadata = null;
        List workbasketSummaries = null;
        if (page != null && pageSize != null) {
            long totalElements = query.count();
            pageMetadata = this.initPageMetadata(pageSize, page, totalElements);
            workbasketSummaries = query.listPage((int)pageMetadata.getNumber(), (int)pageMetadata.getSize());
        } else if (page == null && pageSize == null) {
            workbasketSummaries = query.list();
        } else {
            throw new InvalidArgumentException("Paging information is incomplete.");
        }
        WorkbasketSummaryResourcesAssembler assembler = new WorkbasketSummaryResourcesAssembler();
        PagedResources<WorkbasketSummaryResource> pagedResources = assembler.toResources(workbasketSummaries, pageMetadata);
        return new ResponseEntity(pagedResources, HttpStatus.OK);
    }

    @GetMapping(path={"/{workbasketId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketResource> getWorkbasket(@PathVariable(value="workbasketId") String workbasketId) throws WorkbasketNotFoundException, NotAuthorizedException {
        Workbasket workbasket = this.workbasketService.getWorkbasket(workbasketId);
        ResponseEntity result = new ResponseEntity((Object)this.workbasketMapper.toResource(workbasket), HttpStatus.OK);
        return result;
    }

    @DeleteMapping(path={"/{workbasketId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<?> deleteWorkbasket(@PathVariable(value="workbasketId") String workbasketId) throws WorkbasketNotFoundException, NotAuthorizedException, WorkbasketInUseException, InvalidArgumentException {
        ResponseEntity result = ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).build();
        this.workbasketService.deleteWorkbasket(workbasketId);
        return result;
    }

    @PostMapping
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketResource> createWorkbasket(@RequestBody WorkbasketResource workbasketResource) throws InvalidWorkbasketException, NotAuthorizedException, WorkbasketAlreadyExistException, WorkbasketNotFoundException, DomainNotFoundException {
        Workbasket workbasket = this.workbasketMapper.toModel(workbasketResource);
        workbasket = this.workbasketService.createWorkbasket(workbasket);
        return new ResponseEntity((Object)this.workbasketMapper.toResource(workbasket), HttpStatus.CREATED);
    }

    @PutMapping(path={"/{workbasketId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketResource> updateWorkbasket(@PathVariable(value="workbasketId") String workbasketId, @RequestBody WorkbasketResource workbasketResource) throws InvalidWorkbasketException, WorkbasketNotFoundException, NotAuthorizedException {
        if (!workbasketId.equals(workbasketResource.workbasketId)) {
            throw new InvalidWorkbasketException("Target-WB-ID('" + workbasketId + "') is not identical with the WB-ID of to object which should be updated. ID=('" + workbasketResource.getId() + "')");
        }
        Workbasket workbasket = this.workbasketMapper.toModel(workbasketResource);
        workbasket = this.workbasketService.updateWorkbasket(workbasket);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.workbasketMapper.toResource(workbasket)));
        return result;
    }

    @GetMapping(path={"/{workbasketId}/workbasketAccessItems"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<Resources<WorkbasketAccessItemResource>> getWorkbasketAccessItems(@PathVariable(value="workbasketId") String workbasketId) throws NotAuthorizedException, WorkbasketNotFoundException {
        List accessItems = this.workbasketService.getWorkbasketAccessItems(workbasketId);
        Resources<WorkbasketAccessItemResource> accessItemListResource = this.accessItemListMapper.toResource(workbasketId, accessItems);
        ResponseEntity result = new ResponseEntity(accessItemListResource, HttpStatus.OK);
        return result;
    }

    @PutMapping(value={"/{workbasketId}/workbasketAccessItems"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Resources<WorkbasketAccessItemResource>> setWorkbasketAccessItems(@PathVariable(value="workbasketId") String workbasketId, @RequestBody List<WorkbasketAccessItemResource> workbasketAccessResourceItems) throws NotAuthorizedException, InvalidArgumentException, WorkbasketNotFoundException {
        if (workbasketAccessResourceItems == null) {
            throw new InvalidArgumentException("Can\u00b4t create something with NULL body-value.");
        }
        ArrayList wbAccessItems = new ArrayList();
        workbasketAccessResourceItems.forEach(item -> wbAccessItems.add(this.workbasketAccessItemMapper.toModel((WorkbasketAccessItemResource)((Object)item))));
        this.workbasketService.setWorkbasketAccessItems(workbasketId, wbAccessItems);
        List updatedWbAccessItems = this.workbasketService.getWorkbasketAccessItems(workbasketId);
        Resources<WorkbasketAccessItemResource> accessItemListResource = this.accessItemListMapper.toResource(workbasketId, updatedWbAccessItems);
        return new ResponseEntity(accessItemListResource, HttpStatus.OK);
    }

    @GetMapping(path={"/{workbasketId}/distributiontargets"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<Resources<DistributionTargetResource>> getDistributionTargets(@PathVariable(value="workbasketId") String workbasketId) throws WorkbasketNotFoundException, NotAuthorizedException {
        List distributionTargets = this.workbasketService.getDistributionTargets(workbasketId);
        Resources<DistributionTargetResource> distributionTargetListResource = this.distributionTargetListMapper.toResource(workbasketId, distributionTargets);
        ResponseEntity result = new ResponseEntity(distributionTargetListResource, HttpStatus.OK);
        return result;
    }

    @PutMapping(path={"/{workbasketId}/distributiontargets"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Resources<DistributionTargetResource>> setDistributionTargetsForWorkbasketId(@PathVariable(value="workbasketId") String sourceWorkbasketId, @RequestBody List<String> targetWorkbasketIds) throws WorkbasketNotFoundException, NotAuthorizedException {
        this.workbasketService.setDistributionTargets(sourceWorkbasketId, targetWorkbasketIds);
        List distributionTargets = this.workbasketService.getDistributionTargets(sourceWorkbasketId);
        Resources<DistributionTargetResource> distributionTargetListResource = this.distributionTargetListMapper.toResource(sourceWorkbasketId, distributionTargets);
        return new ResponseEntity(distributionTargetListResource, HttpStatus.OK);
    }

    private void addAuthorizationFilter(WorkbasketQuery query, String requiredPermission) throws InvalidArgumentException {
        if (requiredPermission == null) {
            return;
        }
        block38: for (String authorization : Arrays.asList(requiredPermission.split(","))) {
            switch (authorization.trim()) {
                case "READ": {
                    query.callerHasPermission(WorkbasketPermission.READ);
                    continue block38;
                }
                case "OPEN": {
                    query.callerHasPermission(WorkbasketPermission.OPEN);
                    continue block38;
                }
                case "APPEND": {
                    query.callerHasPermission(WorkbasketPermission.APPEND);
                    continue block38;
                }
                case "TRANSFER": {
                    query.callerHasPermission(WorkbasketPermission.TRANSFER);
                    continue block38;
                }
                case "DISTRIBUTE": {
                    query.callerHasPermission(WorkbasketPermission.DISTRIBUTE);
                    continue block38;
                }
                case "CUSTOM_1": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_1);
                    continue block38;
                }
                case "CUSTOM_2": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_2);
                    continue block38;
                }
                case "CUSTOM_3": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_3);
                    continue block38;
                }
                case "CUSTOM_4": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_4);
                    continue block38;
                }
                case "CUSTOM_5": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_5);
                    continue block38;
                }
                case "CUSTOM_6": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_6);
                    continue block38;
                }
                case "CUSTOM_7": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_7);
                    continue block38;
                }
                case "CUSTOM_8": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_8);
                    continue block38;
                }
                case "CUSTOM_9": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_9);
                    continue block38;
                }
                case "CUSTOM_10": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_10);
                    continue block38;
                }
                case "CUSTOM_11": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_11);
                    continue block38;
                }
                case "CUSTOM_12": {
                    query.callerHasPermission(WorkbasketPermission.CUSTOM_12);
                    continue block38;
                }
            }
            throw new InvalidArgumentException("Unknown authorization '" + authorization + "'");
        }
    }

    private void addSortingToQuery(WorkbasketQuery query, String sortBy, String order) throws IllegalArgumentException {
        BaseQuery.SortDirection sortDirection = this.getSortDirection(order);
        switch (sortBy) {
            case "name": {
                query.orderByName(sortDirection);
                break;
            }
            case "key": {
                query.orderByKey(sortDirection);
                break;
            }
            case "description": {
                query.orderByDescription(sortDirection);
                break;
            }
            case "owner": {
                query.orderByOwner(sortDirection);
                break;
            }
            case "type": {
                query.orderByType(sortDirection);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown order '" + sortBy + "'");
            }
        }
    }

    private BaseQuery.SortDirection getSortDirection(String order) {
        if (order.equals(DESC)) {
            return BaseQuery.SortDirection.DESCENDING;
        }
        return BaseQuery.SortDirection.ASCENDING;
    }

    private void addAttributeFilter(WorkbasketQuery query, String name, String nameLike, String key, String keyLike, String descLike, String owner, String ownerLike, String type) throws InvalidArgumentException {
        if (name != null) {
            query.nameIn(new String[]{name});
        }
        if (nameLike != null) {
            query.nameLike(new String[]{LIKE + nameLike + LIKE});
        }
        if (key != null) {
            query.keyIn(new String[]{key});
        }
        if (keyLike != null) {
            query.keyLike(new String[]{LIKE + keyLike + LIKE});
        }
        if (owner != null) {
            query.ownerIn(new String[]{owner});
        }
        if (ownerLike != null) {
            query.ownerLike(new String[]{LIKE + ownerLike + LIKE});
        }
        if (descLike != null) {
            query.descriptionLike(new String[]{LIKE + descLike + LIKE});
        }
        if (type != null) {
            switch (type) {
                case "PERSONAL": {
                    query.typeIn(new WorkbasketType[]{WorkbasketType.PERSONAL});
                    break;
                }
                case "GROUP": {
                    query.typeIn(new WorkbasketType[]{WorkbasketType.GROUP});
                    break;
                }
                case "CLEARANCE": {
                    query.typeIn(new WorkbasketType[]{WorkbasketType.CLEARANCE});
                    break;
                }
                case "TOPIC": {
                    query.typeIn(new WorkbasketType[]{WorkbasketType.TOPIC});
                    break;
                }
                default: {
                    throw new InvalidArgumentException("Unknown Workbaskettype '" + type + "'");
                }
            }
        }
    }
}

