/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource.mapper;

import org.springframework.beans.BeanUtils;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import pro.taskana.Task;
import pro.taskana.rest.TaskController;
import pro.taskana.rest.resource.TaskResource;
import pro.taskana.rest.resource.mapper.ClassificationSummaryResourceAssembler;
import pro.taskana.rest.resource.mapper.WorkbasketSummaryResourceAssembler;

public class TaskResourceAssembler
extends ResourceAssemblerSupport<Task, TaskResource> {
    private WorkbasketSummaryResourceAssembler workbasketAssembler = new WorkbasketSummaryResourceAssembler();
    private ClassificationSummaryResourceAssembler classificationAssembler = new ClassificationSummaryResourceAssembler();

    public TaskResourceAssembler() {
        super(TaskController.class, TaskResource.class);
    }

    public TaskResource toResource(Task task) {
        TaskResource resource = (TaskResource)this.createResourceWithId(task.getId(), task);
        BeanUtils.copyProperties((Object)task, (Object)((Object)resource));
        resource.setTaskId(task.getId());
        if (task.getCreated() != null) {
            resource.setCreated(task.getCreated().toString());
        }
        if (task.getModified() != null) {
            resource.setModified(task.getModified().toString());
        }
        if (task.getClaimed() != null) {
            resource.setClaimed(task.getClaimed().toString());
        }
        if (task.getCompleted() != null) {
            resource.setCompleted(task.getCompleted().toString());
        }
        if (task.getDue() != null) {
            resource.setDue(task.getDue().toString());
        }
        resource.setClassificationSummaryResource(this.classificationAssembler.toResource(task.getClassificationSummary()));
        resource.setWorkbasketSummaryResource(this.workbasketAssembler.toResource(task.getWorkbasketSummary()));
        return resource;
    }
}

