/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;
import pro.taskana.exceptions.ClassificationAlreadyExistException;
import pro.taskana.exceptions.ClassificationNotFoundException;
import pro.taskana.exceptions.ConcurrencyException;
import pro.taskana.exceptions.DomainNotFoundException;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.InvalidOwnerException;
import pro.taskana.exceptions.InvalidStateException;
import pro.taskana.exceptions.InvalidWorkbasketException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.NotAuthorizedToQueryWorkbasketException;
import pro.taskana.exceptions.TaskAlreadyExistException;
import pro.taskana.exceptions.TaskNotFoundException;
import pro.taskana.exceptions.WorkbasketAlreadyExistException;
import pro.taskana.exceptions.WorkbasketInUseException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.rest.TaskanaErrorData;

@Order(value=-2147483648)
@ControllerAdvice
public class TaskanaRestExceptionHandler
extends ResponseEntityExceptionHandler {
    @ExceptionHandler(value={InvalidArgumentException.class})
    protected ResponseEntity<Object> handleInvalidArgument(InvalidArgumentException ex, WebRequest req) {
        return this.buildResponse((Exception)((Object)ex), req, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={NotAuthorizedException.class})
    protected ResponseEntity<Object> handleNotAuthorized(NotAuthorizedException ex, WebRequest req) {
        return this.buildResponse((Exception)((Object)ex), req, HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={TaskNotFoundException.class})
    protected ResponseEntity<Object> handleTaskNotFound(TaskNotFoundException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={TaskAlreadyExistException.class})
    protected ResponseEntity<Object> handleTaskAlreadyExist(TaskAlreadyExistException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={NotAuthorizedToQueryWorkbasketException.class})
    protected ResponseEntity<Object> handleNotAuthorizedToQueryWorkbasket(NotAuthorizedToQueryWorkbasketException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={InvalidStateException.class})
    protected ResponseEntity<Object> handleInvalidState(InvalidStateException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={InvalidOwnerException.class})
    protected ResponseEntity<Object> handleInvalidOwner(InvalidOwnerException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={ClassificationNotFoundException.class})
    protected ResponseEntity<Object> handleClassificationNotFound(ClassificationNotFoundException ex, WebRequest req) {
        return this.buildResponse((Exception)((Object)ex), req, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={ClassificationAlreadyExistException.class})
    protected ResponseEntity<Object> handleClassificationAlreadyExist(ClassificationAlreadyExistException ex, WebRequest req) {
        return this.buildResponse((Exception)((Object)ex), req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={ConcurrencyException.class})
    protected ResponseEntity<Object> handleConcurrencyException(ConcurrencyException ex, WebRequest req) {
        return this.buildResponse((Exception)((Object)ex), req, HttpStatus.LOCKED);
    }

    @ExceptionHandler(value={WorkbasketInUseException.class})
    protected ResponseEntity<Object> handleWorkbasketInUse(WorkbasketInUseException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.LOCKED);
    }

    @ExceptionHandler(value={WorkbasketAlreadyExistException.class})
    protected ResponseEntity<Object> handleWorkbasketAlreadyExist(WorkbasketAlreadyExistException ex, WebRequest req) {
        return this.buildResponse((Exception)((Object)ex), req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={WorkbasketNotFoundException.class})
    protected ResponseEntity<Object> handleWorkbasketNotFound(WorkbasketNotFoundException ex, WebRequest req) {
        return this.buildResponse((Exception)((Object)ex), req, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={InvalidWorkbasketException.class})
    protected ResponseEntity<Object> handleInvalidWorkbasket(InvalidWorkbasketException ex, WebRequest req) {
        return this.buildResponse((Exception)((Object)ex), req, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={DomainNotFoundException.class})
    protected ResponseEntity<Object> handleDomainNotFound(DomainNotFoundException ex, WebRequest req) {
        return this.buildResponse((Exception)((Object)ex), req, HttpStatus.BAD_REQUEST);
    }

    private ResponseEntity<Object> buildResponse(Exception ex, WebRequest req, HttpStatus status) {
        TaskanaErrorData errorData = new TaskanaErrorData(status, ex, req);
        return new ResponseEntity((Object)errorData, status);
    }
}

