/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource.mapper;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Component;
import pro.taskana.WorkbasketAccessItem;
import pro.taskana.WorkbasketService;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.impl.WorkbasketAccessItemImpl;
import pro.taskana.rest.WorkbasketController;
import pro.taskana.rest.resource.WorkbasketAccessItemResource;

@Component
public class WorkbasketAccessItemMapper {
    @Autowired
    private WorkbasketService workbasketService;

    public WorkbasketAccessItemResource toResource(WorkbasketAccessItem wbAccItem) throws NotAuthorizedException, WorkbasketNotFoundException {
        WorkbasketAccessItemResource resource = new WorkbasketAccessItemResource();
        BeanUtils.copyProperties((Object)wbAccItem, (Object)((Object)resource));
        resource.setAccessItemId(wbAccItem.getId());
        return this.addLinks(resource, wbAccItem);
    }

    public WorkbasketAccessItem toModel(WorkbasketAccessItemResource wbAccItemRecource) {
        WorkbasketAccessItemImpl wbAccItemModel = (WorkbasketAccessItemImpl)this.workbasketService.newWorkbasketAccessItem(wbAccItemRecource.workbasketId, wbAccItemRecource.accessId);
        BeanUtils.copyProperties((Object)((Object)wbAccItemRecource), (Object)wbAccItemModel);
        wbAccItemModel.setId(wbAccItemRecource.accessItemId);
        return wbAccItemModel;
    }

    private WorkbasketAccessItemResource addLinks(WorkbasketAccessItemResource resource, WorkbasketAccessItem wbAccItem) throws NotAuthorizedException, WorkbasketNotFoundException {
        resource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getWorkbasket(wbAccItem.getWorkbasketId())).withRel("workbasket"));
        return resource;
    }
}

