/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.hateoas.PagedResources;
import org.springframework.util.MultiValueMap;
import pro.taskana.exceptions.InvalidArgumentException;

public abstract class AbstractPagingController {
    protected PagedResources.PageMetadata initPageMetadata(String pagesizeParam, String pageParam, long totalElements) throws InvalidArgumentException {
        long page;
        long pagesize;
        try {
            pagesize = Long.valueOf(pagesizeParam);
            page = Long.valueOf(pageParam);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException("page and pagesize must be a integer value.");
        }
        PagedResources.PageMetadata pageMetadata = new PagedResources.PageMetadata(pagesize, page, totalElements);
        if (pageMetadata.getNumber() > pageMetadata.getTotalPages()) {
            pageMetadata = new PagedResources.PageMetadata(pagesize, pageMetadata.getTotalPages(), totalElements);
        }
        return pageMetadata;
    }

    protected String[] extractCommaSeparatedFields(List<String> list) {
        ArrayList values = new ArrayList();
        list.forEach(item -> values.addAll(Arrays.asList(item.split(","))));
        return values.toArray(new String[0]);
    }

    protected void validateNoInvalidParameterIsLeft(MultiValueMap<String, String> params) throws InvalidArgumentException {
        if (!params.isEmpty()) {
            throw new InvalidArgumentException("Invalid parameter specified: " + params.keySet());
        }
    }
}

